"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoveTag = exports.Tags = exports.Tag = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// import * as cxapi from '@aws-cdk/cx-api';
const annotations_1 = require("./annotations");
const aspect_1 = require("./aspect");
const tag_manager_1 = require("./tag-manager");
/**
 * The common functionality for Tag and Remove Tag Aspects
 */
class TagBase {
    constructor(key, props = {}) {
        this.key = key;
        this.props = props;
    }
    visit(construct) {
        if (tag_manager_1.TagManager.isTaggable(construct)) {
            this.applyTag(construct);
        }
    }
}
/**
 * The Tag Aspect will handle adding a tag to this node and cascading tags to children
 */
class Tag extends TagBase {
    constructor(key, value, props = {}) {
        super(key, props);
        this.defaultPriority = 100;
        jsiiDeprecationWarnings._aws_cdk_core_TagProps(props);
        if (value === undefined) {
            throw new Error('Tag must have a value');
        }
        this.value = value;
    }
    /**
     * DEPRECATED: add tags to the node of a construct and all its the taggable children
     *
     * @deprecated use `Tags.of(scope).add()`
     */
    static add(scope, key, value, props = {}) {
        jsiiDeprecationWarnings.print("@aws-cdk/core.Tag#add", "use `Tags.of(scope).add()`");
        jsiiDeprecationWarnings._aws_cdk_core_Construct(scope);
        jsiiDeprecationWarnings._aws_cdk_core_TagProps(props);
        annotations_1.Annotations.of(scope).addDeprecation('@aws-cdk/core.Tag.add(scope,k,v)', 'Use "Tags.of(scope).add(k,v)" instead');
        Tags.of(scope).add(key, value, props);
    }
    /**
     * DEPRECATED: remove tags to the node of a construct and all its the taggable children
     *
     * @deprecated use `Tags.of(scope).remove()`
     */
    static remove(scope, key, props = {}) {
        jsiiDeprecationWarnings.print("@aws-cdk/core.Tag#remove", "use `Tags.of(scope).remove()`");
        jsiiDeprecationWarnings._aws_cdk_core_Construct(scope);
        jsiiDeprecationWarnings._aws_cdk_core_TagProps(props);
        annotations_1.Annotations.of(scope).addDeprecation('@aws-cdk/core.Tag.remove(scope,k,v)', 'Use "Tags.of(scope).remove(k,v)" instead');
        Tags.of(scope).remove(key, props);
    }
    applyTag(resource) {
        var _d;
        jsiiDeprecationWarnings._aws_cdk_core_ITaggable(resource);
        if (resource.tags.applyTagAspectHere(this.props.includeResourceTypes, this.props.excludeResourceTypes)) {
            resource.tags.setTag(this.key, this.value, (_d = this.props.priority) !== null && _d !== void 0 ? _d : this.defaultPriority, this.props.applyToLaunchedInstances !== false);
        }
    }
}
exports.Tag = Tag;
_a = JSII_RTTI_SYMBOL_1;
Tag[_a] = { fqn: "@aws-cdk/core.Tag", version: "1.150.0" };
/**
 * Manages AWS tags for all resources within a construct scope.
 */
class Tags {
    constructor(scope) {
        this.scope = scope;
    }
    /**
     * Returns the tags API for this scope.
     * @param scope The scope
     */
    static of(scope) {
        jsiiDeprecationWarnings._aws_cdk_core_IConstruct(scope);
        return new Tags(scope);
    }
    /**
     * add tags to the node of a construct and all its the taggable children
     */
    add(key, value, props = {}) {
        jsiiDeprecationWarnings._aws_cdk_core_TagProps(props);
        aspect_1.Aspects.of(this.scope).add(new Tag(key, value, props));
    }
    /**
     * remove tags to the node of a construct and all its the taggable children
     */
    remove(key, props = {}) {
        jsiiDeprecationWarnings._aws_cdk_core_TagProps(props);
        aspect_1.Aspects.of(this.scope).add(new RemoveTag(key, props));
    }
}
exports.Tags = Tags;
_b = JSII_RTTI_SYMBOL_1;
Tags[_b] = { fqn: "@aws-cdk/core.Tags", version: "1.150.0" };
/**
 * The RemoveTag Aspect will handle removing tags from this node and children
 */
class RemoveTag extends TagBase {
    constructor(key, props = {}) {
        super(key, props);
        this.defaultPriority = 200;
        jsiiDeprecationWarnings._aws_cdk_core_TagProps(props);
    }
    applyTag(resource) {
        var _d;
        jsiiDeprecationWarnings._aws_cdk_core_ITaggable(resource);
        if (resource.tags.applyTagAspectHere(this.props.includeResourceTypes, this.props.excludeResourceTypes)) {
            resource.tags.removeTag(this.key, (_d = this.props.priority) !== null && _d !== void 0 ? _d : this.defaultPriority);
        }
    }
}
exports.RemoveTag = RemoveTag;
_c = JSII_RTTI_SYMBOL_1;
RemoveTag[_c] = { fqn: "@aws-cdk/core.RemoveTag", version: "1.150.0" };
//# sourceMappingURL=data:application/json;base64,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