"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Names = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const uniqueid_1 = require("./private/uniqueid");
/**
 * Functions for devising unique names for constructs. For example, those can be
 * used to allocate unique physical names for resources.
 */
class Names {
    constructor() { }
    /**
     * Returns a CloudFormation-compatible unique identifier for a construct based
     * on its path. The identifier includes a human readable portion rendered
     * from the path components and a hash suffix.
     *
     * @param construct The construct
     * @returns a unique id based on the construct path
     */
    static uniqueId(construct) {
        const node = constructs_1.Node.of(construct);
        const components = node.scopes.slice(1).map(c => constructs_1.Node.of(c).id);
        return components.length > 0 ? uniqueid_1.makeUniqueId(components) : '';
    }
    /**
     * Returns a CloudFormation-compatible unique identifier for a construct based
     * on its path. The identifier includes a human readable portion rendered
     * from the path components and a hash suffix.
     *
     * TODO (v2): replace with API to use `constructs.Node`.
     *
     * @param node The construct node
     * @returns a unique id based on the construct path
     */
    static nodeUniqueId(node) {
        jsiiDeprecationWarnings._aws_cdk_core_ConstructNode(node);
        const components = node.scopes.slice(1).map(c => c.node.id);
        return components.length > 0 ? uniqueid_1.makeUniqueId(components) : '';
    }
}
exports.Names = Names;
_a = JSII_RTTI_SYMBOL_1;
Names[_a] = { fqn: "@aws-cdk/core.Names", version: "1.150.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmFtZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJuYW1lcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSwyQ0FBNkM7QUFFN0MsaURBQWtEO0FBRWxEOzs7R0FHRztBQUNILE1BQWEsS0FBSztJQThCaEIsaUJBQXdCO0lBN0J4Qjs7Ozs7OztPQU9HO0lBQ0ksTUFBTSxDQUFDLFFBQVEsQ0FBQyxTQUFvQjtRQUN6QyxNQUFNLElBQUksR0FBRyxpQkFBSSxDQUFDLEVBQUUsQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUNoQyxNQUFNLFVBQVUsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxpQkFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztRQUNoRSxPQUFPLFVBQVUsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyx1QkFBWSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7S0FDOUQ7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSxNQUFNLENBQUMsWUFBWSxDQUFDLElBQW1COztRQUM1QyxNQUFNLFVBQVUsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDO1FBQzVELE9BQU8sVUFBVSxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLHVCQUFZLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztLQUM5RDs7QUE1Qkgsc0JBK0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0LCBOb2RlIH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3ROb2RlIH0gZnJvbSAnLi9jb25zdHJ1Y3QtY29tcGF0JztcbmltcG9ydCB7IG1ha2VVbmlxdWVJZCB9IGZyb20gJy4vcHJpdmF0ZS91bmlxdWVpZCc7XG5cbi8qKlxuICogRnVuY3Rpb25zIGZvciBkZXZpc2luZyB1bmlxdWUgbmFtZXMgZm9yIGNvbnN0cnVjdHMuIEZvciBleGFtcGxlLCB0aG9zZSBjYW4gYmVcbiAqIHVzZWQgdG8gYWxsb2NhdGUgdW5pcXVlIHBoeXNpY2FsIG5hbWVzIGZvciByZXNvdXJjZXMuXG4gKi9cbmV4cG9ydCBjbGFzcyBOYW1lcyB7XG4gIC8qKlxuICAgKiBSZXR1cm5zIGEgQ2xvdWRGb3JtYXRpb24tY29tcGF0aWJsZSB1bmlxdWUgaWRlbnRpZmllciBmb3IgYSBjb25zdHJ1Y3QgYmFzZWRcbiAgICogb24gaXRzIHBhdGguIFRoZSBpZGVudGlmaWVyIGluY2x1ZGVzIGEgaHVtYW4gcmVhZGFibGUgcG9ydGlvbiByZW5kZXJlZFxuICAgKiBmcm9tIHRoZSBwYXRoIGNvbXBvbmVudHMgYW5kIGEgaGFzaCBzdWZmaXguXG4gICAqXG4gICAqIEBwYXJhbSBjb25zdHJ1Y3QgVGhlIGNvbnN0cnVjdFxuICAgKiBAcmV0dXJucyBhIHVuaXF1ZSBpZCBiYXNlZCBvbiB0aGUgY29uc3RydWN0IHBhdGhcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgdW5pcXVlSWQoY29uc3RydWN0OiBDb25zdHJ1Y3QpOiBzdHJpbmcge1xuICAgIGNvbnN0IG5vZGUgPSBOb2RlLm9mKGNvbnN0cnVjdCk7XG4gICAgY29uc3QgY29tcG9uZW50cyA9IG5vZGUuc2NvcGVzLnNsaWNlKDEpLm1hcChjID0+IE5vZGUub2YoYykuaWQpO1xuICAgIHJldHVybiBjb21wb25lbnRzLmxlbmd0aCA+IDAgPyBtYWtlVW5pcXVlSWQoY29tcG9uZW50cykgOiAnJztcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGEgQ2xvdWRGb3JtYXRpb24tY29tcGF0aWJsZSB1bmlxdWUgaWRlbnRpZmllciBmb3IgYSBjb25zdHJ1Y3QgYmFzZWRcbiAgICogb24gaXRzIHBhdGguIFRoZSBpZGVudGlmaWVyIGluY2x1ZGVzIGEgaHVtYW4gcmVhZGFibGUgcG9ydGlvbiByZW5kZXJlZFxuICAgKiBmcm9tIHRoZSBwYXRoIGNvbXBvbmVudHMgYW5kIGEgaGFzaCBzdWZmaXguXG4gICAqXG4gICAqIFRPRE8gKHYyKTogcmVwbGFjZSB3aXRoIEFQSSB0byB1c2UgYGNvbnN0cnVjdHMuTm9kZWAuXG4gICAqXG4gICAqIEBwYXJhbSBub2RlIFRoZSBjb25zdHJ1Y3Qgbm9kZVxuICAgKiBAcmV0dXJucyBhIHVuaXF1ZSBpZCBiYXNlZCBvbiB0aGUgY29uc3RydWN0IHBhdGhcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgbm9kZVVuaXF1ZUlkKG5vZGU6IENvbnN0cnVjdE5vZGUpOiBzdHJpbmcge1xuICAgIGNvbnN0IGNvbXBvbmVudHMgPSBub2RlLnNjb3Blcy5zbGljZSgxKS5tYXAoYyA9PiBjLm5vZGUuaWQpO1xuICAgIHJldHVybiBjb21wb25lbnRzLmxlbmd0aCA+IDAgPyBtYWtlVW5pcXVlSWQoY29tcG9uZW50cykgOiAnJztcbiAgfVxuXG4gIHByaXZhdGUgY29uc3RydWN0b3IoKSB7fVxufVxuIl19