"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeLaunchConfig = exports.InternalConsoleOptions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * (experimental) Controls the visibility of the VSCode Debug Console panel during a debugging session Source: https://code.visualstudio.com/docs/editor/debugging#_launchjson-attributes.
 *
 * @experimental
 */
var InternalConsoleOptions;
(function (InternalConsoleOptions) {
    InternalConsoleOptions["NEVER_OPEN"] = "neverOpen";
    InternalConsoleOptions["OPEN_ON_FIRST_SESSION_START"] = "openOnFirstSessionStart";
    InternalConsoleOptions["OPEN_ON_SESSION_START"] = "openOnSessionStart";
})(InternalConsoleOptions = exports.InternalConsoleOptions || (exports.InternalConsoleOptions = {}));
/**
 * (experimental) VSCode launch configuration file (launch.json), useful for enabling in-editor debugger.
 *
 * @experimental
 */
class VsCodeLaunchConfig extends component_1.Component {
    /**
     * @experimental
     */
    constructor(vscode) {
        super(vscode.project);
        this.content = {
            version: '0.2.0',
            configurations: [],
        };
        new json_1.JsonFile(vscode.project, '.vscode/launch.json', {
            obj: this.content,
        });
    }
    /**
     * (experimental) Adds a VsCodeLaunchConfigurationEntry (e.g. a node.js debugger) to `.vscode/launch.json. Each configuration entry has following mandatory fields: type, request and name. See https://code.visualstudio.com/docs/editor/debugging#_launchjson-attributes for details.
     *
     * @param cfg VsCodeLaunchConfigurationEntry.
     * @experimental
     */
    addConfiguration(cfg) {
        this.content.configurations.push(cfg);
    }
}
exports.VsCodeLaunchConfig = VsCodeLaunchConfig;
_a = JSII_RTTI_SYMBOL_1;
VsCodeLaunchConfig[_a] = { fqn: "projen.vscode.VsCodeLaunchConfig", version: "0.17.72" };
//# sourceMappingURL=data:application/json;base64,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