"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const javascript_1 = require("../javascript");
const project_1 = require("../project");
const pip_1 = require("./pip");
const poetry_1 = require("./poetry");
const pytest_1 = require("./pytest");
const python_sample_1 = require("./python-sample");
const setuptools_1 = require("./setuptools");
const venv_1 = require("./venv");
/** Allowed characters in python project names */
const PYTHON_PROJECT_NAME_REGEX = /^[A-Za-z0-9-_\.]+$/;
/**
 * (experimental) Python project.
 *
 * @experimental
 * @pjid python
 */
class PythonProject extends project_1.Project {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s;
        super(options);
        if (!PYTHON_PROJECT_NAME_REGEX.test(options.name)) {
            throw new Error('Python projects must only consist of alphanumeric characters, hyphens, and underscores.');
        }
        this.moduleName = options.moduleName;
        this.version = options.version;
        if ((_b = options.venv) !== null && _b !== void 0 ? _b : true) {
            this.envManager = new venv_1.Venv(this);
        }
        if ((_c = options.pip) !== null && _c !== void 0 ? _c : true) {
            this.depsManager = new pip_1.Pip(this);
        }
        if ((_d = options.setuptools) !== null && _d !== void 0 ? _d : (this.projectType === project_1.ProjectType.LIB)) {
            this.packagingManager = new setuptools_1.Setuptools(this, {
                version: options.version,
                description: options.description,
                authorName: options.authorName,
                authorEmail: options.authorEmail,
                license: options.license,
                homepage: options.homepage,
                classifiers: options.classifiers,
                setupConfig: options.setupConfig,
            });
        }
        // if (options.conda ?? false) {
        //   this.depsManager = new Conda(this, options);
        //   this.envManager = this.depsManager;
        // }
        // if (options.pipenv ?? false) {
        //   this.depsManager = new Pipenv(this, options);
        //   this.envManager = this.depsManager;
        // }
        if ((_e = options.poetry) !== null && _e !== void 0 ? _e : false) {
            const poetry = new poetry_1.Poetry(this, {
                version: options.version,
                description: options.description,
                authorName: options.authorName,
                authorEmail: options.authorEmail,
                license: options.license,
                homepage: options.homepage,
                classifiers: options.classifiers,
                poetryOptions: {
                    readme: (_g = (_f = options.readme) === null || _f === void 0 ? void 0 : _f.filename) !== null && _g !== void 0 ? _g : 'README.md',
                    ...options.poetryOptions,
                },
            });
            this.depsManager = poetry;
            this.envManager = poetry;
            this.packagingManager = poetry;
        }
        if (!this.envManager) {
            throw new Error('At least one tool must be chosen for managing the environment (venv, conda, pipenv, or poetry).');
        }
        if (!this.depsManager) {
            throw new Error('At least one tool must be chosen for managing dependencies (pip, conda, pipenv, or poetry).');
        }
        if (!this.packagingManager && this.projectType === project_1.ProjectType.LIB) {
            throw new Error('At least one tool must be chosen for managing packaging (setuptools or poetry).');
        }
        if (Number((_h = options.venv) !== null && _h !== void 0 ? _h : true) + Number((_j = options.poetry) !== null && _j !== void 0 ? _j : false) > 1) {
            throw new Error('More than one component has been chosen for managing the environment (venv, conda, pipenv, or poetry)');
        }
        if (Number((_k = options.pip) !== null && _k !== void 0 ? _k : true) + Number((_l = options.poetry) !== null && _l !== void 0 ? _l : false) > 1) {
            throw new Error('More than one component has been chosen for managing dependencies (pip, conda, pipenv, or poetry)');
        }
        if (Number((_m = options.setuptools) !== null && _m !== void 0 ? _m : true) + Number((_o = options.poetry) !== null && _o !== void 0 ? _o : false) > 1) {
            throw new Error('More than one component has been chosen for managing packaging (setuptools or poetry)');
        }
        if ((_p = options.pytest) !== null && _p !== void 0 ? _p : true) {
            this.pytest = new pytest_1.Pytest(this, options.pytestOptions);
        }
        if ((_q = options.sample) !== null && _q !== void 0 ? _q : true) {
            new python_sample_1.PythonSample(this, {});
        }
        for (const dep of (_r = options.deps) !== null && _r !== void 0 ? _r : []) {
            this.addDependency(dep);
        }
        for (const dep of (_s = options.devDeps) !== null && _s !== void 0 ? _s : []) {
            this.addDevDependency(dep);
        }
        this.addDefaultGitIgnore();
        // python currently only supports projenrc in java (would be great to
        // support .projenrc.py of course).
        new javascript_1.Projenrc(this);
    }
    /**
     * Adds default gitignore options for a Python project based on
     * https://github.com/github/gitignore/blob/master/Python.gitignore
     */
    addDefaultGitIgnore() {
        this.gitignore.exclude('# Byte-compiled / optimized / DLL files', '__pycache__/', '*.py[cod]', '*$py.class', '', '# C extensions', '*.so', '', '# Distribution / packaging', '.Python', 'build/', 'develop-eggs/', 'dist/', 'downloads/', 'eggs/', '.eggs/', 'lib/', 'lib64/', 'parts/', 'sdist/', 'var/', 'wheels/', 'share/python-wheels/', '*.egg-info/', '.installed.cfg', '*.egg', 'MANIFEST', '', '# PyInstaller', '#  Usually these files are written by a python script from a template', '#  before PyInstaller builds the exe, so as to inject date/other infos into it.', '*.manifest', '*.spec', '', '# Installer logs', 'pip-log.txt', 'pip-delete-this-directory.txt', '', '# Unit test / coverage reports', 'htmlcov/', '.tox/', '.nox/', '.coverage', '.coverage.*', '.cache', 'nosetests.xml', 'coverage.xml', '*.cover', '*.py,cover', '.hypothesis/', '.pytest_cache/', 'cover/', '', '# Translations', '*.mo', '*.pot', '', '# Django stuff:', '*.log', 'local_settings.py', 'db.sqlite3', 'db.sqlite3-journal', '', '# Flask stuff:', 'instance/', '.webassets-cache', '', '# Scrapy stuff:', '.scrapy', '', '# Sphinx documentation', 'docs/_build/', '', '# PyBuilder', '.pybuilder/', 'target/', '', '# Jupyter Notebook', '.ipynb_checkpoints', '', '# IPython', 'profile_default/', 'ipython_config.py', '', '# PEP 582; used by e.g. github.com/David-OConnor/pyflow', '__pypackages__/', '', '# Celery stuff', 'celerybeat-schedule', 'celerybeat.pid', '', '# SageMath parsed files', '*.sage.py', '', '# Environments', '.env', '.venv', 'env/', 'venv/', 'ENV/', 'env.bak/', 'venv.bak/', '', '# Spyder project settings', '.spyderproject', '.spyproject', '', '# Rope project settings', '.ropeproject', '', '# mkdocs documentation', '/site', '', '# mypy', '.mypy_cache/', '.dmypy.json', 'dmypy.json', '', '# Pyre type checker', '.pyre/', '', '# pytype static type analyzer', '.pytype/', '', '# Cython debug symbols', 'cython_debug/');
    }
    /**
     * (experimental) Adds a runtime dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDependency(spec) {
        return this.depsManager.addDependency(spec);
    }
    /**
     * (experimental) Adds a dev dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDevDependency(spec) {
        return this.depsManager.addDevDependency(spec);
    }
    /**
     * (experimental) Called after all components are synthesized.
     *
     * Order is *not* guaranteed.
     *
     * @experimental
     */
    postSynthesize() {
        super.postSynthesize();
        this.envManager.setupEnvironment();
        this.depsManager.installDependencies();
    }
}
exports.PythonProject = PythonProject;
_a = JSII_RTTI_SYMBOL_1;
PythonProject[_a] = { fqn: "projen.python.PythonProject", version: "0.17.72" };
//# sourceMappingURL=data:application/json;base64,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