"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Jest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const semver = require("semver");
const tasks_1 = require("./tasks");
const typescript_1 = require("./typescript");
const DEFAULT_TEST_REPORTS_DIR = 'test-reports';
/**
 * (experimental) Installs the following npm scripts:.
 *
 * - `test` will run `jest --passWithNoTests`
 * - `test:watch` will run `jest --watch`
 * - `test:update` will run `jest -u`
 *
 * @experimental
 */
class Jest {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3;
        this.project = project;
        // Jest snapshot files are generated files!
        (_b = project.root.github) === null || _b === void 0 ? void 0 : _b.annotateGenerated('*.snap');
        const jestDep = options.jestVersion ? `jest@${options.jestVersion}` : 'jest';
        project.addDevDeps(jestDep);
        this.jestConfig = options.jestConfig;
        this.typescriptConfig = options.typescriptConfig;
        this.ignorePatterns = (_e = (_d = (_c = this.jestConfig) === null || _c === void 0 ? void 0 : _c.testPathIgnorePatterns) !== null && _d !== void 0 ? _d : options.ignorePatterns) !== null && _e !== void 0 ? _e : ['/node_modules/'];
        this.watchIgnorePatterns = (_g = (_f = this.jestConfig) === null || _f === void 0 ? void 0 : _f.watchPathIgnorePatterns) !== null && _g !== void 0 ? _g : ['/node_modules/'];
        this.coverageReporters = (_j = (_h = this.jestConfig) === null || _h === void 0 ? void 0 : _h.coverageReporters) !== null && _j !== void 0 ? _j : ['json', 'lcov', 'clover'];
        this.testMatch = (_l = (_k = this.jestConfig) === null || _k === void 0 ? void 0 : _k.testMatch) !== null && _l !== void 0 ? _l : ['**\/__tests__/**\/*.[jt]s?(x)', '**\/?(*.)+(spec|test).[tj]s?(x)'];
        const coverageDirectory = (_o = (_m = this.jestConfig) === null || _m === void 0 ? void 0 : _m.coverageDirectory) !== null && _o !== void 0 ? _o : 'coverage';
        this.reporters = [];
        if ((_p = options.preserveDefaultReporters) !== null && _p !== void 0 ? _p : true) {
            this.reporters.unshift('default');
        }
        this.config = {
            ...this.jestConfig,
            clearMocks: (_r = (_q = this.jestConfig) === null || _q === void 0 ? void 0 : _q.clearMocks) !== null && _r !== void 0 ? _r : true,
            collectCoverage: (_u = (_s = options.coverage) !== null && _s !== void 0 ? _s : (_t = this.jestConfig) === null || _t === void 0 ? void 0 : _t.collectCoverage) !== null && _u !== void 0 ? _u : true,
            coverageReporters: this.coverageReporters,
            coverageDirectory: coverageDirectory,
            coveragePathIgnorePatterns: (_w = (_v = this.jestConfig) === null || _v === void 0 ? void 0 : _v.coveragePathIgnorePatterns) !== null && _w !== void 0 ? _w : this.ignorePatterns,
            testPathIgnorePatterns: this.ignorePatterns,
            watchPathIgnorePatterns: this.watchIgnorePatterns,
            testMatch: this.testMatch,
            reporters: this.reporters,
            snapshotResolver: (() => this._snapshotResolver),
        };
        if ((_x = options.junitReporting) !== null && _x !== void 0 ? _x : true) {
            const reportsDir = DEFAULT_TEST_REPORTS_DIR;
            this.addReporter([
                'jest-junit',
                { outputDirectory: reportsDir },
            ]);
            project.addDevDeps('jest-junit@^12');
            project.gitignore.exclude('# jest-junit artifacts', `/${reportsDir}/`, 'junit.xml');
            (_y = project.npmignore) === null || _y === void 0 ? void 0 : _y.exclude('# jest-junit artifacts', `/${reportsDir}/`, 'junit.xml');
        }
        if ((_z = this.jestConfig) === null || _z === void 0 ? void 0 : _z.reporters) {
            for (const reporter of this.jestConfig.reporters) {
                this.addReporter(reporter);
            }
        }
        if ((_0 = this.jestConfig) === null || _0 === void 0 ? void 0 : _0.coverageThreshold) {
            this.config.coverageThreshold = {
                global: (_1 = this.jestConfig) === null || _1 === void 0 ? void 0 : _1.coverageThreshold,
            };
        }
        this.configureTestCommand();
        project.addFields({ jest: this.config });
        const coverageDirectoryPath = path.posix.join('/', coverageDirectory);
        (_2 = project.npmignore) === null || _2 === void 0 ? void 0 : _2.exclude(coverageDirectoryPath);
        project.gitignore.exclude(coverageDirectoryPath);
        if ((_3 = options.coverageText) !== null && _3 !== void 0 ? _3 : true) {
            this.coverageReporters.push('text');
        }
    }
    /**
     * (experimental) Adds a test match pattern.
     *
     * @param pattern glob pattern to match for tests.
     * @experimental
     */
    addTestMatch(pattern) {
        this.testMatch.push(pattern);
    }
    /**
     * (experimental) Adds a watch ignore pattern.
     *
     * @param pattern The pattern (regular expression).
     * @experimental
     */
    addWatchIgnorePattern(pattern) {
        this.watchIgnorePatterns.push(pattern);
    }
    /**
     * @experimental
     */
    addIgnorePattern(pattern) {
        this.ignorePatterns.push(pattern);
    }
    /**
     * @experimental
     */
    addReporter(reporter) {
        this.reporters.push(reporter);
    }
    /**
     * @experimental
     */
    addSnapshotResolver(file) {
        this._snapshotResolver = file;
    }
    /**
     * (experimental) Merges passed in typescript config options with jest configured typescript options from .projenrc Add Jest config settings for typescript options.
     *
     * @param options TypescriptConfigOptions.
     * @experimental
     */
    generateTypescriptConfig(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j;
        const tsconfig = new typescript_1.TypescriptConfig(this.project, {
            fileName: (_b = options.fileName) !== null && _b !== void 0 ? _b : 'tsconfig.jest.json',
            include: [
                ...options.include ? options.include : [],
                ...((_c = this.typescriptConfig) === null || _c === void 0 ? void 0 : _c.include) ? (_d = this.typescriptConfig) === null || _d === void 0 ? void 0 : _d.include : [],
            ],
            exclude: [
                ...options.exclude ? options.exclude : [],
                ...((_e = this.typescriptConfig) === null || _e === void 0 ? void 0 : _e.exclude) ? (_f = this.typescriptConfig) === null || _f === void 0 ? void 0 : _f.exclude : [],
            ],
            compilerOptions: {
                ...options.compilerOptions,
                ...(_g = this.typescriptConfig) === null || _g === void 0 ? void 0 : _g.compilerOptions,
            },
        });
        this.config.preset = 'ts-jest';
        // only process .ts files
        this.config.testMatch = (_j = (_h = this.jestConfig) === null || _h === void 0 ? void 0 : _h.testMatch) !== null && _j !== void 0 ? _j : [
            '**/__tests__/**/*.ts?(x)',
            '**/?(*.)+(spec|test).ts?(x)',
        ];
        // specify tsconfig.json
        this.config.globals = {
            'ts-jest': {
                tsconfig: tsconfig.fileName,
            },
        };
        // add relevant deps
        this.project.addDevDeps('@types/jest', 'ts-jest');
        return tsconfig;
    }
    configureTestCommand() {
        const jestOpts = ['--passWithNoTests', '--all'];
        // if the project has anti-tamper configured, it should be safe to always run tests
        // with --updateSnapshot because if we forget to commit a snapshot change the CI build will fail.
        if (this.project.antitamper) {
            jestOpts.push('--updateSnapshot');
        }
        // as recommended in the jest docs, node > 14 may use native v8 coverage collection
        // https://jestjs.io/docs/en/cli#--coverageproviderprovider
        if (this.project.package.minNodeVersion && semver.gte(this.project.package.minNodeVersion, '14.0.0')) {
            jestOpts.push('--coverageProvider=v8');
        }
        this.project.testTask.exec(`jest ${jestOpts.join(' ')}`);
        this.project.addTask('test:watch', {
            description: 'Run jest in watch mode',
            category: tasks_1.TaskCategory.TEST,
            exec: 'jest --watch',
        });
        this.project.addTask('test:update', {
            description: 'Update jest snapshots',
            category: tasks_1.TaskCategory.TEST,
            exec: 'jest --updateSnapshot',
        });
    }
}
exports.Jest = Jest;
_a = JSII_RTTI_SYMBOL_1;
Jest[_a] = { fqn: "projen.Jest", version: "0.17.72" };
//# sourceMappingURL=data:application/json;base64,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