"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const component_1 = require("../component");
const render_options_1 = require("../javascript/render-options");
const typescript_1 = require("../typescript");
/**
 * (experimental) Sets up a typescript project to use TypeScript for projenrc.
 *
 * @experimental
 */
class Projenrc extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c;
        super(project);
        this.rcfile = (_b = options.filename) !== null && _b !== void 0 ? _b : '.projenrc.js';
        this.comments = (_c = options.comments) !== null && _c !== void 0 ? _c : true;
        // this is the task projen executes when running `projen`
        project.addTask(typescript_1.TypeScriptProject.DEFAULT_TASK, { exec: `node ${this.rcfile}` });
        this.generateProjenrc();
    }
    generateProjenrc() {
        const rcfile = path_1.resolve(this.project.outdir, this.rcfile);
        if (fs_1.existsSync(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.newProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split('.');
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join('.');
        const js = render_options_1.renderJavaScriptOptions({
            comments: this.comments,
            args: bootstrap.args,
            type: bootstrap.type,
        });
        const lines = new Array();
        lines.push(`const { ${importName} } = require('${moduleName}');`);
        lines.push();
        lines.push(`const project = new ${className}(${js});`);
        lines.push();
        lines.push('project.synth();');
        fs_1.writeFileSync(rcfile, lines.join('\n'));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.javascript.Projenrc", version: "0.17.72" };
//# sourceMappingURL=data:application/json;base64,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