"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentPlaceholders = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Placeholders which can be used manifests
 *
 * These can occur both in the Asset Manifest as well as the general
 * Cloud Assembly manifest.
 */
class EnvironmentPlaceholders {
    /**
     * Replace the environment placeholders in all strings found in a complex object.
     *
     * Duplicated between cdk-assets and aws-cdk CLI because we don't have a good single place to put it
     * (they're nominally independent tools).
     */
    static replace(object, values) {
        jsiiDeprecationWarnings._aws_cdk_cx_api_EnvironmentPlaceholderValues(values);
        return this.recurse(object, value => {
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_REGION, values.region);
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_ACCOUNT, values.accountId);
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_PARTITION, values.partition);
            return value;
        });
    }
    /**
     * Like 'replace', but asynchronous
     */
    static async replaceAsync(object, provider) {
        jsiiDeprecationWarnings._aws_cdk_cx_api_IEnvironmentPlaceholderProvider(provider);
        let needRegion = false;
        let needAccountId = false;
        let needPartition = false;
        this.recurse(object, value => {
            if (value.indexOf(EnvironmentPlaceholders.CURRENT_REGION) > 1) {
                needRegion = true;
            }
            if (value.indexOf(EnvironmentPlaceholders.CURRENT_ACCOUNT) > 1) {
                needAccountId = true;
            }
            if (value.indexOf(EnvironmentPlaceholders.CURRENT_PARTITION) > 1) {
                needPartition = true;
            }
            return value;
        });
        const region = needRegion ? await provider.region() : undefined;
        const accountId = needAccountId ? await provider.accountId() : undefined;
        const partition = needPartition ? await provider.partition() : undefined;
        return this.recurse(object, value => {
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_REGION, region !== null && region !== void 0 ? region : 'WONTHAPPEN');
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_ACCOUNT, accountId !== null && accountId !== void 0 ? accountId : 'WONTHAPPEN');
            value = replaceAll(value, EnvironmentPlaceholders.CURRENT_PARTITION, partition !== null && partition !== void 0 ? partition : 'WONTHAPPEN');
            return value;
        });
    }
    static recurse(value, cb) {
        if (typeof value === 'string') {
            return cb(value);
        }
        if (typeof value !== 'object' || value === null) {
            return value;
        }
        if (Array.isArray(value)) {
            return value.map(x => this.recurse(x, cb));
        }
        const ret = {};
        for (const [key, inner] of Object.entries(value)) {
            ret[key] = this.recurse(inner, cb);
        }
        return ret;
    }
}
exports.EnvironmentPlaceholders = EnvironmentPlaceholders;
_a = JSII_RTTI_SYMBOL_1;
EnvironmentPlaceholders[_a] = { fqn: "@aws-cdk/cx-api.EnvironmentPlaceholders", version: "1.149.0" };
/**
 * Insert this into the destination fields to be replaced with the current region
 */
EnvironmentPlaceholders.CURRENT_REGION = '${AWS::Region}';
/**
 * Insert this into the destination fields to be replaced with the current account
 */
EnvironmentPlaceholders.CURRENT_ACCOUNT = '${AWS::AccountId}';
/**
 * Insert this into the destination fields to be replaced with the current partition
 */
EnvironmentPlaceholders.CURRENT_PARTITION = '${AWS::Partition}';
/**
 * A "replace-all" function that doesn't require us escaping a literal string to a regex
 */
function replaceAll(s, search, replace) {
    return s.split(search).join(replace);
}
//# sourceMappingURL=data:application/json;base64,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