"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SuperDomain = exports.ELBtype = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const certmgr = require("@aws-cdk/aws-certificatemanager");
const r53 = require("@aws-cdk/aws-route53");
const r53tg = require("@aws-cdk/aws-route53-targets");
const cdk = require("@aws-cdk/core");
var ELBtype;
(function (ELBtype) {
    /**
     * Application Load Balancer
     */
    ELBtype["ALB"] = "ALB";
    /**
     * Network Load Balancer
     */
    ELBtype["NLB"] = "NLB";
})(ELBtype = exports.ELBtype || (exports.ELBtype = {}));
class SuperDomain extends cdk.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.zone = this._setzone(props);
        this.acm = (_b = props.acm) !== null && _b !== void 0 ? _b : this._setacm(props);
        this.record = this._setaliasrecord(props);
    }
    _setzone(props) {
        return r53.HostedZone.fromHostedZoneAttributes(this, 'zone', {
            hostedZoneId: props.hostedZoneId,
            zoneName: props.zoneName,
        });
    }
    _setacm(props) {
        return new certmgr.Certificate(this, 'cert', {
            domainName: `*.${props.zoneName}`,
            validation: certmgr.CertificateValidation.fromDns(this.zone),
        });
    }
    _setaliasrecord(props) {
        var _b;
        return new r53.ARecord(this, 'alias-alb', {
            zone: this.zone,
            target: r53.RecordTarget.fromAlias(new r53tg.LoadBalancerTarget(props.loadbalancer)),
            recordName: props.recordName,
            ttl: (_b = props.ttl) !== null && _b !== void 0 ? _b : cdk.Duration.minutes(5),
        });
    }
}
exports.SuperDomain = SuperDomain;
_a = JSII_RTTI_SYMBOL_1;
SuperDomain[_a] = { fqn: "@cdk-constructs-zone/super-ec2.SuperDomain", version: "0.0.308" };
//# sourceMappingURL=data:application/json;base64,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