"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Gitpod = exports.GitpodPortVisibility = exports.GitpodOnOpen = exports.GitpodOpenIn = exports.GitpodOpenMode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const yaml_1 = require("./yaml");
/**
  * Relative path of Gitpod file to generate
  */
const GITPOD_FILE = '.gitpod.yml';
/**
 * (experimental) Configure how the terminal should be opened relative to the previous task.
 *
 * @experimental
 */
var GitpodOpenMode;
(function (GitpodOpenMode) {
    GitpodOpenMode["TAB_AFTER"] = "tab-after";
    GitpodOpenMode["TAB_BEFORE"] = "tab-before";
    GitpodOpenMode["SPLIT_RIGHT"] = "split-right";
    GitpodOpenMode["SPLIT_LEFT"] = "split-left";
    GitpodOpenMode["SPLIT_TOP"] = "split-top";
    GitpodOpenMode["SPLIT_BOTTOM"] = "split-bottom";
})(GitpodOpenMode = exports.GitpodOpenMode || (exports.GitpodOpenMode = {}));
/**
 * (experimental) Configure where in the IDE the terminal should be opened.
 *
 * @experimental
 */
var GitpodOpenIn;
(function (GitpodOpenIn) {
    GitpodOpenIn["BOTTOM"] = "bottom";
    GitpodOpenIn["LEFT"] = "left";
    GitpodOpenIn["RIGHT"] = "right";
    GitpodOpenIn["MAIN"] = "main";
})(GitpodOpenIn = exports.GitpodOpenIn || (exports.GitpodOpenIn = {}));
/**
 * (experimental) What to do when a service on a port is detected.
 *
 * @experimental
 */
var GitpodOnOpen;
(function (GitpodOnOpen) {
    GitpodOnOpen["OPEN_BROWSER"] = "open-browser";
    GitpodOnOpen["OPEN_PREVIEW"] = "open-preview";
    GitpodOnOpen["NOTIFY"] = "notify";
    GitpodOnOpen["IGNORE"] = "ignore";
})(GitpodOnOpen = exports.GitpodOnOpen || (exports.GitpodOnOpen = {}));
/**
 * (experimental) Whether the port visibility should be private or public.
 *
 * @experimental
 */
var GitpodPortVisibility;
(function (GitpodPortVisibility) {
    GitpodPortVisibility["PUBLIC"] = "public";
    GitpodPortVisibility["PRIVATE"] = "private";
})(GitpodPortVisibility = exports.GitpodPortVisibility || (exports.GitpodPortVisibility = {}));
/**
 * (experimental) The Gitpod component which emits .gitpod.yml.
 *
 * @experimental
 */
class Gitpod extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        super(project);
        this.tasks = new Array();
        this.ports = new Array();
        this.vscodeExtensions = new Array();
        this.dockerImage = options === null || options === void 0 ? void 0 : options.dockerImage;
        if (options === null || options === void 0 ? void 0 : options.tasks) {
            for (const task of options.tasks) {
                this.addTasks(task);
            }
        }
        if (options === null || options === void 0 ? void 0 : options.prebuilds) {
            this.addPrebuilds(options === null || options === void 0 ? void 0 : options.prebuilds);
        }
        this.config = {
            image: () => this.renderDockerImage(),
            tasks: this.tasks,
            github: () => this.renderPrebuilds(),
            ports: this.ports,
            vscode: {
                extensions: this.vscodeExtensions,
            },
        };
        new yaml_1.YamlFile(this.project, GITPOD_FILE, { obj: this.config, omitEmpty: true });
    }
    /**
     * (experimental) Add a custom Docker image or Dockerfile for the container.
     *
     * @param image The Docker image.
     * @experimental
     */
    addDockerImage(image) {
        if (this.dockerImage) {
            throw new Error('dockerImage cannot be redefined.');
        }
        this.dockerImage = image;
    }
    /**
     * (experimental) Add tasks to run when gitpod starts.
     *
     * By default, all tasks will be run in parallel. To run tasks in sequence,
     * create a new `Task` and specify the other tasks as subtasks.
     *
     * @param tasks The new tasks.
     * @experimental
     */
    addTasks(...tasks) {
        this.tasks.push(...tasks.map(task => ({
            name: task.name,
            command: `npx projen ${task.name}`,
        })));
    }
    /**
     * (experimental) Add a prebuilds configuration for the Gitpod App.
     *
     * @param config The configuration.
     * @experimental
     */
    addPrebuilds(config) {
        this.prebuilds = config;
    }
    /**
     * (experimental) Add a task with more granular options.
     *
     * By default, all tasks will be run in parallel. To run tasks in sequence,
     * create a new `Task` and set the other tasks as subtasks.
     *
     * @param options The task parameters.
     * @experimental
     */
    addCustomTask(options) {
        this.tasks.push({
            name: options.name,
            command: options.command,
            openMode: options.openMode,
            openIn: options.openIn,
            before: options.before,
            init: options.init,
            prebuild: options.prebuild,
        });
    }
    /**
     * (experimental) Add ports that should be exposed (forwarded) from the container.
     *
     * @param ports The new ports.
     * @experimental
     */
    addPorts(...ports) {
        this.ports.push(...ports.map(port => ({ port: port })));
    }
    /**
     * (experimental) Add a list of VSCode extensions that should be automatically installed in the container.
     *
     * These must be in the format defined in the Open VSX registry.
     *
     * @param extensions The extension IDs.
     * @see https://www.gitpod.io/docs/vscode-extensions/
     * @experimental
     * @example
     *
     * 'scala-lang.scala@0.3.9:O5XmjwY5Gz+0oDZAmqneJw=='
     */
    addVscodeExtensions(...extensions) {
        this.vscodeExtensions.push(...extensions);
    }
    renderDockerImage() {
        var _b, _c;
        if ((_b = this.dockerImage) === null || _b === void 0 ? void 0 : _b.image) {
            return this.dockerImage.image;
        }
        else if ((_c = this.dockerImage) === null || _c === void 0 ? void 0 : _c.dockerFile) {
            return {
                file: this.dockerImage.dockerFile,
            };
        }
        else {
            return undefined;
        }
    }
    renderPrebuilds() {
        if (this.prebuilds) {
            return {
                prebuilds: this.prebuilds,
            };
        }
        else {
            return undefined;
        }
    }
}
exports.Gitpod = Gitpod;
_a = JSII_RTTI_SYMBOL_1;
Gitpod[_a] = { fqn: "projen.Gitpod", version: "0.17.71" };
//# sourceMappingURL=data:application/json;base64,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