"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Eslint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const component_1 = require("./component");
const json_1 = require("./json");
const tasks_1 = require("./tasks");
/**
 * @experimental
 */
class Eslint extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b, _c, _d, _e, _f, _g;
        super(project);
        project.addDevDeps('eslint', '@typescript-eslint/eslint-plugin', '@typescript-eslint/parser', 'eslint-import-resolver-node', 'eslint-import-resolver-typescript', 'eslint-plugin-import', 'json-schema');
        const devdirs = (_b = options.devdirs) !== null && _b !== void 0 ? _b : [];
        const dirs = [...options.dirs, ...devdirs];
        const fileExtensions = (_c = options.fileExtensions) !== null && _c !== void 0 ? _c : ['.ts'];
        this._allowDevDeps = (devdirs !== null && devdirs !== void 0 ? devdirs : []).map(dir => `**/${dir}/**`);
        const lintProjenRc = (_d = options.lintProjenRc) !== null && _d !== void 0 ? _d : true;
        const eslint = project.addTask('eslint', {
            description: 'Runs eslint against the codebase',
            category: tasks_1.TaskCategory.TEST,
            exec: [
                'eslint',
                `--ext ${fileExtensions.join(',')}`,
                '--fix',
                '--no-error-on-unmatched-pattern',
                ...dirs,
                ...lintProjenRc ? [common_1.PROJEN_RC] : [],
            ].join(' '),
        });
        project.testTask.spawn(eslint);
        // exclude some files
        (_e = project.npmignore) === null || _e === void 0 ? void 0 : _e.exclude('/.eslintrc.json');
        this.rules = {
            // Require use of the `import { foo } from 'bar';` form instead of `import foo = require('bar');`
            '@typescript-eslint/no-require-imports': ['error'],
            // see https://github.com/typescript-eslint/typescript-eslint/blob/master/packages/eslint-plugin/docs/rules/indent.md
            'indent': ['off'],
            '@typescript-eslint/indent': ['error', 2],
            // Style
            'quotes': ['error', 'single', { avoidEscape: true }],
            'comma-dangle': ['error', 'always-multiline'],
            'comma-spacing': ['error', { before: false, after: true }],
            'no-multi-spaces': ['error', { ignoreEOLComments: false }],
            'array-bracket-spacing': ['error', 'never'],
            'array-bracket-newline': ['error', 'consistent'],
            'object-curly-spacing': ['error', 'always'],
            'object-curly-newline': ['error', { multiline: true, consistent: true }],
            'object-property-newline': ['error', { allowAllPropertiesOnSameLine: true }],
            'keyword-spacing': ['error'],
            'brace-style': ['error', '1tbs', { allowSingleLine: true }],
            'space-before-blocks': ['error'],
            'curly': ['error', 'multi-line', 'consistent'],
            '@typescript-eslint/member-delimiter-style': ['error'],
            // Require all imported dependencies are actually declared in package.json
            'import/no-extraneous-dependencies': [
                'error',
                {
                    // Only allow importing devDependencies from "devdirs".
                    devDependencies: () => this.renderDevDepsAllowList(),
                    optionalDependencies: false,
                    peerDependencies: true,
                },
            ],
            // Require all imported libraries actually resolve (!!required for import/no-extraneous-dependencies to work!!)
            'import/no-unresolved': ['error'],
            // Require an ordering on all imports
            'import/order': ['warn', {
                    groups: ['builtin', 'external'],
                    alphabetize: { order: 'asc', caseInsensitive: true },
                }],
            // Cannot import from the same module twice
            'no-duplicate-imports': ['error'],
            // Cannot shadow names
            'no-shadow': ['off'],
            '@typescript-eslint/no-shadow': ['error'],
            // Required spacing in property declarations (copied from TSLint, defaults are good)
            'key-spacing': ['error'],
            // Require semicolons
            'semi': ['error', 'always'],
            // Don't unnecessarily quote properties
            'quote-props': ['error', 'consistent-as-needed'],
            // No multiple empty lines
            'no-multiple-empty-lines': ['error'],
            // Max line lengths
            'max-len': ['error', {
                    code: 150,
                    ignoreUrls: true,
                    ignoreStrings: true,
                    ignoreTemplateLiterals: true,
                    ignoreComments: true,
                    ignoreRegExpLiterals: true,
                }],
            // One of the easiest mistakes to make
            '@typescript-eslint/no-floating-promises': ['error'],
            // Make sure that inside try/catch blocks, promises are 'return await'ed
            // (must disable the base rule as it can report incorrect errors)
            'no-return-await': ['off'],
            '@typescript-eslint/return-await': ['error'],
            // Useless diff results
            'no-trailing-spaces': ['error'],
            // Must use foo.bar instead of foo['bar'] if possible
            'dot-notation': ['error'],
            // Are you sure | is not a typo for || ?
            'no-bitwise': ['error'],
            // Member ordering
            '@typescript-eslint/member-ordering': ['error', {
                    default: [
                        'public-static-field',
                        'public-static-method',
                        'protected-static-field',
                        'protected-static-method',
                        'private-static-field',
                        'private-static-method',
                        'field',
                        // Constructors
                        'constructor',
                        // Methods
                        'method',
                    ],
                }],
        };
        // Overrides for .projenrc.js
        this.overrides = [
            {
                files: [common_1.PROJEN_RC],
                rules: {
                    '@typescript-eslint/no-require-imports': 'off',
                    'import/no-extraneous-dependencies': 'off',
                },
            },
        ];
        this.ignorePatterns = (_f = options.ignorePatterns) !== null && _f !== void 0 ? _f : [
            '*.js',
            `!${common_1.PROJEN_RC}`,
            '*.d.ts',
            'node_modules/',
            '*.generated.ts',
            'coverage',
        ];
        const tsconfig = (_g = options.tsconfigPath) !== null && _g !== void 0 ? _g : './tsconfig.json';
        this.config = {
            env: {
                jest: true,
                node: true,
            },
            root: true,
            plugins: [
                '@typescript-eslint',
                'import',
            ],
            parser: '@typescript-eslint/parser',
            parserOptions: {
                ecmaVersion: 2018,
                sourceType: 'module',
                project: tsconfig,
            },
            extends: [
                'plugin:import/typescript',
            ],
            settings: {
                'import/parsers': {
                    '@typescript-eslint/parser': ['.ts', '.tsx'],
                },
                'import/resolver': {
                    node: {},
                    typescript: {
                        project: tsconfig,
                    },
                },
            },
            ignorePatterns: this.ignorePatterns,
            rules: this.rules,
            overrides: this.overrides,
        };
        new json_1.JsonFile(project, '.eslintrc.json', { obj: this.config, marker: false });
    }
    /**
     * (experimental) Add an eslint rule.
     *
     * @experimental
     */
    addRules(rules) {
        for (const [k, v] of Object.entries(rules)) {
            this.rules[k] = v;
        }
    }
    /**
     * (experimental) Add an eslint override.
     *
     * @experimental
     */
    addOverride(override) {
        this.overrides.push(override);
    }
    /**
     * (experimental) Do not lint these files.
     *
     * @experimental
     */
    addIgnorePattern(pattern) {
        this.ignorePatterns.push(pattern);
    }
    /**
     * (experimental) Add a glob file pattern which allows importing dev dependencies.
     *
     * @param pattern glob pattern.
     * @experimental
     */
    allowDevDeps(pattern) {
        this._allowDevDeps.push(pattern);
    }
    renderDevDepsAllowList() {
        return this._allowDevDeps;
    }
}
exports.Eslint = Eslint;
_a = JSII_RTTI_SYMBOL_1;
Eslint[_a] = { fqn: "projen.Eslint", version: "0.17.71" };
//# sourceMappingURL=data:application/json;base64,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