"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryAws = exports.AwsCdkConstructLibrary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const construct_lib_1 = require("./construct-lib");
/**
 * (experimental) AWS CDK construct library project.
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the AWS CDK with a friendly workflow and automatic publishing to
 * the construct catalog.
 *
 * ```ts
 * const project = new ConstructLibraryAws({
 *    name: 'cdk-watchful',
 *    description: 'Watching your CDK apps since 2019',
 *    jsiiVersion: Semver.caret('1.7.0'),
 *    authorName: 'Elad Ben-Israel',
 *    authorEmail: 'elad.benisrael@gmail.com',
 *    repository: 'https://github.com/eladb/cdk-watchful.git',
 *    keywords: [
 *      "cloudwatch",
 *      "monitoring"
 *    ],
 *
 *    catalog: {
 *      twitter: 'emeshbi'
 *    },
 *
 *    // creates PRs for projen upgrades
 *    projenUpgradeSecret: 'PROJEN_GITHUB_TOKEN',
 *
 *    cdkVersion: '1.54.0',
 *    cdkDependencies: [
 *      "@aws-cdk/aws-apigateway",
 *      "@aws-cdk/aws-cloudwatch",
 *      "@aws-cdk/aws-cloudwatch-actions",
 *      "@aws-cdk/aws-dynamodb",
 *      "@aws-cdk/aws-ecs",
 *      "@aws-cdk/aws-ecs-patterns",
 *      "@aws-cdk/aws-elasticloadbalancingv2",
 *      "@aws-cdk/aws-events",
 *      "@aws-cdk/aws-events-targets",
 *      "@aws-cdk/aws-lambda",
 *      "@aws-cdk/aws-rds",
 *      "@aws-cdk/aws-sns",
 *      "@aws-cdk/aws-sns-subscriptions",
 *      "@aws-cdk/aws-sqs",
 *      "@aws-cdk/core"
 *    ],
 *    devDependencies: {
 *      "aws-sdk": Semver.caret("2.708.0")
 *    },
 *
 *    // jsii publishing
 *
 *    java: {
 *      javaPackage: 'com.github.eladb.watchful',
 *      mavenGroupId: 'com.github.eladb',
 *      mavenArtifactId: 'cdk-watchful'
 *    },
 *    python: {
 *      distName: 'cdk-watchful',
 *      module: 'cdk_watchful'
 *    }
 * });
 *
 * project.synth();
 * ```
 *
 * @experimental
 * @pjid awscdk-construct
 */
class AwsCdkConstructLibrary extends construct_lib_1.ConstructLibrary {
    /**
     * @experimental
     */
    constructor(options) {
        var _c, _d, _e, _f;
        super({
            ...options,
            peerDependencyOptions: {
                pinnedDevDependency: false,
            },
        });
        this.version = options.cdkVersionPinning ? options.cdkVersion : `^${options.cdkVersion}`;
        this.cdkDependenciesAsDeps = (_c = options.cdkDependenciesAsDeps) !== null && _c !== void 0 ? _c : true;
        if (options.constructsVersion) {
            this.addPeerDeps(`constructs@^${options.constructsVersion}`);
            this.addDevDeps(`constructs@${options.constructsVersion}`);
        }
        else if (options.cdkVersion.startsWith('1.')) {
            // CDK 1.x is built on constructs 3.x
            this.addPeerDeps('constructs@^3.2.27');
        }
        else if (options.cdkVersion.startsWith('2.')) {
            // CDK 2.x is built on constructs 10.x
            this.addPeerDeps('constructs@^10.0.5');
        }
        else {
            // Otherwise, let the user manage which version they use
            this.addPeerDeps('constructs');
        }
        if ((_d = options.cdkAssert) !== null && _d !== void 0 ? _d : true) {
            this.addDevDeps(this.formatModuleSpec('@aws-cdk/assert'));
        }
        this.addCdkDependencies(...(_e = options.cdkDependencies) !== null && _e !== void 0 ? _e : []);
        this.addCdkTestDependencies(...(_f = options.cdkTestDependencies) !== null && _f !== void 0 ? _f : []);
    }
    /**
     * (experimental) Adds CDK modules as runtime dependencies.
     *
     * Modules are currently by default added with a caret CDK version both as "dependencies"
     * and "peerDependencies". This is because currently npm would not
     * automatically install peer dependencies that are not declared as concerete
     * dependencies by the consumer, so this is a little npm "hack" so that
     * consumers will not need to depend on them directly if they don't interact
     * with them.
     * See `cdkDependenciesAsDeps` for changing the default behavior.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @experimental
     */
    addCdkDependencies(...deps) {
        // this ugliness will go away in cdk v2.0
        this.addPeerDeps(...deps.map(m => this.formatModuleSpec(m)));
        if (this.cdkDependenciesAsDeps) {
            this.addDeps(...deps.map(m => this.formatModuleSpec(m)));
        }
        else {
            this.addDevDeps(...deps.map(m => this.formatModuleSpec(m)));
        }
    }
    /**
     * (experimental) Adds CDK modules as test dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @experimental
     */
    addCdkTestDependencies(...deps) {
        this.addDevDeps(...deps.map(m => this.formatModuleSpec(m)));
    }
    formatModuleSpec(module) {
        return `${module}@${this.version}`;
    }
}
exports.AwsCdkConstructLibrary = AwsCdkConstructLibrary;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkConstructLibrary[_a] = { fqn: "projen.AwsCdkConstructLibrary", version: "0.17.71" };
/**
 * @deprecated use `AwsCdkConstructLibrary`
 */
class ConstructLibraryAws extends AwsCdkConstructLibrary {
}
exports.ConstructLibraryAws = ConstructLibraryAws;
_b = JSII_RTTI_SYMBOL_1;
ConstructLibraryAws[_b] = { fqn: "projen.ConstructLibraryAws", version: "0.17.71" };
//# sourceMappingURL=data:application/json;base64,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