"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestedStackSynthesizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _shared_1 = require("./_shared");
const stack_synthesizer_1 = require("./stack-synthesizer");
/**
 * Synthesizer for a nested stack
 *
 * Forwards all calls to the parent stack's synthesizer.
 *
 * This synthesizer is automatically used for `NestedStack` constructs.
 * App builder do not need to use this class directly.
 */
class NestedStackSynthesizer extends stack_synthesizer_1.StackSynthesizer {
    constructor(parentDeployment) {
        super();
        this.parentDeployment = parentDeployment;
        jsiiDeprecationWarnings._aws_cdk_core_IStackSynthesizer(parentDeployment);
    }
    bind(stack) {
        jsiiDeprecationWarnings._aws_cdk_core_Stack(stack);
        if (this.stack !== undefined) {
            throw new Error('A StackSynthesizer can only be used for one Stack: create a new instance to use with a different Stack');
        }
        this.stack = stack;
    }
    addFileAsset(asset) {
        jsiiDeprecationWarnings._aws_cdk_core_FileAssetSource(asset);
        // Forward to parent deployment. By the magic of cross-stack references any parameter
        // returned and used will magically be forwarded to the nested stack.
        return this.parentDeployment.addFileAsset(asset);
    }
    addDockerImageAsset(asset) {
        jsiiDeprecationWarnings._aws_cdk_core_DockerImageAssetSource(asset);
        // Forward to parent deployment. By the magic of cross-stack references any parameter
        // returned and used will magically be forwarded to the nested stack.
        return this.parentDeployment.addDockerImageAsset(asset);
    }
    synthesize(session) {
        jsiiDeprecationWarnings._aws_cdk_core_ISynthesisSession(session);
        _shared_1.assertBound(this.stack);
        // Synthesize the template, but don't emit as a cloud assembly artifact.
        // It will be registered as an S3 asset of its parent instead.
        this.synthesizeStackTemplate(this.stack, session);
    }
}
exports.NestedStackSynthesizer = NestedStackSynthesizer;
_a = JSII_RTTI_SYMBOL_1;
NestedStackSynthesizer[_a] = { fqn: "@aws-cdk/core.NestedStackSynthesizer", version: "1.146.0" };
//# sourceMappingURL=data:application/json;base64,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