"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnMapping = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const annotations_1 = require("./annotations");
const cfn_element_1 = require("./cfn-element");
const cfn_fn_1 = require("./cfn-fn");
const token_1 = require("./token");
/**
 * Represents a CloudFormation mapping.
 *
 * @stability stable
 */
class CfnMapping extends cfn_element_1.CfnRefElement {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id);
        this.lazyRender = false;
        this.lazyInformed = false;
        jsiiDeprecationWarnings._aws_cdk_core_CfnMappingProps(props);
        this.mapping = (_b = props.mapping) !== null && _b !== void 0 ? _b : {};
        this.lazy = props.lazy;
    }
    /**
     * Sets a value in the map based on the two keys.
     *
     * @stability stable
     */
    setValue(key1, key2, value) {
        if (!(key1 in this.mapping)) {
            this.mapping[key1] = {};
        }
        this.mapping[key1][key2] = value;
    }
    /**
     * @returns A reference to a value in the map based on the two keys.
     * @stability stable
     */
    findInMap(key1, key2) {
        let fullyResolved = false;
        if (!token_1.Token.isUnresolved(key1)) {
            if (!(key1 in this.mapping)) {
                throw new Error(`Mapping doesn't contain top-level key '${key1}'`);
            }
            if (!token_1.Token.isUnresolved(key2)) {
                if (!(key2 in this.mapping[key1])) {
                    throw new Error(`Mapping doesn't contain second-level key '${key2}'`);
                }
                fullyResolved = true;
            }
        }
        if (fullyResolved) {
            if (this.lazy) {
                return this.mapping[key1][key2];
            }
        }
        else {
            this.lazyRender = true;
        }
        return cfn_fn_1.Fn.findInMap(this.logicalId, key1, key2);
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        if (this.lazy === undefined && !this.lazyRender) {
            this.informLazyUse();
        }
        if (!this.lazy || (this.lazy && this.lazyRender)) {
            return {
                Mappings: {
                    [this.logicalId]: this.mapping,
                },
            };
        }
        else {
            return {};
        }
    }
    informLazyUse() {
        if (!this.lazyInformed) {
            annotations_1.Annotations.of(this).addInfo('Consider making this CfnMapping a lazy mapping by providing `lazy: true`: either no findInMap was called or every findInMap could be immediately resolved without using Fn::FindInMap');
        }
        this.lazyInformed = true;
    }
}
exports.CfnMapping = CfnMapping;
_a = JSII_RTTI_SYMBOL_1;
CfnMapping[_a] = { fqn: "@aws-cdk/core.CfnMapping", version: "1.144.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2ZuLW1hcHBpbmcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjZm4tbWFwcGluZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSwrQ0FBNEM7QUFDNUMsK0NBQThDO0FBQzlDLHFDQUE4QjtBQUM5QixtQ0FBZ0M7Ozs7OztBQWFoQyxNQUFhLFVBQVcsU0FBUSwyQkFBYTs7OztJQU0zQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFFBQXlCLEVBQUU7O1FBQ25FLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFKWCxlQUFVLEdBQUcsS0FBSyxDQUFDO1FBQ25CLGlCQUFZLEdBQUcsS0FBSyxDQUFDOztRQUkzQixJQUFJLENBQUMsT0FBTyxTQUFHLEtBQUssQ0FBQyxPQUFPLG1DQUFJLEVBQUcsQ0FBQztRQUNwQyxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7S0FDeEI7Ozs7OztJQUdNLFFBQVEsQ0FBQyxJQUFZLEVBQUUsSUFBWSxFQUFFLEtBQVU7UUFDcEQsSUFBSSxDQUFDLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsRUFBRTtZQUMzQixJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUcsQ0FBQztTQUMxQjtRQUVELElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsS0FBSyxDQUFDO0tBQ2xDOzs7OztJQUdNLFNBQVMsQ0FBQyxJQUFZLEVBQUUsSUFBWTtRQUN6QyxJQUFJLGFBQWEsR0FBRyxLQUFLLENBQUM7UUFDMUIsSUFBSSxDQUFDLGFBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLEVBQUU7WUFDN0IsSUFBSSxDQUFDLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsRUFBRTtnQkFDM0IsTUFBTSxJQUFJLEtBQUssQ0FBQywwQ0FBMEMsSUFBSSxHQUFHLENBQUMsQ0FBQzthQUNwRTtZQUNELElBQUksQ0FBQyxhQUFLLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxFQUFFO2dCQUM3QixJQUFJLENBQUMsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFO29CQUNqQyxNQUFNLElBQUksS0FBSyxDQUFDLDZDQUE2QyxJQUFJLEdBQUcsQ0FBQyxDQUFDO2lCQUN2RTtnQkFDRCxhQUFhLEdBQUcsSUFBSSxDQUFDO2FBQ3RCO1NBQ0Y7UUFDRCxJQUFJLGFBQWEsRUFBRTtZQUNqQixJQUFJLElBQUksQ0FBQyxJQUFJLEVBQUU7Z0JBQ2IsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDO2FBQ2pDO1NBQ0Y7YUFBTTtZQUNMLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO1FBQ0QsT0FBTyxXQUFFLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO0tBQ2pEO0lBRUQ7O09BRUc7SUFDSSxpQkFBaUI7UUFDdEIsSUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLFNBQVMsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDL0MsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO1NBQ3RCO1FBQ0QsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxVQUFVLENBQUMsRUFBRTtZQUNoRCxPQUFPO2dCQUNMLFFBQVEsRUFBRTtvQkFDUixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsRUFBRSxJQUFJLENBQUMsT0FBTztpQkFDL0I7YUFDRixDQUFDO1NBQ0g7YUFBTTtZQUNMLE9BQU8sRUFBRSxDQUFDO1NBQ1g7S0FDRjtJQUVPLGFBQWE7UUFDbkIsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLEVBQUU7WUFDdEIseUJBQVcsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLHVMQUF1TCxDQUFDLENBQUM7U0FDdk47UUFDRCxJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQztLQUMxQjs7QUFwRUgsZ0NBcUVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBBbm5vdGF0aW9ucyB9IGZyb20gJy4vYW5ub3RhdGlvbnMnO1xuaW1wb3J0IHsgQ2ZuUmVmRWxlbWVudCB9IGZyb20gJy4vY2ZuLWVsZW1lbnQnO1xuaW1wb3J0IHsgRm4gfSBmcm9tICcuL2Nmbi1mbic7XG5pbXBvcnQgeyBUb2tlbiB9IGZyb20gJy4vdG9rZW4nO1xuXG50eXBlIE1hcHBpbmcgPSB7IFtrMTogc3RyaW5nXTogeyBbazI6IHN0cmluZ106IGFueSB9IH07XG5cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuTWFwcGluZ1Byb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtYXBwaW5nPzogTWFwcGluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbGF6eT86IGJvb2xlYW47XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgQ2ZuTWFwcGluZyBleHRlbmRzIENmblJlZkVsZW1lbnQge1xuICBwcml2YXRlIG1hcHBpbmc6IE1hcHBpbmc7XG4gIHByaXZhdGUgcmVhZG9ubHkgbGF6eT86IGJvb2xlYW47XG4gIHByaXZhdGUgbGF6eVJlbmRlciA9IGZhbHNlO1xuICBwcml2YXRlIGxhenlJbmZvcm1lZCA9IGZhbHNlO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5NYXBwaW5nUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgdGhpcy5tYXBwaW5nID0gcHJvcHMubWFwcGluZyA/PyB7IH07XG4gICAgdGhpcy5sYXp5ID0gcHJvcHMubGF6eTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHNldFZhbHVlKGtleTE6IHN0cmluZywga2V5Mjogc3RyaW5nLCB2YWx1ZTogYW55KSB7XG4gICAgaWYgKCEoa2V5MSBpbiB0aGlzLm1hcHBpbmcpKSB7XG4gICAgICB0aGlzLm1hcHBpbmdba2V5MV0gPSB7IH07XG4gICAgfVxuXG4gICAgdGhpcy5tYXBwaW5nW2tleTFdW2tleTJdID0gdmFsdWU7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgZmluZEluTWFwKGtleTE6IHN0cmluZywga2V5Mjogc3RyaW5nKTogc3RyaW5nIHtcbiAgICBsZXQgZnVsbHlSZXNvbHZlZCA9IGZhbHNlO1xuICAgIGlmICghVG9rZW4uaXNVbnJlc29sdmVkKGtleTEpKSB7XG4gICAgICBpZiAoIShrZXkxIGluIHRoaXMubWFwcGluZykpIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKGBNYXBwaW5nIGRvZXNuJ3QgY29udGFpbiB0b3AtbGV2ZWwga2V5ICcke2tleTF9J2ApO1xuICAgICAgfVxuICAgICAgaWYgKCFUb2tlbi5pc1VucmVzb2x2ZWQoa2V5MikpIHtcbiAgICAgICAgaWYgKCEoa2V5MiBpbiB0aGlzLm1hcHBpbmdba2V5MV0pKSB7XG4gICAgICAgICAgdGhyb3cgbmV3IEVycm9yKGBNYXBwaW5nIGRvZXNuJ3QgY29udGFpbiBzZWNvbmQtbGV2ZWwga2V5ICcke2tleTJ9J2ApO1xuICAgICAgICB9XG4gICAgICAgIGZ1bGx5UmVzb2x2ZWQgPSB0cnVlO1xuICAgICAgfVxuICAgIH1cbiAgICBpZiAoZnVsbHlSZXNvbHZlZCkge1xuICAgICAgaWYgKHRoaXMubGF6eSkge1xuICAgICAgICByZXR1cm4gdGhpcy5tYXBwaW5nW2tleTFdW2tleTJdO1xuICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLmxhenlSZW5kZXIgPSB0cnVlO1xuICAgIH1cbiAgICByZXR1cm4gRm4uZmluZEluTWFwKHRoaXMubG9naWNhbElkLCBrZXkxLCBrZXkyKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHB1YmxpYyBfdG9DbG91ZEZvcm1hdGlvbigpOiBvYmplY3Qge1xuICAgIGlmICh0aGlzLmxhenkgPT09IHVuZGVmaW5lZCAmJiAhdGhpcy5sYXp5UmVuZGVyKSB7XG4gICAgICB0aGlzLmluZm9ybUxhenlVc2UoKTtcbiAgICB9XG4gICAgaWYgKCF0aGlzLmxhenkgfHwgKHRoaXMubGF6eSAmJiB0aGlzLmxhenlSZW5kZXIpKSB7XG4gICAgICByZXR1cm4ge1xuICAgICAgICBNYXBwaW5nczoge1xuICAgICAgICAgIFt0aGlzLmxvZ2ljYWxJZF06IHRoaXMubWFwcGluZyxcbiAgICAgICAgfSxcbiAgICAgIH07XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiB7fTtcbiAgICB9XG4gIH1cblxuICBwcml2YXRlIGluZm9ybUxhenlVc2UoKSB7XG4gICAgaWYgKCF0aGlzLmxhenlJbmZvcm1lZCkge1xuICAgICAgQW5ub3RhdGlvbnMub2YodGhpcykuYWRkSW5mbygnQ29uc2lkZXIgbWFraW5nIHRoaXMgQ2ZuTWFwcGluZyBhIGxhenkgbWFwcGluZyBieSBwcm92aWRpbmcgYGxhenk6IHRydWVgOiBlaXRoZXIgbm8gZmluZEluTWFwIHdhcyBjYWxsZWQgb3IgZXZlcnkgZmluZEluTWFwIGNvdWxkIGJlIGltbWVkaWF0ZWx5IHJlc29sdmVkIHdpdGhvdXQgdXNpbmcgRm46OkZpbmRJbk1hcCcpO1xuICAgIH1cbiAgICB0aGlzLmxhenlJbmZvcm1lZCA9IHRydWU7XG4gIH1cbn1cbiJdfQ==