import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface GetContextKeyOptions {
    /**
     * The context provider to query.
     *
     * @stability stable
     */
    readonly provider: string;
    /**
     * Provider-specific properties.
     *
     * @stability stable
     */
    readonly props?: {
        [key: string]: any;
    };
    /**
     * Whether to include the stack's account and region automatically.
     *
     * @default true
     * @stability stable
     */
    readonly includeEnvironment?: boolean;
}
/**
 * @stability stable
 */
export interface GetContextValueOptions extends GetContextKeyOptions {
    /**
     * The value to return if the context value was not found and a missing context is reported.
     *
     * This should be a dummy value that should preferably
     * fail during deployment since it represents an invalid state.
     *
     * @stability stable
     */
    readonly dummyValue: any;
}
/**
 * @stability stable
 */
export interface GetContextKeyResult {
    /**
     * @stability stable
     */
    readonly key: string;
    /**
     * @stability stable
     */
    readonly props: {
        [key: string]: any;
    };
}
/**
 * @stability stable
 */
export interface GetContextValueResult {
    /**
     * @stability stable
     */
    readonly value?: any;
}
/**
 * Base class for the model side of context providers.
 *
 * Instances of this class communicate with context provider plugins in the 'cdk
 * toolkit' via context variables (input), outputting specialized queries for
 * more context variables (output).
 *
 * ContextProvider needs access to a Construct to hook into the context mechanism.
 *
 * @stability stable
 */
export declare class ContextProvider {
    /**
     * @returns the context key or undefined if a key cannot be rendered (due to tokens used in any of the props)
     * @stability stable
     */
    static getKey(scope: Construct, options: GetContextKeyOptions): GetContextKeyResult;
    /**
     * @stability stable
     */
    static getValue(scope: Construct, options: GetContextValueOptions): GetContextValueResult;
    private constructor();
}
