"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationStackArtifact = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const cxschema = require("@aws-cdk/cloud-assembly-schema");
const cloud_artifact_1 = require("../cloud-artifact");
const environment_1 = require("../environment");
/**
 * @stability stable
 */
class CloudFormationStackArtifact extends cloud_artifact_1.CloudArtifact {
    /**
     * @stability stable
     */
    constructor(assembly, artifactId, artifact) {
        var _b, _c;
        super(assembly, artifactId, artifact);
        jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        const properties = (this.manifest.properties || {});
        if (!properties.templateFile) {
            throw new Error('Invalid CloudFormation stack artifact. Missing "templateFile" property in cloud assembly manifest');
        }
        if (!artifact.environment) {
            throw new Error('Invalid CloudFormation stack artifact. Missing environment');
        }
        this.environment = environment_1.EnvironmentUtils.parse(artifact.environment);
        this.templateFile = properties.templateFile;
        this.parameters = (_b = properties.parameters) !== null && _b !== void 0 ? _b : {};
        // We get the tags from 'properties' if available (cloud assembly format >= 6.0.0), otherwise
        // from the stack metadata
        this.tags = (_c = properties.tags) !== null && _c !== void 0 ? _c : this.tagsFromMetadata();
        this.assumeRoleArn = properties.assumeRoleArn;
        this.assumeRoleExternalId = properties.assumeRoleExternalId;
        this.cloudFormationExecutionRoleArn = properties.cloudFormationExecutionRoleArn;
        this.stackTemplateAssetObjectUrl = properties.stackTemplateAssetObjectUrl;
        this.requiresBootstrapStackVersion = properties.requiresBootstrapStackVersion;
        this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
        this.terminationProtection = properties.terminationProtection;
        this.validateOnSynth = properties.validateOnSynth;
        this.lookupRole = properties.lookupRole;
        this.stackName = properties.stackName || artifactId;
        this.assets = this.findMetadataByType(cxschema.ArtifactMetadataEntryType.ASSET).map(e => e.data);
        this.displayName = this.stackName === artifactId
            ? this.stackName
            : `${artifactId} (${this.stackName})`;
        this.name = this.stackName; // backwards compat
        this.originalName = this.stackName;
    }
    /**
     * Full path to the template file.
     *
     * @stability stable
     */
    get templateFullPath() {
        return path.join(this.assembly.directory, this.templateFile);
    }
    /**
     * The CloudFormation template for this stack.
     *
     * @stability stable
     */
    get template() {
        if (this._template === undefined) {
            this._template = JSON.parse(fs.readFileSync(this.templateFullPath, 'utf-8'));
        }
        return this._template;
    }
    tagsFromMetadata() {
        var _b;
        const ret = {};
        for (const metadataEntry of this.findMetadataByType(cxschema.ArtifactMetadataEntryType.STACK_TAGS)) {
            for (const tag of ((_b = metadataEntry.data) !== null && _b !== void 0 ? _b : [])) {
                ret[tag.key] = tag.value;
            }
        }
        return ret;
    }
}
exports.CloudFormationStackArtifact = CloudFormationStackArtifact;
_a = JSII_RTTI_SYMBOL_1;
CloudFormationStackArtifact[_a] = { fqn: "@aws-cdk/cx-api.CloudFormationStackArtifact", version: "1.144.0" };
//# sourceMappingURL=data:application/json;base64,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