import * as cxschema from '@aws-cdk/cloud-assembly-schema';
import { CloudArtifact } from '../cloud-artifact';
import type { CloudAssembly } from '../cloud-assembly';
/**
 * Asset manifest is a description of a set of assets which need to be built and published.
 *
 * @stability stable
 */
export declare class NestedCloudAssemblyArtifact extends CloudArtifact {
    /**
     * The relative directory name of the asset manifest.
     *
     * @stability stable
     */
    readonly directoryName: string;
    /**
     * Display name.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * @stability stable
     */
    constructor(assembly: CloudAssembly, name: string, artifact: cxschema.ArtifactManifest);
    /**
     * Full path to the nested assembly directory.
     *
     * @stability stable
     */
    get fullPath(): string;
}
/**
 * Asset manifest is a description of a set of assets which need to be built and published.
 *
 * @stability stable
 */
export interface NestedCloudAssemblyArtifact {
    /**
     * The nested Assembly.
     *
     * @stability stable
     */
    readonly nestedAssembly: CloudAssembly;
}
