import { Tag } from './metadata-schema';
/**
 * Identifier for the context provider.
 *
 * @stability stable
 */
export declare enum ContextProvider {
    /**
     * AMI provider.
     *
     * @stability stable
     */
    AMI_PROVIDER = "ami",
    /**
     * AZ provider.
     *
     * @stability stable
     */
    AVAILABILITY_ZONE_PROVIDER = "availability-zones",
    /**
     * Route53 Hosted Zone provider.
     *
     * @stability stable
     */
    HOSTED_ZONE_PROVIDER = "hosted-zone",
    /**
     * SSM Parameter Provider.
     *
     * @stability stable
     */
    SSM_PARAMETER_PROVIDER = "ssm",
    /**
     * VPC Provider.
     *
     * @stability stable
     */
    VPC_PROVIDER = "vpc-provider",
    /**
     * VPC Endpoint Service AZ Provider.
     *
     * @stability stable
     */
    ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER = "endpoint-service-availability-zones",
    /**
     * Load balancer provider.
     *
     * @stability stable
     */
    LOAD_BALANCER_PROVIDER = "load-balancer",
    /**
     * Load balancer listener provider.
     *
     * @stability stable
     */
    LOAD_BALANCER_LISTENER_PROVIDER = "load-balancer-listener",
    /**
     * Security group provider.
     *
     * @stability stable
     */
    SECURITY_GROUP_PROVIDER = "security-group",
    /**
     * KMS Key Provider.
     *
     * @stability stable
     */
    KEY_PROVIDER = "key-provider",
    /**
     * A plugin provider (the actual plugin name will be in the properties).
     *
     * @stability stable
     */
    PLUGIN = "plugin"
}
/**
 * Query to AMI context provider.
 *
 * @stability stable
 */
export interface AmiContextQuery {
    /**
     * Account to query.
     *
     * @stability stable
     */
    readonly account: string;
    /**
     * Region to query.
     *
     * @stability stable
     */
    readonly region: string;
    /**
     * The ARN of the role that should be used to look up the missing values.
     *
     * @default - None
     * @stability stable
     */
    readonly lookupRoleArn?: string;
    /**
     * Owners to DescribeImages call.
     *
     * @default - All owners
     * @stability stable
     */
    readonly owners?: string[];
    /**
     * Filters to DescribeImages call.
     *
     * @stability stable
     */
    readonly filters: {
        [key: string]: string[];
    };
}
/**
 * Query to availability zone context provider.
 *
 * @stability stable
 */
export interface AvailabilityZonesContextQuery {
    /**
     * Query account.
     *
     * @stability stable
     */
    readonly account: string;
    /**
     * Query region.
     *
     * @stability stable
     */
    readonly region: string;
    /**
     * The ARN of the role that should be used to look up the missing values.
     *
     * @default - None
     * @stability stable
     */
    readonly lookupRoleArn?: string;
}
/**
 * Query to hosted zone context provider.
 *
 * @stability stable
 */
export interface HostedZoneContextQuery {
    /**
     * Query account.
     *
     * @stability stable
     */
    readonly account: string;
    /**
     * Query region.
     *
     * @stability stable
     */
    readonly region: string;
    /**
     * The ARN of the role that should be used to look up the missing values.
     *
     * @default - None
     * @stability stable
     */
    readonly lookupRoleArn?: string;
    /**
     * The domain name e.g. example.com to lookup.
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * True if the zone you want to find is a private hosted zone.
     *
     * @default false
     * @stability stable
     */
    readonly privateZone?: boolean;
    /**
     * The VPC ID to that the private zone must be associated with.
     *
     * If you provide VPC ID and privateZone is false, this will return no results
     * and raise an error.
     *
     * @default - Required if privateZone=true
     * @stability stable
     */
    readonly vpcId?: string;
}
/**
 * Query to SSM Parameter Context Provider.
 *
 * @stability stable
 */
export interface SSMParameterContextQuery {
    /**
     * Query account.
     *
     * @stability stable
     */
    readonly account: string;
    /**
     * Query region.
     *
     * @stability stable
     */
    readonly region: string;
    /**
     * The ARN of the role that should be used to look up the missing values.
     *
     * @default - None
     * @stability stable
     */
    readonly lookupRoleArn?: string;
    /**
     * Parameter name to query.
     *
     * @stability stable
     */
    readonly parameterName: string;
}
/**
 * Query input for looking up a VPC.
 *
 * @stability stable
 */
export interface VpcContextQuery {
    /**
     * Query account.
     *
     * @stability stable
     */
    readonly account: string;
    /**
     * Query region.
     *
     * @stability stable
     */
    readonly region: string;
    /**
     * The ARN of the role that should be used to look up the missing values.
     *
     * @default - None
     * @stability stable
     */
    readonly lookupRoleArn?: string;
    /**
     * Filters to apply to the VPC.
     *
     * Filter parameters are the same as passed to DescribeVpcs.
     *
     * @see https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html
     * @stability stable
     */
    readonly filter: {
        [key: string]: string;
    };
    /**
     * Whether to populate the subnetGroups field of the {@link VpcContextResponse}, which contains potentially asymmetric subnet groups.
     *
     * @default false
     * @stability stable
     */
    readonly returnAsymmetricSubnets?: boolean;
    /**
     * Optional tag for subnet group name.
     *
     * If not provided, we'll look at the aws-cdk:subnet-name tag.
     * If the subnet does not have the specified tag,
     * we'll use its type as the name.
     *
     * @default 'aws-cdk:subnet-name'
     * @stability stable
     */
    readonly subnetGroupNameTag?: string;
}
/**
 * Query to endpoint service context provider.
 *
 * @stability stable
 */
export interface EndpointServiceAvailabilityZonesContextQuery {
    /**
     * Query account.
     *
     * @stability stable
     */
    readonly account: string;
    /**
     * Query region.
     *
     * @stability stable
     */
    readonly region: string;
    /**
     * The ARN of the role that should be used to look up the missing values.
     *
     * @default - None
     * @stability stable
     */
    readonly lookupRoleArn?: string;
    /**
     * Query service name.
     *
     * @stability stable
     */
    readonly serviceName: string;
}
/**
 * Type of load balancer.
 *
 * @stability stable
 */
export declare enum LoadBalancerType {
    /**
     * Network load balancer.
     *
     * @stability stable
     */
    NETWORK = "network",
    /**
     * Application load balancer.
     *
     * @stability stable
     */
    APPLICATION = "application"
}
/**
 * Filters for selecting load balancers.
 *
 * @stability stable
 */
export interface LoadBalancerFilter {
    /**
     * Filter load balancers by their type.
     *
     * @stability stable
     */
    readonly loadBalancerType: LoadBalancerType;
    /**
     * Find by load balancer's ARN.
     *
     * @default - does not search by load balancer arn
     * @stability stable
     */
    readonly loadBalancerArn?: string;
    /**
     * Match load balancer tags.
     *
     * @default - does not match load balancers by tags
     * @stability stable
     */
    readonly loadBalancerTags?: Tag[];
}
/**
 * Query input for looking up a load balancer.
 *
 * @stability stable
 */
export interface LoadBalancerContextQuery extends LoadBalancerFilter {
    /**
     * Query account.
     *
     * @stability stable
     */
    readonly account: string;
    /**
     * Query region.
     *
     * @stability stable
     */
    readonly region: string;
    /**
     * The ARN of the role that should be used to look up the missing values.
     *
     * @default - None
     * @stability stable
     */
    readonly lookupRoleArn?: string;
}
/**
 * The protocol for connections from clients to the load balancer.
 *
 * @stability stable
 */
export declare enum LoadBalancerListenerProtocol {
    /**
     * HTTP protocol.
     *
     * @stability stable
     */
    HTTP = "HTTP",
    /**
     * HTTPS protocol.
     *
     * @stability stable
     */
    HTTPS = "HTTPS",
    /**
     * TCP protocol.
     *
     * @stability stable
     */
    TCP = "TCP",
    /**
     * TLS protocol.
     *
     * @stability stable
     */
    TLS = "TLS",
    /**
     * UDP protocol.
     *
     * @stability stable
     */
    UDP = "UDP",
    /**
     * TCP and UDP protocol.
     *
     * @stability stable
     */
    TCP_UDP = "TCP_UDP"
}
/**
 * Query input for looking up a load balancer listener.
 *
 * @stability stable
 */
export interface LoadBalancerListenerContextQuery extends LoadBalancerFilter {
    /**
     * Query account.
     *
     * @stability stable
     */
    readonly account: string;
    /**
     * Query region.
     *
     * @stability stable
     */
    readonly region: string;
    /**
     * The ARN of the role that should be used to look up the missing values.
     *
     * @default - None
     * @stability stable
     */
    readonly lookupRoleArn?: string;
    /**
     * Find by listener's arn.
     *
     * @default - does not find by listener arn
     * @stability stable
     */
    readonly listenerArn?: string;
    /**
     * Filter by listener protocol.
     *
     * @default - does not filter by listener protocol
     * @stability stable
     */
    readonly listenerProtocol?: LoadBalancerListenerProtocol;
    /**
     * Filter listeners by listener port.
     *
     * @default - does not filter by a listener port
     * @stability stable
     */
    readonly listenerPort?: number;
}
/**
 * Query input for looking up a security group.
 *
 * @stability stable
 */
export interface SecurityGroupContextQuery {
    /**
     * Query account.
     *
     * @stability stable
     */
    readonly account: string;
    /**
     * Query region.
     *
     * @stability stable
     */
    readonly region: string;
    /**
     * The ARN of the role that should be used to look up the missing values.
     *
     * @default - None
     * @stability stable
     */
    readonly lookupRoleArn?: string;
    /**
     * Security group id.
     *
     * @default - None
     * @stability stable
     */
    readonly securityGroupId?: string;
    /**
     * Security group name.
     *
     * @default - None
     * @stability stable
     */
    readonly securityGroupName?: string;
    /**
     * VPC ID.
     *
     * @default - None
     * @stability stable
     */
    readonly vpcId?: string;
}
/**
 * Query input for looking up a KMS Key.
 *
 * @stability stable
 */
export interface KeyContextQuery {
    /**
     * Query account.
     *
     * @stability stable
     */
    readonly account: string;
    /**
     * Query region.
     *
     * @stability stable
     */
    readonly region: string;
    /**
     * The ARN of the role that should be used to look up the missing values.
     *
     * @default - None
     * @stability stable
     */
    readonly lookupRoleArn?: string;
    /**
     * Alias name used to search the Key.
     *
     * @stability stable
     */
    readonly aliasName: string;
}
/**
 * Query input for plugins.
 *
 * This alternate branch is necessary because it needs to be able to escape all type checking
 * we do on on the cloud assembly -- we cannot know the properties that will be used a priori.
 *
 * @stability stable
 */
export interface PluginContextQuery {
    /**
     * The name of the plugin.
     *
     * @stability stable
     */
    readonly pluginName: string;
    /**
     * Arbitrary other arguments for the plugin
     */
    [key: string]: any;
}
export declare type ContextQueryProperties = AmiContextQuery | AvailabilityZonesContextQuery | HostedZoneContextQuery | SSMParameterContextQuery | VpcContextQuery | EndpointServiceAvailabilityZonesContextQuery | LoadBalancerContextQuery | LoadBalancerListenerContextQuery | SecurityGroupContextQuery | KeyContextQuery | PluginContextQuery;
