"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Makefile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("./file");
/**
 * (experimental) Minimal Makefile.
 *
 * @experimental
 */
class Makefile extends file_1.FileBase {
    /**
     * @experimental
     */
    constructor(project, filePath, options = {}) {
        super(project, filePath, options);
        const all = options.all ? options.all : [];
        const rules = options.rules ? options.rules : [];
        rules.forEach(e => this.validateRule(e));
        this.all = {
            targets: ['all'],
            prerequisites: all,
            phony: true,
        };
        this.rules = [
            this.all,
            ...rules,
        ];
    }
    /**
     * (experimental) Add a target to all.
     *
     * @experimental
     */
    addAll(target) {
        this.all.prerequisites.push(target);
        return this;
    }
    /**
     * (experimental) Add multiple targets to all.
     *
     * @experimental
     */
    addAlls(...targets) {
        targets.forEach(e => this.addAll(e));
        return this;
    }
    /**
     * (experimental) Add a rule to the Makefile.
     *
     * @experimental
     */
    addRule(rule) {
        this.validateRule(rule);
        this.rules.push(rule);
        return this;
    }
    /**
     * (experimental) Add multiple rules to the Makefile.
     *
     * @experimental
     */
    addRules(...rules) {
        rules.forEach(e => this.addRule(e));
        return this;
    }
    validateRule(rule) {
        if (!rule.targets || !rule.targets.length) {
            throw new Error('"targets" cannot be undefined or empty for items in "rules"');
        }
    }
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    synthesizeContent(resolver) {
        const rules = resolver.resolve(this.rules);
        const lines = [
            ...rules.map((rule) => {
                const targets = rule.targets.join(' ');
                const prerequisites = (rule.prerequisites ? rule.prerequisites : []).join(' ');
                const recipe = rule.recipe ? rule.recipe : [];
                const phony = rule.phony ? [`.PHONY: ${targets}`] : [];
                return [
                    ...phony,
                    `${targets}: ${prerequisites}`.trim(),
                    ...recipe.map(step => `\t${step}`),
                ].join('\n');
            }),
        ];
        return `${lines.join('\n\n')}\n`;
    }
}
exports.Makefile = Makefile;
_a = JSII_RTTI_SYMBOL_1;
Makefile[_a] = { fqn: "projen.Makefile", version: "0.17.65" };
//# sourceMappingURL=data:application/json;base64,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