"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dependabot = exports.VersioningStrategy = exports.DependabotScheduleInterval = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const yargs_1 = require("yargs");
const component_1 = require("../component");
const yaml_1 = require("../yaml");
/**
 * (experimental) How often to check for new versions and raise pull requests for version updates.
 *
 * @experimental
 */
var DependabotScheduleInterval;
(function (DependabotScheduleInterval) {
    DependabotScheduleInterval["DAILY"] = "daily";
    DependabotScheduleInterval["WEEKLY"] = "weekly";
    DependabotScheduleInterval["MONTHLY"] = "monthly";
})(DependabotScheduleInterval = exports.DependabotScheduleInterval || (exports.DependabotScheduleInterval = {}));
/**
 * (experimental) The strategy to use when edits manifest and lock files.
 *
 * @experimental
 */
var VersioningStrategy;
(function (VersioningStrategy) {
    VersioningStrategy["LOCKFILE_ONLY"] = "lockfile-only";
    VersioningStrategy["AUTO"] = "auto";
    VersioningStrategy["WIDEN"] = "widen";
    VersioningStrategy["INCREASE"] = "increase";
    VersioningStrategy["INCREASE_IF_NECESSARY"] = "increase-if-necessary";
})(VersioningStrategy = exports.VersioningStrategy || (exports.VersioningStrategy = {}));
/**
 * (experimental) Defines dependabot configuration for node projects.
 *
 * Since module versions are managed in projen, the versioning strategy will be
 * configured to "lockfile-only" which means that only updates that can be done
 * on the lockfile itself will be proposed.
 *
 * @experimental
 */
class Dependabot extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, options = {}) {
        var _b, _c, _d, _e, _f;
        super(github.project);
        const project = github.project;
        this.ignore = [];
        this.config = {
            version: 2,
            updates: [
                {
                    'package-ecosystem': 'npm',
                    'versioning-strategy': 'lockfile-only',
                    'directory': '/',
                    'schedule': {
                        interval: (_b = options.scheduleInterval) !== null && _b !== void 0 ? _b : DependabotScheduleInterval.DAILY,
                    },
                    'ignore': () => this.ignore.length > 0 ? this.ignore : undefined,
                },
            ],
        };
        new yaml_1.YamlFile(project, '.github/dependabot.yml', {
            obj: this.config,
            committed: true,
        });
        if ((_c = options.autoMerge) !== null && _c !== void 0 ? _c : true) {
            github.addMergifyRules({
                name: 'Merge pull requests from dependabot if CI passes',
                conditions: [
                    'author=dependabot[bot]',
                    'status-success=build',
                ],
                actions: {
                    merge: {
                        method: 'squash',
                        commit_message: 'title+body',
                        strict: 'smart',
                        strict_method: 'merge',
                    },
                },
            });
        }
        for (const i of (_d = options.ignore) !== null && _d !== void 0 ? _d : []) {
            this.addIgnore(i.dependencyName, ...((_e = i.versions) !== null && _e !== void 0 ? _e : []));
        }
        if ((_f = options.ignoreProjen) !== null && _f !== void 0 ? _f : true) {
            this.addIgnore('projen');
        }
    }
    /**
     * (experimental) Ignores a dependency from automatic updates.
     *
     * @param dependencyName Use to ignore updates for dependencies with matching names, optionally using `*` to match zero or more characters.
     * @param versions Use to ignore specific versions or ranges of versions.
     * @experimental
     */
    addIgnore(dependencyName, ...versions) {
        this.ignore.push({
            'dependency-name': dependencyName,
            'versions': () => versions.length > 0 ? yargs_1.version : undefined,
        });
    }
}
exports.Dependabot = Dependabot;
_a = JSII_RTTI_SYMBOL_1;
Dependabot[_a] = { fqn: "projen.github.Dependabot", version: "0.17.65" };
//# sourceMappingURL=data:application/json;base64,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