"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FIREHOSE_CIDR_BLOCKS = exports.CLOUDWATCH_LAMBDA_INSIGHTS_ARNS = exports.APPMESH_ECR_ACCOUNTS = exports.DLC_REPOSITORY_ACCOUNTS = exports.ELBV2_ACCOUNTS = exports.PARTITION_MAP = exports.EBS_ENV_ENDPOINT_HOSTED_ZONE_IDS = exports.ROUTE_53_BUCKET_WEBSITE_ZONE_IDS = exports.AWS_CDK_METADATA = void 0;
exports.AWS_CDK_METADATA = new Set([
    'us-east-2',
    'us-east-1',
    'us-west-1',
    'us-west-2',
    // 'us-gov-east-1',
    // 'us-gov-west-1',
    // 'us-iso-east-1',
    // 'us-isob-east-1',
    'af-south-1',
    'ap-south-1',
    'ap-east-1',
    // 'ap-northeast-3',
    'ap-northeast-2',
    'ap-southeast-1',
    'ap-southeast-2',
    'ap-northeast-1',
    'ca-central-1',
    'cn-north-1',
    'cn-northwest-1',
    'eu-central-1',
    'eu-west-1',
    'eu-west-2',
    'eu-west-3',
    'eu-north-1',
    'eu-south-1',
    'me-south-1',
    'sa-east-1',
]);
/**
 * The hosted zone Id if using an alias record in Route53.
 *
 * @see https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_region
 */
exports.ROUTE_53_BUCKET_WEBSITE_ZONE_IDS = {
    'af-south-1': 'Z11KHD8FBVPUYU',
    'ap-east-1': 'ZNB98KWMFR0R6',
    'ap-northeast-1': 'Z2M4EHUR26P7ZW',
    'ap-northeast-2': 'Z3W03O7B5YMIYP',
    'ap-northeast-3': 'Z2YQB5RD63NC85',
    'ap-south-1': 'Z11RGJOFQNVJUP',
    'ap-southeast-1': 'Z3O0J2DXBE1FTB',
    'ap-southeast-2': 'Z1WCIGYICN2BYD',
    'ca-central-1': 'Z1QDHH18159H29',
    'cn-northwest-1': 'Z282HJ1KT0DH03',
    'eu-central-1': 'Z21DNDUVLTQW6Q',
    'eu-north-1': 'Z3BAZG2TWCNX0D',
    'eu-south-1': 'Z3IXVV8C73GIO3',
    'eu-west-1': 'Z1BKCTXD74EZPE',
    'eu-west-2': 'Z3GKZC51ZF0DB4',
    'eu-west-3': 'Z3R1K369G5AVDG',
    'me-south-1': 'Z1MPMWCPA7YB62',
    'sa-east-1': 'Z7KQH4QJS55SO',
    'us-east-1': 'Z3AQBSTGFYJSTF',
    'us-east-2': 'Z2O1EMRO9K5GLX',
    'us-gov-east-1': 'Z2NIFVYYW2VKV1',
    'us-gov-west-1': 'Z31GFT0UA1I2HV',
    'us-west-1': 'Z2F56UZL2M1ACD',
    'us-west-2': 'Z3BJ6K6RIION7M',
};
/**
 * The hosted zone Id of the Elastic Beanstalk environment.
 *
 * @see https://docs.aws.amazon.com/general/latest/gr/elasticbeanstalk.html
 */
exports.EBS_ENV_ENDPOINT_HOSTED_ZONE_IDS = {
    'af-south-1': 'Z1EI3BVKMKK4AM',
    'ap-east-1': 'ZPWYUBWRU171A',
    'ap-northeast-1': 'Z1R25G3KIG2GBW',
    'ap-northeast-2': 'Z3JE5OI70TWKCP',
    'ap-northeast-3': 'ZNE5GEY1TIAGY',
    'ap-south-1': 'Z18NTBI3Y7N9TZ',
    'ap-southeast-1': 'Z16FZ9L249IFLT',
    'ap-southeast-2': 'Z2PCDNR3VC2G1N',
    'ca-central-1': 'ZJFCZL7SSZB5I',
    'eu-central-1': 'Z1FRNW7UH4DEZJ',
    'eu-north-1': 'Z23GO28BZ5AETM',
    'eu-south-1': 'Z10VDYYOA2JFKM',
    'eu-west-1': 'Z2NYPWQ7DFZAZH',
    'eu-west-2': 'Z1GKAAAUGATPF1',
    'eu-west-3': 'Z5WN6GAYWG5OB',
    'me-south-1': 'Z2BBTEKR2I36N2',
    'sa-east-1': 'Z10X7K2B4QSOFV',
    'us-east-1': 'Z117KPS5GTRQ2G',
    'us-east-2': 'Z14LCN19Q5QHIC',
    'us-gov-east-1': 'Z35TSARG0EJ4VU',
    'us-gov-west-1': 'Z4KAURWC4UUUG',
    'us-west-1': 'Z1LQECGX5PH1X',
    'us-west-2': 'Z38NKT9BP95V3O',
};
exports.PARTITION_MAP = {
    'default': { partition: 'aws', domainSuffix: 'amazonaws.com' },
    'cn-': { partition: 'aws-cn', domainSuffix: 'amazonaws.com.cn' },
    'us-gov-': { partition: 'aws-us-gov', domainSuffix: 'amazonaws.com' },
    'us-iso-': { partition: 'aws-iso', domainSuffix: 'c2s.ic.gov' },
    'us-isob-': { partition: 'aws-iso-b', domainSuffix: 'sc2s.sgov.gov' },
};
// https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-access-logs.html#access-logging-bucket-permissions
// https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html#attach-bucket-policy
exports.ELBV2_ACCOUNTS = {
    'af-south-1': '098369216593',
    'ap-east-1': '754344448648',
    'ap-northeast-1': '582318560864',
    'ap-northeast-2': '600734575887',
    'ap-northeast-3': '383597477331',
    'ap-south-1': '718504428378',
    'ap-southeast-1': '114774131450',
    'ap-southeast-2': '783225319266',
    'ap-southeast-3': '589379963580',
    'ca-central-1': '985666609251',
    'cn-north-1': '638102146993',
    'cn-northwest-1': '037604701340',
    'eu-central-1': '054676820928',
    'eu-north-1': '897822967062',
    'eu-south-1': '635631232127',
    'eu-west-1': '156460612806',
    'eu-west-2': '652711504416',
    'eu-west-3': '009996457667',
    'me-south-1': '076674570225',
    'sa-east-1': '507241528517',
    'us-east-1': '127311923021',
    'us-east-2': '033677994240',
    'us-gov-east-1': '190560391635',
    'us-gov-west-1': '048591011584',
    'us-west-1': '027434742980',
    'us-west-2': '797873946194',
};
// https://aws.amazon.com/releasenotes/available-deep-learning-containers-images
exports.DLC_REPOSITORY_ACCOUNTS = {
    'ap-east-1': '871362719292',
    'ap-northeast-1': '763104351884',
    'ap-northeast-2': '763104351884',
    'ap-south-1': '763104351884',
    'ap-southeast-1': '763104351884',
    'ap-southeast-2': '763104351884',
    'ca-central-1': '763104351884',
    'cn-north-1': '727897471807',
    'cn-northwest-1': '727897471807',
    'eu-central-1': '763104351884',
    'eu-north-1': '763104351884',
    'eu-west-1': '763104351884',
    'eu-west-2': '763104351884',
    'eu-west-3': '763104351884',
    'me-south-1': '217643126080',
    'sa-east-1': '763104351884',
    'us-east-1': '763104351884',
    'us-east-2': '763104351884',
    'us-west-1': '763104351884',
    'us-west-2': '763104351884',
};
// https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html
// https://docs.amazonaws.cn/app-mesh/latest/userguide/envoy.html
exports.APPMESH_ECR_ACCOUNTS = {
    'af-south-1': '924023996002',
    'ap-east-1': '856666278305',
    'ap-northeast-1': '840364872350',
    'ap-northeast-2': '840364872350',
    'ap-northeast-3': '840364872350',
    'ap-south-1': '840364872350',
    'ap-southeast-1': '840364872350',
    'ap-southeast-2': '840364872350',
    'ca-central-1': '840364872350',
    'cn-north-1': '919366029133',
    'cn-northwest-1': '919830735681',
    'eu-central-1': '840364872350',
    'eu-north-1': '840364872350',
    'eu-south-1': '422531588944',
    'eu-west-1': '840364872350',
    'eu-west-2': '840364872350',
    'eu-west-3': '840364872350',
    'me-south-1': '772975370895',
    'sa-east-1': '840364872350',
    'us-east-1': '840364872350',
    'us-east-2': '840364872350',
    'us-west-1': '840364872350',
    'us-west-2': '840364872350',
};
// https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-extension-versions.html
exports.CLOUDWATCH_LAMBDA_INSIGHTS_ARNS = {
    '1.0.119.0': {
        arm64: {
            // US East (N. Virginia)
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // US East (Ohio)
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // US West (Oregon)
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // Asia Pacific (Mumbai)
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // Asia Pacific (Singapore)
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // Asia Pacific (Sydney)
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // Asia Pacific (Tokyo)
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // Europe (Frankfurt)
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // Europe (Ireland)
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension-Arm64:1',
            // Europe (London)
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension-Arm64:1',
        },
        x86_64: {
            // US East (N. Virginia)
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:16',
            // US East (Ohio)
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:16',
            // US West (N. California)
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:16',
            // US West (Oregon)
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:16',
            // Africa (Cape Town)
            'af-south-1': 'arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:9',
            // Asia Pacific (Hong Kong)
            'ap-east-1': 'arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:9',
            // Asia Pacific (Mumbai)
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:16',
            // Asia Pacific (Seoul)
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:16',
            // Asia Pacific (Singapore)
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:16',
            // Asia Pacific (Sydney)
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:16',
            // Asia Pacific (Tokyo)
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:23',
            // Canada (Central)
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:16',
            // China (Beijing)
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:9',
            // China (Ningxia)
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:9',
            // Europe (Frankfurt)
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:16',
            // Europe (Ireland)
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:16',
            // Europe (London)
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:16',
            // Europe (Milan)
            'eu-south-1': 'arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:9',
            // Europe (Paris)
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:16',
            // Europe (Stockholm)
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:16',
            // Middle East (Bahrain)
            'me-south-1': 'arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:9',
            // South America (Sao Paulo)
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:16',
        },
    },
    '1.0.98.0': {
        x86_64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:14',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:14',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:14',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:14',
            'af-south-1': 'arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:8',
            'ap-east-1': 'arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:8',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:14',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:14',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:14',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:14',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:14',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:14',
            'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:8',
            'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:8',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:14',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:14',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:14',
            'eu-south-1': 'arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:8',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:14',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:14',
            'me-south-1': 'arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:8',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:14',
        },
    },
    '1.0.89.0': {
        x86_64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:12',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:12',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:12',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:12',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:12',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:12',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:12',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:12',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:12',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:12',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:12',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:12',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:12',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:12',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:12',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:12',
        },
    },
    '1.0.86.0': {
        x86_64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:11',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:11',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:11',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:11',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:11',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:11',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:11',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:11',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:11',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:11',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:11',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:11',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:11',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:11',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:11',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:11',
        },
    },
    '1.0.54.0': {
        x86_64: {
            'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:2',
            'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:2',
            'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:2',
            'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:2',
            'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:2',
            'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:2',
            'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:2',
            'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:2',
            'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:2',
            'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:2',
            'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:2',
            'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:2',
            'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:2',
            'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:2',
            'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:2',
            'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:2',
        },
    },
};
// https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-rs-vpc
exports.FIREHOSE_CIDR_BLOCKS = {
    'af-south-1': '13.244.121.224',
    'ap-east-1': '18.162.221.32',
    'ap-northeast-1': '13.113.196.224',
    'ap-northeast-2': '13.209.1.64',
    'ap-northeast-3': '13.208.177.192',
    'ap-south-1': '13.232.67.32',
    'ap-southeast-1': '13.228.64.192',
    'ap-southeast-2': '13.210.67.224',
    'ca-central-1': '35.183.92.128',
    'cn-north-1': '52.81.151.32',
    'cn-northwest-1': '161.189.23.64',
    'eu-central-1': '35.158.127.160',
    'eu-north-1': '13.53.63.224',
    'eu-south-1': '15.161.135.128',
    'eu-west-1': '52.19.239.192',
    'eu-west-2': '18.130.1.96',
    'eu-west-3': '35.180.1.96',
    'me-south-1': '15.185.91.0',
    'sa-east-1': '18.228.1.128',
    'us-east-1': '52.70.63.192',
    'us-east-2': '13.58.135.96',
    'us-gov-east-1': '18.253.138.96',
    'us-gov-west-1': '52.61.204.160',
    'us-west-1': '13.57.135.192',
    'us-west-2': '52.89.255.224',
};
//# sourceMappingURL=data:application/json;base64,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