"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentUtils = exports.UNKNOWN_REGION = exports.UNKNOWN_ACCOUNT = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Parser for the artifact environment field.
 *
 * Account validation is relaxed to allow account aliasing in the future.
 */
const AWS_ENV_REGEX = /aws\:\/\/([a-z0-9A-Z\-\@\.\_]+)\/([a-z\-0-9]+)/;
exports.UNKNOWN_ACCOUNT = 'unknown-account';
exports.UNKNOWN_REGION = 'unknown-region';
/**
 * @stability stable
 */
class EnvironmentUtils {
    /**
     * @stability stable
     */
    static parse(environment) {
        const env = AWS_ENV_REGEX.exec(environment);
        if (!env) {
            throw new Error(`Unable to parse environment specification "${environment}". ` +
                'Expected format: aws://account/region');
        }
        const [, account, region] = env;
        if (!account || !region) {
            throw new Error(`Invalid environment specification: ${environment}`);
        }
        return { account, region, name: environment };
    }
    /**
     * Build an environment object from an account and region.
     *
     * @stability stable
     */
    static make(account, region) {
        return { account, region, name: this.format(account, region) };
    }
    /**
     * Format an environment string from an account and region.
     *
     * @stability stable
     */
    static format(account, region) {
        return `aws://${account}/${region}`;
    }
}
exports.EnvironmentUtils = EnvironmentUtils;
_a = JSII_RTTI_SYMBOL_1;
EnvironmentUtils[_a] = { fqn: "@aws-cdk/cx-api.EnvironmentUtils", version: "1.141.0" };
//# sourceMappingURL=data:application/json;base64,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