import { Intrinsic } from './private/intrinsic';
/**
 * Properties for a Dynamic Reference.
 *
 * @stability stable
 */
export interface CfnDynamicReferenceProps {
    /**
     * The service to retrieve the dynamic reference from.
     *
     * @stability stable
     */
    readonly service: CfnDynamicReferenceService;
    /**
     * The reference key of the dynamic reference.
     *
     * @stability stable
     */
    readonly referenceKey: string;
}
/**
 * References a dynamically retrieved value.
 *
 * This is a Construct so that subclasses will (eventually) be able to attach
 * metadata to themselves without having to change call signatures.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html
 * @stability stable
 */
export declare class CfnDynamicReference extends Intrinsic {
    /**
     * @stability stable
     */
    constructor(service: CfnDynamicReferenceService, key: string);
}
/**
 * The service to retrieve the dynamic reference from.
 *
 * @stability stable
 */
export declare enum CfnDynamicReferenceService {
    /**
     * Plaintext value stored in AWS Systems Manager Parameter Store.
     *
     * @stability stable
     */
    SSM = "ssm",
    /**
     * Secure string stored in AWS Systems Manager Parameter Store.
     *
     * @stability stable
     */
    SSM_SECURE = "ssm-secure",
    /**
     * Secret stored in AWS Secrets Manager.
     *
     * @stability stable
     */
    SECRETS_MANAGER = "secretsmanager"
}
