"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JavaProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const project_1 = require("../project");
const junit_1 = require("./junit");
const maven_compile_1 = require("./maven-compile");
const maven_packaging_1 = require("./maven-packaging");
const maven_sample_1 = require("./maven-sample");
const pom_1 = require("./pom");
const projenrc_1 = require("./projenrc");
/**
 * (experimental) Java project.
 *
 * @experimental
 * @pjid java
 */
class JavaProject extends project_1.Project {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h;
        super(options);
        this.distdir = (_b = options.distdir) !== null && _b !== void 0 ? _b : 'dist/java';
        this.pom = new pom_1.Pom(this, options);
        if ((_c = options.projenrcJava) !== null && _c !== void 0 ? _c : true) {
            this.projenrc = new projenrc_1.Projenrc(this, this.pom, {
                ...options.projenrcJavaOptions,
                initializationOptions: options,
            });
        }
        const sampleJavaPackage = (_d = options.sampleJavaPackage) !== null && _d !== void 0 ? _d : 'org.acme';
        if ((_e = options.junit) !== null && _e !== void 0 ? _e : true) {
            this.junit = new junit_1.Junit(this, {
                pom: this.pom,
                sampleJavaPackage,
                ...options.junitOptions,
            });
        }
        if ((_f = options.sample) !== null && _f !== void 0 ? _f : true) {
            new maven_sample_1.MavenSample(this, { package: sampleJavaPackage });
        }
        // platform independent build
        this.pom.addProperty('project.build.sourceEncoding', 'UTF-8');
        this.gitignore.exclude('.classpath');
        this.gitignore.exclude('.project');
        this.gitignore.exclude('.settings');
        this.compile = new maven_compile_1.MavenCompile(this, this.pom, options.compileOptions);
        this.packaging = new maven_packaging_1.MavenPackaging(this, this.pom, options.packagingOptions);
        this.addPlugin('org.apache.maven.plugins/maven-enforcer-plugin@3.0.0-M3', {
            executions: [{ id: 'enforce-maven', goals: ['enforce'] }],
            configuration: {
                rules: [
                    { requireMavenVersion: [{ version: '3.6' }] },
                ],
            },
        });
        const buildTask = this.addTask('build', { description: 'Full CI build' });
        buildTask.spawn(this.packaging.task);
        for (const dep of (_g = options.deps) !== null && _g !== void 0 ? _g : []) {
            this.addDependency(dep);
        }
        for (const dep of (_h = options.testDeps) !== null && _h !== void 0 ? _h : []) {
            this.addTestDependency(dep);
        }
    }
    /**
     * (experimental) Adds a runtime dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`.
     * @experimental
     */
    addDependency(spec) {
        return this.pom.addDependency(spec);
    }
    /**
     * (experimental) Adds a test dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`.
     * @experimental
     */
    addTestDependency(spec) {
        return this.pom.addTestDependency(spec);
    }
    /**
     * (experimental) Adds a build plugin to the pom.
     *
     * The plug in is also added as a BUILD dep to the project.
     *
     * @param spec dependency spec (`group/artifact@version`).
     * @param options plugin options.
     * @experimental
     */
    addPlugin(spec, options = {}) {
        return this.pom.addPlugin(spec, options);
    }
}
exports.JavaProject = JavaProject;
_a = JSII_RTTI_SYMBOL_1;
JavaProject[_a] = { fqn: "projen.java.JavaProject", version: "0.17.62" };
//# sourceMappingURL=data:application/json;base64,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