import { Construct } from './construct-compat';
/**
 * Accessor for pseudo parameters.
 *
 * Since pseudo parameters need to be anchored to a stack somewhere in the
 * construct tree, this class takes an scope parameter; the pseudo parameter
 * values can be obtained as properties from an scoped object.
 *
 * @stability stable
 */
export declare class Aws {
    /**
     * @stability stable
     */
    static readonly ACCOUNT_ID: string;
    /**
     * @stability stable
     */
    static readonly URL_SUFFIX: string;
    /**
     * @stability stable
     */
    static readonly NOTIFICATION_ARNS: string[];
    /**
     * @stability stable
     */
    static readonly PARTITION: string;
    /**
     * @stability stable
     */
    static readonly REGION: string;
    /**
     * @stability stable
     */
    static readonly STACK_ID: string;
    /**
     * @stability stable
     */
    static readonly STACK_NAME: string;
    /**
     * @stability stable
     */
    static readonly NO_VALUE: string;
    private constructor();
}
/**
 * Accessor for scoped pseudo parameters.
 *
 * These pseudo parameters are anchored to a stack somewhere in the construct
 * tree, and their values will be exported automatically.
 *
 * @stability stable
 */
export declare class ScopedAws {
    private readonly scope;
    /**
     * @stability stable
     */
    constructor(scope: Construct);
    /**
     * @stability stable
     */
    get accountId(): string;
    /**
     * @stability stable
     */
    get urlSuffix(): string;
    /**
     * @stability stable
     */
    get notificationArns(): string[];
    /**
     * @stability stable
     */
    get partition(): string;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    get stackId(): string;
    /**
     * @stability stable
     */
    get stackName(): string;
    private asString;
}
