"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JenkinsEC2 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const targets = require("@aws-cdk/aws-elasticloadbalancingv2-targets");
const super_ec2_1 = require("./super-ec2");
const super_ec2_interfaces_1 = require("./super-ec2-interfaces");
;
/**
 * @experimental
 */
class JenkinsEC2 extends super_ec2_1.SuperEC2Base {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.userData.addCommands(...this.jenkinsUserData());
        this._addIngressRule(this.defaultSecurityGroup, [22, 8080, 50000]);
        this.loadbalancer = (_b = props.loadbalancer) !== null && _b !== void 0 ? _b : this._setloadbalancer(props.loadbalancerType);
        if (props.domain) {
            this.domain = new super_ec2_interfaces_1.SuperDomain(this, 'superDomain', { ...props.domain, loadbalancer: this.loadbalancer });
            this._setlistener(this.domain.acm);
        }
        else {
            this._set80listener();
        }
    }
    /**
     * @experimental
     */
    jenkinsUserData() {
        return ['yum install docker -y',
            'systemctl start docker',
            'usermod -aG docker ec2-user',
            'usermod -aG docker ssm-user',
            'chmod +x /var/run/docker.sock',
            'systemctl restart docker && systemctl enable docker',
            'mkdir /home/ec2-user/jenkins-data',
            'docker run --name jks --rm -d -u root -p 8080:8080 -p 50000:50000 -v /home/ec2-user/jenkins-data:/var/jenkins_home -v /var/run/docker.sock:/var/run/docker.sock -v /home/ec2-user:/home jenkinsci/blueocean'];
    }
    ;
    _addIngressRule(SecurityGroup, Ports) {
        Ports.forEach(port => {
            SecurityGroup.addIngressRule(ec2.Peer.anyIpv4(), ec2.Port.tcp(port));
        });
        return SecurityGroup;
    }
    _setloadbalancer(loadbalancerType) {
        switch (loadbalancerType) {
            case super_ec2_interfaces_1.ELBtype.ALB:
                return new elbv2.ApplicationLoadBalancer(this, 'jksALB', {
                    vpc: this.vpc,
                    loadBalancerName: 'jksALB',
                    internetFacing: true,
                });
            case super_ec2_interfaces_1.ELBtype.NLB:
                return new elbv2.NetworkLoadBalancer(this, 'jksNLB', {
                    vpc: this.vpc,
                    loadBalancerName: 'jksNLB',
                    internetFacing: true,
                });
            default: {
                return new elbv2.ApplicationLoadBalancer(this, 'jksALB', {
                    vpc: this.vpc,
                    loadBalancerName: 'jksALB',
                    internetFacing: true,
                });
            }
        }
    }
    _setlistener(acm) {
        const httpslistener = this.loadbalancer.addListener('httpsListener', {
            certificates: [elbv2.ListenerCertificate.fromArn(acm.certificateArn)],
            port: 443,
        });
        if (this.loadbalancer instanceof elbv2.ApplicationLoadBalancer) {
            this.loadbalancer.addListener('httpListener', {
                port: 80,
                open: true,
                defaultAction: elbv2.ListenerAction.redirect({
                    protocol: 'HTTPS',
                    host: '#{host}',
                    path: '/#{path}',
                    query: '/#{query}',
                    port: '443',
                }),
            });
        }
        if (httpslistener instanceof elbv2.ApplicationListener) {
            httpslistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.ApplicationProtocol.HTTP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
            httpslistener.connections.allowTo(this.instance, ec2.Port.tcp(8080));
        }
        else if (httpslistener instanceof elbv2.NetworkListener) {
            httpslistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.Protocol.TCP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
        }
    }
    _set80listener() {
        const httplistener = this.loadbalancer.addListener('httpListener', {
            port: 80,
        });
        if (httplistener instanceof elbv2.ApplicationListener) {
            httplistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.ApplicationProtocol.HTTP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
            httplistener.connections.allowTo(this.instance, ec2.Port.tcp(8080));
        }
        else if (httplistener instanceof elbv2.NetworkListener) {
            httplistener.addTargets('Targets', {
                port: 8080,
                protocol: elbv2.Protocol.TCP,
                targets: [new targets.InstanceTarget(this.instance)],
            });
        }
    }
}
exports.JenkinsEC2 = JenkinsEC2;
_a = JSII_RTTI_SYMBOL_1;
JenkinsEC2[_a] = { fqn: "@cdk-constructs-zone/super-ec2.JenkinsEC2", version: "0.0.25" };
//# sourceMappingURL=data:application/json;base64,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