import { schema } from '../lib';
export declare function massageSpec(spec: schema.Specification): void;
export declare function forEachSection(spec: schema.Specification, data: any, cb: (spec: any, fragment: any, path: string[]) => void): void;
export declare function decorateResourceTypes(data: any): void;
export declare function merge(spec: any, fragment: any, jsonPath: string[]): void;
export declare function patch(spec: any, fragment: any): void;
/**
 * Modifies the provided specification so that ``ResourceTypes`` and ``PropertyTypes`` are listed in alphabetical order.
 *
 * @param spec an AWS CloudFormation Resource Specification document.
 *
 * @returns ``spec``, after having sorted the ``ResourceTypes`` and ``PropertyTypes`` sections alphabetically.
 */
export declare function normalize(spec: schema.Specification): schema.Specification;
