"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Version = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const json_1 = require("./json");
const tasks_1 = require("./tasks");
/**
 * @experimental
 */
class Version extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project) {
        var _b;
        super(project);
        const versionFile = '.version.tmp.json';
        this.changelogFile = '.changelog.tmp.md';
        // this command determines if there were any changes since the last release
        // (the top-most commit is not a bump). it is used as a condition for both
        // the `bump` and the `release` tasks.
        const changesSinceLastRelease = '! git log --oneline -1 | grep -q "chore(release):"';
        this.bumpTask = project.addTask('bump', {
            description: 'Bumps version based on latest git tag and generates a changelog entry',
            category: tasks_1.TaskCategory.RELEASE,
            condition: changesSinceLastRelease,
        });
        // the default for "standard-version" is to find a tag across the entire
        // repository but we want to select the last tag accessible from the
        // *current branch*.
        this.bumpTask.exec(`git describe --tags --match="v*" --first-parent --abbrev=0 > ${versionFile}`);
        this.bumpTask.exec('standard-version');
        this.unbumpTask = project.addTask('unbump', {
            description: 'Restores version to 0.0.0',
            category: tasks_1.TaskCategory.RELEASE,
            exec: 'standard-version -r 0.0.0',
        });
        project.addDevDeps('standard-version@^9');
        (_b = project.npmignore) === null || _b === void 0 ? void 0 : _b.exclude('/.versionrc.json');
        project.gitignore.addPatterns(`/${this.changelogFile}`);
        project.gitignore.addPatterns(`/${versionFile}`);
        new json_1.JsonFile(project, '.versionrc.json', {
            obj: {
                packageFiles: [{
                        filename: versionFile,
                        type: 'plain-text',
                    }],
                bumpFiles: ['package.json'],
                commitAll: false,
                infile: this.changelogFile,
                header: '',
                skip: {
                    commit: true,
                    tag: true,
                },
            },
        });
    }
}
exports.Version = Version;
_a = JSII_RTTI_SYMBOL_1;
Version[_a] = { fqn: "projen.Version", version: "0.17.62" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmVyc2lvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy92ZXJzaW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsMkNBQXdDO0FBQ3hDLGlDQUFrQztBQUVsQyxtQ0FBNkM7Ozs7QUFFN0MsTUFBYSxPQUFRLFNBQVEscUJBQVM7Ozs7SUFNcEMsWUFBWSxPQUFvQjs7UUFDOUIsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBRWYsTUFBTSxXQUFXLEdBQUcsbUJBQW1CLENBQUM7UUFDeEMsSUFBSSxDQUFDLGFBQWEsR0FBRyxtQkFBbUIsQ0FBQztRQUV6QywyRUFBMkU7UUFDM0UsMEVBQTBFO1FBQzFFLHNDQUFzQztRQUN0QyxNQUFNLHVCQUF1QixHQUFHLG9EQUFvRCxDQUFDO1FBRXJGLElBQUksQ0FBQyxRQUFRLEdBQUcsT0FBTyxDQUFDLE9BQU8sQ0FBQyxNQUFNLEVBQUU7WUFDdEMsV0FBVyxFQUFFLHVFQUF1RTtZQUNwRixRQUFRLEVBQUUsb0JBQVksQ0FBQyxPQUFPO1lBQzlCLFNBQVMsRUFBRSx1QkFBdUI7U0FDbkMsQ0FBQyxDQUFDO1FBRUgsd0VBQXdFO1FBQ3hFLG9FQUFvRTtRQUNwRSxvQkFBb0I7UUFDcEIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsZ0VBQWdFLFdBQVcsRUFBRSxDQUFDLENBQUM7UUFDbEcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUV2QyxJQUFJLENBQUMsVUFBVSxHQUFHLE9BQU8sQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFO1lBQzFDLFdBQVcsRUFBRSwyQkFBMkI7WUFDeEMsUUFBUSxFQUFFLG9CQUFZLENBQUMsT0FBTztZQUM5QixJQUFJLEVBQUUsMkJBQTJCO1NBQ2xDLENBQUMsQ0FBQztRQUVILE9BQU8sQ0FBQyxVQUFVLENBQ2hCLHFCQUFxQixDQUN0QixDQUFDO1FBRUYsTUFBQSxPQUFPLENBQUMsU0FBUywwQ0FBRSxPQUFPLENBQUMsa0JBQWtCLEVBQUU7UUFDL0MsT0FBTyxDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQUMsSUFBSSxJQUFJLENBQUMsYUFBYSxFQUFFLENBQUMsQ0FBQztRQUN4RCxPQUFPLENBQUMsU0FBUyxDQUFDLFdBQVcsQ0FBQyxJQUFJLFdBQVcsRUFBRSxDQUFDLENBQUM7UUFFakQsSUFBSSxlQUFRLENBQUMsT0FBTyxFQUFFLGlCQUFpQixFQUFFO1lBQ3ZDLEdBQUcsRUFBRTtnQkFDSCxZQUFZLEVBQUUsQ0FBQzt3QkFDYixRQUFRLEVBQUUsV0FBVzt3QkFDckIsSUFBSSxFQUFFLFlBQVk7cUJBQ25CLENBQUM7Z0JBQ0YsU0FBUyxFQUFFLENBQUMsY0FBYyxDQUFDO2dCQUMzQixTQUFTLEVBQUUsS0FBSztnQkFDaEIsTUFBTSxFQUFFLElBQUksQ0FBQyxhQUFhO2dCQUMxQixNQUFNLEVBQUUsRUFBRTtnQkFDVixJQUFJLEVBQUU7b0JBQ0osTUFBTSxFQUFFLElBQUk7b0JBQ1osR0FBRyxFQUFFLElBQUk7aUJBQ1Y7YUFDRjtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBM0RILDBCQTREQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCB9IGZyb20gJy4vY29tcG9uZW50JztcbmltcG9ydCB7IEpzb25GaWxlIH0gZnJvbSAnLi9qc29uJztcbmltcG9ydCB7IE5vZGVQcm9qZWN0IH0gZnJvbSAnLi9ub2RlLXByb2plY3QnO1xuaW1wb3J0IHsgVGFzaywgVGFza0NhdGVnb3J5IH0gZnJvbSAnLi90YXNrcyc7XG5cbmV4cG9ydCBjbGFzcyBWZXJzaW9uIGV4dGVuZHMgQ29tcG9uZW50IHtcblxuICBwdWJsaWMgcmVhZG9ubHkgYnVtcFRhc2s6IFRhc2s7XG4gIHB1YmxpYyByZWFkb25seSB1bmJ1bXBUYXNrOiBUYXNrO1xuICBwdWJsaWMgcmVhZG9ubHkgY2hhbmdlbG9nRmlsZTogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IE5vZGVQcm9qZWN0KSB7XG4gICAgc3VwZXIocHJvamVjdCk7XG5cbiAgICBjb25zdCB2ZXJzaW9uRmlsZSA9ICcudmVyc2lvbi50bXAuanNvbic7XG4gICAgdGhpcy5jaGFuZ2Vsb2dGaWxlID0gJy5jaGFuZ2Vsb2cudG1wLm1kJztcblxuICAgIC8vIHRoaXMgY29tbWFuZCBkZXRlcm1pbmVzIGlmIHRoZXJlIHdlcmUgYW55IGNoYW5nZXMgc2luY2UgdGhlIGxhc3QgcmVsZWFzZVxuICAgIC8vICh0aGUgdG9wLW1vc3QgY29tbWl0IGlzIG5vdCBhIGJ1bXApLiBpdCBpcyB1c2VkIGFzIGEgY29uZGl0aW9uIGZvciBib3RoXG4gICAgLy8gdGhlIGBidW1wYCBhbmQgdGhlIGByZWxlYXNlYCB0YXNrcy5cbiAgICBjb25zdCBjaGFuZ2VzU2luY2VMYXN0UmVsZWFzZSA9ICchIGdpdCBsb2cgLS1vbmVsaW5lIC0xIHwgZ3JlcCAtcSBcImNob3JlKHJlbGVhc2UpOlwiJztcblxuICAgIHRoaXMuYnVtcFRhc2sgPSBwcm9qZWN0LmFkZFRhc2soJ2J1bXAnLCB7XG4gICAgICBkZXNjcmlwdGlvbjogJ0J1bXBzIHZlcnNpb24gYmFzZWQgb24gbGF0ZXN0IGdpdCB0YWcgYW5kIGdlbmVyYXRlcyBhIGNoYW5nZWxvZyBlbnRyeScsXG4gICAgICBjYXRlZ29yeTogVGFza0NhdGVnb3J5LlJFTEVBU0UsXG4gICAgICBjb25kaXRpb246IGNoYW5nZXNTaW5jZUxhc3RSZWxlYXNlLFxuICAgIH0pO1xuXG4gICAgLy8gdGhlIGRlZmF1bHQgZm9yIFwic3RhbmRhcmQtdmVyc2lvblwiIGlzIHRvIGZpbmQgYSB0YWcgYWNyb3NzIHRoZSBlbnRpcmVcbiAgICAvLyByZXBvc2l0b3J5IGJ1dCB3ZSB3YW50IHRvIHNlbGVjdCB0aGUgbGFzdCB0YWcgYWNjZXNzaWJsZSBmcm9tIHRoZVxuICAgIC8vICpjdXJyZW50IGJyYW5jaCouXG4gICAgdGhpcy5idW1wVGFzay5leGVjKGBnaXQgZGVzY3JpYmUgLS10YWdzIC0tbWF0Y2g9XCJ2KlwiIC0tZmlyc3QtcGFyZW50IC0tYWJicmV2PTAgPiAke3ZlcnNpb25GaWxlfWApO1xuICAgIHRoaXMuYnVtcFRhc2suZXhlYygnc3RhbmRhcmQtdmVyc2lvbicpO1xuXG4gICAgdGhpcy51bmJ1bXBUYXNrID0gcHJvamVjdC5hZGRUYXNrKCd1bmJ1bXAnLCB7XG4gICAgICBkZXNjcmlwdGlvbjogJ1Jlc3RvcmVzIHZlcnNpb24gdG8gMC4wLjAnLFxuICAgICAgY2F0ZWdvcnk6IFRhc2tDYXRlZ29yeS5SRUxFQVNFLFxuICAgICAgZXhlYzogJ3N0YW5kYXJkLXZlcnNpb24gLXIgMC4wLjAnLFxuICAgIH0pO1xuXG4gICAgcHJvamVjdC5hZGREZXZEZXBzKFxuICAgICAgJ3N0YW5kYXJkLXZlcnNpb25AXjknLFxuICAgICk7XG5cbiAgICBwcm9qZWN0Lm5wbWlnbm9yZT8uZXhjbHVkZSgnLy52ZXJzaW9ucmMuanNvbicpO1xuICAgIHByb2plY3QuZ2l0aWdub3JlLmFkZFBhdHRlcm5zKGAvJHt0aGlzLmNoYW5nZWxvZ0ZpbGV9YCk7XG4gICAgcHJvamVjdC5naXRpZ25vcmUuYWRkUGF0dGVybnMoYC8ke3ZlcnNpb25GaWxlfWApO1xuXG4gICAgbmV3IEpzb25GaWxlKHByb2plY3QsICcudmVyc2lvbnJjLmpzb24nLCB7XG4gICAgICBvYmo6IHtcbiAgICAgICAgcGFja2FnZUZpbGVzOiBbe1xuICAgICAgICAgIGZpbGVuYW1lOiB2ZXJzaW9uRmlsZSxcbiAgICAgICAgICB0eXBlOiAncGxhaW4tdGV4dCcsXG4gICAgICAgIH1dLFxuICAgICAgICBidW1wRmlsZXM6IFsncGFja2FnZS5qc29uJ10sXG4gICAgICAgIGNvbW1pdEFsbDogZmFsc2UsXG4gICAgICAgIGluZmlsZTogdGhpcy5jaGFuZ2Vsb2dGaWxlLFxuICAgICAgICBoZWFkZXI6ICcnLFxuICAgICAgICBza2lwOiB7XG4gICAgICAgICAgY29tbWl0OiB0cnVlLFxuICAgICAgICAgIHRhZzogdHJ1ZSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==