"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IniFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const INI = require("ini");
const object_file_1 = require("./object-file");
/**
 * (experimental) Represents an INI file.
 *
 * @experimental
 */
class IniFile extends object_file_1.ObjectFile {
    /**
     * @experimental
     */
    constructor(project, filePath, options) {
        super(project, filePath, options);
    }
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    synthesizeContent(resolver) {
        const json = super.synthesizeContent(resolver);
        if (!json) {
            return undefined;
        }
        return [
            ...(this.marker ? [`# ${IniFile.PROJEN_MARKER}`] : []),
            '',
            INI.stringify(JSON.parse(json)),
        ].join('\n');
    }
}
exports.IniFile = IniFile;
_a = JSII_RTTI_SYMBOL_1;
IniFile[_a] = { fqn: "projen.IniFile", version: "0.17.51" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5pLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2luaS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDJCQUEyQjtBQUUzQiwrQ0FBOEQ7Ozs7OztBQVc5RCxNQUFhLE9BQVEsU0FBUSx3QkFBVTs7OztJQUNyQyxZQUFZLE9BQWdCLEVBQUUsUUFBZ0IsRUFBRSxPQUF1QjtRQUNyRSxLQUFLLENBQUMsT0FBTyxFQUFFLFFBQVEsRUFBRSxPQUFPLENBQUMsQ0FBQztJQUNwQyxDQUFDOzs7Ozs7SUFFUyxpQkFBaUIsQ0FBQyxRQUFtQjtRQUM3QyxNQUFNLElBQUksR0FBRyxLQUFLLENBQUMsaUJBQWlCLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDL0MsSUFBSSxDQUFDLElBQUksRUFBRTtZQUNULE9BQU8sU0FBUyxDQUFDO1NBQ2xCO1FBRUQsT0FBTztZQUNMLEdBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssT0FBTyxDQUFDLGFBQWEsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztZQUN2RCxFQUFFO1lBQ0YsR0FBRyxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDO1NBQ2hDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ2YsQ0FBQzs7QUFoQkgsMEJBaUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgSU5JIGZyb20gJ2luaSc7XG5pbXBvcnQgeyBJUmVzb2x2ZXIgfSBmcm9tICcuL2ZpbGUnO1xuaW1wb3J0IHsgT2JqZWN0RmlsZSwgT2JqZWN0RmlsZU9wdGlvbnMgfSBmcm9tICcuL29iamVjdC1maWxlJztcbmltcG9ydCB7IFByb2plY3QgfSBmcm9tICcuL3Byb2plY3QnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSW5pRmlsZU9wdGlvbnMgZXh0ZW5kcyBPYmplY3RGaWxlT3B0aW9ucyB7fVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgSW5pRmlsZSBleHRlbmRzIE9iamVjdEZpbGUge1xuICBjb25zdHJ1Y3Rvcihwcm9qZWN0OiBQcm9qZWN0LCBmaWxlUGF0aDogc3RyaW5nLCBvcHRpb25zOiBJbmlGaWxlT3B0aW9ucykge1xuICAgIHN1cGVyKHByb2plY3QsIGZpbGVQYXRoLCBvcHRpb25zKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQ29udGVudChyZXNvbHZlcjogSVJlc29sdmVyKTogc3RyaW5nIHwgdW5kZWZpbmVkIHtcbiAgICBjb25zdCBqc29uID0gc3VwZXIuc3ludGhlc2l6ZUNvbnRlbnQocmVzb2x2ZXIpO1xuICAgIGlmICghanNvbikge1xuICAgICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgICB9XG5cbiAgICByZXR1cm4gW1xuICAgICAgLi4uICh0aGlzLm1hcmtlciA/IFtgIyAke0luaUZpbGUuUFJPSkVOX01BUktFUn1gXSA6IFtdKSxcbiAgICAgICcnLFxuICAgICAgSU5JLnN0cmluZ2lmeShKU09OLnBhcnNlKGpzb24pKSxcbiAgICBdLmpvaW4oJ1xcbicpO1xuICB9XG59XG4iXX0=