"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Default = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Provides default values for certain regional information points.
 *
 * @stability stable
 */
class Default {
    constructor() { }
    /**
     * Computes a "standard" AWS Service principal for a given service, region and suffix.
     *
     * This is useful for example when
     * you need to compute a service principal name, but you do not have a synthesize-time region literal available (so
     * all you have is `{ "Ref": "AWS::Region" }`). This way you get the same defaulting behavior that is normally used
     * for built-in data.
     *
     * @param service the name of the service (s3, s3.amazonaws.com, ...).
     * @param region the region in which the service principal is needed.
     * @param urlSuffix the URL suffix for the partition in which the region is located.
     * @stability stable
     */
    static servicePrincipal(service, region, urlSuffix) {
        const matches = service.match(/^([^.]+)(?:(?:\.amazonaws\.com(?:\.cn)?)|(?:\.c2s\.ic\.gov)|(?:\.sc2s\.sgov\.gov))?$/);
        if (!matches) {
            // Return "service" if it does not look like any of the following:
            // - s3
            // - s3.amazonaws.com
            // - s3.amazonaws.com.cn
            // - s3.c2s.ic.gov
            // - s3.sc2s.sgov.gov
            return service;
        }
        service = matches[1]; // Simplify the service name down to something like "s3"
        // Exceptions for Service Principals in us-iso-*
        const US_ISO_EXCEPTIONS = new Set([
            'cloudhsm',
            'config',
            'states',
            'workspaces',
        ]);
        // Exceptions for Service Principals in us-isob-*
        const US_ISOB_EXCEPTIONS = new Set([
            'dms',
            'states',
        ]);
        // Account for idiosyncratic Service Principals in `us-iso-*` regions
        if (region.startsWith('us-iso-') && US_ISO_EXCEPTIONS.has(service)) {
            switch (service) {
                // Services with universal principal
                case ('states'):
                    return `${service}.amazonaws.com`;
                // Services with a partitional principal
                default:
                    return `${service}.${urlSuffix}`;
            }
        }
        // Account for idiosyncratic Service Principals in `us-isob-*` regions
        if (region.startsWith('us-isob-') && US_ISOB_EXCEPTIONS.has(service)) {
            switch (service) {
                // Services with universal principal
                case ('states'):
                    return `${service}.amazonaws.com`;
                // Services with a partitional principal
                default:
                    return `${service}.${urlSuffix}`;
            }
        }
        switch (service) {
            // Services with a regional AND partitional principal
            case 'codedeploy':
            case 'logs':
                return `${service}.${region}.${urlSuffix}`;
            // Services with a regional principal
            case 'states':
            case 'ssm':
                return `${service}.${region}.amazonaws.com`;
            // Services with a partitional principal
            case 'ec2':
                return `${service}.${urlSuffix}`;
            // Services with a universal principal across all regions/partitions (the default case)
            default:
                return `${service}.amazonaws.com`;
        }
    }
}
exports.Default = Default;
_a = JSII_RTTI_SYMBOL_1;
Default[_a] = { fqn: "@aws-cdk/region-info.Default", version: "1.134.0" };
/**
 * The default value for a VPC Endpoint Service name prefix, useful if you do not have a synthesize-time region literal available (all you have is `{ "Ref": "AWS::Region" }`).
 *
 * @stability stable
 */
Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX = 'com.amazonaws.vpce';
//# sourceMappingURL=data:application/json;base64,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