"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tasks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const common_1 = require("../common");
const component_1 = require("../component");
const json_1 = require("../json");
const task_1 = require("./task");
/**
 * (experimental) Defines project tasks.
 *
 * Tasks extend the projen CLI by adding subcommands to it. Task definitions are
 * synthesized into `.projen/tasks.json`.
 *
 * @experimental
 */
class Tasks extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project) {
        super(project);
        const manifestFile = Tasks.MANIFEST_FILE;
        this._tasks = {};
        this._env = {};
        new json_1.JsonFile(project, manifestFile, {
            omitEmpty: true,
            obj: {
                tasks: (() => this.renderTasks()),
                env: (() => this._env),
            },
        });
    }
    /**
     * (experimental) All tasks.
     *
     * @experimental
     */
    get all() {
        return Object.values(this._tasks);
    }
    /**
     * (experimental) Adds a task to a project.
     *
     * @param name The name of the task.
     * @param options Task options.
     * @experimental
     */
    addTask(name, options = {}) {
        const task = new task_1.Task(this, name, options);
        this._tasks[name] = task;
        return task;
    }
    /**
     * (experimental) Adds global environment.
     *
     * @param name Environment variable name.
     * @param value Value.
     * @experimental
     */
    addEnvironment(name, value) {
        this._env[name] = value;
    }
    /**
     * (experimental) Returns a copy of the currently global environment for this project.
     *
     * @experimental
     */
    get env() {
        return {
            ...this._env,
        };
    }
    /**
     * (experimental) Finds a task by name.
     *
     * Returns `undefined` if the task cannot be found.
     *
     * @param name The name of the task.
     * @experimental
     */
    tryFind(name) {
        return this._tasks[name];
    }
    renderTasks() {
        const tasks = {};
        for (const task of Object.values(this._tasks)) {
            tasks[task.name] = task._renderSpec();
        }
        return tasks;
    }
}
exports.Tasks = Tasks;
_a = JSII_RTTI_SYMBOL_1;
Tasks[_a] = { fqn: "projen.tasks.Tasks", version: "0.17.49" };
/**
 * (experimental) The project-relative path of the tasks manifest file.
 *
 * @experimental
 */
Tasks.MANIFEST_FILE = path.posix.join(common_1.PROJEN_DIR, 'tasks.json');
//# sourceMappingURL=data:application/json;base64,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