"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsiiProject = exports.Stability = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const jsii_docgen_1 = require("./jsii-docgen");
const tasks_1 = require("./tasks");
const typescript_1 = require("./typescript");
const DEFAULT_JSII_IMAGE = 'jsii/superchain';
const EMAIL_REGEX = /(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])/;
const URL_REGEX = /((([A-Za-z]{3,9}:(?:\/\/)?)(?:[\-;:&=\+\$,\w]+@)?[A-Za-z0-9\.\-]+|(?:www\.|[\-;:&=\+\$,\w]+@)[A-Za-z0-9\.\-]+)((?:\/[\+~%\/\.\w\-_]*)?\??(?:[\-\+=&;%@\.\w_]*)#?(?:[\.\!\/\\\w]*))?)/;
/**
 * @experimental
 */
var Stability;
(function (Stability) {
    Stability["EXPERIMENTAL"] = "experimental";
    Stability["STABLE"] = "stable";
    Stability["DEPRECATED"] = "deprecated";
})(Stability = exports.Stability || (exports.Stability = {}));
/**
 * (experimental) Multi-language jsii library project.
 *
 * @experimental
 */
class JsiiProject extends typescript_1.TypeScriptProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
        const { authorEmail, authorUrl } = parseAuthorAddress(options);
        super({
            ...options,
            workflowContainerImage: (_b = options.workflowContainerImage) !== null && _b !== void 0 ? _b : DEFAULT_JSII_IMAGE,
            releaseToNpm: false,
            repository: options.repositoryUrl,
            authorName: options.author,
            ...options,
            disableTsconfig: true,
            authorEmail,
            authorUrl,
        });
        const srcdir = this.srcdir;
        const libdir = this.libdir;
        this.addFields({ types: `${libdir}/index.d.ts` });
        // this is an unhelpful warning
        const jsiiFlags = [
            '--silence-warnings=reserved-word',
            '--no-fix-peer-dependencies',
        ].join(' ');
        const compatIgnore = (_c = options.compatIgnore) !== null && _c !== void 0 ? _c : '.compatignore';
        this.addFields({ stability: (_d = options.stability) !== null && _d !== void 0 ? _d : Stability.STABLE });
        if (options.stability === Stability.DEPRECATED) {
            this.addFields({ deprecated: true });
        }
        const compatTask = this.addTask('compat', {
            description: 'Perform API compatibility check against latest version',
            category: tasks_1.TaskCategory.RELEASE,
            exec: `jsii-diff npm:$(node -p "require(\'./package.json\').name") -k --ignore-file ${compatIgnore} || (echo "\nUNEXPECTED BREAKING CHANGES: add keys such as \'removed:constructs.Node.of\' to ${compatIgnore} to skip.\n" && exit 1)`,
        });
        const compat = (_e = options.compat) !== null && _e !== void 0 ? _e : false;
        if (compat) {
            this.compileTask.spawn(compatTask);
        }
        this.compileTask.reset(`jsii ${jsiiFlags}`);
        this.watchTask.reset(`jsii -w ${jsiiFlags}`);
        (_f = this.packageTask) === null || _f === void 0 ? void 0 : _f.reset('jsii-pacmak');
        const targets = {};
        const jsii = {
            outdir: 'dist',
            targets,
            tsc: {
                outDir: libdir,
                rootDir: srcdir,
            },
        };
        if (options.excludeTypescript) {
            jsii.excludeTypescript = options.excludeTypescript;
        }
        this.addFields({ jsii });
        (_g = this.publisher) === null || _g === void 0 ? void 0 : _g.publishToNpm({
            distTag: this.package.npmDistTag,
            registry: this.package.npmRegistry,
        });
        // we cannot call an option `java` because the java code generated by jsii
        // does not compile due to a conflict between this option name and the `java`
        // package (e.g. when `java.util.Objects` is referenced).
        if ('java' in options) {
            throw new Error('the "java" option is now called "publishToMaven"');
        }
        if (options.publishToMaven) {
            targets.java = {
                package: options.publishToMaven.javaPackage,
                maven: {
                    groupId: options.publishToMaven.mavenGroupId,
                    artifactId: options.publishToMaven.mavenArtifactId,
                },
            };
            (_h = this.publisher) === null || _h === void 0 ? void 0 : _h.publishToMaven(options.publishToMaven);
        }
        const pypi = (_j = options.publishToPypi) !== null && _j !== void 0 ? _j : options.python;
        if (pypi) {
            targets.python = {
                distName: pypi.distName,
                module: pypi.module,
            };
            (_k = this.publisher) === null || _k === void 0 ? void 0 : _k.publishToPyPi(pypi);
        }
        const nuget = (_l = options.publishToNuget) !== null && _l !== void 0 ? _l : options.dotnet;
        if (nuget) {
            targets.dotnet = {
                namespace: nuget.dotNetNamespace,
                packageId: nuget.packageId,
            };
            (_m = this.publisher) === null || _m === void 0 ? void 0 : _m.publishToNuget(nuget);
        }
        const golang = options.publishToGo;
        if (golang) {
            targets.go = {
                moduleName: golang.moduleName,
            };
            (_o = this.publisher) === null || _o === void 0 ? void 0 : _o.publishToGo(golang);
        }
        this.addDevDeps('jsii', 'jsii-diff', 'jsii-pacmak');
        this.gitignore.exclude('.jsii', 'tsconfig.json');
        (_p = this.npmignore) === null || _p === void 0 ? void 0 : _p.include('.jsii');
        if ((_q = options.docgen) !== null && _q !== void 0 ? _q : true) {
            new jsii_docgen_1.JsiiDocgen(this);
        }
        // jsii updates .npmignore, so we make it writable
        if (this.npmignore) {
            this.npmignore.readonly = false;
        }
    }
}
exports.JsiiProject = JsiiProject;
_a = JSII_RTTI_SYMBOL_1;
JsiiProject[_a] = { fqn: "projen.JsiiProject", version: "0.17.47" };
function parseAuthorAddress(options) {
    let authorEmail = options.authorEmail;
    let authorUrl = options.authorUrl;
    if (options.authorAddress) {
        if (options.authorEmail && options.authorEmail !== options.authorAddress) {
            throw new Error('authorEmail is deprecated and cannot be used in conjunction with authorAddress');
        }
        if (options.authorUrl && options.authorUrl !== options.authorAddress) {
            throw new Error('authorUrl is deprecated and cannot be used in conjunction with authorAddress.');
        }
        if (EMAIL_REGEX.test(options.authorAddress)) {
            authorEmail = options.authorAddress;
        }
        else if (URL_REGEX.test(options.authorAddress)) {
            authorUrl = options.authorAddress;
        }
        else {
            throw new Error(`authorAddress must be either an email address or a URL: ${options.authorAddress}`);
        }
    }
    return { authorEmail, authorUrl };
}
//# sourceMappingURL=data:application/json;base64,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