"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SuperEC2Base = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const ami_1 = require("./ami");
/**
 * @experimental
 */
class SuperEC2Base extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        this.vpc = (_b = props.vpc) !== null && _b !== void 0 ? _b : new ec2.Vpc(this, 'SuperEC2Vpc', {
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 1,
        });
        this.userData = ec2.UserData.forLinux();
        this.defaultSecurityGroup = new ec2.SecurityGroup(this, 'defaultSecurityGroup', {
            vpc: this.vpc,
        });
        this.instance = new ec2.Instance(this, 'SuperEC2', {
            machineImage: props.amiOSType ? ami_1.amiFinder(props === null || props === void 0 ? void 0 : props.amiOSType) : ami_1.amiFinder(ami_1.AmiOSType.AMAZON_LINUX_2),
            vpc: this.vpc,
            instanceType: (_c = props.instanceType) !== null && _c !== void 0 ? _c : new ec2.InstanceType('t3.small'),
            userData: this.userData,
            securityGroup: this.defaultSecurityGroup,
        });
    }
}
exports.SuperEC2Base = SuperEC2Base;
_a = JSII_RTTI_SYMBOL_1;
SuperEC2Base[_a] = { fqn: "super-ec2.SuperEC2Base", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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