"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubWorkflow = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const yaml_1 = require("../yaml");
/**
 * @experimental
 */
class GithubWorkflow extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, name) {
        super(github.project);
        this.events = {};
        this.jobs = {};
        this.name = name;
        this.file = new yaml_1.YamlFile(this.project, `.github/workflows/${name.toLocaleLowerCase()}.yml`, {
            obj: () => this.renderWorkflow(),
        });
    }
    /**
     * @experimental
     */
    on(events) {
        this.events = {
            ...this.events,
            ...events,
        };
    }
    /**
     * @experimental
     */
    addJobs(jobs) {
        this.jobs = {
            ...this.jobs,
            ...jobs,
        };
    }
    renderWorkflow() {
        return {
            name: this.name,
            on: this.events,
            jobs: this.jobs,
        };
    }
}
exports.GithubWorkflow = GithubWorkflow;
_a = JSII_RTTI_SYMBOL_1;
GithubWorkflow[_a] = { fqn: "projen.github.GithubWorkflow", version: "0.17.43" };
//# sourceMappingURL=data:application/json;base64,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