import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
import * as cdk from '@aws-cdk/core';
import { SuperEC2Base, ISuperEC2BaseProps } from './super-ec2';
import { ELBtype, IDomainProps, SuperDomain } from './super-ec2-interfaces';
/**
 * @experimental
 */
export interface IJenkinsEC2Props extends ISuperEC2BaseProps {
    /**
     * (experimental) Provide a loadbalancer.
     *
     * Only support ALB and NLB.
     *
     * @default - Create ApplicationLoadBalancer
     * @experimental
     */
    loadbalancer?: elbv2.ApplicationLoadBalancer | elbv2.NetworkLoadBalancer;
    /**
     * (experimental) ELB type.
     *
     * @default - ELBtype.ALB
     * @experimental
     */
    loadbalancerType?: ELBtype;
    /**
     * (experimental) Provide domain attribute.
     *
     * @default - Not use certificate and route53
     * @experimental
     */
    domain?: IDomainProps;
}
/**
 * @experimental
 */
export declare class JenkinsEC2 extends SuperEC2Base {
    /**
     * @experimental
     */
    readonly loadbalancer: elbv2.ApplicationLoadBalancer | elbv2.NetworkLoadBalancer;
    /**
     * @experimental
     */
    readonly domain?: SuperDomain;
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props: IJenkinsEC2Props);
    /**
     * @experimental
     */
    jenkinsUserData(): string[];
    private _addIngressRule;
    private _setloadbalancer;
    private _setlistener;
    private _set80listener;
}
