"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const fs_extra_1 = require("fs-extra");
const common_1 = require("../common");
const component_1 = require("../component");
const deps_1 = require("../deps");
const project_1 = require("../project");
/**
 * (experimental) Allows writing projenrc files in java.
 *
 * This will install `org.projen/projen` as a Maven dependency and will add a
 * `synth` task which will compile & execute `main()` from
 * `src/main/java/projenrc.java`.
 *
 * @experimental
 */
class Projenrc extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, pom, options = {}) {
        var _b, _c, _d;
        super(project);
        const projenVersion = (_b = options.projenVersion) !== null && _b !== void 0 ? _b : common_1.PROJEN_VERSION;
        this.className = (_c = options.className) !== null && _c !== void 0 ? _c : 'projenrc';
        this.testScope = (_d = options.testScope) !== null && _d !== void 0 ? _d : true;
        const depType = this.testScope ? deps_1.DependencyType.TEST : deps_1.DependencyType.RUNTIME;
        const execOpts = this.testScope ? ' -Dexec.classpathScope="test"' : '';
        const compileGoal = this.testScope ? 'compiler:testCompile' : 'compiler:compile';
        project.deps.addDependency(`com.github.eladb/projen@${projenVersion}`, depType);
        pom.addPlugin('org.codehaus.mojo/exec-maven-plugin@3.0.0');
        // set up the "default" task which is the task executed when `projen` is executed for this project.
        const defaultTask = project.addTask(project_1.Project.DEFAULT_TASK, { description: 'Synthesize the project' });
        defaultTask.exec(`mvn ${compileGoal} --quiet`);
        defaultTask.exec(`mvn exec:java --quiet -Dexec.mainClass=${this.className}${execOpts}`);
        // if this is a new project, generate a skelaton for projenrc.java
        this.generateProjenrc(options.initializationOptions);
    }
    generateProjenrc(initOptions) {
        var _b, _c, _d;
        if (!this.project.jsiiFqn) {
            return; // cannot generate projenrc without the FQN of the project type.
        }
        let [moduleName] = this.project.jsiiFqn.split('.');
        if (moduleName === 'projen') {
            moduleName = '../..';
        }
        const jsiiManifestFile = require.resolve(`${moduleName}/.jsii`);
        const jsiiManifest = fs_extra_1.readJsonSync(jsiiManifestFile);
        const jsiiType = jsiiManifest.types[this.project.jsiiFqn];
        const javaTarget = jsiiManifest.targets.java;
        const optionsTypeFqn = (_d = (_c = (_b = jsiiType.initializer) === null || _b === void 0 ? void 0 : _b.parameters) === null || _c === void 0 ? void 0 : _c[0].type) === null || _d === void 0 ? void 0 : _d.fqn;
        if (!optionsTypeFqn) {
            this.project.logger.warn('cannot determine jsii type for project options');
            return;
        }
        const jsiiOptionsType = jsiiManifest.types[optionsTypeFqn];
        if (!jsiiOptionsType) {
            this.project.logger.warn(`cannot find jsii type for project options: ${optionsTypeFqn}`);
            return;
        }
        const dir = this.testScope ? 'src/test/java' : 'src/main/java';
        const split = this.className.split('.');
        let javaClass, javaPackage;
        if (split.length === 1) {
            javaClass = split[0];
            javaPackage = [];
        }
        else {
            javaPackage = split.slice(0, split.length - 2);
            javaClass = split[split.length - 1];
        }
        const javaFile = path_1.join(this.project.outdir, dir, ...javaPackage, javaClass + '.java');
        // skip if file exists
        if (fs_extra_1.existsSync(javaFile)) {
            return;
        }
        const lines = new Array();
        let indent = 0;
        const emit = (line = '') => lines.push(' '.repeat(indent * 4) + line);
        const openBlock = (line = '') => { emit(line + ' {'); indent++; };
        const closeBlock = () => { indent--; emit('}'); };
        if (javaPackage.length > 0) {
            emit(`package ${javaPackage.join('.')};`);
            emit();
        }
        emit(`import ${javaTarget.package}.${toJavaFullTypeName(jsiiType)};`);
        emit(`import ${javaTarget.package}.${toJavaFullTypeName(jsiiOptionsType)};`);
        emit();
        openBlock(`public class ${javaClass}`);
        openBlock('public static void main(String[] args)');
        emit(`${jsiiType.name} project = new ${jsiiType.name}(${renderJavaOptions(indent, jsiiOptionsType.name, initOptions)});`);
        emit('project.synth();');
        closeBlock();
        closeBlock();
        fs_extra_1.mkdirpSync(path_1.dirname(javaFile));
        fs_extra_1.writeFileSync(javaFile, lines.join('\n'));
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.java.Projenrc", version: "0.17.37" };
function renderJavaOptions(indent, optionsTypeName, initOptions) {
    if (!initOptions || Object.keys(initOptions).length === 0) {
        return ''; // no options
    }
    const lines = [`${optionsTypeName}.builder()`];
    for (const [name, value] of Object.entries(initOptions)) {
        lines.push(`.${toJavaProperty(name)}(${toJavaValue(value)})`);
    }
    lines.push('.build()');
    return lines.join(`\n${' '.repeat((indent + 1) * 4)}`);
}
function toJavaProperty(prop) {
    return prop;
}
function toJavaValue(value) {
    return JSON.stringify(value);
}
function toJavaFullTypeName(jsiiType) {
    return [jsiiType.namespace, jsiiType.name].filter(x => x).join('.');
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJvamVucmMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvamF2YS9wcm9qZW5yYy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLCtCQUFxQztBQUNyQyx1Q0FBK0U7QUFDL0Usc0NBQTJDO0FBQzNDLDRDQUF5QztBQUN6QyxrQ0FBeUM7QUFDekMsd0NBQXFDOzs7Ozs7Ozs7O0FBZ0RyQyxNQUFhLFFBQVMsU0FBUSxxQkFBUzs7OztJQVdyQyxZQUFZLE9BQWdCLEVBQUUsR0FBUSxFQUFFLFVBQTJCLEVBQUU7O1FBQ25FLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUVmLE1BQU0sYUFBYSxTQUFHLE9BQU8sQ0FBQyxhQUFhLG1DQUFJLHVCQUFjLENBQUM7UUFDOUQsSUFBSSxDQUFDLFNBQVMsU0FBRyxPQUFPLENBQUMsU0FBUyxtQ0FBSSxVQUFVLENBQUM7UUFDakQsSUFBSSxDQUFDLFNBQVMsU0FBRyxPQUFPLENBQUMsU0FBUyxtQ0FBSSxJQUFJLENBQUM7UUFFM0MsTUFBTSxPQUFPLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMscUJBQWMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLHFCQUFjLENBQUMsT0FBTyxDQUFDO1FBQzlFLE1BQU0sUUFBUSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLCtCQUErQixDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7UUFDdkUsTUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxDQUFDLGtCQUFrQixDQUFDO1FBRWpGLE9BQU8sQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLDJCQUEyQixhQUFhLEVBQUUsRUFBRSxPQUFPLENBQUMsQ0FBQztRQUNoRixHQUFHLENBQUMsU0FBUyxDQUFDLDJDQUEyQyxDQUFDLENBQUM7UUFFM0QsbUdBQW1HO1FBQ25HLE1BQU0sV0FBVyxHQUFHLE9BQU8sQ0FBQyxPQUFPLENBQUMsaUJBQU8sQ0FBQyxZQUFZLEVBQUUsRUFBRSxXQUFXLEVBQUUsd0JBQXdCLEVBQUUsQ0FBQyxDQUFDO1FBQ3JHLFdBQVcsQ0FBQyxJQUFJLENBQUMsT0FBTyxXQUFXLFVBQVUsQ0FBQyxDQUFDO1FBQy9DLFdBQVcsQ0FBQyxJQUFJLENBQUMsMENBQTBDLElBQUksQ0FBQyxTQUFTLEdBQUcsUUFBUSxFQUFFLENBQUMsQ0FBQztRQUV4RixrRUFBa0U7UUFDbEUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE9BQU8sQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3ZELENBQUM7SUFFTyxnQkFBZ0IsQ0FBQyxXQUFpQzs7UUFDeEQsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxFQUFFO1lBQ3pCLE9BQU8sQ0FBQyxnRUFBZ0U7U0FDekU7UUFFRCxJQUFJLENBQUMsVUFBVSxDQUFDLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ25ELElBQUksVUFBVSxLQUFLLFFBQVEsRUFBRTtZQUMzQixVQUFVLEdBQUcsT0FBTyxDQUFDO1NBQ3RCO1FBRUQsTUFBTSxnQkFBZ0IsR0FBRyxPQUFPLENBQUMsT0FBTyxDQUFDLEdBQUcsVUFBVSxRQUFRLENBQUMsQ0FBQztRQUNoRSxNQUFNLFlBQVksR0FBRyx1QkFBWSxDQUFDLGdCQUFnQixDQUFDLENBQUM7UUFDcEQsTUFBTSxRQUFRLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQzFELE1BQU0sVUFBVSxHQUFHLFlBQVksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDO1FBQzdDLE1BQU0sY0FBYyxxQkFBRyxRQUFRLENBQUMsV0FBVywwQ0FBRSxVQUFVLDBDQUFHLENBQUMsRUFBRSxJQUFJLDBDQUFFLEdBQUcsQ0FBQztRQUN2RSxJQUFJLENBQUMsY0FBYyxFQUFFO1lBQ25CLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxnREFBZ0QsQ0FBQyxDQUFDO1lBQzNFLE9BQU87U0FDUjtRQUNELE1BQU0sZUFBZSxHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDLENBQUM7UUFDM0QsSUFBSSxDQUFDLGVBQWUsRUFBRTtZQUNwQixJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsOENBQThDLGNBQWMsRUFBRSxDQUFDLENBQUM7WUFDekYsT0FBTztTQUNSO1FBRUQsTUFBTSxHQUFHLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyxlQUFlLENBQUM7UUFDL0QsTUFBTSxLQUFLLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDeEMsSUFBSSxTQUFpQixFQUFFLFdBQXFCLENBQUM7UUFDN0MsSUFBSSxLQUFLLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtZQUN0QixTQUFTLEdBQUcsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ3JCLFdBQVcsR0FBRyxFQUFFLENBQUM7U0FDbEI7YUFBTTtZQUNMLFdBQVcsR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxLQUFLLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDO1lBQy9DLFNBQVMsR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQztTQUNyQztRQUVELE1BQU0sUUFBUSxHQUFHLFdBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sRUFBRSxHQUFHLEVBQUUsR0FBRyxXQUFXLEVBQUUsU0FBUyxHQUFHLE9BQU8sQ0FBQyxDQUFDO1FBRXJGLHNCQUFzQjtRQUN0QixJQUFJLHFCQUFVLENBQUMsUUFBUSxDQUFDLEVBQUU7WUFDeEIsT0FBTztTQUNSO1FBRUQsTUFBTSxLQUFLLEdBQUcsSUFBSSxLQUFLLEVBQVUsQ0FBQztRQUVsQyxJQUFJLE1BQU0sR0FBRyxDQUFDLENBQUM7UUFDZixNQUFNLElBQUksR0FBRyxDQUFDLE9BQWUsRUFBRSxFQUFFLEVBQUUsQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQyxDQUFDO1FBQzlFLE1BQU0sU0FBUyxHQUFHLENBQUMsT0FBZSxFQUFFLEVBQUUsRUFBRSxHQUFHLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLENBQUMsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUMxRSxNQUFNLFVBQVUsR0FBRyxHQUFHLEVBQUUsR0FBRyxNQUFNLEVBQUUsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUVsRCxJQUFJLFdBQVcsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO1lBQzFCLElBQUksQ0FBQyxXQUFXLFdBQVcsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQzFDLElBQUksRUFBRSxDQUFDO1NBQ1I7UUFFRCxJQUFJLENBQUMsVUFBVSxVQUFVLENBQUMsT0FBTyxJQUFJLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUN0RSxJQUFJLENBQUMsVUFBVSxVQUFVLENBQUMsT0FBTyxJQUFJLGtCQUFrQixDQUFDLGVBQWUsQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUM3RSxJQUFJLEVBQUUsQ0FBQztRQUNQLFNBQVMsQ0FBQyxnQkFBZ0IsU0FBUyxFQUFFLENBQUMsQ0FBQztRQUN2QyxTQUFTLENBQUMsd0NBQXdDLENBQUMsQ0FBQztRQUNwRCxJQUFJLENBQUMsR0FBRyxRQUFRLENBQUMsSUFBSSxrQkFBa0IsUUFBUSxDQUFDLElBQUksSUFBSSxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsZUFBZSxDQUFDLElBQUksRUFBRSxXQUFXLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDMUgsSUFBSSxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDekIsVUFBVSxFQUFFLENBQUM7UUFDYixVQUFVLEVBQUUsQ0FBQztRQUViLHFCQUFVLENBQUMsY0FBTyxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7UUFDOUIsd0JBQWEsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQzVDLENBQUM7O0FBckdILDRCQXNHQzs7O0FBRUQsU0FBUyxpQkFBaUIsQ0FBQyxNQUFjLEVBQUUsZUFBdUIsRUFBRSxXQUFpQztJQUNuRyxJQUFJLENBQUMsV0FBVyxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtRQUN6RCxPQUFPLEVBQUUsQ0FBQyxDQUFDLGFBQWE7S0FDekI7SUFFRCxNQUFNLEtBQUssR0FBRyxDQUFDLEdBQUcsZUFBZSxZQUFZLENBQUMsQ0FBQztJQUUvQyxLQUFLLE1BQU0sQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsRUFBRTtRQUN2RCxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksY0FBYyxDQUFDLElBQUksQ0FBQyxJQUFJLFdBQVcsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7S0FDL0Q7SUFFRCxLQUFLLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBRXZCLE9BQU8sS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLEdBQUcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDO0FBQ3pELENBQUM7QUFFRCxTQUFTLGNBQWMsQ0FBQyxJQUFZO0lBQ2xDLE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQUVELFNBQVMsV0FBVyxDQUFDLEtBQVU7SUFDN0IsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxDQUFDO0FBQy9CLENBQUM7QUFFRCxTQUFTLGtCQUFrQixDQUFDLFFBQWE7SUFDdkMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxTQUFTLEVBQUUsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztBQUN0RSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgZGlybmFtZSwgam9pbiB9IGZyb20gJ3BhdGgnO1xuaW1wb3J0IHsgZXhpc3RzU3luYywgbWtkaXJwU3luYywgcmVhZEpzb25TeW5jLCB3cml0ZUZpbGVTeW5jIH0gZnJvbSAnZnMtZXh0cmEnO1xuaW1wb3J0IHsgUFJPSkVOX1ZFUlNJT04gfSBmcm9tICcuLi9jb21tb24nO1xuaW1wb3J0IHsgQ29tcG9uZW50IH0gZnJvbSAnLi4vY29tcG9uZW50JztcbmltcG9ydCB7IERlcGVuZGVuY3lUeXBlIH0gZnJvbSAnLi4vZGVwcyc7XG5pbXBvcnQgeyBQcm9qZWN0IH0gZnJvbSAnLi4vcHJvamVjdCc7XG5pbXBvcnQgeyBQb20gfSBmcm9tICcuL3BvbSc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgUHJvamVucmNDb21tb25PcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2xhc3NOYW1lPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwcm9qZW5WZXJzaW9uPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGVzdFNjb3BlPzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBQcm9qZW5yY09wdGlvbnMgZXh0ZW5kcyBQcm9qZW5yY0NvbW1vbk9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGluaXRpYWxpemF0aW9uT3B0aW9ucz86IHsgW25hbWU6IHN0cmluZ106IGFueSB9O1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgUHJvamVucmMgZXh0ZW5kcyBDb21wb25lbnQge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGNsYXNzTmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIHRoZSBjbGFzcyBpcyBpbiB0aGUgXCJ0ZXN0XCIgb3IgXCJtYWluXCIgc2NvcGU/XG4gICAqL1xuICBwcml2YXRlIHJlYWRvbmx5IHRlc3RTY29wZTogYm9vbGVhbjtcblxuICBjb25zdHJ1Y3Rvcihwcm9qZWN0OiBQcm9qZWN0LCBwb206IFBvbSwgb3B0aW9uczogUHJvamVucmNPcHRpb25zID0ge30pIHtcbiAgICBzdXBlcihwcm9qZWN0KTtcblxuICAgIGNvbnN0IHByb2plblZlcnNpb24gPSBvcHRpb25zLnByb2plblZlcnNpb24gPz8gUFJPSkVOX1ZFUlNJT047XG4gICAgdGhpcy5jbGFzc05hbWUgPSBvcHRpb25zLmNsYXNzTmFtZSA/PyAncHJvamVucmMnO1xuICAgIHRoaXMudGVzdFNjb3BlID0gb3B0aW9ucy50ZXN0U2NvcGUgPz8gdHJ1ZTtcblxuICAgIGNvbnN0IGRlcFR5cGUgPSB0aGlzLnRlc3RTY29wZSA/IERlcGVuZGVuY3lUeXBlLlRFU1QgOiBEZXBlbmRlbmN5VHlwZS5SVU5USU1FO1xuICAgIGNvbnN0IGV4ZWNPcHRzID0gdGhpcy50ZXN0U2NvcGUgPyAnIC1EZXhlYy5jbGFzc3BhdGhTY29wZT1cInRlc3RcIicgOiAnJztcbiAgICBjb25zdCBjb21waWxlR29hbCA9IHRoaXMudGVzdFNjb3BlID8gJ2NvbXBpbGVyOnRlc3RDb21waWxlJyA6ICdjb21waWxlcjpjb21waWxlJztcblxuICAgIHByb2plY3QuZGVwcy5hZGREZXBlbmRlbmN5KGBjb20uZ2l0aHViLmVsYWRiL3Byb2plbkAke3Byb2plblZlcnNpb259YCwgZGVwVHlwZSk7XG4gICAgcG9tLmFkZFBsdWdpbignb3JnLmNvZGVoYXVzLm1vam8vZXhlYy1tYXZlbi1wbHVnaW5AMy4wLjAnKTtcblxuICAgIC8vIHNldCB1cCB0aGUgXCJkZWZhdWx0XCIgdGFzayB3aGljaCBpcyB0aGUgdGFzayBleGVjdXRlZCB3aGVuIGBwcm9qZW5gIGlzIGV4ZWN1dGVkIGZvciB0aGlzIHByb2plY3QuXG4gICAgY29uc3QgZGVmYXVsdFRhc2sgPSBwcm9qZWN0LmFkZFRhc2soUHJvamVjdC5ERUZBVUxUX1RBU0ssIHsgZGVzY3JpcHRpb246ICdTeW50aGVzaXplIHRoZSBwcm9qZWN0JyB9KTtcbiAgICBkZWZhdWx0VGFzay5leGVjKGBtdm4gJHtjb21waWxlR29hbH0gLS1xdWlldGApO1xuICAgIGRlZmF1bHRUYXNrLmV4ZWMoYG12biBleGVjOmphdmEgLS1xdWlldCAtRGV4ZWMubWFpbkNsYXNzPSR7dGhpcy5jbGFzc05hbWV9JHtleGVjT3B0c31gKTtcblxuICAgIC8vIGlmIHRoaXMgaXMgYSBuZXcgcHJvamVjdCwgZ2VuZXJhdGUgYSBza2VsYXRvbiBmb3IgcHJvamVucmMuamF2YVxuICAgIHRoaXMuZ2VuZXJhdGVQcm9qZW5yYyhvcHRpb25zLmluaXRpYWxpemF0aW9uT3B0aW9ucyk7XG4gIH1cblxuICBwcml2YXRlIGdlbmVyYXRlUHJvamVucmMoaW5pdE9wdGlvbnM/OiBSZWNvcmQ8c3RyaW5nLCBhbnk+KSB7XG4gICAgaWYgKCF0aGlzLnByb2plY3QuanNpaUZxbikge1xuICAgICAgcmV0dXJuOyAvLyBjYW5ub3QgZ2VuZXJhdGUgcHJvamVucmMgd2l0aG91dCB0aGUgRlFOIG9mIHRoZSBwcm9qZWN0IHR5cGUuXG4gICAgfVxuXG4gICAgbGV0IFttb2R1bGVOYW1lXSA9IHRoaXMucHJvamVjdC5qc2lpRnFuLnNwbGl0KCcuJyk7XG4gICAgaWYgKG1vZHVsZU5hbWUgPT09ICdwcm9qZW4nKSB7XG4gICAgICBtb2R1bGVOYW1lID0gJy4uLy4uJztcbiAgICB9XG5cbiAgICBjb25zdCBqc2lpTWFuaWZlc3RGaWxlID0gcmVxdWlyZS5yZXNvbHZlKGAke21vZHVsZU5hbWV9Ly5qc2lpYCk7XG4gICAgY29uc3QganNpaU1hbmlmZXN0ID0gcmVhZEpzb25TeW5jKGpzaWlNYW5pZmVzdEZpbGUpO1xuICAgIGNvbnN0IGpzaWlUeXBlID0ganNpaU1hbmlmZXN0LnR5cGVzW3RoaXMucHJvamVjdC5qc2lpRnFuXTtcbiAgICBjb25zdCBqYXZhVGFyZ2V0ID0ganNpaU1hbmlmZXN0LnRhcmdldHMuamF2YTtcbiAgICBjb25zdCBvcHRpb25zVHlwZUZxbiA9IGpzaWlUeXBlLmluaXRpYWxpemVyPy5wYXJhbWV0ZXJzPy5bMF0udHlwZT8uZnFuO1xuICAgIGlmICghb3B0aW9uc1R5cGVGcW4pIHtcbiAgICAgIHRoaXMucHJvamVjdC5sb2dnZXIud2FybignY2Fubm90IGRldGVybWluZSBqc2lpIHR5cGUgZm9yIHByb2plY3Qgb3B0aW9ucycpO1xuICAgICAgcmV0dXJuO1xuICAgIH1cbiAgICBjb25zdCBqc2lpT3B0aW9uc1R5cGUgPSBqc2lpTWFuaWZlc3QudHlwZXNbb3B0aW9uc1R5cGVGcW5dO1xuICAgIGlmICghanNpaU9wdGlvbnNUeXBlKSB7XG4gICAgICB0aGlzLnByb2plY3QubG9nZ2VyLndhcm4oYGNhbm5vdCBmaW5kIGpzaWkgdHlwZSBmb3IgcHJvamVjdCBvcHRpb25zOiAke29wdGlvbnNUeXBlRnFufWApO1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIGNvbnN0IGRpciA9IHRoaXMudGVzdFNjb3BlID8gJ3NyYy90ZXN0L2phdmEnIDogJ3NyYy9tYWluL2phdmEnO1xuICAgIGNvbnN0IHNwbGl0ID0gdGhpcy5jbGFzc05hbWUuc3BsaXQoJy4nKTtcbiAgICBsZXQgamF2YUNsYXNzOiBzdHJpbmcsIGphdmFQYWNrYWdlOiBzdHJpbmdbXTtcbiAgICBpZiAoc3BsaXQubGVuZ3RoID09PSAxKSB7XG4gICAgICBqYXZhQ2xhc3MgPSBzcGxpdFswXTtcbiAgICAgIGphdmFQYWNrYWdlID0gW107XG4gICAgfSBlbHNlIHtcbiAgICAgIGphdmFQYWNrYWdlID0gc3BsaXQuc2xpY2UoMCwgc3BsaXQubGVuZ3RoIC0gMik7XG4gICAgICBqYXZhQ2xhc3MgPSBzcGxpdFtzcGxpdC5sZW5ndGggLSAxXTtcbiAgICB9XG5cbiAgICBjb25zdCBqYXZhRmlsZSA9IGpvaW4odGhpcy5wcm9qZWN0Lm91dGRpciwgZGlyLCAuLi5qYXZhUGFja2FnZSwgamF2YUNsYXNzICsgJy5qYXZhJyk7XG5cbiAgICAvLyBza2lwIGlmIGZpbGUgZXhpc3RzXG4gICAgaWYgKGV4aXN0c1N5bmMoamF2YUZpbGUpKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgY29uc3QgbGluZXMgPSBuZXcgQXJyYXk8c3RyaW5nPigpO1xuXG4gICAgbGV0IGluZGVudCA9IDA7XG4gICAgY29uc3QgZW1pdCA9IChsaW5lOiBzdHJpbmcgPSAnJykgPT4gbGluZXMucHVzaCgnICcucmVwZWF0KGluZGVudCAqIDQpICsgbGluZSk7XG4gICAgY29uc3Qgb3BlbkJsb2NrID0gKGxpbmU6IHN0cmluZyA9ICcnKSA9PiB7IGVtaXQobGluZSArICcgeycpOyBpbmRlbnQrKzsgfTtcbiAgICBjb25zdCBjbG9zZUJsb2NrID0gKCkgPT4geyBpbmRlbnQtLTsgZW1pdCgnfScpOyB9O1xuXG4gICAgaWYgKGphdmFQYWNrYWdlLmxlbmd0aCA+IDApIHtcbiAgICAgIGVtaXQoYHBhY2thZ2UgJHtqYXZhUGFja2FnZS5qb2luKCcuJyl9O2ApO1xuICAgICAgZW1pdCgpO1xuICAgIH1cblxuICAgIGVtaXQoYGltcG9ydCAke2phdmFUYXJnZXQucGFja2FnZX0uJHt0b0phdmFGdWxsVHlwZU5hbWUoanNpaVR5cGUpfTtgKTtcbiAgICBlbWl0KGBpbXBvcnQgJHtqYXZhVGFyZ2V0LnBhY2thZ2V9LiR7dG9KYXZhRnVsbFR5cGVOYW1lKGpzaWlPcHRpb25zVHlwZSl9O2ApO1xuICAgIGVtaXQoKTtcbiAgICBvcGVuQmxvY2soYHB1YmxpYyBjbGFzcyAke2phdmFDbGFzc31gKTtcbiAgICBvcGVuQmxvY2soJ3B1YmxpYyBzdGF0aWMgdm9pZCBtYWluKFN0cmluZ1tdIGFyZ3MpJyk7XG4gICAgZW1pdChgJHtqc2lpVHlwZS5uYW1lfSBwcm9qZWN0ID0gbmV3ICR7anNpaVR5cGUubmFtZX0oJHtyZW5kZXJKYXZhT3B0aW9ucyhpbmRlbnQsIGpzaWlPcHRpb25zVHlwZS5uYW1lLCBpbml0T3B0aW9ucyl9KTtgKTtcbiAgICBlbWl0KCdwcm9qZWN0LnN5bnRoKCk7Jyk7XG4gICAgY2xvc2VCbG9jaygpO1xuICAgIGNsb3NlQmxvY2soKTtcblxuICAgIG1rZGlycFN5bmMoZGlybmFtZShqYXZhRmlsZSkpO1xuICAgIHdyaXRlRmlsZVN5bmMoamF2YUZpbGUsIGxpbmVzLmpvaW4oJ1xcbicpKTtcbiAgfVxufVxuXG5mdW5jdGlvbiByZW5kZXJKYXZhT3B0aW9ucyhpbmRlbnQ6IG51bWJlciwgb3B0aW9uc1R5cGVOYW1lOiBzdHJpbmcsIGluaXRPcHRpb25zPzogUmVjb3JkPHN0cmluZywgYW55Pik6IHN0cmluZyB7XG4gIGlmICghaW5pdE9wdGlvbnMgfHwgT2JqZWN0LmtleXMoaW5pdE9wdGlvbnMpLmxlbmd0aCA9PT0gMCkge1xuICAgIHJldHVybiAnJzsgLy8gbm8gb3B0aW9uc1xuICB9XG5cbiAgY29uc3QgbGluZXMgPSBbYCR7b3B0aW9uc1R5cGVOYW1lfS5idWlsZGVyKClgXTtcblxuICBmb3IgKGNvbnN0IFtuYW1lLCB2YWx1ZV0gb2YgT2JqZWN0LmVudHJpZXMoaW5pdE9wdGlvbnMpKSB7XG4gICAgbGluZXMucHVzaChgLiR7dG9KYXZhUHJvcGVydHkobmFtZSl9KCR7dG9KYXZhVmFsdWUodmFsdWUpfSlgKTtcbiAgfVxuXG4gIGxpbmVzLnB1c2goJy5idWlsZCgpJyk7XG5cbiAgcmV0dXJuIGxpbmVzLmpvaW4oYFxcbiR7JyAnLnJlcGVhdCgoaW5kZW50ICsgMSkgKiA0KX1gKTtcbn1cblxuZnVuY3Rpb24gdG9KYXZhUHJvcGVydHkocHJvcDogc3RyaW5nKSB7XG4gIHJldHVybiBwcm9wO1xufVxuXG5mdW5jdGlvbiB0b0phdmFWYWx1ZSh2YWx1ZTogYW55KSB7XG4gIHJldHVybiBKU09OLnN0cmluZ2lmeSh2YWx1ZSk7XG59XG5cbmZ1bmN0aW9uIHRvSmF2YUZ1bGxUeXBlTmFtZShqc2lpVHlwZTogYW55KSB7XG4gIHJldHVybiBbanNpaVR5cGUubmFtZXNwYWNlLCBqc2lpVHlwZS5uYW1lXS5maWx0ZXIoeCA9PiB4KS5qb2luKCcuJyk7XG59Il19