import * as certmgr from '@aws-cdk/aws-certificatemanager';
import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
import * as r53 from '@aws-cdk/aws-route53';
import * as cdk from '@aws-cdk/core';
/**
 * @experimental
 */
export declare enum ELBtype {
    /**
     * (experimental) Application Load Balancer.
     *
     * @experimental
     */
    ALB = "ALB",
    /**
     * (experimental) Network Load Balancer.
     *
     * @experimental
     */
    NLB = "NLB"
}
/**
 * @experimental
 */
export interface IDomainProps {
    /**
     * (experimental) Provide a certificate.
     *
     * @default - Create a new certificate (validate from DNS)
     * @experimental
     */
    acm?: certmgr.ICertificate;
    /**
     * (experimental) HostZoneID.
     *
     * @experimental
     */
    hostedZoneId: string;
    /**
     * (experimental) zonename (e.g., `cdk-construct-zone.com`).
     *
     * @experimental
     */
    zoneName: string;
    /**
     * (experimental) recordname (e.g., superjks).
     *
     * @experimental
     */
    recordName: string;
    /**
     * (experimental) record cache time.
     *
     * @experimental
     * @deafult - 5 mins.
     */
    ttl?: cdk.Duration;
}
/**
 * @experimental
 */
export interface ISuperDomainProps extends IDomainProps {
    /**
     * @experimental
     */
    loadbalancer: elbv2.ApplicationLoadBalancer | elbv2.NetworkLoadBalancer;
}
/**
 * @experimental
 */
export declare class SuperDomain extends cdk.Construct {
    /**
     * @experimental
     */
    readonly acm: certmgr.ICertificate;
    /**
     * @experimental
     */
    readonly record: r53.ARecord;
    /**
     * @experimental
     */
    readonly zone: r53.IHostedZone;
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props: ISuperDomainProps);
    private _setzone;
    private _setacm;
    private _setaliasrecord;
}
