"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PoetryPyproject = exports.Poetry = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const deps_1 = require("../deps");
const tasks_1 = require("../tasks");
const toml_1 = require("../toml");
const util_1 = require("../util");
/**
 * (experimental) Manage project dependencies, virtual environments, and packaging through the poetry CLI tool.
 *
 * @experimental
 */
class Poetry extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _c;
        super(project);
        this.installTask = project.addTask('install', {
            description: 'Install and upgrade dependencies',
            category: tasks_1.TaskCategory.BUILD,
            exec: 'poetry update',
        });
        this.project.tasks.addEnvironment('VIRTUAL_ENV', '$(poetry env info -p)');
        this.project.tasks.addEnvironment('PATH', '$(echo $(poetry env info -p)/bin:$PATH)');
        // declare the python versions for which the package is compatible
        this.addDependency('python@^3.6');
        this.packageTask = project.addTask('package', {
            description: 'Creates source archive and wheel for distribution.',
            category: tasks_1.TaskCategory.RELEASE,
            exec: 'poetry build',
        });
        this.publishTestTask = project.addTask('publish:test', {
            description: 'Uploads the package against a test PyPI endpoint.',
            category: tasks_1.TaskCategory.RELEASE,
            exec: 'poetry publish -r testpypi',
        });
        this.publishTask = project.addTask('publish', {
            description: 'Uploads the package to PyPI.',
            category: tasks_1.TaskCategory.RELEASE,
            exec: 'poetry publish',
        });
        new PoetryPyproject(project, {
            name: project.name,
            version: options.version,
            description: (_c = options.description) !== null && _c !== void 0 ? _c : '',
            license: options.license,
            authors: [`${options.authorName} <${options.authorEmail}>`],
            homepage: options.homepage,
            classifiers: options.classifiers,
            ...options.poetryOptions,
            dependencies: () => this.synthDependencies(),
            devDependencies: () => this.synthDevDependencies(),
        });
        new toml_1.TomlFile(project, 'poetry.toml', {
            committed: false,
            obj: {
                repositories: {
                    testpypi: {
                        url: 'https://test.pypi.org/legacy/',
                    },
                },
            },
        });
    }
    synthDependencies() {
        const dependencies = {};
        for (const pkg of this.project.deps.all) {
            if (pkg.type === deps_1.DependencyType.RUNTIME) {
                dependencies[pkg.name] = pkg.version;
            }
        }
        return dependencies;
    }
    synthDevDependencies() {
        const dependencies = {};
        for (const pkg of this.project.deps.all) {
            if ([deps_1.DependencyType.DEVENV].includes(pkg.type)) {
                dependencies[pkg.name] = pkg.version;
            }
        }
        return dependencies;
    }
    /**
     * (experimental) Adds a runtime dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDependency(spec) {
        this.project.deps.addDependency(spec, deps_1.DependencyType.RUNTIME);
    }
    /**
     * (experimental) Adds a dev dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDevDependency(spec) {
        this.project.deps.addDependency(spec, deps_1.DependencyType.DEVENV);
    }
    /**
     * (experimental) Initializes the virtual environment if it doesn't exist (called during post-synthesis).
     *
     * @experimental
     */
    setupEnvironment() {
        const result = util_1.execOrUndefined('which poetry', { cwd: this.project.outdir });
        if (!result) {
            this.project.logger.info('Unable to setup an environment since poetry is not installed. Please install poetry (https://python-poetry.org/docs/) or use a different component for managing environments such as \'venv\'.');
        }
        let envPath = util_1.execOrUndefined('poetry env info -p', { cwd: this.project.outdir });
        if (!envPath) {
            this.project.logger.info('Setting up a virtual environment...');
            util_1.exec('poetry env use python', { cwd: this.project.outdir });
            envPath = util_1.execOrUndefined('poetry env info -p', { cwd: this.project.outdir });
            this.project.logger.info(`Environment successfully created (located in ${envPath}}).`);
        }
    }
    /**
     * (experimental) Installs dependencies (called during post-synthesis).
     *
     * @experimental
     */
    installDependencies() {
        this.project.logger.info('Installing dependencies...');
        util_1.exec(this.installTask.toShellCommand(), { cwd: this.project.outdir });
    }
}
exports.Poetry = Poetry;
_a = JSII_RTTI_SYMBOL_1;
Poetry[_a] = { fqn: "projen.python.Poetry", version: "0.17.33" };
/**
 * (experimental) Represents configuration of a pyproject.toml file for a Poetry project.
 *
 * @see https://python-poetry.org/docs/pyproject/
 * @experimental
 */
class PoetryPyproject extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        super(project);
        this.file = new toml_1.TomlFile(project, 'pyproject.toml', {
            omitEmpty: false,
            obj: {
                'build-system': {
                    'requires': ['poetry_core>=1.0.0'],
                    'build-backend': 'poetry.core.masonry.api',
                },
                'tool': {
                    poetry: {
                        'name': options.name,
                        'version': options.version,
                        'description': options.description,
                        'license': options.license,
                        'authors': options.authors,
                        'maintainers': options.maintainers,
                        'readme': options.readme,
                        'homepage': options.homepage,
                        'repository': options.repository,
                        'documentation': options.documentation,
                        'keywords': options.keywords,
                        'classifiers': options.classifiers,
                        'packages': options.packages,
                        'include': options.include,
                        'exclude': options.exclude,
                        'dependencies': options.dependencies,
                        'dev-dependencies': options.devDependencies,
                        'scripts': options.scripts,
                    },
                },
            },
        });
    }
}
exports.PoetryPyproject = PoetryPyproject;
_b = JSII_RTTI_SYMBOL_1;
PoetryPyproject[_b] = { fqn: "projen.python.PoetryPyproject", version: "0.17.33" };
//# sourceMappingURL=data:application/json;base64,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