"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = require("../../logger");
const python_1 = require("../../python");
const util_1 = require("../util");
test('poetry enabled', () => {
    const p = new TestPythonProject({
        venv: false,
        pip: false,
        setuptools: false,
        poetry: true,
        homepage: 'http://www.example.com',
        description: 'a short project description',
        license: 'Apache-2.0',
        classifiers: [
            'Development Status :: 4 - Beta',
        ],
    });
    const snapshot = util_1.synthSnapshot(p);
    expect(snapshot['pyproject.toml']).toContain('First Last');
    expect(snapshot['pyproject.toml']).toContain('email@example.com');
    expect(snapshot['pyproject.toml']).toContain('http://www.example.com');
    expect(snapshot['pyproject.toml']).toContain('a short project description');
    expect(snapshot['pyproject.toml']).toContain('Apache-2.0');
    expect(snapshot['pyproject.toml']).toContain('Development Status :: 4 - Beta');
});
class TestPythonProject extends python_1.PythonProject {
    constructor(options = {}) {
        super({
            ...options,
            clobber: false,
            name: 'test-python-project',
            moduleName: 'test_python_project',
            authorName: 'First Last',
            authorEmail: 'email@example.com',
            version: '0.1.0',
            outdir: util_1.mkdtemp(),
            logging: { level: logger_1.LogLevel.OFF },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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