"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeProject = exports.AutoRelease = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const auto_merge_1 = require("./github/auto-merge");
const ignore_file_1 = require("./ignore-file");
const jest_1 = require("./jest");
const license_1 = require("./license");
const node_package_1 = require("./node-package");
const project_1 = require("./project");
const projen_upgrade_1 = require("./projen-upgrade");
const publisher_1 = require("./publisher");
const tasks_1 = require("./tasks");
const version_1 = require("./version");
const PROJEN_SCRIPT = 'projen';
/**
 * (experimental) Automatic bump modes.
 *
 * @experimental
 */
var AutoRelease;
(function (AutoRelease) {
    AutoRelease[AutoRelease["EVERY_COMMIT"] = 0] = "EVERY_COMMIT";
    AutoRelease[AutoRelease["DAILY"] = 1] = "DAILY";
})(AutoRelease = exports.AutoRelease || (exports.AutoRelease = {}));
/**
 * (experimental) Node.js project.
 *
 * @experimental
 */
class NodeProject extends project_1.Project {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7;
        super(options);
        this.package = new node_package_1.NodePackage(this, options);
        this.runScriptCommand = (() => {
            switch (this.packageManager) {
                case node_package_1.NodePackageManager.NPM: return 'npm run';
                case node_package_1.NodePackageManager.YARN: return 'yarn run';
                case node_package_1.NodePackageManager.PNPM: return 'pnpm run';
                default: throw new Error(`unexpected package manager ${this.packageManager}`);
            }
        })();
        this.nodeVersion = (_b = options.workflowNodeVersion) !== null && _b !== void 0 ? _b : this.package.minNodeVersion;
        // add PATH for all tasks which includes the project's npm .bin list
        this.tasks.addEnvironment('PATH', '$(npx -c "node -e \\\"console.log(process.env.PATH)\\\"")');
        this.compileTask = this.addTask('compile', {
            description: 'Only compile',
            category: tasks_1.TaskCategory.BUILD,
        });
        this.testCompileTask = this.addTask('test:compile', {
            description: 'compiles the test code',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask = this.addTask('test', {
            description: 'Run tests',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask.spawn(this.testCompileTask);
        this.buildTask = this.addTask('build', {
            description: 'Full release build (test+compile)',
            category: tasks_1.TaskCategory.BUILD,
        });
        // first, execute projen as the first thing during build
        if ((_c = options.projenDuringBuild) !== null && _c !== void 0 ? _c : true) {
            // skip for sub-projects (i.e. "parent" is defined) since synthing the
            // root project will include the subprojects.
            if (!this.parent) {
                this.buildTask.exec(this.projenCommand);
            }
        }
        this.addLicense(options);
        this.npmDistTag = this.package.npmDistTag;
        this.npmRegistry = this.package.npmRegistry;
        if ((_d = options.npmignoreEnabled) !== null && _d !== void 0 ? _d : true) {
            this.npmignore = new ignore_file_1.IgnoreFile(this, '.npmignore');
        }
        this.addDefaultGitIgnore();
        if ((_e = options.gitignore) === null || _e === void 0 ? void 0 : _e.length) {
            for (const i of options.gitignore) {
                this.gitignore.exclude(i);
            }
        }
        if ((_f = options.npmignore) === null || _f === void 0 ? void 0 : _f.length) {
            if (!this.npmignore) {
                throw new Error('.npmignore is not defined for an APP project type. Add "npmIgnore: true" to override this');
            }
            for (const i of options.npmignore) {
                this.npmignore.exclude(i);
            }
        }
        this.setScript(PROJEN_SCRIPT, this.package.projenCommand);
        this.setScript('start', `${this.package.projenCommand} start`);
        (_g = this.npmignore) === null || _g === void 0 ? void 0 : _g.exclude(`/${common_1.PROJEN_RC}`);
        (_h = this.npmignore) === null || _h === void 0 ? void 0 : _h.exclude(`/${common_1.PROJEN_DIR}`);
        this.gitignore.include(`/${common_1.PROJEN_RC}`);
        const projen = (_j = options.projenDevDependency) !== null && _j !== void 0 ? _j : true;
        if (projen) {
            const projenVersion = (_k = options.projenVersion) !== null && _k !== void 0 ? _k : `^${common_1.PROJEN_VERSION}`;
            this.addDevDeps(`projen@${projenVersion}`);
        }
        if (!options.defaultReleaseBranch) {
            throw new Error('"defaultReleaseBranch" is temporarily a required option while we migrate its default value from "master" to "main"');
        }
        const defaultReleaseBranch = (_l = options.defaultReleaseBranch) !== null && _l !== void 0 ? _l : 'main';
        // version is read from a committed file called version.json which is how we bump
        this._version = new version_1.Version(this, { releaseBranch: defaultReleaseBranch });
        this.package.addVersion(this._version.currentVersion);
        const buildEnabled = (_m = options.buildWorkflow) !== null && _m !== void 0 ? _m : (this.parent ? false : true);
        const mutableBuilds = (_o = options.mutableBuild) !== null && _o !== void 0 ? _o : true;
        // indicate if we have anti-tamper configured in our workflows. used by e.g. Jest
        // to decide if we can always run with --updateSnapshot
        this.antitamper = buildEnabled && ((_p = options.antitamper) !== null && _p !== void 0 ? _p : true);
        // configure jest if enabled
        // must be before the build/release workflows
        if ((_q = options.jest) !== null && _q !== void 0 ? _q : true) {
            this.jest = new jest_1.Jest(this, options.jestOptions);
        }
        if ((_r = options.buildWorkflow) !== null && _r !== void 0 ? _r : (this.parent ? false : true)) {
            const branch = '${{ github.event.pull_request.head.ref }}';
            const repo = '${{ github.event.pull_request.head.repo.full_name }}';
            const { workflow, buildJobId } = this.createBuildWorkflow('Build', {
                trigger: {
                    pull_request: {},
                },
                checkoutWith: mutableBuilds ? {
                    ref: branch,
                    repository: repo,
                } : undefined,
                postSteps: [
                    {
                        name: 'Commit and push changes (if any)',
                        run: `git diff --exit-code || (git commit -am "chore: self mutation" && git push origin HEAD:${branch})`,
                    },
                ],
                antitamperDisabled: mutableBuilds,
                image: options.workflowContainerImage,
                codeCov: (_s = options.codeCov) !== null && _s !== void 0 ? _s : false,
                codeCovTokenSecret: options.codeCovTokenSecret,
            });
            this.buildWorkflow = workflow;
            this.buildWorkflowJobId = buildJobId;
        }
        if ((_t = options.releaseWorkflow) !== null && _t !== void 0 ? _t : (this.parent ? false : true)) {
            const releaseBranches = (_u = options.releaseBranches) !== null && _u !== void 0 ? _u : [defaultReleaseBranch];
            const trigger = {};
            if ((_v = options.releaseEveryCommit) !== null && _v !== void 0 ? _v : true) {
                trigger.push = { branches: releaseBranches };
            }
            if (options.releaseSchedule) {
                trigger.schedule = { cron: options.releaseSchedule };
            }
            const artifactDirectory = (_w = options.artifactsDirectory) !== null && _w !== void 0 ? _w : 'dist';
            const { workflow, buildJobId } = this.createBuildWorkflow('Release', {
                trigger,
                preBuildSteps: [{
                        name: 'Bump to next version',
                        run: this.runTaskCommand(this._version.bumpTask),
                    }],
                postSteps: [
                    {
                        name: 'Push commits',
                        run: 'git push origin HEAD:${{ github.ref }}',
                    },
                    {
                        name: 'Push tags',
                        run: 'git push --follow-tags origin ${{ github.ref }}',
                    },
                ],
                artifactDirectory,
                image: options.workflowContainerImage,
                codeCov: (_x = options.codeCov) !== null && _x !== void 0 ? _x : false,
                codeCovTokenSecret: options.codeCovTokenSecret,
                checkoutWith: {
                    // we must use 'fetch-depth=0' in order to fetch all tags
                    // otherwise tags are not checked out
                    'fetch-depth': 0,
                },
            });
            this.releaseWorkflow = workflow;
            this.publisher = new publisher_1.Publisher(this, {
                workflow: this.releaseWorkflow,
                artifactName: artifactDirectory,
                buildJobId,
                jsiiReleaseVersion: options.jsiiReleaseVersion,
            });
            if ((_y = options.releaseToNpm) !== null && _y !== void 0 ? _y : false) {
                this.publisher.publishToNpm({
                    distTag: this.package.npmDistTag,
                    registry: this.package.npmRegistry,
                });
            }
        }
        else {
            // validate that no release options are selected if the release workflow is disabled.
            if (options.releaseToNpm) {
                throw new Error('"releaseToNpm" is not supported for APP projects');
            }
            if (options.releaseBranches) {
                throw new Error('"releaseBranches" is not supported for APP projects');
            }
            if (options.releaseEveryCommit) {
                throw new Error('"releaseEveryCommit" is not supported for APP projects');
            }
            if (options.releaseSchedule) {
                throw new Error('"releaseSchedule" is not supported for APP projects');
            }
        }
        if ((_z = options.mergify) !== null && _z !== void 0 ? _z : true) {
            this.autoMerge = new auto_merge_1.AutoMerge(this, {
                autoMergeLabel: options.mergifyAutoMergeLabel,
                buildJob: this.buildWorkflowJobId,
            });
            (_0 = this.npmignore) === null || _0 === void 0 ? void 0 : _0.exclude('/.mergify.yml');
        }
        if ((_1 = options.dependabot) !== null && _1 !== void 0 ? _1 : true) {
            (_2 = this.github) === null || _2 === void 0 ? void 0 : _2.addDependabot(options.dependabotOptions);
        }
        const projenAutoMerge = (_3 = options.projenUpgradeAutoMerge) !== null && _3 !== void 0 ? _3 : true;
        new projen_upgrade_1.ProjenUpgrade(this, {
            autoUpgradeSecret: options.projenUpgradeSecret,
            autoUpgradeSchedule: options.projenUpgradeSchedule,
            labels: (projenAutoMerge && ((_4 = this.autoMerge) === null || _4 === void 0 ? void 0 : _4.autoMergeLabel))
                ? [this.autoMerge.autoMergeLabel]
                : [],
        });
        if ((_5 = options.pullRequestTemplate) !== null && _5 !== void 0 ? _5 : true) {
            (_6 = this.github) === null || _6 === void 0 ? void 0 : _6.addPullRequestTemplate(...(_7 = options.pullRequestTemplateContents) !== null && _7 !== void 0 ? _7 : []);
        }
    }
    /**
     * @deprecated use `package.allowLibraryDependencies`
     */
    get allowLibraryDependencies() { return this.package.allowLibraryDependencies; }
    /**
     * @deprecated use `package.entrypoint`
     */
    get entrypoint() { return this.package.entrypoint; }
    /**
     * (experimental) Minimum node.js version required by this package.
     *
     * @experimental
     */
    get minNodeVersion() { return this.package.minNodeVersion; }
    /**
     * (experimental) Maximum node version required by this pacakge.
     *
     * @experimental
     */
    get maxNodeVersion() { return this.package.maxNodeVersion; }
    /**
     * (deprecated) The package manager to use.
     *
     * @deprecated use `package.packageManager`
     */
    get packageManager() { return this.package.packageManager; }
    /**
     * (deprecated) Determines how tasks are executed when invoked as npm scripts (yarn/npm run xyz).
     *
     * @deprecated use `package.npmTaskExecution`
     */
    get npmTaskExecution() { return this.package.npmTaskExecution; }
    /**
     * (experimental) The command to use in order to run the projen CLI.
     *
     * @experimental
     */
    get projenCommand() { return this.package.projenCommand; }
    /**
     * @deprecated use `package.addField(x, y)`
     */
    get manifest() {
        return this.package.manifest;
    }
    /**
     * @experimental
     */
    addBins(bins) {
        this.package.addBin(bins);
    }
    /**
     * (experimental) Replaces the contents of an npm package.json script.
     *
     * @param name The script name.
     * @param command The command to execute.
     * @experimental
     */
    setScript(name, command) {
        this.package.setScript(name, command);
    }
    /**
     * (experimental) Removes the npm script (always successful).
     *
     * @param name The name of the script.
     * @experimental
     */
    removeScript(name) {
        this.package.removeScript(name);
    }
    /**
     * (experimental) Indicates if a script by the name name is defined.
     *
     * @param name The name of the script.
     * @experimental
     */
    hasScript(name) {
        return this.package.hasScript(name);
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.compileTask.exec()`
     */
    addCompileCommand(...commands) {
        for (const c of commands) {
            this.compileTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.testTask.exec()`
     */
    addTestCommand(...commands) {
        for (const c of commands) {
            this.testTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.buildTask.exec()`
     */
    addBuildCommand(...commands) {
        for (const c of commands) {
            this.buildTask.exec(c);
        }
    }
    /**
     * (experimental) Directly set fields in `package.json`.
     *
     * @param fields The fields to set.
     * @experimental
     */
    addFields(fields) {
        for (const [name, value] of Object.entries(fields)) {
            this.package.addField(name, value);
        }
    }
    /**
     * (experimental) Adds keywords to package.json (deduplicated).
     *
     * @param keywords The keywords to add.
     * @experimental
     */
    addKeywords(...keywords) {
        this.package.addKeywords(...keywords);
    }
    /**
     * @experimental
     */
    get installWorkflowSteps() {
        const install = new Array();
        if (this.nodeVersion) {
            install.push({
                name: 'Setup Node.js',
                uses: 'actions/setup-node@v1',
                with: { 'node-version': this.nodeVersion },
            });
        }
        install.push({
            name: 'Install dependencies',
            run: this.package.installCommand,
        });
        return install;
    }
    /**
     * (experimental) Defines normal dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDeps(...deps) {
        return this.package.addDeps(...deps);
    }
    /**
     * (experimental) Defines development/test dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDevDeps(...deps) {
        return this.package.addDevDeps(...deps);
    }
    /**
     * (experimental) Defines peer dependencies.
     *
     * When adding peer dependencies, a devDependency will also be added on the
     * pinned version of the declared peer. This will ensure that you are testing
     * your code against the minimum version required from your consumers.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addPeerDeps(...deps) {
        return this.package.addPeerDeps(...deps);
    }
    /**
     * (experimental) Defines bundled dependencies.
     *
     * Bundled dependencies will be added as normal dependencies as well as to the
     * `bundledDependencies` section of your `package.json`.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addBundledDeps(...deps) {
        return this.package.addBundledDeps(...deps);
    }
    addLicense(options) {
        var _b;
        if (this.package.license) {
            new license_1.License(this, this.package.license, {
                copyrightOwner: (_b = options.copyrightOwner) !== null && _b !== void 0 ? _b : options.authorName,
                copyrightPeriod: options.copyrightPeriod,
            });
        }
    }
    addDefaultGitIgnore() {
        this.gitignore.exclude('# Logs', 'logs', '*.log', 'npm-debug.log*', 'yarn-debug.log*', 'yarn-error.log*', 'lerna-debug.log*', '# Diagnostic reports (https://nodejs.org/api/report.html)', 'report.[0-9]*.[0-9]*.[0-9]*.[0-9]*.json', '# Runtime data', 'pids', '*.pid', '*.seed', '*.pid.lock', '# Directory for instrumented libs generated by jscoverage/JSCover', 'lib-cov', '# Coverage directory used by tools like istanbul', 'coverage', '*.lcov', '# nyc test coverage', '.nyc_output', '# Compiled binary addons (https://nodejs.org/api/addons.html)', 'build/Release', '# Dependency directories', 'node_modules/', 'jspm_packages/', '# TypeScript cache', '*.tsbuildinfo', '# Optional eslint cache', '.eslintcache', '# Output of \'npm pack\'', '*.tgz', '# Yarn Integrity file', '.yarn-integrity', '# parcel-bundler cache (https://parceljs.org/)', '.cache');
    }
    createBuildWorkflow(name, options) {
        var _b, _c, _d, _e;
        const buildJobId = 'build';
        const github = this.github;
        if (!github) {
            throw new Error('no github support');
        }
        const workflow = github.addWorkflow(name);
        if (options.trigger) {
            if (options.trigger.issue_comment) {
                throw new Error('"issue_comment" should not be used as a trigger due to a security issue');
            }
            workflow.on(options.trigger);
        }
        workflow.on({
            workflow_dispatch: {},
        });
        const condition = options.condition ? { if: options.condition } : {};
        const preBuildSteps = (_b = options.preBuildSteps) !== null && _b !== void 0 ? _b : [];
        const preCheckoutSteps = (_c = options.preCheckoutSteps) !== null && _c !== void 0 ? _c : [];
        const checkoutWith = options.checkoutWith ? { with: options.checkoutWith } : {};
        const postSteps = (_d = options.postSteps) !== null && _d !== void 0 ? _d : [];
        const antitamperSteps = (options.antitamperDisabled || !this.antitamper) ? [] : [{
                name: 'Anti-tamper check',
                run: 'git diff --exit-code',
            }];
        const job = {
            'runs-on': 'ubuntu-latest',
            'env': {
                CI: 'true',
            },
            ...condition,
            'steps': [
                ...preCheckoutSteps,
                // check out sources.
                {
                    name: 'Checkout',
                    uses: 'actions/checkout@v2',
                    ...checkoutWith,
                },
                // install dependencies
                ...this.installWorkflowSteps,
                // perform an anti-tamper check immediately after we run projen.
                ...antitamperSteps,
                // sets git identity so we can push later
                {
                    name: 'Set git identity',
                    run: [
                        'git config user.name "Auto-bump"',
                        'git config user.email "github-actions@github.com"',
                    ].join('\n'),
                },
                // if there are changes, creates a bump commit
                ...preBuildSteps,
                // build (compile + test)
                {
                    name: 'Build',
                    run: this.runTaskCommand(this.buildTask),
                },
                // run codecov if enabled or a secret token name is passed in
                // AND jest must be configured
                ...(options.codeCov || options.codeCovTokenSecret) && ((_e = this.jest) === null || _e === void 0 ? void 0 : _e.config) ? [{
                        name: 'Upload coverage to Codecov',
                        uses: 'codecov/codecov-action@v1',
                        with: options.codeCovTokenSecret ? {
                            token: `\${{ secrets.${options.codeCovTokenSecret} }}`,
                            directory: this.jest.config.coverageDirectory,
                        } : {
                            directory: this.jest.config.coverageDirectory,
                        },
                    }] : [],
                // anti-tamper check (fails if there were changes to committed files)
                // this will identify any non-committed files generated during build (e.g. test snapshots)
                ...antitamperSteps,
                ...postSteps,
            ],
        };
        if (options.image) {
            job.container = { image: options.image };
        }
        if (options.artifactDirectory) {
            job.steps.push({
                name: 'Upload artifact',
                uses: 'actions/upload-artifact@v2.1.1',
                with: {
                    name: options.artifactDirectory,
                    path: options.artifactDirectory,
                },
            });
        }
        workflow.addJobs({ [buildJobId]: job });
        return { workflow, buildJobId };
    }
    /**
     * (experimental) Returns the shell command to execute in order to run a task.
     *
     * If
     * npmTaskExecution is set to PROJEN, the command will be `npx projen TASK`.
     * If it is set to SHELL, the command will be `yarn run TASK` (or `npm run
     * TASK`).
     *
     * @param task The task for which the command is required.
     * @experimental
     */
    runTaskCommand(task) {
        switch (this.package.npmTaskExecution) {
            case node_package_1.NpmTaskExecution.PROJEN: return `${this.package.projenCommand} ${task.name}`;
            case node_package_1.NpmTaskExecution.SHELL: return `${this.runScriptCommand} ${task.name}`;
            default:
                throw new Error(`invalid npmTaskExecution mode: ${this.package.npmTaskExecution}`);
        }
    }
}
exports.NodeProject = NodeProject;
_a = JSII_RTTI_SYMBOL_1;
NodeProject[_a] = { fqn: "projen.NodeProject", version: "0.17.27" };
//# sourceMappingURL=data:application/json;base64,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