"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dependabot = exports.VersioningStrategy = exports.DependabotScheduleInterval = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const yargs_1 = require("yargs");
const component_1 = require("../component");
const yaml_1 = require("../yaml");
/**
 * (experimental) How often to check for new versions and raise pull requests for version updates.
 *
 * @experimental
 */
var DependabotScheduleInterval;
(function (DependabotScheduleInterval) {
    DependabotScheduleInterval["DAILY"] = "daily";
    DependabotScheduleInterval["WEEKLY"] = "weekly";
    DependabotScheduleInterval["MONTHLY"] = "monthly";
})(DependabotScheduleInterval = exports.DependabotScheduleInterval || (exports.DependabotScheduleInterval = {}));
/**
 * (experimental) The strategy to use when edits manifest and lock files.
 *
 * @experimental
 */
var VersioningStrategy;
(function (VersioningStrategy) {
    VersioningStrategy["LOCKFILE_ONLY"] = "lockfile-only";
    VersioningStrategy["AUTO"] = "auto";
    VersioningStrategy["WIDEN"] = "widen";
    VersioningStrategy["INCREASE"] = "increase";
    VersioningStrategy["INCREASE_IF_NECESSARY"] = "increase-if-necessary";
})(VersioningStrategy = exports.VersioningStrategy || (exports.VersioningStrategy = {}));
/**
 * (experimental) Defines dependabot configuration for node projects.
 *
 * Since module versions are managed in projen, the versioning strategy will be
 * configured to "lockfile-only" which means that only updates that can be done
 * on the lockfile itself will be proposed.
 *
 * @experimental
 */
class Dependabot extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, options = {}) {
        var _b, _c, _d, _e, _f;
        super(github.project);
        const project = github.project;
        this.ignore = [];
        this.config = {
            version: 2,
            updates: [
                {
                    'package-ecosystem': 'npm',
                    'versioning-strategy': 'lockfile-only',
                    'directory': '/',
                    'schedule': {
                        interval: (_b = options.scheduleInterval) !== null && _b !== void 0 ? _b : DependabotScheduleInterval.DAILY,
                    },
                    'ignore': () => this.ignore.length > 0 ? this.ignore : undefined,
                },
            ],
        };
        new yaml_1.YamlFile(project, '.github/dependabot.yml', {
            obj: this.config,
            committed: true,
            marker: true,
        });
        if ((_c = options.autoMerge) !== null && _c !== void 0 ? _c : true) {
            github.addMergifyRules({
                name: 'Merge pull requests from dependabot if CI passes',
                conditions: [
                    'author=dependabot[bot]',
                    'status-success=build',
                ],
                actions: {
                    merge: {
                        method: 'squash',
                        commit_message: 'title+body',
                        strict: 'smart',
                        strict_method: 'merge',
                    },
                },
            });
        }
        for (const i of (_d = options.ignore) !== null && _d !== void 0 ? _d : []) {
            this.addIgnore(i.dependencyName, ...((_e = i.versions) !== null && _e !== void 0 ? _e : []));
        }
        if ((_f = options.ignoreProjen) !== null && _f !== void 0 ? _f : true) {
            this.addIgnore('projen');
        }
    }
    /**
     * (experimental) Ignores a dependency from automatic updates.
     *
     * @param dependencyName Use to ignore updates for dependencies with matching names, optionally using `*` to match zero or more characters.
     * @param versions Use to ignore specific versions or ranges of versions.
     * @experimental
     */
    addIgnore(dependencyName, ...versions) {
        this.ignore.push({
            'dependency-name': dependencyName,
            'versions': () => versions.length > 0 ? yargs_1.version : undefined,
        });
    }
}
exports.Dependabot = Dependabot;
_a = JSII_RTTI_SYMBOL_1;
Dependabot[_a] = { fqn: "projen.github.Dependabot", version: "0.17.27" };
//# sourceMappingURL=data:application/json;base64,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