import rsa
from Crypto.Cipher import AES,DES,PKCS1_v1_5
from Crypto.PublicKey import RSA
from Crypto.Util.Padding import unpad,pad  #补位
#b2a_hex 字符串->十六进制  a2b_hex 十六进制->字符串
from binascii import b2a_hex, a2b_hex #
from PIL import Image
from uuid import uuid1
from serial import Serial
from .sx import *

#需要第三方包的模块
def add_block(content:bytes, block_size:int=16, style:bytes=b'\x00')->bytes:
    # b=len(content)%block_size
    # if b != 0:
    #     content += style * (block_size - b)
    # return content
    return content + style * (block_size - (len(content) % block_size))
class OPTIONS_HEADERS():
    def __init__(self,url=False,uri=False,ts=False):
        self.url = url  # 下载m3u8 是否要加url
        self.ts = ts  # 下载ts 是否要加url
        self.uri = uri  # 下载uri 是否要加url
class AES_128_CBC():
    def __init__(self, key:bytes or list,iv:bytes or list,block:int=16,pad_str='\0'):
        '''
        :param key: 长度16位的bytes
        :param iv: 长度16位的bytes
        自定义补 \0
        '''
        if type(key)==bytes:
            self.key=key
        elif type(key)==list:
            self.key=bytes(key)
        else:
            raise Exception('key 类型错误')
        if type(iv)==bytes:
            self.iv=iv
        elif type(iv)==list:
            self.iv=bytes(iv)
        else:
            raise Exception('iv 类型错误')
        self.mode = AES.MODE_CBC
        self.block=block
        self.pad_str=pad_str
    # 这里密钥key 长度必须为16（AES-128）、24（AES-192）、或32（AES-256）Bytes 长度.目前AES-128足够用
    # 如果text不足16位的倍数就用空格补足为16位
    def add_to_16(self,text):
        if len(text.encode('utf-8')) % self.block:
            add = self.block - (len(text.encode('utf-8')) % self.block)
        else:
            add = 0
        text = text + (self.pad_str * add)
        return text.encode('utf-8')
        # 加密函数
    def encrypt(self,text:str)->str:
        cryptos = AES.new(self.key, self.mode, self.iv)
        cipher_text = cryptos.encrypt(self.add_to_16(text))
        # 因为AES加密后的字符串不一定是ascii字符集的，输出保存可能存在问题，所以这里转为16进制字符串
        return b2a_hex(cipher_text).decode()    #b2a_hex 字符串转成16进制
    # 解密后，去掉补足的空格用strip() 去掉
    def decrypt(self,text:str)->str:
        cryptos = AES.new(self.key, self.mode, self.iv)
        plain_text = cryptos.decrypt(a2b_hex(text)) #a2b_hex ascii转成bytes
        return bytes.decode(plain_text).rstrip(self.pad_str)
class AES_ECB():
    def __init__(self,key:bytes or list,block=16):
        if type(key)==bytes:
            self.key=key
        elif type(key)==list:
            self.key=bytes(key)
        self.block=block
    def encrypt(self,content :bytes):
        aes=AES.new(self.key,AES.MODE_ECB)
        content = pad(content, self.block)
        return aes.encrypt(content)
    def decrypt(self,content:bytes):
        aes=AES.new(self.key,AES.MODE_ECB)
        content=aes.decrypt(content)
        return unpad(content,self.block)
class DES_ECB():
    def __init__(self,key:bytes,block=16):
        '''block 8 或者  16 都可以 '''
        self.block=block
        self.des=DES.new(key,mode=DES.MODE_ECB)
    def encrypt(self,content)->bytes:
        return self.des.encrypt(pad(content,block_size=self.block))
    def decrypt(self,content)->bytes:
        '''
        验证解码
        网址：https://the-x.cn/zh-cn/cryptography/Des.aspx
        key = 12345678
        明文：001900423330413543304400000000000000000000000000000000eb01
        加密后：bad9271686660e506e701cbb5eb2cd93e8f359d79065012e5f6a7d528e394f395f6a7d528e394f395f6a7d528e394f3942e290f9c6dd2622ddcd676751f31afb

        网址 http://tool.chacuo.net/cryptdes
        选 ECB pkcs7padding 12345678  hex  utf8 解码
        密文：bad9271686660e506e701cbb5eb2cd93e8f359d79065012e5f6a7d528e394f395f6a7d528e394f395f6a7d528e394f3942e290f9c6dd2622ddcd676751f31afb
        解密后：001900423330413543304400000000000000000000000000000000eb01
        '''
        content= self.des.decrypt(content)
        return unpad(content,block_size=self.block)
class AES_CBC():
    def __init__(self,key:bytes or list,iv:bytes or list,block=16,输出16进制=False,输出base64=False,pad_style='pkcs7',pad_str=''):
        '''
        :param key:
        :param iv:
        :param block:
        :param 输出16进制:
        :param pad_style:  pkcs7  x923 iso7816
        :param pad_str:  \0  自定义补 padding
        '''
        if isinstance(key,bytes):
            self.key=key
        elif isinstance(key,list):
            self.key=bytes(key)
        else:
            raise Exception('key 类型错误')
        if isinstance(iv,bytes):
            self.iv=iv
        elif isinstance(iv,list):
            self.iv=bytes(iv)
        else:
            raise Exception('iv 类型错误')
        self.block=block
        self.style=pad_style

        self.pad_str=pad_str
        self.输出16进制=输出16进制
        self.输出base64=输出base64
    def add_to_block(self,text:str):
        if len(text.encode('utf-8')) % self.block:
            add = self.block - (len(text.encode('utf-8')) % self.block)
        else:
            add = 0
        text = text + (self.pad_str * add) #'\0'
        return text.encode('utf-8')
    def encrypt(self,content):
        aes=AES.new(self.key,AES.MODE_CBC,self.iv)
        if self.pad_str:
            content=self.add_to_block(content.decode())
        else:
            content=pad(content,self.block,self.style)
        #----------------------------------------
        res=aes.encrypt(content)
        if self.输出16进制:
            return b2a_hex(res).decode() #然后字符串
        elif self.输出base64:
            return str( base64.encodebytes(res) ,encoding='utf-8').replace('\n','') #返回字符串
        else:
            return res #bytes
    def decrypt(self,content):
        aes=AES.new(self.key,AES.MODE_CBC,self.iv)
        if self.输出16进制:
            content = aes.decrypt(a2b_hex(content))

            if self.pad_str:
                return bytes.decode(content).rstrip(self.pad_str)  # 返回字符串
            else:
                content=unpad(content,self.block,self.style)
                return bytes.decode(content) #返回字符串
        elif self.输出base64:
            content=base64.decodebytes(content.encode('utf-8'))
            content=aes.decrypt(content)

            if self.pad_str:
                return bytes.decode(content,encoding='utf-8').rstrip(self.pad_str)  # 字符串
            else:
                return unpad(content, self.block, self.style).decode('utf-8') #返回字符串
        else:
            content = aes.decrypt(content)

            if self.pad_str:
                return bytes.decode(content).rstrip(self.pad_str)  # 字符串
            else:
                return unpad(content, self.block, self.style) # bytes
class DES_CBC():
    def __init__(self,key:bytes,iv:bytes,block=16):
        '''block 8 或者  16 都可以 '''
        self.block=block
        self.des=DES.new(key,mode=DES.MODE_CBC,iv=iv)
    def encrypt(self,content)->bytes:
        return self.des.encrypt(pad(content,block_size=self.block))
    def decrypt(self,content)->bytes:
        content= self.des.decrypt(content)
        return unpad(content,block_size=self.block)
def rsa_PKCS1_新建(字节长度=1024):
    ''' 字节长度:   最小为1024，且必需是1024的倍数(2048,...) '''
    class rsa1():
        def __init__(self):
            self.私钥=RSA.generate(字节长度)
            self.公钥= self.私钥.publickey()
            self.私钥文本=self.私钥.exportKey().decode()
            self.公钥文本=self.公钥.exportKey().decode()
    return rsa1()
def rsa_PKCS1_公钥文本_加密(公钥文本:bytes,加密对象:bytes)->bytes:
    '''rand 随机字节函数 None  Crypto.Random.get_random_bytes '''
    公钥=RSA.importKey(公钥文本)
    pkcs=PKCS1_v1_5.new(公钥)
    return pkcs.encrypt(加密对象)
def rsa_PKCS1_公钥_加密(公钥:bytes,加密对象:bytes)->bytes:
    '''rand 随机字节函数 None  Crypto.Random.get_random_bytes '''
    pkcs=PKCS1_v1_5.new(公钥)
    return pkcs.encrypt(加密对象)
def rsa_PKCS1_私钥文本_解密(私钥文本:bytes,解密对象:bytes)->bytes:
    私钥=RSA.importKey(私钥文本)
    pkcs=PKCS1_v1_5.new(私钥)
    return pkcs.decrypt(解密对象,sentinel=None)
def rsa_PKCS1_私钥_解密(私钥:bytes,解密对象:bytes)->bytes:
    pkcs=PKCS1_v1_5.new(私钥)
    return pkcs.decrypt(解密对象,sentinel=None)
def rsa_新建(字节长度=1024):
    ''' 字节长度:   最小为1024，且必需是1024的倍数(2048,...) '''
    class rsa1():
        def __init__(self):
            (self.公钥,self.私钥)=rsa.newkeys(字节长度)
            self.私钥文本=self.私钥.save_pkcs1().decode()
            self.公钥文本=self.公钥.save_pkcs1().decode()
    return rsa1()
def rsa_公钥_加密(公钥:bytes,加密对象:bytes)->bytes:
    return rsa.encrypt(加密对象, 公钥)
def rsa_私钥_解密(私钥:bytes,解密对象:bytes)->bytes:
    return rsa.decrypt(解密对象, 私钥)
class rsa_pkcs1():
    def 创建秘钥(self,文本=0):
        # 生成公钥、私钥
        (pubkey, privkey) = rsa.newkeys(1024)
        if 文本:
            return (pubkey.save_pkcs1(),privkey.save_pkcs1())
        else:
            return (pubkey,privkey)
    def 加密(self,公钥,文本:str):#公钥
        # 明文编码格式
        return rsa.encrypt(文本.encode("utf-8"), 公钥)
    def 解密(self, 私钥,对象:bytes):#私钥
        return rsa.decrypt(对象, 私钥).decode("utf-8")
class DOWN_M3U8():
    def __init__(self, 文件路径='test.mp4', 网址='', m3u8字符串='', 线程数=20,show_text=False, istest=False,显示解码=True,二进制=True,分离器=False,显示错误=True,headers=None,cookies=None,proxies=None,curl=False,try_num=10,cmd_show=1,timeout=30, 类型=1):
        # 链接地址回调 可以调整ts链接
        if 类型==1:
            self.url = 网址
        elif 类型==2:
            #无加密视频网址
            print('[ {} ]'.format(scolor('测试无加密模式')))
            self.url = 'https://hls.videocc.net/source/24560c93d4/d/24560c93d4c855d66ab155af0db215d1_1.m3u8'
        elif 类型==3:
            #加密视频网址
            print('[ {} ]'.format(scolor('测试加密模式')))
            self.url= 'https://cd15-ccd1-2.play.bokecc.com/flvs/0DD1F081022C163E/2021-02-23/0642A98932599FAF9C33DC5901307461-20.m3u8?t=1635076402&key=E45B49E325D8B1C425133DC317308BDE&tpl=10&tpt=112'
            self.url = 'https://1258712167.vod2.myqcloud.com/25121a6avodtransbj1258712167/9d02b67b5285890800144111742/drm/voddrm.token.dWluPTt2b2RfdHlwZT0yO2NpZD0xMDkxMTA7cHNrZXk9O2V4dD0=.v.f30741.m3u8?t=619caf12&exper=0&us=2673142424772967461&sign=5ed90abe3dd10924416a7f996447ea11'
        else:
            print('[ {} ]'.format(scolor('测试 文本+视频链接 模式')))
            self.url='https://hls.videocc.net/source/24560c93d4/d/24560c93d4c855d66ab155af0db215d1_1.m3u8'
            m3u8字符串=get_request(self.url).text

        self.fpath=os.path.abspath(文件路径)
        self.fname=os.path.split(文件路径)[1]
        self.try_num=try_num #失败次数

        self.items=[]  #存所有的ts地址
        self.cookies=cookies
        self.proxies=proxies
        self.curl=curl
        if headers:
            self.headers=headers
        else:
            self.headers={'User-Agent':'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.25 Safari/537.36 Core/1.70.3732.400 QQBrowser/10.5.3819.400'}

        self.加密信息 = {}  # 存加密信息
        self.线程数 = 线程数  # 线程数
        self.m3u8字符串= ''  #m3u8内容

        self.加密行= []
        self.AES对象 = []
        self.打印TS链接 = False
        self.key=None #bytes 或者 列表
        self.iv=None #bytes 或者 列表
        self.m3u8字符串 = m3u8字符串.strip()

        self.state=True  #是否正常获取视频信息
        self.show=show_text  #显示text
        self.测试下载数量=10
        self.二进制=二进制
        self.分离器=分离器
        self.显示解码=显示解码
        self.显示错误=显示错误
        self.timeout = timeout
        self.istest = istest
        self.options_headers=OPTIONS_HEADERS(url=1,uri=1,ts=1)

        self.block_size=None  #content 加block  #未使用
        self.block_style=b'\x00'                #未使用
        #----------------------------------------
        self.TS地址回调函数=None #回调进度条
        self.进度条回调函数=None #回调进度条
        self.URI地址回调函数=None #dd.URI地址回调函数=
        self.链接前缀=''
        #----------------------------------------
        self.__uri_temp_data={'uri':None, 'key':None}
        self.每行不同加密 = None  #Ture  或者  False 或者 None
        self.cmd_show=cmd_show
        self.random_id=随机字符串(类型=1,长度=20)
        self.TEMP_DIR='cache/{}/'.format(self.random_id)
        self.ff = FFMPEG()
    def get_items(self):
        try:
            if self.m3u8字符串:
                lines=self.m3u8字符串
                if self.show:
                    print('[ {} ] [ {} ] : {}'.format(scolor('文本'),scolor('视频链接'), self.url if self.url else '无视频链接'))
            else:
                if self.show:
                    print('[ {} ] : {}'.format(scolor('视频链接'), self.url))
                req_m3u8 = self.get_url(self.url, type_='url',stream=True)
                req_headers = req_m3u8.headers
                if 'content-type' in req_headers:
                    #m3u8 类型
                    if 'mpegurl' in req_headers['content-type'].lower() or 'text' in  req_headers['content-type'].lower():
                        pass
                    #其他类型
                    else:
                        # 返回文件长度
                        return 下载文件_进度条(文件路径=self.fpath, 网址=self.url, 线程数=self.线程数, 多线程=True, 分段长度=10 * 1024)

                lines = b''
                for chunk in req_m3u8.iter_content(chunk_size=5 * 1024):
                    lines += chunk
                lines = lines.decode()  # 获取M3U8的文件内容
                req_m3u8.close()
                self.m3u8字符串 = lines
            # 读取文件里的每一行
            file_line = lines.split("\n")
            # 通过判断文件头来确定是否是M3U8文件
            if '#EXTM3U' not in file_line[0].upper():
                raise Exception('非M3U8的链接')
            else:
                self.链接前缀 = self.url.rsplit("/", 1)[0]
                self.域名前缀 = '/'.join(self.url.split('/')[:3])
                self.flag_域名前缀 = None
                unknow = True  # 用来判断是否找到了下载的地址
                n = 1
                # ----------------------------------------------ts行
                for index, line in enumerate(file_line):
                    if "EXTINF" in line:
                        unknow = False
                        ts_url=file_line[index+1]
                        if self.TS地址回调函数:  # 如果设置了回调
                            # def TS地址回调函数(line):return url
                            ts_url_new = self.TS地址回调函数(ts_url)
                        else:
                            if 'http' not in ts_url and self.url:
                                if ts_url[0] == '/':
                                    ts_url_new = self.链接前缀 + ts_url
                                else:
                                    ts_url_new = self.链接前缀 + "/" + ts_url

                                if self.flag_域名前缀 == None:
                                    try:
                                        req = self.get_url(ts_url_new, type_='ts',stream=True)
                                        code = req.status_code
                                    except:
                                        code = 404

                                    if code == 404:
                                        self.flag_域名前缀 = True
                                    else:
                                        self.flag_域名前缀 = False

                                if self.flag_域名前缀:
                                    if ts_url[0] == '/':
                                        ts_url_new = self.域名前缀 + ts_url
                                    else:
                                        ts_url_new = self.域名前缀 + "/" + ts_url
                            else:
                                ts_url_new = ts_url
                        if self.打印TS链接:
                            print(ts_url_new)
                        self.items.append({'i': n, 'url': ts_url_new})
                        n += 1
                if unknow:
                    raise Exception("没有ts链接")
                # ----------------------------------------------加密行
                for index, key_line in enumerate(file_line):
                    if '#EXT-X-KEY' in key_line and (('URI' in key_line) or ('IV' in key_line)): #存在URI或者IV
                        key_dict = {}
                        for line in key_line.split(','):
                            kv = line.split('=', 1)
                            if len(kv) == 2:
                                key_dict[kv[0].strip()] = kv[1].strip().strip('"').strip("'").strip()
                        self.加密行.append(key_dict)

                if self.加密行:
                    self.加密信息=self.加密行[0]
                else:
                    self.加密信息=None
                加密行数量 = set([f'{x["URI"] if "URI" in x else "None"} {x["IV"] if "IV" in x else "None"}' for x in self.加密行])
                if len(加密行数量)==1:
                    self.每行不同加密 = False
                elif len(加密行数量)>1:
                    self.每行不同加密=True
        except BaseException as e:
            if self.显示错误:
                print('[ {} ]'.format(scolor('get_items: {} {}'.format(跟踪函数(-3),e),'err')))
            self.state=False
    def __aes(self,加密信息):
        try:
            if self.key:  # 自定义key判断类型 转成bytes
                KEY = self.key
                if type(KEY) == list:
                    KEY = bytes(KEY)
                elif type(KEY) == bytes and len(KEY) == 16:
                    pass
                elif type(KEY) == str and len(KEY) == 34:
                    KEY = bytes.fromhex(KEY[2:])
                else:
                    raise Exception('AES KEY 输入错误')
            else:
                if 'URI' not in 加密信息:
                    raise Exception('没有URI链接地址')
                if self.__uri_temp_data['uri'] == 加密信息['URI']:
                    KEY = self.__uri_temp_data['key']
                else:
                    KEY = self.get_url(加密信息['URI'],type_='uri').content  # 不加headers
                    if len(KEY) != 16:
                        raise Exception('AES KEY 长度 {}'.format(len(KEY)))
            if self.iv:  # 自定义iv判断类型 转成bytes
                IV = self.iv
                if type(IV) == list:
                    IV = bytes(IV)
                elif type(IV) == bytes and len(IV) == 16:
                    pass
                elif type(IV) == str and len(IV) == 34:
                    IV = bytes.fromhex(IV[2:])
                else:
                    raise Exception('AES IV 输入错误')
            else:
                if 'IV' in 加密信息 and 加密信息['IV']:
                    IV=加密信息['IV']
                    if len(IV) == 34:  # 16进制转成字节
                        IV = bytes.fromhex(IV[2:])
                    else:
                        IV = IV.encode() #转bytes
                else:
                    if self.显示解码:
                        print('[ {} ]'.format(scolor('默认IV')), end=' ')
                    IV=bytes([0]*16)
            self.__uri_temp_data = {'uri': 加密信息['URI'] if 'URI' in 加密信息 else None, 'key': KEY}
            return AES.new(KEY, AES.MODE_CBC, IV)
        except BaseException as e:
            return f'{跟踪函数(-5)} {str(e)}'
    def __get_aes(self):
        # 如果有加密 则简单的解密
        # 如果复杂的加密 请覆盖 KEY cryptor 还有items
        if self.显示解码:
            if self.每行不同加密==False:
                model='S'
            elif self.每行不同加密==True:
                model='M'
            else:
                model='N'
            print('[ {} ]'.format(scolor(model,'warn')), end=' ')
        if self.state:
            if self.AES对象:
                if isinstance(self.AES对象, list):
                    pass
                else:
                    self.AES对象 = [self.AES对象] #转成列表  自定义
            else:
                if self.加密行:
                    if not self.每行不同加密:
                        self.加密行=[self.加密信息]  #自定义
                    for 加密信息 in self.加密行:
                        if self.URI地址回调函数:
                            加密信息['URI']=self.URI地址回调函数(加密信息['URI'])
                        aes对象 = self.__aes(加密信息)
                        if isinstance(aes对象,str):
                            print('[ {} {} ]'.format(scolor('解码失败:'),aes对象), end=' ')
                            self.state = False  # 修改状态
                            return
                        elif aes对象:
                            self.AES对象.append(aes对象)
                        else:  #None
                            self.state=False #修改状态
                            return
                    if self.显示解码:
                        print('[ {} ]'.format(scolor('解码成功')), end=' ')
    def __download_ts(self,item):
        for i in range(self.try_num):
            try:
                req=self.get_url(item['url'],type_='ts',try_num=1)
                size=req.headers['content-length']
                content=req.content
                if self.AES对象:#如果有加密
                    if self.每行不同加密:
                        content = self.AES对象[item['i']-1].decrypt(content)
                    else:
                        content = self.AES对象[0].decrypt(add_block(content))
                #item['i'] 已有
                item['size']=int(size)
                #写入到缓存目录
                if not os.path.exists(self.TEMP_DIR):
                    os.makedirs(self.TEMP_DIR, exist_ok=1)
                fpath = os.path.join(self.TEMP_DIR, '%010d.ts'%item['i'])
                try:
                    with open(fpath, 'wb') as f:
                        f.write(content)
                    if self.分离器:
                        item['content'] = '%010d.ts' % item['i']
                    else:
                        item['content'] = fpath # 去掉目录前缀
                except BaseException as ef:
                    raise Exception('写入文件错误: {}'.format(ef))

                return item
            except BaseException as e:
                if i==self.try_num-1:
                    打印错误(e)
        return None
    def get_url(self, url,type_='url',try_num=None,stream=False):
        try:
            if getattr(self.options_headers,type_):
                headers=self.headers
            else:
                headers=None
            return get_request(url, cookies=self.cookies, headers=headers,stream=stream, proxies=self.proxies, allow_redirects=True, verify=False,curl=self.curl, try_num=try_num if try_num else self.try_num,timeout=self.timeout)
        except BaseException as e:
            raise Exception('get_url {}: {}'.format(type_, e))
    def run(self):
        try:
            返回=True
            if self.items and self.state:
                self.加密行 = self.加密行[:self.测试下载数量] if self.istest else self.加密行  # 测试行数
                self.__get_aes()
                if self.state:
                    print('[ {} ] : {}'.format(scolor('正在下载', 'warn'), scolor(self.fpath, 'yes')))
                    self.开始时间=time.time()
                    self.已下载大小=0
                    self.进度 = 0  # 统计进度条
                    pool=ThreadPoolExecutor(self.线程数)
                    self.items= self.items[:self.测试下载数量] if self.istest else self.items #测试行数
                    self.count = len(self.items)

                    data={}
                    L=len(self.items)
                    def callback(rt):
                        item = rt.result()
                        if item:
                            data[item['i']] = item['content']
                            self.已下载大小 += item['size']
                            t=time.time()-self.开始时间
                            seconds = t * L / (self.进度 + 1) - t
                            if seconds<1:
                                剩余时间=' '*12
                            else:
                                m, s = divmod(seconds, 60)
                                h, m = divmod(m, 60)
                                剩余时间 =' {:0=2.0f}:{:0=2.0f}:{:0=2.0f}'.format(h,m,s)
                            speed = '{:.2f}MB/S{}'.format(self.已下载大小 / 1024 / 1024 / t,剩余时间)
                            fsize='{:.2f}MB'.format(self.已下载大小 / 1024 / 1024)
                            if self.进度条回调函数:
                                #'{}    {} {}/{} {} {}'.format(rt['name'],rt['bfb'], rt['i'],rt['count'],rt['size'],rt['speed'])
                                self.进度条回调函数({'name':self.fname,'bfb':'{}%'.format(int((self.进度+1)/self.count*100)),'size':fsize, 'i':self.进度+1, 'count':self.count,'speed':speed})
                            else:
                                打印_进度条(fsize, self.进度, self.count, 1, speed, 类型=4)
                            self.进度 += 1
                        else:
                            nonlocal 返回
                            返回=False
                    tasks=[]
                    for item in self.items:
                        tasks.append(pool.submit(self.__download_ts,item).add_done_callback(callback))
                    pool.shutdown(wait=True)
                    if os.path.exists(self.fpath):
                        os.remove(self.fpath)
                    # 只有全部完成才保存
                    if 返回:
                        data = sorted(data.items(), key=lambda d: d[0], reverse=False)
                        if self.分离器:
                            file_txt=os.path.join(self.TEMP_DIR,'filelist.txt')
                            with open(file_txt,'w',encoding='utf-8') as f:
                                for d in data:
                                    f.write("file {}\n".format(d[1]))
                            print()
                            self.ff.ffmpeg_分离器合并(文件路径=self.fpath,文件名=file_txt)
                        else:
                            #二进制合并
                            if self.二进制:
                                with open(self.fpath, 'wb') as f:
                                    for d in data:
                                        with open(d[1], 'rb') as f1:
                                            f.write(f1.read())
                            else:
                                temp_mp4 = f'{self.fpath}.temp'
                                if os.path.exists(temp_mp4): os.remove(temp_mp4)
                                with open(temp_mp4, 'ab') as f:
                                    for d in data:
                                        with open(d[1], 'rb') as f1:
                                            f.write(f1.read())
                                print()
                                # ffmpeg -i "concat:input1.ts|input2.ts|input3.ts" -c copy -bsf:a aac_adtstoasc -movflags +faststart output.mp4
                                cmd=f'"{self.ff.ffmpeg_path}" -i "{temp_mp4}" -y -c copy -bsf:a aac_adtstoasc "{self.fpath}'
                                self.ff.执行(cmd,show=self.cmd_show)
                                if os.path.exists(temp_mp4):os.remove(temp_mp4)
                        #删除缓存目录
                        if os.path.exists(self.TEMP_DIR):
                            with error(ignore=True):
                                import shutil
                                shutil.rmtree(self.TEMP_DIR)
                    del tasks
                    del data
                else:
                    返回=False
            else:
                返回=False
            print()
            return 返回
        except BaseException as e:
            打印错误(e)
            return False
class 剪切板():
    def __init__(self):
        pass
    def 复制文本(self,字符串):
        import win32clipboard
        import win32con
        win32clipboard.OpenClipboard()
        win32clipboard.EmptyClipboard()
        win32clipboard.SetClipboardData(win32con.CF_UNICODETEXT, 字符串)
        win32clipboard.CloseClipboard()
    def 粘贴文本(self):
        import win32clipboard
        import win32con
        win32clipboard.OpenClipboard()
        text = win32clipboard.GetClipboardData(win32con.CF_UNICODETEXT)
        win32clipboard.CloseClipboard()
        return text
    def 复制图片(self,图片路径):
        if os.path.exists(图片路径):
            import win32clipboard
            import win32con
            imagepath = 图片路径
            img = Image.open(imagepath)  # Image.open可以打开网络图片与本地图片。
            output = BytesIO()  # BytesIO实现了在内存中读写bytes
            img.convert("RGB").save(output, "BMP")  # 以RGB模式保存图像
            data = output.getvalue()[14:]
            output.close()
            win32clipboard.OpenClipboard()  # 打开剪贴板
            win32clipboard.EmptyClipboard()  # 先清空剪贴板
            win32clipboard.SetClipboardData(win32con.CF_DIB, data)  # 将图片放入剪贴板
            win32clipboard.CloseClipboard()
def 获取_电脑信息():
    from wmi import WMI
    c=WMI()
    dic = {'cpu': c.Win32_Processor(),
           '硬盘': c.Win32_DiskDrive(),
           '主板': c.Win32_BaseBoard(),
           'bios': c.Win32_BIOS(),
           '电池': c.Win32_Battery(),
           '网卡': c.Win32_NetworkAdapter()
           }
    dic_new = {}
    for k, v in dic.items():
        dic_new[k] = []
        for x in v:
            dic_new[k].append(dict(re.findall('(\w+) = (.*?);', str(x))))
    return dic_new
def 获取_机器码(加密字符串=None,类型=1):
    from wmi import WMI
    c=WMI()
    info={}
    主板=c.Win32_BaseBoard()[0]
    if 类型==1:    #绑定主板
        info['主板型号'] = 主板.Product.strip()
        info['主板UUID'] = 主板.qualifiers['UUID'].strip()
    elif 类型==2:  #绑定主板+网卡
        info['主板型号'] = 主板.Product.strip()
        info['主板UUID'] = 主板.qualifiers['UUID'].strip()
        info['网卡地址']=str(uuid1()).split('-')[-1].strip()
    if 加密字符串:
        info['加密字符串'] = str(加密字符串)
    return md5(str(info).encode("utf-8")).hexdigest()
