![This is an image](https://firebasestorage.googleapis.com/v0/b/datakund-studio.appspot.com/o/selenium%20pro1.png?alt=media&token=45a2f1cd-b577-4bb5-9ff8-8e91ac7c9aec)

# selenium pro - intelligent & powerful cloud native selenium
[![PyPI version](https://badge.fury.io/py/selenium-pro.svg)](https://badge.fury.io/py/selenium-pro)

### Benefits of selenium-pro over selenium
- All the capabilities of Selenium + 
- Auto write scripts using Selenium Script Generator
- No Inspection of HTML Elements required
- Intelligent Element Handling Automatically in case of HTML changes
- Auto Setup Chromedrivers based on Operating System & Browser versions
- Run scripts in Cloud with single function call
- Bypass Automated Browser Detection
- Coming Up - Convert your old selenium scripts to selenium pro so that they never fail due to element errors

### [Selenium Pro Auto Code Generator Chrome Extension](https://chrome.google.com/webstore/detail/selenium-auto-code-genera/ocimgcpcnobcnmclomhhmjidgoiekeaf)
- Install the extension in your browser
- Start Recording your actions like 
  - Open Url
  - Click
  - Type
  - Scrape (right click on element & use scrape option)
  - etc.
- Selenium-Pro code will be generated automatically
- Copy it & run in your python shell

### Installation
```sh
pip install selenium-pro
```

### Import
Just replace `selenium` with `selenium_pro` everywhere in your imports
```sh
from selenium_pro.webdriver.common.keys import Keys
from selenium_pro import webdriver
```

### Start Browser
This method starts automated window on your default browser. It installs all the drivers required
```sh
driver = webdriver.Start()
```

### Example
Below script searches given keyword on google & scrapes result count
```sh
from selenium_pro.webdriver.common.keys import Keys
from selenium_pro import webdriver

driver = webdriver.Start()

driver.get('https://www.google.com/')

# Advanced method to click on search bar
driver.find_element_by_pro('QYQyyPtidm5_xqG').click()

driver.switch_to.active_element.send_keys('shoes\n')

# Advanced method to scrape result count
result_count=driver.find_element_by_pro('z6XMV66vxokYpfn').text
print('result_count ',result_count)

driver.quit()

```

### find_element_by_pro() method
- This is one of the advanced methods added in this library aside from the conventional methods in selenium.
- This method finds element without you having to mention selectors or locators
- Also this ensures that whenever HTML element changes, its able to adapt to changes & work fine without you having to do any code change
- Use this [Selenium Pro Auto Code Generator Chrome Extension](https://chrome.google.com/webstore/detail/selenium-auto-code-genera/ocimgcpcnobcnmclomhhmjidgoiekeaf) to get pro-id for any element on the web

### Find multiple similar elements
Just replace **find_element** with **find_elements**

### find_elements_by_pro() method 
It finds all elements similar to the element which you pointed in the extension  
eg. Below script opens pypi search result link & fetches the titles of resulting packages

```sh
from selenium_pro.webdriver.common.keys import Keys
from selenium_pro import webdriver

driver = webdriver.Start()

driver.get("https://pypi.org/search/?q=firebase")

# Advanced Method to find all search results titles on the page
search_results_titles=driver.find_elements_by_pro("ErZwU_jOEg0s4_9")
for result_title in search_results_titles:
	print(result_title.text)

driver.quit()

```

### Start() method
- This method will check your operating system, default browser & its version & install driver accordingly
- You can still use conventional methods if you want  specific configuration


### All Default Selenium Functions Work Well
```sh
#find elements by conventional methods
driver.find_elements(By.XPATH, '//button')

#close window
driver.close()

#set cookies in browser
driver.add_cookie({})

....
```

#### All your existing selenium scripts will work fine with selenium pro. Just import selenium pro instead

```sh
#from selenium import webdriver
from selenium_pro import webdriver
#from selenium.webdriver.support.ui import WebDriverWait
from selenium_pro.webdriver.support.ui import WebDriverWait

## Old Selenium Code.....
```

### Intermix Advanced & Conventional Methods
You can use both conventional & advanced methods in your scripts
eg. Below code searches keyword on pypi & scrapes few details of package

```sh
from selenium_pro.webdriver.common.keys import Keys
from selenium_pro import webdriver

driver = webdriver.Start()

driver.get("https://pypi.org")

# Conventional method to click on search bar
driver.find_element_by_id('search').click()

driver.switch_to.active_element.send_keys('datakund\n')

# Advanced method to click on 1st item in search results
driver.find_element_by_pro('NEHC72vwdxktcm5').click()

# Conventional method to scrape title
title=driver.find_element_by_class_name('package-header__name').text
print('title ',title)

# Advanced method to scrape release_date
release_date=driver.find_element_by_pro('STT9vQuCT0fdEdq').text
print('release_date ',release_date)

# Advanced method to scrape author
author=driver.find_element_by_pro('gsANAnAvkCt7_aM').text
print('author ',author)

# Conventional method to scrape description
description=driver.find_element_by_class_name('package-description__summary').text
print('description ',description)

driver.quit()
```

### [Selenium Pro Auto Code Generator Chrome Extension](https://chrome.google.com/webstore/detail/selenium-auto-code-genera/ocimgcpcnobcnmclomhhmjidgoiekeaf)

### [Complete Selenium Documentation Available here](https://www.selenium.dev/documentation/)
### [Selenium Python Docs](https://selenium-python.readthedocs.io/)

### Contact Us
* [Telegram](https://t.me/datakund)