/*
 Copyright (C) 2015-2017 Alexander Borisov

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA

 Author: lex.borisov@gmail.com (Alexander Borisov)
*/

#ifndef MyHTML_MyCSS_PROPERTY_CONST_H
#define MyHTML_MyCSS_PROPERTY_CONST_H
#pragma once

#ifdef __cplusplus
extern "C" {
#endif

enum mycss_property_type {
	MyCSS_PROPERTY_TYPE_UNDEF                       = 0x0000,
	MyCSS_PROPERTY_TYPE_ALIGN_CONTENT               = 0x0001,
	MyCSS_PROPERTY_TYPE_ALIGN_ITEMS                 = 0x0002,
	MyCSS_PROPERTY_TYPE_ALIGN_SELF                  = 0x0003,
	MyCSS_PROPERTY_TYPE_ANIMATION                   = 0x0004,
	MyCSS_PROPERTY_TYPE_ANIMATION_DELAY             = 0x0005,
	MyCSS_PROPERTY_TYPE_ANIMATION_DIRECTION         = 0x0006,
	MyCSS_PROPERTY_TYPE_ANIMATION_DURATION          = 0x0007,
	MyCSS_PROPERTY_TYPE_ANIMATION_FILL_MODE         = 0x0008,
	MyCSS_PROPERTY_TYPE_ANIMATION_ITERATION_COUNT   = 0x0009,
	MyCSS_PROPERTY_TYPE_ANIMATION_NAME              = 0x000a,
	MyCSS_PROPERTY_TYPE_ANIMATION_PLAY_STATE        = 0x000b,
	MyCSS_PROPERTY_TYPE_ANIMATION_TIMING_FUNCTION   = 0x000c,
	MyCSS_PROPERTY_TYPE_APPEARANCE                  = 0x000d,
	MyCSS_PROPERTY_TYPE_BACKFACE_VISIBILITY         = 0x000e,
	MyCSS_PROPERTY_TYPE_BACKGROUND                  = 0x000f,
	MyCSS_PROPERTY_TYPE_BACKGROUND_ATTACHMENT       = 0x0010,
	MyCSS_PROPERTY_TYPE_BACKGROUND_CLIP             = 0x0011,
	MyCSS_PROPERTY_TYPE_BACKGROUND_COLOR            = 0x0012,
	MyCSS_PROPERTY_TYPE_BACKGROUND_IMAGE            = 0x0013,
	MyCSS_PROPERTY_TYPE_BACKGROUND_ORIGIN           = 0x0014,
	MyCSS_PROPERTY_TYPE_BACKGROUND_POSITION         = 0x0015,
	MyCSS_PROPERTY_TYPE_BACKGROUND_REPEAT           = 0x0016,
	MyCSS_PROPERTY_TYPE_BACKGROUND_SIZE             = 0x0017,
	MyCSS_PROPERTY_TYPE_BOOKMARK_LABEL              = 0x0018,
	MyCSS_PROPERTY_TYPE_BOOKMARK_LEVEL              = 0x0019,
	MyCSS_PROPERTY_TYPE_BOOKMARK_STATE              = 0x001a,
	MyCSS_PROPERTY_TYPE_BORDER                      = 0x001b,
	MyCSS_PROPERTY_TYPE_BORDER_BLOCK_END            = 0x001c,
	MyCSS_PROPERTY_TYPE_BORDER_BLOCK_END_COLOR      = 0x001d,
	MyCSS_PROPERTY_TYPE_BORDER_BLOCK_END_STYLE      = 0x001e,
	MyCSS_PROPERTY_TYPE_BORDER_BLOCK_END_WIDTH      = 0x001f,
	MyCSS_PROPERTY_TYPE_BORDER_BLOCK_START          = 0x0020,
	MyCSS_PROPERTY_TYPE_BORDER_BLOCK_START_COLOR    = 0x0021,
	MyCSS_PROPERTY_TYPE_BORDER_BLOCK_START_STYLE    = 0x0022,
	MyCSS_PROPERTY_TYPE_BORDER_BLOCK_START_WIDTH    = 0x0023,
	MyCSS_PROPERTY_TYPE_BORDER_BOTTOM               = 0x0024,
	MyCSS_PROPERTY_TYPE_BORDER_BOTTOM_COLOR         = 0x0025,
	MyCSS_PROPERTY_TYPE_BORDER_BOTTOM_LEFT_RADIUS   = 0x0026,
	MyCSS_PROPERTY_TYPE_BORDER_BOTTOM_RIGHT_RADIUS  = 0x0027,
	MyCSS_PROPERTY_TYPE_BORDER_BOTTOM_STYLE         = 0x0028,
	MyCSS_PROPERTY_TYPE_BORDER_BOTTOM_WIDTH         = 0x0029,
	MyCSS_PROPERTY_TYPE_BORDER_COLLAPSE             = 0x002a,
	MyCSS_PROPERTY_TYPE_BORDER_COLOR                = 0x002b,
	MyCSS_PROPERTY_TYPE_BORDER_IMAGE                = 0x002c,
	MyCSS_PROPERTY_TYPE_BORDER_IMAGE_OUTSET         = 0x002d,
	MyCSS_PROPERTY_TYPE_BORDER_IMAGE_REPEAT         = 0x002e,
	MyCSS_PROPERTY_TYPE_BORDER_IMAGE_SLICE          = 0x002f,
	MyCSS_PROPERTY_TYPE_BORDER_IMAGE_WIDTH          = 0x0030,
	MyCSS_PROPERTY_TYPE_BORDER_INLINE_END           = 0x0031,
	MyCSS_PROPERTY_TYPE_BORDER_INLINE_END_COLOR     = 0x0032,
	MyCSS_PROPERTY_TYPE_BORDER_INLINE_END_STYLE     = 0x0033,
	MyCSS_PROPERTY_TYPE_BORDER_INLINE_END_WIDTH     = 0x0034,
	MyCSS_PROPERTY_TYPE_BORDER_INLINE_START         = 0x0035,
	MyCSS_PROPERTY_TYPE_BORDER_INLINE_START_COLOR   = 0x0036,
	MyCSS_PROPERTY_TYPE_BORDER_INLINE_START_STYLE   = 0x0037,
	MyCSS_PROPERTY_TYPE_BORDER_INLINE_START_WIDTH   = 0x0038,
	MyCSS_PROPERTY_TYPE_BORDER_LEFT                 = 0x0039,
	MyCSS_PROPERTY_TYPE_BORDER_LEFT_COLOR           = 0x003a,
	MyCSS_PROPERTY_TYPE_BORDER_LEFT_STYLE           = 0x003b,
	MyCSS_PROPERTY_TYPE_BORDER_LEFT_WIDTH           = 0x003c,
	MyCSS_PROPERTY_TYPE_BORDER_RADIUS               = 0x003d,
	MyCSS_PROPERTY_TYPE_BORDER_RIGHT                = 0x003e,
	MyCSS_PROPERTY_TYPE_BORDER_RIGHT_COLOR          = 0x003f,
	MyCSS_PROPERTY_TYPE_BORDER_RIGHT_STYLE          = 0x0040,
	MyCSS_PROPERTY_TYPE_BORDER_RIGHT_WIDTH          = 0x0041,
	MyCSS_PROPERTY_TYPE_BORDER_SPACING              = 0x0042,
	MyCSS_PROPERTY_TYPE_BORDER_STYLE                = 0x0043,
	MyCSS_PROPERTY_TYPE_BORDER_TOP                  = 0x0044,
	MyCSS_PROPERTY_TYPE_BORDER_TOP_COLOR            = 0x0045,
	MyCSS_PROPERTY_TYPE_BORDER_TOP_LEFT_RADIUS      = 0x0046,
	MyCSS_PROPERTY_TYPE_BORDER_TOP_RIGHT_RADIUS     = 0x0047,
	MyCSS_PROPERTY_TYPE_BORDER_TOP_STYLE            = 0x0048,
	MyCSS_PROPERTY_TYPE_BORDER_TOP_WIDTH            = 0x0049,
	MyCSS_PROPERTY_TYPE_BORDER_WIDTH                = 0x004a,
	MyCSS_PROPERTY_TYPE_BOTTOM                      = 0x004b,
	MyCSS_PROPERTY_TYPE_BOX_DECORATION_BREAK        = 0x004c,
	MyCSS_PROPERTY_TYPE_BOX_SHADOW                  = 0x004d,
	MyCSS_PROPERTY_TYPE_BOX_SIZING                  = 0x004e,
	MyCSS_PROPERTY_TYPE_BOX_SUPPRESS                = 0x004f,
	MyCSS_PROPERTY_TYPE_BREAK_AFTER                 = 0x0050,
	MyCSS_PROPERTY_TYPE_BREAK_BEFORE                = 0x0051,
	MyCSS_PROPERTY_TYPE_BREAK_INSIDE                = 0x0052,
	MyCSS_PROPERTY_TYPE_CAPTION_SIDE                = 0x0053,
	MyCSS_PROPERTY_TYPE_CARET                       = 0x0054,
	MyCSS_PROPERTY_TYPE_CARET_COLOR                 = 0x0055,
	MyCSS_PROPERTY_TYPE_CARET_SHAPE                 = 0x0056,
	MyCSS_PROPERTY_TYPE_CLEAR                       = 0x0057,
	MyCSS_PROPERTY_TYPE_CLEAR_AFTER                 = 0x0058,
	MyCSS_PROPERTY_TYPE_COLOR                       = 0x0059,
	MyCSS_PROPERTY_TYPE_COLOR_ADJUST                = 0x005a,
	MyCSS_PROPERTY_TYPE_COLOR_INTERPOLATION         = 0x005b,
	MyCSS_PROPERTY_TYPE_COLOR_INTERPOLATION_FILTERS = 0x005c,
	MyCSS_PROPERTY_TYPE_COLOR_RENDERING             = 0x005d,
	MyCSS_PROPERTY_TYPE_COLUMN_COUNT                = 0x005e,
	MyCSS_PROPERTY_TYPE_COLUMN_FILL                 = 0x005f,
	MyCSS_PROPERTY_TYPE_COLUMN_GAP                  = 0x0060,
	MyCSS_PROPERTY_TYPE_COLUMN_RULE                 = 0x0061,
	MyCSS_PROPERTY_TYPE_COLUMN_RULE_COLOR           = 0x0062,
	MyCSS_PROPERTY_TYPE_COLUMN_RULE_STYLE           = 0x0063,
	MyCSS_PROPERTY_TYPE_COLUMN_RULE_WIDTH           = 0x0064,
	MyCSS_PROPERTY_TYPE_COLUMN_SPAN                 = 0x0065,
	MyCSS_PROPERTY_TYPE_COLUMN_WIDTH                = 0x0066,
	MyCSS_PROPERTY_TYPE_COLUMNS                     = 0x0067,
	MyCSS_PROPERTY_TYPE_CONTAIN                     = 0x0068,
	MyCSS_PROPERTY_TYPE_CONTENT                     = 0x0069,
	MyCSS_PROPERTY_TYPE_CONTINUE                    = 0x006a,
	MyCSS_PROPERTY_TYPE_COUNTER_INCREMENT           = 0x006b,
	MyCSS_PROPERTY_TYPE_CUE                         = 0x006c,
	MyCSS_PROPERTY_TYPE_CUE_AFTER                   = 0x006d,
	MyCSS_PROPERTY_TYPE_CUE_BEFORE                  = 0x006e,
	MyCSS_PROPERTY_TYPE_CURSOR                      = 0x006f,
	MyCSS_PROPERTY_TYPE_DIRECTION                   = 0x0070,
	MyCSS_PROPERTY_TYPE_DISPLAY                     = 0x0071,
	MyCSS_PROPERTY_TYPE_EMPTY_CELLS                 = 0x0072,
	MyCSS_PROPERTY_TYPE_FILL                        = 0x0073,
	MyCSS_PROPERTY_TYPE_FILL_OPACITY                = 0x0074,
	MyCSS_PROPERTY_TYPE_FILL_RULE                   = 0x0075,
	MyCSS_PROPERTY_TYPE_FLEX                        = 0x0076,
	MyCSS_PROPERTY_TYPE_FLEX_BASIS                  = 0x0077,
	MyCSS_PROPERTY_TYPE_FLEX_DIRECTION              = 0x0078,
	MyCSS_PROPERTY_TYPE_FLEX_FLOW                   = 0x0079,
	MyCSS_PROPERTY_TYPE_FLEX_GROW                   = 0x007a,
	MyCSS_PROPERTY_TYPE_FLEX_SHRINK                 = 0x007b,
	MyCSS_PROPERTY_TYPE_FLEX_WRAP                   = 0x007c,
	MyCSS_PROPERTY_TYPE_FLOAT                       = 0x007d,
	MyCSS_PROPERTY_TYPE_FLOAT_DISPLACE              = 0x007e,
	MyCSS_PROPERTY_TYPE_FONT                        = 0x007f,
	MyCSS_PROPERTY_TYPE_FONT_FAMILY                 = 0x0080,
	MyCSS_PROPERTY_TYPE_FONT_FEATURE_SETTINGS       = 0x0081,
	MyCSS_PROPERTY_TYPE_FONT_KERNING                = 0x0082,
	MyCSS_PROPERTY_TYPE_FONT_LANGUAGE_OVERRIDE      = 0x0083,
	MyCSS_PROPERTY_TYPE_FONT_SIZE                   = 0x0084,
	MyCSS_PROPERTY_TYPE_FONT_SIZE_ADJUST            = 0x0085,
	MyCSS_PROPERTY_TYPE_FONT_STRETCH                = 0x0086,
	MyCSS_PROPERTY_TYPE_FONT_STYLE                  = 0x0087,
	MyCSS_PROPERTY_TYPE_FONT_SYNTHESIS              = 0x0088,
	MyCSS_PROPERTY_TYPE_FONT_VARIANT                = 0x0089,
	MyCSS_PROPERTY_TYPE_FONT_VARIANT_ALTERNATES     = 0x008a,
	MyCSS_PROPERTY_TYPE_FONT_VARIANT_CAPS           = 0x008b,
	MyCSS_PROPERTY_TYPE_FONT_VARIANT_EAST_ASIAN     = 0x008c,
	MyCSS_PROPERTY_TYPE_FONT_VARIANT_LIGATURES      = 0x008d,
	MyCSS_PROPERTY_TYPE_FONT_VARIANT_NUMERIC        = 0x008e,
	MyCSS_PROPERTY_TYPE_FONT_VARIANT_POSITION       = 0x008f,
	MyCSS_PROPERTY_TYPE_FONT_WEIGHT                 = 0x0090,
	MyCSS_PROPERTY_TYPE_GLYPH_ORIENTATION_VERTICAL  = 0x0091,
	MyCSS_PROPERTY_TYPE_HANGING_PUNCTUATION         = 0x0092,
	MyCSS_PROPERTY_TYPE_HEIGHT                      = 0x0093,
	MyCSS_PROPERTY_TYPE_HYPHENS                     = 0x0094,
	MyCSS_PROPERTY_TYPE_IMAGE_RENDERING             = 0x0095,
	MyCSS_PROPERTY_TYPE_INDENT_EDGE_RESET           = 0x0096,
	MyCSS_PROPERTY_TYPE_INLINE_SIZE_STEP            = 0x0097,
	MyCSS_PROPERTY_TYPE_JUSTIFY_CONTENT             = 0x0098,
	MyCSS_PROPERTY_TYPE_LEFT                        = 0x0099,
	MyCSS_PROPERTY_TYPE_LETTER_SPACING              = 0x009a,
	MyCSS_PROPERTY_TYPE_LINE_BREAK                  = 0x009b,
	MyCSS_PROPERTY_TYPE_LINE_HEIGHT                 = 0x009c,
	MyCSS_PROPERTY_TYPE_LINE_HEIGHT_STEP            = 0x009d,
	MyCSS_PROPERTY_TYPE_LIST_STYLE                  = 0x009e,
	MyCSS_PROPERTY_TYPE_LIST_STYLE_IMAGE            = 0x009f,
	MyCSS_PROPERTY_TYPE_LIST_STYLE_POSITION         = 0x00a0,
	MyCSS_PROPERTY_TYPE_LIST_STYLE_TYPE             = 0x00a1,
	MyCSS_PROPERTY_TYPE_MARGIN                      = 0x00a2,
	MyCSS_PROPERTY_TYPE_MARGIN_BLOCK_END            = 0x00a3,
	MyCSS_PROPERTY_TYPE_MARGIN_BLOCK_START          = 0x00a4,
	MyCSS_PROPERTY_TYPE_MARGIN_BOTTOM               = 0x00a5,
	MyCSS_PROPERTY_TYPE_MARGIN_INLINE_END           = 0x00a6,
	MyCSS_PROPERTY_TYPE_MARGIN_INLINE_START         = 0x00a7,
	MyCSS_PROPERTY_TYPE_MARGIN_LEFT                 = 0x00a8,
	MyCSS_PROPERTY_TYPE_MARGIN_RIGHT                = 0x00a9,
	MyCSS_PROPERTY_TYPE_MARGIN_TOP                  = 0x00aa,
	MyCSS_PROPERTY_TYPE_MARKER                      = 0x00ab,
	MyCSS_PROPERTY_TYPE_MARKER_END                  = 0x00ac,
	MyCSS_PROPERTY_TYPE_MARKER_MID                  = 0x00ad,
	MyCSS_PROPERTY_TYPE_MARKER_SIDE                 = 0x00ae,
	MyCSS_PROPERTY_TYPE_MARKER_START                = 0x00af,
	MyCSS_PROPERTY_TYPE_MAX_HEIGHT                  = 0x00b0,
	MyCSS_PROPERTY_TYPE_MAX_LINES                   = 0x00b1,
	MyCSS_PROPERTY_TYPE_MAX_WIDTH                   = 0x00b2,
	MyCSS_PROPERTY_TYPE_MIN_HEIGHT                  = 0x00b3,
	MyCSS_PROPERTY_TYPE_MIN_WIDTH                   = 0x00b4,
	MyCSS_PROPERTY_TYPE_NAV_DOWN                    = 0x00b5,
	MyCSS_PROPERTY_TYPE_NAV_LEFT                    = 0x00b6,
	MyCSS_PROPERTY_TYPE_NAV_RIGHT                   = 0x00b7,
	MyCSS_PROPERTY_TYPE_NAV_UP                      = 0x00b8,
	MyCSS_PROPERTY_TYPE_OFFSET_AFTER                = 0x00b9,
	MyCSS_PROPERTY_TYPE_OFFSET_BEFORE               = 0x00ba,
	MyCSS_PROPERTY_TYPE_OFFSET_END                  = 0x00bb,
	MyCSS_PROPERTY_TYPE_OFFSET_START                = 0x00bc,
	MyCSS_PROPERTY_TYPE_OPACITY                     = 0x00bd,
	MyCSS_PROPERTY_TYPE_ORDER                       = 0x00be,
	MyCSS_PROPERTY_TYPE_ORPHANS                     = 0x00bf,
	MyCSS_PROPERTY_TYPE_OUTLINE                     = 0x00c0,
	MyCSS_PROPERTY_TYPE_OUTLINE_COLOR               = 0x00c1,
	MyCSS_PROPERTY_TYPE_OUTLINE_OFFSET              = 0x00c2,
	MyCSS_PROPERTY_TYPE_OUTLINE_STYLE               = 0x00c3,
	MyCSS_PROPERTY_TYPE_OUTLINE_WIDTH               = 0x00c4,
	MyCSS_PROPERTY_TYPE_OVERFLOW                    = 0x00c5,
	MyCSS_PROPERTY_TYPE_OVERFLOW_WRAP               = 0x00c6,
	MyCSS_PROPERTY_TYPE_OVERFLOW_X                  = 0x00c7,
	MyCSS_PROPERTY_TYPE_OVERFLOW_Y                  = 0x00c8,
	MyCSS_PROPERTY_TYPE_PADDING                     = 0x00c9,
	MyCSS_PROPERTY_TYPE_PADDING_BLOCK_END           = 0x00ca,
	MyCSS_PROPERTY_TYPE_PADDING_BLOCK_START         = 0x00cb,
	MyCSS_PROPERTY_TYPE_PADDING_BOTTOM              = 0x00cc,
	MyCSS_PROPERTY_TYPE_PADDING_INLINE_END          = 0x00cd,
	MyCSS_PROPERTY_TYPE_PADDING_INLINE_START        = 0x00ce,
	MyCSS_PROPERTY_TYPE_PADDING_LEFT                = 0x00cf,
	MyCSS_PROPERTY_TYPE_PADDING_RIGHT               = 0x00d0,
	MyCSS_PROPERTY_TYPE_PADDING_TOP                 = 0x00d1,
	MyCSS_PROPERTY_TYPE_PAUSE                       = 0x00d2,
	MyCSS_PROPERTY_TYPE_PAUSE_AFTER                 = 0x00d3,
	MyCSS_PROPERTY_TYPE_PAUSE_BEFORE                = 0x00d4,
	MyCSS_PROPERTY_TYPE_PERSPECTIVE                 = 0x00d5,
	MyCSS_PROPERTY_TYPE_PERSPECTIVE_ORIGIN          = 0x00d6,
	MyCSS_PROPERTY_TYPE_POSITION                    = 0x00d7,
	MyCSS_PROPERTY_TYPE_PRESENTATION_LEVEL          = 0x00d8,
	MyCSS_PROPERTY_TYPE_QUOTES                      = 0x00d9,
	MyCSS_PROPERTY_TYPE_REGION_FRAGMENT             = 0x00da,
	MyCSS_PROPERTY_TYPE_RESIZE                      = 0x00db,
	MyCSS_PROPERTY_TYPE_REST                        = 0x00dc,
	MyCSS_PROPERTY_TYPE_REST_AFTER                  = 0x00dd,
	MyCSS_PROPERTY_TYPE_REST_BEFORE                 = 0x00de,
	MyCSS_PROPERTY_TYPE_RIGHT                       = 0x00df,
	MyCSS_PROPERTY_TYPE_RUBY_ALIGN                  = 0x00e0,
	MyCSS_PROPERTY_TYPE_RUBY_MERGE                  = 0x00e1,
	MyCSS_PROPERTY_TYPE_RUBY_POSITION               = 0x00e2,
	MyCSS_PROPERTY_TYPE_SCROLL_PADDING              = 0x00e3,
	MyCSS_PROPERTY_TYPE_SCROLL_SNAP_ALIGN           = 0x00e4,
	MyCSS_PROPERTY_TYPE_SCROLL_SNAP_MARGIN          = 0x00e5,
	MyCSS_PROPERTY_TYPE_SCROLL_SNAP_STOP            = 0x00e6,
	MyCSS_PROPERTY_TYPE_SCROLL_SNAP_TYPE            = 0x00e7,
	MyCSS_PROPERTY_TYPE_SHAPE_IMAGE_THRESHOLD       = 0x00e8,
	MyCSS_PROPERTY_TYPE_SHAPE_MARGIN                = 0x00e9,
	MyCSS_PROPERTY_TYPE_SHAPE_OUTSIDE               = 0x00ea,
	MyCSS_PROPERTY_TYPE_SHAPE_RENDERING             = 0x00eb,
	MyCSS_PROPERTY_TYPE_SPEAK                       = 0x00ec,
	MyCSS_PROPERTY_TYPE_SPEAK_AS                    = 0x00ed,
	MyCSS_PROPERTY_TYPE_STRING_SET                  = 0x00ee,
	MyCSS_PROPERTY_TYPE_STROKE                      = 0x00ef,
	MyCSS_PROPERTY_TYPE_STROKE_DASHARRAY            = 0x00f0,
	MyCSS_PROPERTY_TYPE_STROKE_DASHOFFSET           = 0x00f1,
	MyCSS_PROPERTY_TYPE_STROKE_LINECAP              = 0x00f2,
	MyCSS_PROPERTY_TYPE_STROKE_LINEJOIN             = 0x00f3,
	MyCSS_PROPERTY_TYPE_STROKE_MITERLIMIT           = 0x00f4,
	MyCSS_PROPERTY_TYPE_STROKE_OPACITY              = 0x00f5,
	MyCSS_PROPERTY_TYPE_STROKE_WIDTH                = 0x00f6,
	MyCSS_PROPERTY_TYPE_TAB_SIZE                    = 0x00f7,
	MyCSS_PROPERTY_TYPE_TABLE_LAYOUT                = 0x00f8,
	MyCSS_PROPERTY_TYPE_TEXT_ALIGN                  = 0x00f9,
	MyCSS_PROPERTY_TYPE_TEXT_ALIGN_ALL              = 0x00fa,
	MyCSS_PROPERTY_TYPE_TEXT_ALIGN_LAST             = 0x00fb,
	MyCSS_PROPERTY_TYPE_TEXT_COMBINE_UPRIGHT        = 0x00fc,
	MyCSS_PROPERTY_TYPE_TEXT_DECORATION             = 0x00fd,
	MyCSS_PROPERTY_TYPE_TEXT_DECORATION_COLOR       = 0x00fe,
	MyCSS_PROPERTY_TYPE_TEXT_DECORATION_LINE        = 0x00ff,
	MyCSS_PROPERTY_TYPE_TEXT_DECORATION_SKIP        = 0x0100,
	MyCSS_PROPERTY_TYPE_TEXT_DECORATION_STYLE       = 0x0101,
	MyCSS_PROPERTY_TYPE_TEXT_EMPHASIS               = 0x0102,
	MyCSS_PROPERTY_TYPE_TEXT_EMPHASIS_COLOR         = 0x0103,
	MyCSS_PROPERTY_TYPE_TEXT_EMPHASIS_POSITION      = 0x0104,
	MyCSS_PROPERTY_TYPE_TEXT_EMPHASIS_STYLE         = 0x0105,
	MyCSS_PROPERTY_TYPE_TEXT_INDENT                 = 0x0106,
	MyCSS_PROPERTY_TYPE_TEXT_JUSTIFY                = 0x0107,
	MyCSS_PROPERTY_TYPE_TEXT_ORIENTATION            = 0x0108,
	MyCSS_PROPERTY_TYPE_TEXT_OVERFLOW               = 0x0109,
	MyCSS_PROPERTY_TYPE_TEXT_RENDERING              = 0x010a,
	MyCSS_PROPERTY_TYPE_TEXT_SHADOW                 = 0x010b,
	MyCSS_PROPERTY_TYPE_TEXT_SIZE_ADJUST            = 0x010c,
	MyCSS_PROPERTY_TYPE_TEXT_TRANSFORM              = 0x010d,
	MyCSS_PROPERTY_TYPE_TEXT_UNDERLINE_POSITION     = 0x010e,
	MyCSS_PROPERTY_TYPE_TOP                         = 0x010f,
	MyCSS_PROPERTY_TYPE_TOUCH_ACTION                = 0x0110,
	MyCSS_PROPERTY_TYPE_TRANSFORM                   = 0x0111,
	MyCSS_PROPERTY_TYPE_TRANSFORM_BOX               = 0x0112,
	MyCSS_PROPERTY_TYPE_TRANSFORM_ORIGIN            = 0x0113,
	MyCSS_PROPERTY_TYPE_TRANSFORM_STYLE             = 0x0114,
	MyCSS_PROPERTY_TYPE_TRANSITION                  = 0x0115,
	MyCSS_PROPERTY_TYPE_TRANSITION_DELAY            = 0x0116,
	MyCSS_PROPERTY_TYPE_TRANSITION_DURATION         = 0x0117,
	MyCSS_PROPERTY_TYPE_TRANSITION_PROPERTY         = 0x0118,
	MyCSS_PROPERTY_TYPE_TRANSITION_TIMING_FUNCTION  = 0x0119,
	MyCSS_PROPERTY_TYPE_UNICODE_BIDI                = 0x011a,
	MyCSS_PROPERTY_TYPE_USER_SELECT                 = 0x011b,
	MyCSS_PROPERTY_TYPE_VERTICAL_ALIGN              = 0x011c,
	MyCSS_PROPERTY_TYPE_VISIBILITY                  = 0x011d,
	MyCSS_PROPERTY_TYPE_VOICE_BALANCE               = 0x011e,
	MyCSS_PROPERTY_TYPE_VOICE_DURATION              = 0x011f,
	MyCSS_PROPERTY_TYPE_VOICE_FAMILY                = 0x0120,
	MyCSS_PROPERTY_TYPE_VOICE_PITCH                 = 0x0121,
	MyCSS_PROPERTY_TYPE_VOICE_RANGE                 = 0x0122,
	MyCSS_PROPERTY_TYPE_VOICE_RATE                  = 0x0123,
	MyCSS_PROPERTY_TYPE_VOICE_STRESS                = 0x0124,
	MyCSS_PROPERTY_TYPE_VOICE_VOLUME                = 0x0125,
	MyCSS_PROPERTY_TYPE_WHITE_SPACE                 = 0x0126,
	MyCSS_PROPERTY_TYPE_WIDOWS                      = 0x0127,
	MyCSS_PROPERTY_TYPE_WIDTH                       = 0x0128,
	MyCSS_PROPERTY_TYPE_WILL_CHANGE                 = 0x0129,
	MyCSS_PROPERTY_TYPE_WORD_BREAK                  = 0x012a,
	MyCSS_PROPERTY_TYPE_WORD_SPACING                = 0x012b,
	MyCSS_PROPERTY_TYPE_WORD_WRAP                   = 0x012c,
	MyCSS_PROPERTY_TYPE_WRAP_FLOW                   = 0x012d,
	MyCSS_PROPERTY_TYPE_WRAP_THROUGH                = 0x012e,
	MyCSS_PROPERTY_TYPE_WRITING_MODE                = 0x012f,
	MyCSS_PROPERTY_TYPE_Z_INDEX                     = 0x0130,
	MyCSS_PROPERTY_TYPE_LAST_ENTRY                  = 0x0131
}
typedef mycss_property_type_t;

enum mycss_property_value {
	MyCSS_PROPERTY_VALUE_UNDEF                     = 0x0000,
	MyCSS_PROPERTY_VALUE_AUTO                      = 0x0018,
	MyCSS_PROPERTY_VALUE_CURRENTCOLOR              = 0x0050,
	MyCSS_PROPERTY_VALUE_FIRST                     = 0x0073,
	MyCSS_PROPERTY_VALUE_FIRST_EXCEPT              = 0x0074,
	MyCSS_PROPERTY_VALUE_INHERIT                   = 0x0092,
	MyCSS_PROPERTY_VALUE_INITIAL                   = 0x0093,
	MyCSS_PROPERTY_VALUE_LAST                      = 0x00ac,
	MyCSS_PROPERTY_VALUE_NONE                      = 0x00d3,
	MyCSS_PROPERTY_VALUE_START                     = 0x0146,
	MyCSS_PROPERTY_VALUE_TRANSPARENT               = 0x0166,
	MyCSS_PROPERTY_VALUE_UNSET                     = 0x016f,
	MyCSS_PROPERTY_VALUE__COLOR                    = 0x0190,
	MyCSS_PROPERTY_VALUE__CROSS_FADE_FUNCTION      = 0x0191,
	MyCSS_PROPERTY_VALUE__CUSTOM_IDENT             = 0x0192,
	MyCSS_PROPERTY_VALUE__ELEMENT_FUNCTION         = 0x0193,
	MyCSS_PROPERTY_VALUE__IMAGE                    = 0x0196,
	MyCSS_PROPERTY_VALUE__IMAGE_FUNCTION           = 0x0197,
	MyCSS_PROPERTY_VALUE__IMAGE_LIST               = 0x0198,
	MyCSS_PROPERTY_VALUE__IMAGE_SET_FUNCTION       = 0x0199,
	MyCSS_PROPERTY_VALUE__LENGTH                   = 0x019a,
	MyCSS_PROPERTY_VALUE__LINEAR_GRADIENT_FUNCTION = 0x019b,
	MyCSS_PROPERTY_VALUE__NUMBER                   = 0x019c,
	MyCSS_PROPERTY_VALUE__PERCENTAGE               = 0x019d,
	MyCSS_PROPERTY_VALUE__RADIAL_GRADIENT_FUNCTION = 0x019e,
	MyCSS_PROPERTY_VALUE__RESOLUTION               = 0x019f,
	MyCSS_PROPERTY_VALUE__URL                      = 0x01a0,
	MyCSS_PROPERTY_VALUE_LAST_ENTRY                = 0x01a1
}
typedef mycss_property_value_t;

enum mycss_property_align_content {
	MyCSS_PROPERTY_ALIGN_CONTENT_CENTER        = 0x0037,
	MyCSS_PROPERTY_ALIGN_CONTENT_FLEX_END      = 0x0079,
	MyCSS_PROPERTY_ALIGN_CONTENT_FLEX_START    = 0x007a,
	MyCSS_PROPERTY_ALIGN_CONTENT_STRETCH       = 0x014c,
	MyCSS_PROPERTY_ALIGN_CONTENT_SPACE_AROUND  = 0x0140,
	MyCSS_PROPERTY_ALIGN_CONTENT_SPACE_BETWEEN = 0x0141
}
typedef mycss_property_align_content_t;

enum mycss_property_align_items {
	MyCSS_PROPERTY_ALIGN_ITEMS_CENTER     = 0x0037,
	MyCSS_PROPERTY_ALIGN_ITEMS_FLEX_END   = 0x0079,
	MyCSS_PROPERTY_ALIGN_ITEMS_FLEX_START = 0x007a,
	MyCSS_PROPERTY_ALIGN_ITEMS_STRETCH    = 0x014c,
	MyCSS_PROPERTY_ALIGN_ITEMS_BASELINE   = 0x0022
}
typedef mycss_property_align_items_t;

enum mycss_property_align_self {
	MyCSS_PROPERTY_ALIGN_SELF_AUTO       = 0x0018,
	MyCSS_PROPERTY_ALIGN_SELF_CENTER     = 0x0037,
	MyCSS_PROPERTY_ALIGN_SELF_FLEX_END   = 0x0079,
	MyCSS_PROPERTY_ALIGN_SELF_FLEX_START = 0x007a,
	MyCSS_PROPERTY_ALIGN_SELF_STRETCH    = 0x014c,
	MyCSS_PROPERTY_ALIGN_SELF_BASELINE   = 0x0022
}
typedef mycss_property_align_self_t;

enum mycss_property_animation_direction {
	MyCSS_PROPERTY_ANIMATION_DIRECTION_NORMAL            = 0x00d5,
	MyCSS_PROPERTY_ANIMATION_DIRECTION_REVERSE           = 0x0113,
	MyCSS_PROPERTY_ANIMATION_DIRECTION_ALTERNATE         = 0x0015,
	MyCSS_PROPERTY_ANIMATION_DIRECTION_ALTERNATE_REVERSE = 0x0016
}
typedef mycss_property_animation_direction_t;

enum mycss_property_animation_fill_mode {
	MyCSS_PROPERTY_ANIMATION_FILL_MODE_NONE      = 0x00d3,
	MyCSS_PROPERTY_ANIMATION_FILL_MODE_BOTH      = 0x002c,
	MyCSS_PROPERTY_ANIMATION_FILL_MODE_FORWARDS  = 0x007e,
	MyCSS_PROPERTY_ANIMATION_FILL_MODE_BACKWARDS = 0x001e
}
typedef mycss_property_animation_fill_mode_t;

enum mycss_property_animation_name {
	MyCSS_PROPERTY_ANIMATION_NAME_NONE = 0x00d3
}
typedef mycss_property_animation_name_t;

enum mycss_property_animation_play_state {
	MyCSS_PROPERTY_ANIMATION_PLAY_STATE_PAUSED  = 0x00ff,
	MyCSS_PROPERTY_ANIMATION_PLAY_STATE_RUNNING = 0x0122
}
typedef mycss_property_animation_play_state_t;

enum mycss_property_animation_timing_function {
	MyCSS_PROPERTY_ANIMATION_TIMING_FUNCTION_LINEAR      = 0x00b2,
	MyCSS_PROPERTY_ANIMATION_TIMING_FUNCTION_EASE        = 0x005e,
	MyCSS_PROPERTY_ANIMATION_TIMING_FUNCTION_EASE_IN     = 0x005f,
	MyCSS_PROPERTY_ANIMATION_TIMING_FUNCTION_EASE_OUT    = 0x0061,
	MyCSS_PROPERTY_ANIMATION_TIMING_FUNCTION_STEP_END    = 0x0149,
	MyCSS_PROPERTY_ANIMATION_TIMING_FUNCTION_STEP_START  = 0x014a,
	MyCSS_PROPERTY_ANIMATION_TIMING_FUNCTION_EASE_IN_OUT = 0x0060
}
typedef mycss_property_animation_timing_function_t;

enum mycss_property_appearance {
	MyCSS_PROPERTY_APPEARANCE_AUTO = 0x0018,
	MyCSS_PROPERTY_APPEARANCE_NONE = 0x00d3
}
typedef mycss_property_appearance_t;

enum mycss_property_backface_visibility {
	MyCSS_PROPERTY_BACKFACE_VISIBILITY_HIDDEN  = 0x0088,
	MyCSS_PROPERTY_BACKFACE_VISIBILITY_VISIBLE = 0x0178
}
typedef mycss_property_backface_visibility_t;

enum mycss_property_background {
	MyCSS_PROPERTY_BACKGROUND_REPEAT_X  = 0x0111,
	MyCSS_PROPERTY_BACKGROUND_UNSET     = 0x016f,
	MyCSS_PROPERTY_BACKGROUND_CONTAIN   = 0x0044,
	MyCSS_PROPERTY_BACKGROUND_REPEAT_Y  = 0x0112,
	MyCSS_PROPERTY_BACKGROUND_REPEAT    = 0x0110,
	MyCSS_PROPERTY_BACKGROUND_INHERIT   = 0x0092,
	MyCSS_PROPERTY_BACKGROUND_INITIAL   = 0x0093,
	MyCSS_PROPERTY_BACKGROUND_COVER     = 0x004c,
	MyCSS_PROPERTY_BACKGROUND_AUTO      = 0x0018,
	MyCSS_PROPERTY_BACKGROUND_SPACE     = 0x013e,
	MyCSS_PROPERTY_BACKGROUND_ROUND     = 0x0118,
	MyCSS_PROPERTY_BACKGROUND_FIXED     = 0x0076,
	MyCSS_PROPERTY_BACKGROUND_SCROLL    = 0x0126,
	MyCSS_PROPERTY_BACKGROUND_NO_REPEAT = 0x00e0,
	MyCSS_PROPERTY_BACKGROUND_LOCAL     = 0x00b9
}
typedef mycss_property_background_t;

enum mycss_property_background_attachment {
	MyCSS_PROPERTY_BACKGROUND_ATTACHMENT_UNSET   = 0x016f,
	MyCSS_PROPERTY_BACKGROUND_ATTACHMENT_INHERIT = 0x0092,
	MyCSS_PROPERTY_BACKGROUND_ATTACHMENT_INITIAL = 0x0093,
	MyCSS_PROPERTY_BACKGROUND_ATTACHMENT_LOCAL   = 0x00b9,
	MyCSS_PROPERTY_BACKGROUND_ATTACHMENT_SCROLL  = 0x0126,
	MyCSS_PROPERTY_BACKGROUND_ATTACHMENT_FIXED   = 0x0076
}
typedef mycss_property_background_attachment_t;

enum mycss_property_background_clip {
	MyCSS_PROPERTY_BACKGROUND_CLIP_UNSET       = 0x016f,
	MyCSS_PROPERTY_BACKGROUND_CLIP_INHERIT     = 0x0092,
	MyCSS_PROPERTY_BACKGROUND_CLIP_BORDER_BOX  = 0x002a,
	MyCSS_PROPERTY_BACKGROUND_CLIP_INITIAL     = 0x0093,
	MyCSS_PROPERTY_BACKGROUND_CLIP_PADDING_BOX = 0x00f4,
	MyCSS_PROPERTY_BACKGROUND_CLIP_CONTENT_BOX = 0x0047
}
typedef mycss_property_background_clip_t;

enum mycss_property_background_color {
	MyCSS_PROPERTY_BACKGROUND_COLOR_UNSET       = 0x016f,
	MyCSS_PROPERTY_BACKGROUND_COLOR__COLOR      = 0x0190,
	MyCSS_PROPERTY_BACKGROUND_COLOR_INHERIT     = 0x0092,
	MyCSS_PROPERTY_BACKGROUND_COLOR_INITIAL     = 0x0093,
	MyCSS_PROPERTY_BACKGROUND_COLOR_TRANSPARENT = 0x0166
}
typedef mycss_property_background_color_t;

enum mycss_property_background_image {
	MyCSS_PROPERTY_BACKGROUND_IMAGE_NONE    = 0x00d3,
	MyCSS_PROPERTY_BACKGROUND_IMAGE__IMAGE  = 0x0196,
	MyCSS_PROPERTY_BACKGROUND_IMAGE_UNSET   = 0x016f,
	MyCSS_PROPERTY_BACKGROUND_IMAGE_INHERIT = 0x0092,
	MyCSS_PROPERTY_BACKGROUND_IMAGE_INITIAL = 0x0093
}
typedef mycss_property_background_image_t;

enum mycss_property_background_origin {
	MyCSS_PROPERTY_BACKGROUND_ORIGIN_UNSET       = 0x016f,
	MyCSS_PROPERTY_BACKGROUND_ORIGIN_INHERIT     = 0x0092,
	MyCSS_PROPERTY_BACKGROUND_ORIGIN_BORDER_BOX  = 0x002a,
	MyCSS_PROPERTY_BACKGROUND_ORIGIN_INITIAL     = 0x0093,
	MyCSS_PROPERTY_BACKGROUND_ORIGIN_PADDING_BOX = 0x00f4,
	MyCSS_PROPERTY_BACKGROUND_ORIGIN_CONTENT_BOX = 0x0047
}
typedef mycss_property_background_origin_t;

enum mycss_property_background_position {
	MyCSS_PROPERTY_BACKGROUND_POSITION_UNSET   = 0x016f,
	MyCSS_PROPERTY_BACKGROUND_POSITION_BOTTOM  = 0x002d,
	MyCSS_PROPERTY_BACKGROUND_POSITION_INHERIT = 0x0092,
	MyCSS_PROPERTY_BACKGROUND_POSITION_INITIAL = 0x0093,
	MyCSS_PROPERTY_BACKGROUND_POSITION_RIGHT   = 0x0115,
	MyCSS_PROPERTY_BACKGROUND_POSITION_CENTER  = 0x0037,
	MyCSS_PROPERTY_BACKGROUND_POSITION_LEFT    = 0x00ae,
	MyCSS_PROPERTY_BACKGROUND_POSITION_TOP     = 0x0164
}
typedef mycss_property_background_position_t;

enum mycss_property_background_repeat {
	MyCSS_PROPERTY_BACKGROUND_REPEAT_REPEAT_X  = 0x0111,
	MyCSS_PROPERTY_BACKGROUND_REPEAT_ROUND     = 0x0118,
	MyCSS_PROPERTY_BACKGROUND_REPEAT_UNSET     = 0x016f,
	MyCSS_PROPERTY_BACKGROUND_REPEAT_INHERIT   = 0x0092,
	MyCSS_PROPERTY_BACKGROUND_REPEAT_NO_REPEAT = 0x00e0,
	MyCSS_PROPERTY_BACKGROUND_REPEAT_INITIAL   = 0x0093,
	MyCSS_PROPERTY_BACKGROUND_REPEAT_REPEAT_Y  = 0x0112,
	MyCSS_PROPERTY_BACKGROUND_REPEAT_SPACE     = 0x013e,
	MyCSS_PROPERTY_BACKGROUND_REPEAT_REPEAT    = 0x0110
}
typedef mycss_property_background_repeat_t;

enum mycss_property_background_size {
	MyCSS_PROPERTY_BACKGROUND_SIZE_COVER   = 0x004c,
	MyCSS_PROPERTY_BACKGROUND_SIZE_AUTO    = 0x0018,
	MyCSS_PROPERTY_BACKGROUND_SIZE_UNSET   = 0x016f,
	MyCSS_PROPERTY_BACKGROUND_SIZE_CONTAIN = 0x0044,
	MyCSS_PROPERTY_BACKGROUND_SIZE_INHERIT = 0x0092,
	MyCSS_PROPERTY_BACKGROUND_SIZE_INITIAL = 0x0093
}
typedef mycss_property_background_size_t;

enum mycss_property_bookmark_level {
	MyCSS_PROPERTY_BOOKMARK_LEVEL_NONE = 0x00d3
}
typedef mycss_property_bookmark_level_t;

enum mycss_property_bookmark_state {
	MyCSS_PROPERTY_BOOKMARK_STATE_CLOSED = 0x003c,
	MyCSS_PROPERTY_BOOKMARK_STATE_OPEN   = 0x00ea
}
typedef mycss_property_bookmark_state_t;

enum mycss_property_border {
	MyCSS_PROPERTY_BORDER_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_HIDDEN  = 0x0088,
	MyCSS_PROPERTY_BORDER_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_INITIAL = 0x0093,
	MyCSS_PROPERTY_BORDER_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER__COLOR  = 0x0190,
	MyCSS_PROPERTY_BORDER_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_OUTSET  = 0x00ef
}
typedef mycss_property_border_t;

enum mycss_property_border_block_end {
	MyCSS_PROPERTY_BORDER_BLOCK_END_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER_BLOCK_END__COLOR  = 0x0190,
	MyCSS_PROPERTY_BORDER_BLOCK_END__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_BLOCK_END_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_BLOCK_END_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_BLOCK_END_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_BLOCK_END_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_BLOCK_END_HIDDEN  = 0x0088,
	MyCSS_PROPERTY_BORDER_BLOCK_END_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_BLOCK_END_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_BLOCK_END_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_BLOCK_END_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_BLOCK_END_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_BLOCK_END_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_BLOCK_END_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_BLOCK_END_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_BLOCK_END_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_BLOCK_END_INITIAL = 0x0093
}
typedef mycss_property_border_block_end_t;

enum mycss_property_border_block_end_color {
	MyCSS_PROPERTY_BORDER_BLOCK_END_COLOR_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_BLOCK_END_COLOR_INITIAL = 0x0093,
	MyCSS_PROPERTY_BORDER_BLOCK_END_COLOR_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_BLOCK_END_COLOR__COLOR  = 0x0190
}
typedef mycss_property_border_block_end_color_t;

enum mycss_property_border_block_end_style {
	MyCSS_PROPERTY_BORDER_BLOCK_END_STYLE_INITIAL = 0x0093,
	MyCSS_PROPERTY_BORDER_BLOCK_END_STYLE_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_BLOCK_END_STYLE_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_BLOCK_END_STYLE_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_BLOCK_END_STYLE_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_BLOCK_END_STYLE_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_BLOCK_END_STYLE_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_BLOCK_END_STYLE_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_BLOCK_END_STYLE_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_BLOCK_END_STYLE_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_BLOCK_END_STYLE_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_BLOCK_END_STYLE_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_BLOCK_END_STYLE_HIDDEN  = 0x0088
}
typedef mycss_property_border_block_end_style_t;

enum mycss_property_border_block_end_width {
	MyCSS_PROPERTY_BORDER_BLOCK_END_WIDTH__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_BLOCK_END_WIDTH_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_BLOCK_END_WIDTH_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_BLOCK_END_WIDTH_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_BLOCK_END_WIDTH_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_BLOCK_END_WIDTH_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER_BLOCK_END_WIDTH_INITIAL = 0x0093
}
typedef mycss_property_border_block_end_width_t;

enum mycss_property_border_block_start {
	MyCSS_PROPERTY_BORDER_BLOCK_START_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER_BLOCK_START__COLOR  = 0x0190,
	MyCSS_PROPERTY_BORDER_BLOCK_START__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_BLOCK_START_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_BLOCK_START_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_BLOCK_START_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_BLOCK_START_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_BLOCK_START_HIDDEN  = 0x0088,
	MyCSS_PROPERTY_BORDER_BLOCK_START_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_BLOCK_START_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_BLOCK_START_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_BLOCK_START_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_BLOCK_START_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_BLOCK_START_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_BLOCK_START_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_BLOCK_START_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_BLOCK_START_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_BLOCK_START_INITIAL = 0x0093
}
typedef mycss_property_border_block_start_t;

enum mycss_property_border_block_start_color {
	MyCSS_PROPERTY_BORDER_BLOCK_START_COLOR_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_BLOCK_START_COLOR__COLOR  = 0x0190,
	MyCSS_PROPERTY_BORDER_BLOCK_START_COLOR_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_BLOCK_START_COLOR_INITIAL = 0x0093
}
typedef mycss_property_border_block_start_color_t;

enum mycss_property_border_block_start_style {
	MyCSS_PROPERTY_BORDER_BLOCK_START_STYLE_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_BLOCK_START_STYLE_INITIAL = 0x0093,
	MyCSS_PROPERTY_BORDER_BLOCK_START_STYLE_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_BLOCK_START_STYLE_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_BLOCK_START_STYLE_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_BLOCK_START_STYLE_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_BLOCK_START_STYLE_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_BLOCK_START_STYLE_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_BLOCK_START_STYLE_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_BLOCK_START_STYLE_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_BLOCK_START_STYLE_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_BLOCK_START_STYLE_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_BLOCK_START_STYLE_HIDDEN  = 0x0088
}
typedef mycss_property_border_block_start_style_t;

enum mycss_property_border_block_start_width {
	MyCSS_PROPERTY_BORDER_BLOCK_START_WIDTH__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_BLOCK_START_WIDTH_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_BLOCK_START_WIDTH_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_BLOCK_START_WIDTH_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_BLOCK_START_WIDTH_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_BLOCK_START_WIDTH_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER_BLOCK_START_WIDTH_INITIAL = 0x0093
}
typedef mycss_property_border_block_start_width_t;

enum mycss_property_border_bottom {
	MyCSS_PROPERTY_BORDER_BOTTOM_INITIAL = 0x0093,
	MyCSS_PROPERTY_BORDER_BOTTOM_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER_BOTTOM__COLOR  = 0x0190,
	MyCSS_PROPERTY_BORDER_BOTTOM__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_BOTTOM_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_BOTTOM_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_BOTTOM_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_BOTTOM_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_BOTTOM_HIDDEN  = 0x0088,
	MyCSS_PROPERTY_BORDER_BOTTOM_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_BOTTOM_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_BOTTOM_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_BOTTOM_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_BOTTOM_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_BOTTOM_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_BOTTOM_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_BOTTOM_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_BOTTOM_INHERIT = 0x0092
}
typedef mycss_property_border_bottom_t;

enum mycss_property_border_bottom_color {
	MyCSS_PROPERTY_BORDER_BOTTOM_COLOR_UNSET        = 0x016f,
	MyCSS_PROPERTY_BORDER_BOTTOM_COLOR__COLOR       = 0x0190,
	MyCSS_PROPERTY_BORDER_BOTTOM_COLOR_INHERIT      = 0x0092,
	MyCSS_PROPERTY_BORDER_BOTTOM_COLOR_INITIAL      = 0x0093,
	MyCSS_PROPERTY_BORDER_BOTTOM_COLOR_CURRENTCOLOR = 0x0050
}
typedef mycss_property_border_bottom_color_t;

enum mycss_property_border_bottom_left_radius {
	MyCSS_PROPERTY_BORDER_BOTTOM_LEFT_RADIUS_UNSET       = 0x016f,
	MyCSS_PROPERTY_BORDER_BOTTOM_LEFT_RADIUS__LENGTH     = 0x019a,
	MyCSS_PROPERTY_BORDER_BOTTOM_LEFT_RADIUS_INHERIT     = 0x0092,
	MyCSS_PROPERTY_BORDER_BOTTOM_LEFT_RADIUS_INITIAL     = 0x0093,
	MyCSS_PROPERTY_BORDER_BOTTOM_LEFT_RADIUS__PERCENTAGE = 0x019d
}
typedef mycss_property_border_bottom_left_radius_t;

enum mycss_property_border_bottom_right_radius {
	MyCSS_PROPERTY_BORDER_BOTTOM_RIGHT_RADIUS_UNSET       = 0x016f,
	MyCSS_PROPERTY_BORDER_BOTTOM_RIGHT_RADIUS__LENGTH     = 0x019a,
	MyCSS_PROPERTY_BORDER_BOTTOM_RIGHT_RADIUS_INHERIT     = 0x0092,
	MyCSS_PROPERTY_BORDER_BOTTOM_RIGHT_RADIUS_INITIAL     = 0x0093,
	MyCSS_PROPERTY_BORDER_BOTTOM_RIGHT_RADIUS__PERCENTAGE = 0x019d
}
typedef mycss_property_border_bottom_right_radius_t;

enum mycss_property_border_bottom_style {
	MyCSS_PROPERTY_BORDER_BOTTOM_STYLE_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_BOTTOM_STYLE_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_BOTTOM_STYLE_HIDDEN  = 0x0088,
	MyCSS_PROPERTY_BORDER_BOTTOM_STYLE_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_BOTTOM_STYLE_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_BOTTOM_STYLE_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_BOTTOM_STYLE_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_BOTTOM_STYLE_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_BOTTOM_STYLE_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_BOTTOM_STYLE_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_BOTTOM_STYLE_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_BOTTOM_STYLE_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_BOTTOM_STYLE_INITIAL = 0x0093
}
typedef mycss_property_border_bottom_style_t;

enum mycss_property_border_bottom_width {
	MyCSS_PROPERTY_BORDER_BOTTOM_WIDTH__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_BOTTOM_WIDTH_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_BOTTOM_WIDTH_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_BOTTOM_WIDTH_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_BOTTOM_WIDTH_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_BOTTOM_WIDTH_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER_BOTTOM_WIDTH_INITIAL = 0x0093
}
typedef mycss_property_border_bottom_width_t;

enum mycss_property_border_collapse {
	MyCSS_PROPERTY_BORDER_COLLAPSE_COLLAPSE = 0x003d,
	MyCSS_PROPERTY_BORDER_COLLAPSE_SEPARATE = 0x012a
}
typedef mycss_property_border_collapse_t;

enum mycss_property_border_color {
	MyCSS_PROPERTY_BORDER_COLOR_INHERIT      = 0x0092,
	MyCSS_PROPERTY_BORDER_COLOR_UNSET        = 0x016f,
	MyCSS_PROPERTY_BORDER_COLOR__COLOR       = 0x0190,
	MyCSS_PROPERTY_BORDER_COLOR_INITIAL      = 0x0093,
	MyCSS_PROPERTY_BORDER_COLOR_CURRENTCOLOR = 0x0050
}
typedef mycss_property_border_color_t;

enum mycss_property_border_image_repeat {
	MyCSS_PROPERTY_BORDER_IMAGE_REPEAT_ROUND   = 0x0118,
	MyCSS_PROPERTY_BORDER_IMAGE_REPEAT_REPEAT  = 0x0110,
	MyCSS_PROPERTY_BORDER_IMAGE_REPEAT_STRETCH = 0x014c,
	MyCSS_PROPERTY_BORDER_IMAGE_REPEAT_SPACE   = 0x013e
}
typedef mycss_property_border_image_repeat_t;

enum mycss_property_border_image_slice {
	MyCSS_PROPERTY_BORDER_IMAGE_SLICE_FILL = 0x0070
}
typedef mycss_property_border_image_slice_t;

enum mycss_property_border_image_width {
	MyCSS_PROPERTY_BORDER_IMAGE_WIDTH_AUTO = 0x0018
}
typedef mycss_property_border_image_width_t;

enum mycss_property_border_inline_end {
	MyCSS_PROPERTY_BORDER_INLINE_END_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER_INLINE_END__COLOR  = 0x0190,
	MyCSS_PROPERTY_BORDER_INLINE_END__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_INLINE_END_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_INLINE_END_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_INLINE_END_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_INLINE_END_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_INLINE_END_HIDDEN  = 0x0088,
	MyCSS_PROPERTY_BORDER_INLINE_END_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_INLINE_END_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_INLINE_END_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_INLINE_END_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_INLINE_END_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_INLINE_END_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_INLINE_END_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_INLINE_END_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_INLINE_END_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_INLINE_END_INITIAL = 0x0093
}
typedef mycss_property_border_inline_end_t;

enum mycss_property_border_inline_end_color {
	MyCSS_PROPERTY_BORDER_INLINE_END_COLOR_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_INLINE_END_COLOR__COLOR  = 0x0190,
	MyCSS_PROPERTY_BORDER_INLINE_END_COLOR_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_INLINE_END_COLOR_INITIAL = 0x0093
}
typedef mycss_property_border_inline_end_color_t;

enum mycss_property_border_inline_end_style {
	MyCSS_PROPERTY_BORDER_INLINE_END_STYLE_HIDDEN  = 0x0088,
	MyCSS_PROPERTY_BORDER_INLINE_END_STYLE_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_INLINE_END_STYLE_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_INLINE_END_STYLE_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_INLINE_END_STYLE_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_INLINE_END_STYLE_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_INLINE_END_STYLE_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_INLINE_END_STYLE_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_INLINE_END_STYLE_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_INLINE_END_STYLE_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_INLINE_END_STYLE_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_INLINE_END_STYLE_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_INLINE_END_STYLE_INITIAL = 0x0093
}
typedef mycss_property_border_inline_end_style_t;

enum mycss_property_border_inline_end_width {
	MyCSS_PROPERTY_BORDER_INLINE_END_WIDTH__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_INLINE_END_WIDTH_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_INLINE_END_WIDTH_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_INLINE_END_WIDTH_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_INLINE_END_WIDTH_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_INLINE_END_WIDTH_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER_INLINE_END_WIDTH_INITIAL = 0x0093
}
typedef mycss_property_border_inline_end_width_t;

enum mycss_property_border_inline_start {
	MyCSS_PROPERTY_BORDER_INLINE_START_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER_INLINE_START__COLOR  = 0x0190,
	MyCSS_PROPERTY_BORDER_INLINE_START__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_INLINE_START_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_INLINE_START_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_INLINE_START_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_INLINE_START_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_INLINE_START_HIDDEN  = 0x0088,
	MyCSS_PROPERTY_BORDER_INLINE_START_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_INLINE_START_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_INLINE_START_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_INLINE_START_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_INLINE_START_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_INLINE_START_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_INLINE_START_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_INLINE_START_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_INLINE_START_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_INLINE_START_INITIAL = 0x0093
}
typedef mycss_property_border_inline_start_t;

enum mycss_property_border_inline_start_color {
	MyCSS_PROPERTY_BORDER_INLINE_START_COLOR_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_INLINE_START_COLOR_INITIAL = 0x0093,
	MyCSS_PROPERTY_BORDER_INLINE_START_COLOR__COLOR  = 0x0190,
	MyCSS_PROPERTY_BORDER_INLINE_START_COLOR_INHERIT = 0x0092
}
typedef mycss_property_border_inline_start_color_t;

enum mycss_property_border_inline_start_style {
	MyCSS_PROPERTY_BORDER_INLINE_START_STYLE_INITIAL = 0x0093,
	MyCSS_PROPERTY_BORDER_INLINE_START_STYLE_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_INLINE_START_STYLE_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_INLINE_START_STYLE_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_INLINE_START_STYLE_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_INLINE_START_STYLE_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_INLINE_START_STYLE_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_INLINE_START_STYLE_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_INLINE_START_STYLE_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_INLINE_START_STYLE_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_INLINE_START_STYLE_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_INLINE_START_STYLE_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_INLINE_START_STYLE_HIDDEN  = 0x0088
}
typedef mycss_property_border_inline_start_style_t;

enum mycss_property_border_inline_start_width {
	MyCSS_PROPERTY_BORDER_INLINE_START_WIDTH__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_INLINE_START_WIDTH_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_INLINE_START_WIDTH_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_INLINE_START_WIDTH_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_INLINE_START_WIDTH_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_INLINE_START_WIDTH_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER_INLINE_START_WIDTH_INITIAL = 0x0093
}
typedef mycss_property_border_inline_start_width_t;

enum mycss_property_border_left {
	MyCSS_PROPERTY_BORDER_LEFT_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER_LEFT__COLOR  = 0x0190,
	MyCSS_PROPERTY_BORDER_LEFT__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_LEFT_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_LEFT_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_LEFT_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_LEFT_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_LEFT_HIDDEN  = 0x0088,
	MyCSS_PROPERTY_BORDER_LEFT_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_LEFT_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_LEFT_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_LEFT_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_LEFT_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_LEFT_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_LEFT_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_LEFT_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_LEFT_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_LEFT_INITIAL = 0x0093
}
typedef mycss_property_border_left_t;

enum mycss_property_border_left_color {
	MyCSS_PROPERTY_BORDER_LEFT_COLOR_INITIAL      = 0x0093,
	MyCSS_PROPERTY_BORDER_LEFT_COLOR_CURRENTCOLOR = 0x0050,
	MyCSS_PROPERTY_BORDER_LEFT_COLOR_UNSET        = 0x016f,
	MyCSS_PROPERTY_BORDER_LEFT_COLOR__COLOR       = 0x0190,
	MyCSS_PROPERTY_BORDER_LEFT_COLOR_INHERIT      = 0x0092
}
typedef mycss_property_border_left_color_t;

enum mycss_property_border_left_style {
	MyCSS_PROPERTY_BORDER_LEFT_STYLE_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_LEFT_STYLE_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_LEFT_STYLE_HIDDEN  = 0x0088,
	MyCSS_PROPERTY_BORDER_LEFT_STYLE_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_LEFT_STYLE_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_LEFT_STYLE_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_LEFT_STYLE_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_LEFT_STYLE_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_LEFT_STYLE_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_LEFT_STYLE_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_LEFT_STYLE_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_LEFT_STYLE_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_LEFT_STYLE_INITIAL = 0x0093
}
typedef mycss_property_border_left_style_t;

enum mycss_property_border_left_width {
	MyCSS_PROPERTY_BORDER_LEFT_WIDTH_INITIAL = 0x0093,
	MyCSS_PROPERTY_BORDER_LEFT_WIDTH__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_LEFT_WIDTH_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_LEFT_WIDTH_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_LEFT_WIDTH_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_LEFT_WIDTH_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_LEFT_WIDTH_THIN    = 0x0162
}
typedef mycss_property_border_left_width_t;

enum mycss_property_border_radius {
	MyCSS_PROPERTY_BORDER_RADIUS_UNSET       = 0x016f,
	MyCSS_PROPERTY_BORDER_RADIUS__LENGTH     = 0x019a,
	MyCSS_PROPERTY_BORDER_RADIUS_INHERIT     = 0x0092,
	MyCSS_PROPERTY_BORDER_RADIUS_INITIAL     = 0x0093,
	MyCSS_PROPERTY_BORDER_RADIUS__PERCENTAGE = 0x019d
}
typedef mycss_property_border_radius_t;

enum mycss_property_border_right {
	MyCSS_PROPERTY_BORDER_RIGHT_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_RIGHT_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_RIGHT_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_RIGHT_HIDDEN  = 0x0088,
	MyCSS_PROPERTY_BORDER_RIGHT_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_RIGHT_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_RIGHT_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_RIGHT_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_RIGHT_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_RIGHT_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_RIGHT_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_RIGHT_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_RIGHT_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_RIGHT_INITIAL = 0x0093,
	MyCSS_PROPERTY_BORDER_RIGHT_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER_RIGHT__COLOR  = 0x0190,
	MyCSS_PROPERTY_BORDER_RIGHT__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_RIGHT_NONE    = 0x00d3
}
typedef mycss_property_border_right_t;

enum mycss_property_border_right_color {
	MyCSS_PROPERTY_BORDER_RIGHT_COLOR_UNSET        = 0x016f,
	MyCSS_PROPERTY_BORDER_RIGHT_COLOR__COLOR       = 0x0190,
	MyCSS_PROPERTY_BORDER_RIGHT_COLOR_INHERIT      = 0x0092,
	MyCSS_PROPERTY_BORDER_RIGHT_COLOR_INITIAL      = 0x0093,
	MyCSS_PROPERTY_BORDER_RIGHT_COLOR_CURRENTCOLOR = 0x0050
}
typedef mycss_property_border_right_color_t;

enum mycss_property_border_right_style {
	MyCSS_PROPERTY_BORDER_RIGHT_STYLE_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_RIGHT_STYLE_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_RIGHT_STYLE_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_RIGHT_STYLE_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_RIGHT_STYLE_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_RIGHT_STYLE_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_RIGHT_STYLE_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_RIGHT_STYLE_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_RIGHT_STYLE_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_RIGHT_STYLE_INITIAL = 0x0093,
	MyCSS_PROPERTY_BORDER_RIGHT_STYLE_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_RIGHT_STYLE_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_RIGHT_STYLE_HIDDEN  = 0x0088
}
typedef mycss_property_border_right_style_t;

enum mycss_property_border_right_width {
	MyCSS_PROPERTY_BORDER_RIGHT_WIDTH__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_RIGHT_WIDTH_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_RIGHT_WIDTH_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_RIGHT_WIDTH_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_RIGHT_WIDTH_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_RIGHT_WIDTH_INITIAL = 0x0093,
	MyCSS_PROPERTY_BORDER_RIGHT_WIDTH_THIN    = 0x0162
}
typedef mycss_property_border_right_width_t;

enum mycss_property_border_style {
	MyCSS_PROPERTY_BORDER_STYLE_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_STYLE_HIDDEN  = 0x0088,
	MyCSS_PROPERTY_BORDER_STYLE_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_STYLE_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_STYLE_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_STYLE_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_STYLE_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_STYLE_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_STYLE_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_STYLE_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_STYLE_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_STYLE_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_STYLE_INITIAL = 0x0093
}
typedef mycss_property_border_style_t;

enum mycss_property_border_top {
	MyCSS_PROPERTY_BORDER_TOP_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_TOP__COLOR  = 0x0190,
	MyCSS_PROPERTY_BORDER_TOP_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER_TOP__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_TOP_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_TOP_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_TOP_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_TOP_HIDDEN  = 0x0088,
	MyCSS_PROPERTY_BORDER_TOP_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_TOP_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_TOP_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_TOP_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_TOP_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_TOP_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_TOP_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_TOP_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_TOP_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_TOP_INITIAL = 0x0093
}
typedef mycss_property_border_top_t;

enum mycss_property_border_top_color {
	MyCSS_PROPERTY_BORDER_TOP_COLOR_UNSET        = 0x016f,
	MyCSS_PROPERTY_BORDER_TOP_COLOR__COLOR       = 0x0190,
	MyCSS_PROPERTY_BORDER_TOP_COLOR_INHERIT      = 0x0092,
	MyCSS_PROPERTY_BORDER_TOP_COLOR_INITIAL      = 0x0093,
	MyCSS_PROPERTY_BORDER_TOP_COLOR_CURRENTCOLOR = 0x0050
}
typedef mycss_property_border_top_color_t;

enum mycss_property_border_top_left_radius {
	MyCSS_PROPERTY_BORDER_TOP_LEFT_RADIUS_UNSET       = 0x016f,
	MyCSS_PROPERTY_BORDER_TOP_LEFT_RADIUS__LENGTH     = 0x019a,
	MyCSS_PROPERTY_BORDER_TOP_LEFT_RADIUS_INHERIT     = 0x0092,
	MyCSS_PROPERTY_BORDER_TOP_LEFT_RADIUS_INITIAL     = 0x0093,
	MyCSS_PROPERTY_BORDER_TOP_LEFT_RADIUS__PERCENTAGE = 0x019d
}
typedef mycss_property_border_top_left_radius_t;

enum mycss_property_border_top_right_radius {
	MyCSS_PROPERTY_BORDER_TOP_RIGHT_RADIUS_INHERIT     = 0x0092,
	MyCSS_PROPERTY_BORDER_TOP_RIGHT_RADIUS__LENGTH     = 0x019a,
	MyCSS_PROPERTY_BORDER_TOP_RIGHT_RADIUS_INITIAL     = 0x0093,
	MyCSS_PROPERTY_BORDER_TOP_RIGHT_RADIUS__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_BORDER_TOP_RIGHT_RADIUS_UNSET       = 0x016f
}
typedef mycss_property_border_top_right_radius_t;

enum mycss_property_border_spacing {
    MyCSS_PROPERTY_BORDER_SPACING_INHERIT    = 0x0092,
    MyCSS_PROPERTY_BORDER_SPACING__LENGTH    = 0x019a,
}
typedef mycss_property_border_spacing_t;

enum mycss_property_border_top_style {
	MyCSS_PROPERTY_BORDER_TOP_STYLE_NONE    = 0x00d3,
	MyCSS_PROPERTY_BORDER_TOP_STYLE_SOLID   = 0x013d,
	MyCSS_PROPERTY_BORDER_TOP_STYLE_HIDDEN  = 0x0088,
	MyCSS_PROPERTY_BORDER_TOP_STYLE_DOTTED  = 0x005a,
	MyCSS_PROPERTY_BORDER_TOP_STYLE_DASHED  = 0x0052,
	MyCSS_PROPERTY_BORDER_TOP_STYLE_RIDGE   = 0x0114,
	MyCSS_PROPERTY_BORDER_TOP_STYLE_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_BORDER_TOP_STYLE_GROOVE  = 0x0085,
	MyCSS_PROPERTY_BORDER_TOP_STYLE_INSET   = 0x009b,
	MyCSS_PROPERTY_BORDER_TOP_STYLE_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_TOP_STYLE_OUTSET  = 0x00ef,
	MyCSS_PROPERTY_BORDER_TOP_STYLE_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_TOP_STYLE_INITIAL = 0x0093
}
typedef mycss_property_border_top_style_t;

enum mycss_property_border_top_width {
	MyCSS_PROPERTY_BORDER_TOP_WIDTH_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER_TOP_WIDTH__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_TOP_WIDTH_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_TOP_WIDTH_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_TOP_WIDTH_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_TOP_WIDTH_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_TOP_WIDTH_INITIAL = 0x0093
}
typedef mycss_property_border_top_width_t;

enum mycss_property_border_width {
	MyCSS_PROPERTY_BORDER_WIDTH_THIN    = 0x0162,
	MyCSS_PROPERTY_BORDER_WIDTH__LENGTH = 0x019a,
	MyCSS_PROPERTY_BORDER_WIDTH_THICK   = 0x0161,
	MyCSS_PROPERTY_BORDER_WIDTH_MEDIUM  = 0x00c6,
	MyCSS_PROPERTY_BORDER_WIDTH_UNSET   = 0x016f,
	MyCSS_PROPERTY_BORDER_WIDTH_INHERIT = 0x0092,
	MyCSS_PROPERTY_BORDER_WIDTH_INITIAL = 0x0093
}
typedef mycss_property_border_width_t;

enum mycss_property_bottom {
	MyCSS_PROPERTY_BOTTOM_AUTO        = 0x0018,
	MyCSS_PROPERTY_BOTTOM__LENGTH     = 0x019a,
	MyCSS_PROPERTY_BOTTOM_UNSET       = 0x016f,
	MyCSS_PROPERTY_BOTTOM__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_BOTTOM_INHERIT     = 0x0092,
	MyCSS_PROPERTY_BOTTOM_INITIAL     = 0x0093
}
typedef mycss_property_bottom_t;

enum mycss_property_box_decoration_break {
	MyCSS_PROPERTY_BOX_DECORATION_BREAK_SLICE = 0x0136,
	MyCSS_PROPERTY_BOX_DECORATION_BREAK_CLONE = 0x003b
}
typedef mycss_property_box_decoration_break_t;

enum mycss_property_box_shadow {
	MyCSS_PROPERTY_BOX_SHADOW_NONE = 0x00d3
}
typedef mycss_property_box_shadow_t;

enum mycss_property_box_sizing {
	MyCSS_PROPERTY_BOX_SIZING_INITIAL     = 0x0093,
	MyCSS_PROPERTY_BOX_SIZING_UNSET       = 0x016f,
	MyCSS_PROPERTY_BOX_SIZING_INHERIT     = 0x0092,
	MyCSS_PROPERTY_BOX_SIZING_BORDER_BOX  = 0x002a,
	MyCSS_PROPERTY_BOX_SIZING_CONTENT_BOX = 0x0047
}
typedef mycss_property_box_sizing_t;

enum mycss_property_box_suppress {
	MyCSS_PROPERTY_BOX_SUPPRESS_DISCARD = 0x0057,
	MyCSS_PROPERTY_BOX_SUPPRESS_HIDE    = 0x0089,
	MyCSS_PROPERTY_BOX_SUPPRESS_SHOW    = 0x012e
}
typedef mycss_property_box_suppress_t;

enum mycss_property_break_after {
	MyCSS_PROPERTY_BREAK_AFTER_PAGE         = 0x00f6,
	MyCSS_PROPERTY_BREAK_AFTER_AVOID        = 0x001a,
	MyCSS_PROPERTY_BREAK_AFTER_AUTO         = 0x0018,
	MyCSS_PROPERTY_BREAK_AFTER_LEFT         = 0x00ae,
	MyCSS_PROPERTY_BREAK_AFTER_AVOID_PAGE   = 0x001c,
	MyCSS_PROPERTY_BREAK_AFTER_RIGHT        = 0x0115,
	MyCSS_PROPERTY_BREAK_AFTER_RECTO        = 0x010c,
	MyCSS_PROPERTY_BREAK_AFTER_VERSO        = 0x0172,
	MyCSS_PROPERTY_BREAK_AFTER_COLUMN       = 0x003e,
	MyCSS_PROPERTY_BREAK_AFTER_REGION       = 0x010e,
	MyCSS_PROPERTY_BREAK_AFTER_AVOID_COLUMN = 0x001b,
	MyCSS_PROPERTY_BREAK_AFTER_AVOID_REGION = 0x001d
}
typedef mycss_property_break_after_t;

enum mycss_property_break_before {
	MyCSS_PROPERTY_BREAK_BEFORE_VERSO        = 0x0172,
	MyCSS_PROPERTY_BREAK_BEFORE_RECTO        = 0x010c,
	MyCSS_PROPERTY_BREAK_BEFORE_COLUMN       = 0x003e,
	MyCSS_PROPERTY_BREAK_BEFORE_REGION       = 0x010e,
	MyCSS_PROPERTY_BREAK_BEFORE_RIGHT        = 0x0115,
	MyCSS_PROPERTY_BREAK_BEFORE_AVOID_REGION = 0x001d,
	MyCSS_PROPERTY_BREAK_BEFORE_AUTO         = 0x0018,
	MyCSS_PROPERTY_BREAK_BEFORE_PAGE         = 0x00f6,
	MyCSS_PROPERTY_BREAK_BEFORE_AVOID        = 0x001a,
	MyCSS_PROPERTY_BREAK_BEFORE_AVOID_COLUMN = 0x001b,
	MyCSS_PROPERTY_BREAK_BEFORE_LEFT         = 0x00ae,
	MyCSS_PROPERTY_BREAK_BEFORE_AVOID_PAGE   = 0x001c
}
typedef mycss_property_break_before_t;

enum mycss_property_break_inside {
	MyCSS_PROPERTY_BREAK_INSIDE_AVOID_PAGE   = 0x001c,
	MyCSS_PROPERTY_BREAK_INSIDE_AVOID_COLUMN = 0x001b,
	MyCSS_PROPERTY_BREAK_INSIDE_AVOID_REGION = 0x001d,
	MyCSS_PROPERTY_BREAK_INSIDE_AUTO         = 0x0018,
	MyCSS_PROPERTY_BREAK_INSIDE_AVOID        = 0x001a
}
typedef mycss_property_break_inside_t;

enum mycss_property_caption_side {
	MyCSS_PROPERTY_CAPTION_SIDE_BOTTOM = 0x002d,
	MyCSS_PROPERTY_CAPTION_SIDE_TOP    = 0x0164
}
typedef mycss_property_caption_side_t;

enum mycss_property_caret {
	MyCSS_PROPERTY_CARET_AUTO = 0x0018
}
typedef mycss_property_caret_t;

enum mycss_property_caret_color {
	MyCSS_PROPERTY_CARET_COLOR_AUTO = 0x0018
}
typedef mycss_property_caret_color_t;

enum mycss_property_caret_shape {
	MyCSS_PROPERTY_CARET_SHAPE_UNDERSCORE = 0x016c,
	MyCSS_PROPERTY_CARET_SHAPE_BAR        = 0x0021,
	MyCSS_PROPERTY_CARET_SHAPE_AUTO       = 0x0018,
	MyCSS_PROPERTY_CARET_SHAPE_BLOCK      = 0x0026
}
typedef mycss_property_caret_shape_t;

enum mycss_property_clear {
	MyCSS_PROPERTY_CLEAR_BOTH    = 0x002c,
	MyCSS_PROPERTY_CLEAR_RIGHT   = 0x0115,
	MyCSS_PROPERTY_CLEAR_NONE    = 0x00d3,
	MyCSS_PROPERTY_CLEAR_UNSET   = 0x016f,
	MyCSS_PROPERTY_CLEAR_LEFT    = 0x00ae,
	MyCSS_PROPERTY_CLEAR_INHERIT = 0x0092,
	MyCSS_PROPERTY_CLEAR_INITIAL = 0x0093
}
typedef mycss_property_clear_t;

enum mycss_property_clear_after {
	MyCSS_PROPERTY_CLEAR_AFTER_OUTSIDE     = 0x00f0,
	MyCSS_PROPERTY_CLEAR_AFTER_START       = 0x0146,
	MyCSS_PROPERTY_CLEAR_AFTER_DESCENDANTS = 0x0054,
	MyCSS_PROPERTY_CLEAR_AFTER_TOP         = 0x0164,
	MyCSS_PROPERTY_CLEAR_AFTER_BOTH        = 0x002c,
	MyCSS_PROPERTY_CLEAR_AFTER_UNSET       = 0x016f,
	MyCSS_PROPERTY_CLEAR_AFTER_INHERIT     = 0x0092,
	MyCSS_PROPERTY_CLEAR_AFTER_END         = 0x0066,
	MyCSS_PROPERTY_CLEAR_AFTER_INITIAL     = 0x0093,
	MyCSS_PROPERTY_CLEAR_AFTER_INSIDE      = 0x009c,
	MyCSS_PROPERTY_CLEAR_AFTER_BOTTOM      = 0x002d,
	MyCSS_PROPERTY_CLEAR_AFTER_NONE        = 0x00d3,
	MyCSS_PROPERTY_CLEAR_AFTER_LEFT        = 0x00ae,
	MyCSS_PROPERTY_CLEAR_AFTER_RIGHT       = 0x0115
}
typedef mycss_property_clear_after_t;

enum mycss_property_color {
	MyCSS_PROPERTY_COLOR__COLOR  = 0x0190,
	MyCSS_PROPERTY_COLOR_INHERIT = 0x0092,
	MyCSS_PROPERTY_COLOR_UNSET   = 0x016f,
	MyCSS_PROPERTY_COLOR_INITIAL = 0x0093
}
typedef mycss_property_color_t;

enum mycss_property_color_adjust {
	MyCSS_PROPERTY_COLOR_ADJUST_ECONOMY = 0x0062,
	MyCSS_PROPERTY_COLOR_ADJUST_EXACT   = 0x0069
}
typedef mycss_property_color_adjust_t;

enum mycss_property_color_interpolation {
	MyCSS_PROPERTY_COLOR_INTERPOLATION_SRGB      = 0x0144,
	MyCSS_PROPERTY_COLOR_INTERPOLATION_AUTO      = 0x0018,
	MyCSS_PROPERTY_COLOR_INTERPOLATION_INHERIT   = 0x0092,
	MyCSS_PROPERTY_COLOR_INTERPOLATION_LINEARRGB = 0x00b3
}
typedef mycss_property_color_interpolation_t;

enum mycss_property_color_interpolation_filters {
	MyCSS_PROPERTY_COLOR_INTERPOLATION_FILTERS_SRGB      = 0x0144,
	MyCSS_PROPERTY_COLOR_INTERPOLATION_FILTERS_AUTO      = 0x0018,
	MyCSS_PROPERTY_COLOR_INTERPOLATION_FILTERS_INHERIT   = 0x0092,
	MyCSS_PROPERTY_COLOR_INTERPOLATION_FILTERS_LINEARRGB = 0x00b3
}
typedef mycss_property_color_interpolation_filters_t;

enum mycss_property_color_rendering {
	MyCSS_PROPERTY_COLOR_RENDERING_INHERIT         = 0x0092,
	MyCSS_PROPERTY_COLOR_RENDERING_OPTIMIZESPEED   = 0x00ed,
	MyCSS_PROPERTY_COLOR_RENDERING_OPTIMIZEQUALITY = 0x00ec,
	MyCSS_PROPERTY_COLOR_RENDERING_AUTO            = 0x0018
}
typedef mycss_property_color_rendering_t;

enum mycss_property_column_count {
	MyCSS_PROPERTY_COLUMN_COUNT_AUTO = 0x0018
}
typedef mycss_property_column_count_t;

enum mycss_property_column_fill {
	MyCSS_PROPERTY_COLUMN_FILL_AUTO        = 0x0018,
	MyCSS_PROPERTY_COLUMN_FILL_BALANCE     = 0x001f,
	MyCSS_PROPERTY_COLUMN_FILL_BALANCE_ALL = 0x0020
}
typedef mycss_property_column_fill_t;

enum mycss_property_column_gap {
	MyCSS_PROPERTY_COLUMN_GAP_NORMAL = 0x00d5
}
typedef mycss_property_column_gap_t;

enum mycss_property_column_rule_color {
	MyCSS_PROPERTY_COLUMN_RULE_COLOR_CURRENTCOLOR = 0x0050
}
typedef mycss_property_column_rule_color_t;

enum mycss_property_column_rule_style {
	MyCSS_PROPERTY_COLUMN_RULE_STYLE_NONE = 0x00d3
}
typedef mycss_property_column_rule_style_t;

enum mycss_property_column_rule_width {
	MyCSS_PROPERTY_COLUMN_RULE_WIDTH_MEDIUM = 0x00c6
}
typedef mycss_property_column_rule_width_t;

enum mycss_property_column_span {
	MyCSS_PROPERTY_COLUMN_SPAN_NONE = 0x00d3,
	MyCSS_PROPERTY_COLUMN_SPAN_ALL  = 0x0010
}
typedef mycss_property_column_span_t;

enum mycss_property_column_width {
	MyCSS_PROPERTY_COLUMN_WIDTH_AUTO = 0x0018
}
typedef mycss_property_column_width_t;

enum mycss_property_contain {
	MyCSS_PROPERTY_CONTAIN_CONTENT = 0x0045,
	MyCSS_PROPERTY_CONTAIN_STRICT  = 0x014d,
	MyCSS_PROPERTY_CONTAIN_NONE    = 0x00d3,
	MyCSS_PROPERTY_CONTAIN_STYLE   = 0x014f,
	MyCSS_PROPERTY_CONTAIN_LAYOUT  = 0x00ad,
	MyCSS_PROPERTY_CONTAIN_PAINT   = 0x00f8,
	MyCSS_PROPERTY_CONTAIN_SIZE    = 0x0134
}
typedef mycss_property_contain_t;

enum mycss_property_content {
	MyCSS_PROPERTY_CONTENT_NONE   = 0x00d3,
	MyCSS_PROPERTY_CONTENT_NORMAL = 0x00d5
}
typedef mycss_property_content_t;

enum mycss_property_continue {
	MyCSS_PROPERTY_CONTINUE_DISCARD   = 0x0057,
	MyCSS_PROPERTY_CONTINUE_OVERFLOW  = 0x00f2,
	MyCSS_PROPERTY_CONTINUE_PAGINATE  = 0x00f7,
	MyCSS_PROPERTY_CONTINUE_FRAGMENTS = 0x007f,
	MyCSS_PROPERTY_CONTINUE_AUTO      = 0x0018
}
typedef mycss_property_continue_t;

enum mycss_property_counter_increment {
	MyCSS_PROPERTY_COUNTER_INCREMENT_NONE = 0x00d3
}
typedef mycss_property_counter_increment_t;

enum mycss_property_cue_after {
	MyCSS_PROPERTY_CUE_AFTER_NONE = 0x00d3
}
typedef mycss_property_cue_after_t;

enum mycss_property_cue_before {
	MyCSS_PROPERTY_CUE_BEFORE_NONE = 0x00d3
}
typedef mycss_property_cue_before_t;

enum mycss_property_cursor {
	MyCSS_PROPERTY_CURSOR_CELL          = 0x0036,
	MyCSS_PROPERTY_CURSOR_INITIAL       = 0x0093,
	MyCSS_PROPERTY_CURSOR_PROGRESS      = 0x0108,
	MyCSS_PROPERTY_CURSOR_HELP          = 0x0087,
	MyCSS_PROPERTY_CURSOR_DEFAULT       = 0x0053,
	MyCSS_PROPERTY_CURSOR_WAIT          = 0x0179,
	MyCSS_PROPERTY_CURSOR_POINTER       = 0x0102,
	MyCSS_PROPERTY_CURSOR_CONTEXT_MENU  = 0x004a,
	MyCSS_PROPERTY_CURSOR_AUTO          = 0x0018,
	MyCSS_PROPERTY_CURSOR_NONE          = 0x00d3,
	MyCSS_PROPERTY_CURSOR_TEXT          = 0x015e,
	MyCSS_PROPERTY_CURSOR_COPY          = 0x004b,
	MyCSS_PROPERTY_CURSOR_CROSSHAIR     = 0x004e,
	MyCSS_PROPERTY_CURSOR_ALIAS         = 0x000f,
	MyCSS_PROPERTY_CURSOR_MOVE          = 0x00d0,
	MyCSS_PROPERTY_CURSOR_VERTICAL_TEXT = 0x0176,
	MyCSS_PROPERTY_CURSOR_GRAB          = 0x0082,
	MyCSS_PROPERTY_CURSOR_NO_DROP       = 0x00dd,
	MyCSS_PROPERTY_CURSOR_UNSET         = 0x016f,
	MyCSS_PROPERTY_CURSOR_NOT_ALLOWED   = 0x00d6,
	MyCSS_PROPERTY_CURSOR_ZOOM_IN       = 0x018e,
	MyCSS_PROPERTY_CURSOR_GRABBING      = 0x0083,
	MyCSS_PROPERTY_CURSOR_E_RESIZE      = 0x006d,
	MyCSS_PROPERTY_CURSOR_N_RESIZE      = 0x00e4,
	MyCSS_PROPERTY_CURSOR_S_RESIZE      = 0x0153,
	MyCSS_PROPERTY_CURSOR_NE_RESIZE     = 0x00d2,
	MyCSS_PROPERTY_CURSOR_NW_RESIZE     = 0x00e3,
	MyCSS_PROPERTY_CURSOR_W_RESIZE      = 0x017f,
	MyCSS_PROPERTY_CURSOR_SE_RESIZE     = 0x012d,
	MyCSS_PROPERTY_CURSOR_SW_RESIZE     = 0x0152,
	MyCSS_PROPERTY_CURSOR_EW_RESIZE     = 0x0068,
	MyCSS_PROPERTY_CURSOR_NS_RESIZE     = 0x00e1,
	MyCSS_PROPERTY_CURSOR_COL_RESIZE    = 0x0040,
	MyCSS_PROPERTY_CURSOR_NESW_RESIZE   = 0x00d1,
	MyCSS_PROPERTY_CURSOR_NWSE_RESIZE   = 0x00e2,
	MyCSS_PROPERTY_CURSOR_ROW_RESIZE    = 0x011a,
	MyCSS_PROPERTY_CURSOR_ALL_SCROLL    = 0x0013,
	MyCSS_PROPERTY_CURSOR_INHERIT       = 0x0092,
	MyCSS_PROPERTY_CURSOR_ZOOM_OUT      = 0x018f
}
typedef mycss_property_cursor_t;

enum mycss_property_direction {
	MyCSS_PROPERTY_DIRECTION_LTR     = 0x00be,
	MyCSS_PROPERTY_DIRECTION_RTL     = 0x011c,
	MyCSS_PROPERTY_DIRECTION_UNSET   = 0x016f,
	MyCSS_PROPERTY_DIRECTION_INHERIT = 0x0092,
	MyCSS_PROPERTY_DIRECTION_INITIAL = 0x0093
}
typedef mycss_property_direction_t;

enum mycss_property_display {
	MyCSS_PROPERTY_DISPLAY_RUBY_BASE           = 0x011e,
	MyCSS_PROPERTY_DISPLAY_TABLE               = 0x0154,
	MyCSS_PROPERTY_DISPLAY_FLOW_ROOT           = 0x007c,
	MyCSS_PROPERTY_DISPLAY_TABLE_CELL          = 0x0156,
	MyCSS_PROPERTY_DISPLAY_TABLE_ROW_GROUP     = 0x015c,
	MyCSS_PROPERTY_DISPLAY_NONE                = 0x00d3,
	MyCSS_PROPERTY_DISPLAY_FLOW                = 0x007b,
	MyCSS_PROPERTY_DISPLAY_BLOCK               = 0x0026,
	MyCSS_PROPERTY_DISPLAY_FLEX                = 0x0078,
	MyCSS_PROPERTY_DISPLAY_INLINE              = 0x0095,
	MyCSS_PROPERTY_DISPLAY_RUN_IN              = 0x0123,
	MyCSS_PROPERTY_DISPLAY_TABLE_HEADER_GROUP  = 0x015a,
	MyCSS_PROPERTY_DISPLAY_TABLE_FOOTER_GROUP  = 0x0159,
	MyCSS_PROPERTY_DISPLAY_TABLE_COLUMN        = 0x0157,
	MyCSS_PROPERTY_DISPLAY_RUBY_TEXT           = 0x0120,
	MyCSS_PROPERTY_DISPLAY_TABLE_CAPTION       = 0x0155,
	MyCSS_PROPERTY_DISPLAY_TABLE_COLUMN_GROUP  = 0x0158,
	MyCSS_PROPERTY_DISPLAY_GRID                = 0x0084,
	MyCSS_PROPERTY_DISPLAY_RUBY                = 0x011d,
	MyCSS_PROPERTY_DISPLAY_UNSET               = 0x016f,
	MyCSS_PROPERTY_DISPLAY_INHERIT             = 0x0092,
	MyCSS_PROPERTY_DISPLAY_CONTENTS            = 0x0046,
	MyCSS_PROPERTY_DISPLAY_LIST_ITEM           = 0x00b7,
	MyCSS_PROPERTY_DISPLAY_TABLE_ROW           = 0x015b,
	MyCSS_PROPERTY_DISPLAY_INITIAL             = 0x0093,
	MyCSS_PROPERTY_DISPLAY_INLINE_FLEX         = 0x0097,
	MyCSS_PROPERTY_DISPLAY_INLINE_BLOCK        = 0x0096,
	MyCSS_PROPERTY_DISPLAY_RUBY_BASE_CONTAINER = 0x011f,
	MyCSS_PROPERTY_DISPLAY_RUBY_TEXT_CONTAINER = 0x0121,
	MyCSS_PROPERTY_DISPLAY_INLINE_TABLE        = 0x009a,
	MyCSS_PROPERTY_DISPLAY_INLINE_LIST_ITEM    = 0x0099,
	MyCSS_PROPERTY_DISPLAY_INLINE_GRID         = 0x0098
}
typedef mycss_property_display_t;

enum mycss_property_empty_cells {
	MyCSS_PROPERTY_EMPTY_CELLS_SHOW = 0x012e,
	MyCSS_PROPERTY_EMPTY_CELLS_HIDE = 0x0089
}
typedef mycss_property_empty_cells_t;

enum mycss_property_fill_opacity {
	MyCSS_PROPERTY_FILL_OPACITY_INHERIT = 0x0092
}
typedef mycss_property_fill_opacity_t;

enum mycss_property_fill_rule {
	MyCSS_PROPERTY_FILL_RULE_INHERIT = 0x0092,
	MyCSS_PROPERTY_FILL_RULE_NONZERO = 0x00d4,
	MyCSS_PROPERTY_FILL_RULE_EVENODD = 0x0067
}
typedef mycss_property_fill_rule_t;

enum mycss_property_flex {
	MyCSS_PROPERTY_FLEX_NONE = 0x00d3
}
typedef mycss_property_flex_t;

enum mycss_property_flex_basis {
	MyCSS_PROPERTY_FLEX_BASIS_AUTO    = 0x0018,
	MyCSS_PROPERTY_FLEX_BASIS_CONTENT = 0x0045
}
typedef mycss_property_flex_basis_t;

enum mycss_property_flex_direction {
	MyCSS_PROPERTY_FLEX_DIRECTION_COLUMN         = 0x003e,
	MyCSS_PROPERTY_FLEX_DIRECTION_ROW            = 0x0119,
	MyCSS_PROPERTY_FLEX_DIRECTION_ROW_REVERSE    = 0x011b,
	MyCSS_PROPERTY_FLEX_DIRECTION_COLUMN_REVERSE = 0x003f
}
typedef mycss_property_flex_direction_t;

enum mycss_property_flex_flow {
	MyCSS_PROPERTY_FLEX_FLOW_NOWRAP         = 0x00d7,
	MyCSS_PROPERTY_FLEX_FLOW_ROW_REVERSE    = 0x011b,
	MyCSS_PROPERTY_FLEX_FLOW_COLUMN_REVERSE = 0x003f,
	MyCSS_PROPERTY_FLEX_FLOW_WRAP           = 0x017d,
	MyCSS_PROPERTY_FLEX_FLOW_COLUMN         = 0x003e,
	MyCSS_PROPERTY_FLEX_FLOW_ROW            = 0x0119,
	MyCSS_PROPERTY_FLEX_FLOW_WRAP_REVERSE   = 0x017e
}
typedef mycss_property_flex_flow_t;

enum mycss_property_flex_wrap {
	MyCSS_PROPERTY_FLEX_WRAP_WRAP_REVERSE = 0x017e,
	MyCSS_PROPERTY_FLEX_WRAP_WRAP         = 0x017d,
	MyCSS_PROPERTY_FLEX_WRAP_NOWRAP       = 0x00d7
}
typedef mycss_property_flex_wrap_t;

enum mycss_property_float {
	MyCSS_PROPERTY_FLOAT_START   = 0x0146,
	MyCSS_PROPERTY_FLOAT_BOTTOM  = 0x002d,
	MyCSS_PROPERTY_FLOAT_TOP     = 0x0164,
	MyCSS_PROPERTY_FLOAT_LEFT    = 0x00ae,
	MyCSS_PROPERTY_FLOAT_NONE    = 0x00d3,
	MyCSS_PROPERTY_FLOAT_UNSET   = 0x016f,
	MyCSS_PROPERTY_FLOAT_INHERIT = 0x0092,
	MyCSS_PROPERTY_FLOAT_INITIAL = 0x0093,
	MyCSS_PROPERTY_FLOAT_RIGHT   = 0x0115,
	MyCSS_PROPERTY_FLOAT_END     = 0x0066
}
typedef mycss_property_float_t;

enum mycss_property_float_displace {
	MyCSS_PROPERTY_FLOAT_DISPLACE_LINE              = 0x00b1,
	MyCSS_PROPERTY_FLOAT_DISPLACE_BLOCK             = 0x0026,
	MyCSS_PROPERTY_FLOAT_DISPLACE_INDENT            = 0x0091,
	MyCSS_PROPERTY_FLOAT_DISPLACE_UNSET             = 0x016f,
	MyCSS_PROPERTY_FLOAT_DISPLACE_INHERIT           = 0x0092,
	MyCSS_PROPERTY_FLOAT_DISPLACE_INITIAL           = 0x0093,
	MyCSS_PROPERTY_FLOAT_DISPLACE_BLOCK_WITHIN_PAGE = 0x0027
}
typedef mycss_property_float_displace_t;

enum mycss_property_font {
	MyCSS_PROPERTY_FONT_ICON          = 0x008f,
	MyCSS_PROPERTY_FONT_CAPTION       = 0x0035,
	MyCSS_PROPERTY_FONT_MENU          = 0x00c7,
	MyCSS_PROPERTY_FONT_UNSE          = 0x016e,
	MyCSS_PROPERTY_FONT_NORMAL        = 0x00d5,
	MyCSS_PROPERTY_FONT_STATUS_BAR    = 0x0148,
	MyCSS_PROPERTY_FONT_MESSAGE_BOX   = 0x00c8,
	MyCSS_PROPERTY_FONT_SMALL_CAPTION = 0x013b,
	MyCSS_PROPERTY_FONT_INHERIT       = 0x0092,
	MyCSS_PROPERTY_FONT_SMALL_CAPS    = 0x013a,
	MyCSS_PROPERTY_FONT_INITIAL       = 0x0093
}
typedef mycss_property_font_t;

enum mycss_property_font_family {
	MyCSS_PROPERTY_FONT_FAMILY__GENERIC_FAMILY = 0x0195,
	MyCSS_PROPERTY_FONT_FAMILY_SANS_SERIF      = 0x0125,
	MyCSS_PROPERTY_FONT_FAMILY_UNSE            = 0x016e,
	MyCSS_PROPERTY_FONT_FAMILY_SERIF           = 0x012b,
	MyCSS_PROPERTY_FONT_FAMILY_CURSIVE         = 0x0051,
	MyCSS_PROPERTY_FONT_FAMILY__FAMILY_NAME    = 0x0194,
	MyCSS_PROPERTY_FONT_FAMILY_FANTASY         = 0x006e,
	MyCSS_PROPERTY_FONT_FAMILY_INHERIT         = 0x0092,
	MyCSS_PROPERTY_FONT_FAMILY_MONOSPACE       = 0x00cf,
	MyCSS_PROPERTY_FONT_FAMILY_INITIAL         = 0x0093
}
typedef mycss_property_font_family_t;

enum mycss_property_font_feature_settings {
	MyCSS_PROPERTY_FONT_FEATURE_SETTINGS_ON     = 0x00e9,
	MyCSS_PROPERTY_FONT_FEATURE_SETTINGS_NORMAL = 0x00d5,
	MyCSS_PROPERTY_FONT_FEATURE_SETTINGS_OFF    = 0x00e7
}
typedef mycss_property_font_feature_settings_t;

enum mycss_property_font_kerning {
	MyCSS_PROPERTY_FONT_KERNING_AUTO   = 0x0018,
	MyCSS_PROPERTY_FONT_KERNING_NONE   = 0x00d3,
	MyCSS_PROPERTY_FONT_KERNING_NORMAL = 0x00d5
}
typedef mycss_property_font_kerning_t;

enum mycss_property_font_language_override {
	MyCSS_PROPERTY_FONT_LANGUAGE_OVERRIDE_NORMAL = 0x00d5
}
typedef mycss_property_font_language_override_t;

enum mycss_property_font_size {
	MyCSS_PROPERTY_FONT_SIZE_INITIAL     = 0x0093,
	MyCSS_PROPERTY_FONT_SIZE_SMALL       = 0x0138,
	MyCSS_PROPERTY_FONT_SIZE__LENGTH     = 0x019a,
	MyCSS_PROPERTY_FONT_SIZE_X_SMALL     = 0x0189,
	MyCSS_PROPERTY_FONT_SIZE_XX_SMALL    = 0x0182,
	MyCSS_PROPERTY_FONT_SIZE__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_FONT_SIZE_LARGE       = 0x00aa,
	MyCSS_PROPERTY_FONT_SIZE_MEDIUM      = 0x00c6,
	MyCSS_PROPERTY_FONT_SIZE_UNSET       = 0x016f,
	MyCSS_PROPERTY_FONT_SIZE_LARGER      = 0x00ab,
	MyCSS_PROPERTY_FONT_SIZE_X_LARGE     = 0x0185,
	MyCSS_PROPERTY_FONT_SIZE_XX_LARGE    = 0x0181,
	MyCSS_PROPERTY_FONT_SIZE_INHERIT     = 0x0092,
	MyCSS_PROPERTY_FONT_SIZE_SMALLER     = 0x0139
}
typedef mycss_property_font_size_t;

enum mycss_property_font_size_adjust {
	MyCSS_PROPERTY_FONT_SIZE_ADJUST_INITIAL = 0x0093,
	MyCSS_PROPERTY_FONT_SIZE_ADJUST_UNSET   = 0x016f,
	MyCSS_PROPERTY_FONT_SIZE_ADJUST_NONE    = 0x00d3,
	MyCSS_PROPERTY_FONT_SIZE_ADJUST__NUMBER = 0x019c,
	MyCSS_PROPERTY_FONT_SIZE_ADJUST_INHERIT = 0x0092
}
typedef mycss_property_font_size_adjust_t;

enum mycss_property_font_stretch {
	MyCSS_PROPERTY_FONT_STRETCH_ULTRA_CONDENSED = 0x0168,
	MyCSS_PROPERTY_FONT_STRETCH_EXTRA_CONDENSED = 0x006b,
	MyCSS_PROPERTY_FONT_STRETCH_EXPANDED        = 0x006a,
	MyCSS_PROPERTY_FONT_STRETCH_CONDENSED       = 0x0043,
	MyCSS_PROPERTY_FONT_STRETCH_ULTRA_EXPANDED  = 0x0169,
	MyCSS_PROPERTY_FONT_STRETCH_NORMAL          = 0x00d5,
	MyCSS_PROPERTY_FONT_STRETCH_SEMI_EXPANDED   = 0x0129,
	MyCSS_PROPERTY_FONT_STRETCH_SEMI_CONDENSED  = 0x0128,
	MyCSS_PROPERTY_FONT_STRETCH_EXTRA_EXPANDED  = 0x006c
}
typedef mycss_property_font_stretch_t;

enum mycss_property_font_style {
	MyCSS_PROPERTY_FONT_STYLE_NORMAL  = 0x00d5,
	MyCSS_PROPERTY_FONT_STYLE_ITALIC  = 0x00a2,
	MyCSS_PROPERTY_FONT_STYLE_OBLIQUE = 0x00e6,
	MyCSS_PROPERTY_FONT_STYLE_INHERIT = 0x0092,
	MyCSS_PROPERTY_FONT_STYLE_INITIAL = 0x0093,
	MyCSS_PROPERTY_FONT_STYLE_UNSET   = 0x016f
}
typedef mycss_property_font_style_t;

enum mycss_property_font_synthesis {
	MyCSS_PROPERTY_FONT_SYNTHESIS_NONE   = 0x00d3,
	MyCSS_PROPERTY_FONT_SYNTHESIS_STYLE  = 0x014f,
	MyCSS_PROPERTY_FONT_SYNTHESIS_WEIGHT = 0x017c
}
typedef mycss_property_font_synthesis_t;

enum mycss_property_font_variant {
	MyCSS_PROPERTY_FONT_VARIANT_HISTORICAL_FORMS = 0x008b,
	MyCSS_PROPERTY_FONT_VARIANT_PETITE_CAPS      = 0x0100,
	MyCSS_PROPERTY_FONT_VARIANT_UNICASE          = 0x016d,
	MyCSS_PROPERTY_FONT_VARIANT_RUBY             = 0x011d,
	MyCSS_PROPERTY_FONT_VARIANT_SMALL_CAPS       = 0x013a,
	MyCSS_PROPERTY_FONT_VARIANT_ORDINAL          = 0x00ee,
	MyCSS_PROPERTY_FONT_VARIANT_ALL_SMALL_CAPS   = 0x0014,
	MyCSS_PROPERTY_FONT_VARIANT_NORMAL           = 0x00d5,
	MyCSS_PROPERTY_FONT_VARIANT_ALL_PETITE_CAPS  = 0x0012,
	MyCSS_PROPERTY_FONT_VARIANT_TITLING_CAPS     = 0x0163,
	MyCSS_PROPERTY_FONT_VARIANT_SLASHED_ZERO     = 0x0135,
	MyCSS_PROPERTY_FONT_VARIANT_SUPER            = 0x0151,
	MyCSS_PROPERTY_FONT_VARIANT_SUB              = 0x0150,
	MyCSS_PROPERTY_FONT_VARIANT_NONE             = 0x00d3
}
typedef mycss_property_font_variant_t;

enum mycss_property_font_variant_alternates {
	MyCSS_PROPERTY_FONT_VARIANT_ALTERNATES_NORMAL           = 0x00d5,
	MyCSS_PROPERTY_FONT_VARIANT_ALTERNATES_HISTORICAL_FORMS = 0x008b
}
typedef mycss_property_font_variant_alternates_t;

enum mycss_property_font_variant_caps {
	MyCSS_PROPERTY_FONT_VARIANT_CAPS_SMALL_CAPS      = 0x013a,
	MyCSS_PROPERTY_FONT_VARIANT_CAPS_PETITE_CAPS     = 0x0100,
	MyCSS_PROPERTY_FONT_VARIANT_CAPS_NORMAL          = 0x00d5,
	MyCSS_PROPERTY_FONT_VARIANT_CAPS_UNICASE         = 0x016d,
	MyCSS_PROPERTY_FONT_VARIANT_CAPS_ALL_SMALL_CAPS  = 0x0014,
	MyCSS_PROPERTY_FONT_VARIANT_CAPS_ALL_PETITE_CAPS = 0x0012,
	MyCSS_PROPERTY_FONT_VARIANT_CAPS_TITLING_CAPS    = 0x0163
}
typedef mycss_property_font_variant_caps_t;

enum mycss_property_font_variant_east_asian {
	MyCSS_PROPERTY_FONT_VARIANT_EAST_ASIAN_PROPORTIONAL_WIDTH = 0x010a,
	MyCSS_PROPERTY_FONT_VARIANT_EAST_ASIAN_RUBY               = 0x011d,
	MyCSS_PROPERTY_FONT_VARIANT_EAST_ASIAN_JIS78              = 0x00a4,
	MyCSS_PROPERTY_FONT_VARIANT_EAST_ASIAN_NORMAL             = 0x00d5,
	MyCSS_PROPERTY_FONT_VARIANT_EAST_ASIAN_JIS83              = 0x00a5,
	MyCSS_PROPERTY_FONT_VARIANT_EAST_ASIAN_JIS90              = 0x00a6,
	MyCSS_PROPERTY_FONT_VARIANT_EAST_ASIAN_SIMPLIFIED         = 0x0133,
	MyCSS_PROPERTY_FONT_VARIANT_EAST_ASIAN_FULL_WIDTH         = 0x0080,
	MyCSS_PROPERTY_FONT_VARIANT_EAST_ASIAN_TRADITIONAL        = 0x0165,
	MyCSS_PROPERTY_FONT_VARIANT_EAST_ASIAN_JIS04              = 0x00a3
}
typedef mycss_property_font_variant_east_asian_t;

enum mycss_property_font_variant_ligatures {
	MyCSS_PROPERTY_FONT_VARIANT_LIGATURES_HISTORICAL_LIGATURES       = 0x008c,
	MyCSS_PROPERTY_FONT_VARIANT_LIGATURES_DISCRETIONARY_LIGATURES    = 0x0058,
	MyCSS_PROPERTY_FONT_VARIANT_LIGATURES_NO_DISCRETIONARY_LIGATURES = 0x00db,
	MyCSS_PROPERTY_FONT_VARIANT_LIGATURES_CONTEXTUAL                 = 0x0049,
	MyCSS_PROPERTY_FONT_VARIANT_LIGATURES_NO_CONTEXTUAL              = 0x00da,
	MyCSS_PROPERTY_FONT_VARIANT_LIGATURES_NO_COMMON_LIGATURES        = 0x00d8,
	MyCSS_PROPERTY_FONT_VARIANT_LIGATURES_NONE                       = 0x00d3,
	MyCSS_PROPERTY_FONT_VARIANT_LIGATURES_NORMAL                     = 0x00d5,
	MyCSS_PROPERTY_FONT_VARIANT_LIGATURES_COMMON_LIGATURES           = 0x0041,
	MyCSS_PROPERTY_FONT_VARIANT_LIGATURES_NO_HISTORICAL_LIGATURES    = 0x00de
}
typedef mycss_property_font_variant_ligatures_t;

enum mycss_property_font_variant_numeric {
	MyCSS_PROPERTY_FONT_VARIANT_NUMERIC_NORMAL             = 0x00d5,
	MyCSS_PROPERTY_FONT_VARIANT_NUMERIC_LINING_NUMS        = 0x00b5,
	MyCSS_PROPERTY_FONT_VARIANT_NUMERIC_TABULAR_NUMS       = 0x015d,
	MyCSS_PROPERTY_FONT_VARIANT_NUMERIC_OLDSTYLE_NUMS      = 0x00e8,
	MyCSS_PROPERTY_FONT_VARIANT_NUMERIC_PROPORTIONAL_NUMS  = 0x0109,
	MyCSS_PROPERTY_FONT_VARIANT_NUMERIC_STACKED_FRACTIONS  = 0x0145,
	MyCSS_PROPERTY_FONT_VARIANT_NUMERIC_DIAGONAL_FRACTIONS = 0x0055
}
typedef mycss_property_font_variant_numeric_t;

enum mycss_property_font_variant_position {
	MyCSS_PROPERTY_FONT_VARIANT_POSITION_SUB    = 0x0150,
	MyCSS_PROPERTY_FONT_VARIANT_POSITION_NORMAL = 0x00d5,
	MyCSS_PROPERTY_FONT_VARIANT_POSITION_SUPER  = 0x0151
}
typedef mycss_property_font_variant_position_t;

enum mycss_property_font_weight {
	MyCSS_PROPERTY_FONT_WEIGHT_500     = 0x0007,
	MyCSS_PROPERTY_FONT_WEIGHT_600     = 0x0008,
	MyCSS_PROPERTY_FONT_WEIGHT_700     = 0x0009,
	MyCSS_PROPERTY_FONT_WEIGHT_800     = 0x000a,
	MyCSS_PROPERTY_FONT_WEIGHT_900     = 0x000c,
	MyCSS_PROPERTY_FONT_WEIGHT_UNSET   = 0x016f,
	MyCSS_PROPERTY_FONT_WEIGHT_INHERIT = 0x0092,
	MyCSS_PROPERTY_FONT_WEIGHT_INITIAL = 0x0093,
	MyCSS_PROPERTY_FONT_WEIGHT_400     = 0x0006,
	MyCSS_PROPERTY_FONT_WEIGHT_BOLDER  = 0x0029,
	MyCSS_PROPERTY_FONT_WEIGHT_200     = 0x0004,
	MyCSS_PROPERTY_FONT_WEIGHT_LIGHTER = 0x00b0,
	MyCSS_PROPERTY_FONT_WEIGHT_300     = 0x0005,
	MyCSS_PROPERTY_FONT_WEIGHT_100     = 0x0003,
	MyCSS_PROPERTY_FONT_WEIGHT_BOLD    = 0x0028,
	MyCSS_PROPERTY_FONT_WEIGHT_NORMAL  = 0x00d5
}
typedef mycss_property_font_weight_t;

enum mycss_property_glyph_orientation_vertical {
	MyCSS_PROPERTY_GLYPH_ORIENTATION_VERTICAL_INITIAL = 0x0093,
	MyCSS_PROPERTY_GLYPH_ORIENTATION_VERTICAL_0       = 0x0001,
	MyCSS_PROPERTY_GLYPH_ORIENTATION_VERTICAL_AUTO    = 0x0018,
	MyCSS_PROPERTY_GLYPH_ORIENTATION_VERTICAL_0DEG    = 0x0002,
	MyCSS_PROPERTY_GLYPH_ORIENTATION_VERTICAL_90DEG   = 0x000d,
	MyCSS_PROPERTY_GLYPH_ORIENTATION_VERTICAL_90      = 0x000b,
	MyCSS_PROPERTY_GLYPH_ORIENTATION_VERTICAL_UNSET   = 0x016f,
	MyCSS_PROPERTY_GLYPH_ORIENTATION_VERTICAL_INHERIT = 0x0092
}
typedef mycss_property_glyph_orientation_vertical_t;

enum mycss_property_hanging_punctuation {
	MyCSS_PROPERTY_HANGING_PUNCTUATION_FORCE_END = 0x007d,
	MyCSS_PROPERTY_HANGING_PUNCTUATION_NONE      = 0x00d3,
	MyCSS_PROPERTY_HANGING_PUNCTUATION_LAST      = 0x00ac,
	MyCSS_PROPERTY_HANGING_PUNCTUATION_FIRST     = 0x0073,
	MyCSS_PROPERTY_HANGING_PUNCTUATION_ALLOW_END = 0x0011
}
typedef mycss_property_hanging_punctuation_t;

enum mycss_property_height {
	MyCSS_PROPERTY_HEIGHT_AUTO        = 0x0018,
	MyCSS_PROPERTY_HEIGHT__LENGTH     = 0x019a,
	MyCSS_PROPERTY_HEIGHT_COMPLEX     = 0x0042,
	MyCSS_PROPERTY_HEIGHT_AVAILABLE   = 0x0019,
	MyCSS_PROPERTY_HEIGHT__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_HEIGHT_MIN_CONTENT = 0x00cb,
	MyCSS_PROPERTY_HEIGHT_MAX_CONTENT = 0x00c5,
	MyCSS_PROPERTY_HEIGHT_FIT_CONTENT = 0x0075,
	MyCSS_PROPERTY_HEIGHT_UNSET       = 0x016f,
	MyCSS_PROPERTY_HEIGHT_INHERIT     = 0x0092,
	MyCSS_PROPERTY_HEIGHT_INITIAL     = 0x0093
}
typedef mycss_property_height_t;

enum mycss_property_hyphens {
	MyCSS_PROPERTY_HYPHENS_INHERIT = 0x0092,
	MyCSS_PROPERTY_HYPHENS_INITIAL = 0x0093,
	MyCSS_PROPERTY_HYPHENS_NONE    = 0x00d3,
	MyCSS_PROPERTY_HYPHENS_UNSET   = 0x016f,
	MyCSS_PROPERTY_HYPHENS_AUTO    = 0x0018,
	MyCSS_PROPERTY_HYPHENS_MANUAL  = 0x00c1
}
typedef mycss_property_hyphens_t;

enum mycss_property_image_rendering {
	MyCSS_PROPERTY_IMAGE_RENDERING_INHERIT         = 0x0092,
	MyCSS_PROPERTY_IMAGE_RENDERING_OPTIMIZESPEED   = 0x00ed,
	MyCSS_PROPERTY_IMAGE_RENDERING_OPTIMIZEQUALITY = 0x00ec,
	MyCSS_PROPERTY_IMAGE_RENDERING_AUTO            = 0x0018
}
typedef mycss_property_image_rendering_t;

enum mycss_property_indent_edge_reset {
	MyCSS_PROPERTY_INDENT_EDGE_RESET_NONE         = 0x00d3,
	MyCSS_PROPERTY_INDENT_EDGE_RESET_MARGIN_EDGE  = 0x00c2,
	MyCSS_PROPERTY_INDENT_EDGE_RESET_BORDER_EDGE  = 0x002b,
	MyCSS_PROPERTY_INDENT_EDGE_RESET_PADDING_EDGE = 0x00f5,
	MyCSS_PROPERTY_INDENT_EDGE_RESET_CONTENT_EDGE = 0x0048
}
typedef mycss_property_indent_edge_reset_t;

enum mycss_property_justify_content {
	MyCSS_PROPERTY_JUSTIFY_CONTENT_FLEX_START    = 0x007a,
	MyCSS_PROPERTY_JUSTIFY_CONTENT_CENTER        = 0x0037,
	MyCSS_PROPERTY_JUSTIFY_CONTENT_FLEX_END      = 0x0079,
	MyCSS_PROPERTY_JUSTIFY_CONTENT_SPACE_AROUND  = 0x0140,
	MyCSS_PROPERTY_JUSTIFY_CONTENT_SPACE_BETWEEN = 0x0141
}
typedef mycss_property_justify_content_t;

enum mycss_property_left {
	MyCSS_PROPERTY_LEFT__LENGTH     = 0x019a,
	MyCSS_PROPERTY_LEFT_UNSET       = 0x016f,
	MyCSS_PROPERTY_LEFT__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_LEFT_INHERIT     = 0x0092,
	MyCSS_PROPERTY_LEFT_AUTO        = 0x0018,
	MyCSS_PROPERTY_LEFT_INITIAL     = 0x0093
}
typedef mycss_property_left_t;

enum mycss_property_letter_spacing {
	MyCSS_PROPERTY_LETTER_SPACING__LENGTH = 0x019a,
	MyCSS_PROPERTY_LETTER_SPACING_INHERIT = 0x0092,
	MyCSS_PROPERTY_LETTER_SPACING_NORMAL  = 0x00d5,
	MyCSS_PROPERTY_LETTER_SPACING_INITIAL = 0x0093,
	MyCSS_PROPERTY_LETTER_SPACING_UNSET   = 0x016f
}
typedef mycss_property_letter_spacing_t;

enum mycss_property_line_break {
	MyCSS_PROPERTY_LINE_BREAK_NORMAL  = 0x00d5,
	MyCSS_PROPERTY_LINE_BREAK_UNSET   = 0x016f,
	MyCSS_PROPERTY_LINE_BREAK_STRICT  = 0x014d,
	MyCSS_PROPERTY_LINE_BREAK_INHERIT = 0x0092,
	MyCSS_PROPERTY_LINE_BREAK_INITIAL = 0x0093,
	MyCSS_PROPERTY_LINE_BREAK_AUTO    = 0x0018,
	MyCSS_PROPERTY_LINE_BREAK_LOOSE   = 0x00ba
}
typedef mycss_property_line_break_t;

enum mycss_property_line_height {
	MyCSS_PROPERTY_LINE_HEIGHT_UNSET       = 0x016f,
	MyCSS_PROPERTY_LINE_HEIGHT_NORMAL      = 0x00d5,
	MyCSS_PROPERTY_LINE_HEIGHT__NUMBER     = 0x019c,
	MyCSS_PROPERTY_LINE_HEIGHT__LENGTH     = 0x019a,
	MyCSS_PROPERTY_LINE_HEIGHT__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_LINE_HEIGHT_INHERIT     = 0x0092,
	MyCSS_PROPERTY_LINE_HEIGHT_INITIAL     = 0x0093
}
typedef mycss_property_line_height_t;

enum mycss_property_list_style_image {
	MyCSS_PROPERTY_LIST_STYLE_IMAGE_NONE = 0x00d3
}
typedef mycss_property_list_style_image_t;

enum mycss_property_list_style_position {
	MyCSS_PROPERTY_LIST_STYLE_POSITION_INSIDE  = 0x009c,
	MyCSS_PROPERTY_LIST_STYLE_POSITION_OUTSIDE = 0x00f0
}
typedef mycss_property_list_style_position_t;

enum mycss_property_list_style_type {
	MyCSS_PROPERTY_LIST_STYLE_TYPE_NONE = 0x00d3
}
typedef mycss_property_list_style_type_t;

enum mycss_property_margin {
	MyCSS_PROPERTY_MARGIN_AUTO        = 0x0018,
	MyCSS_PROPERTY_MARGIN_UNSET       = 0x016f,
	MyCSS_PROPERTY_MARGIN__LENGTH     = 0x019a,
	MyCSS_PROPERTY_MARGIN_INHERIT     = 0x0092,
	MyCSS_PROPERTY_MARGIN_INITIAL     = 0x0093,
	MyCSS_PROPERTY_MARGIN__PERCENTAGE = 0x019d
}
typedef mycss_property_margin_t;

enum mycss_property_margin_block_end {
	MyCSS_PROPERTY_MARGIN_BLOCK_END_AUTO        = 0x0018,
	MyCSS_PROPERTY_MARGIN_BLOCK_END_UNSET       = 0x016f,
	MyCSS_PROPERTY_MARGIN_BLOCK_END__LENGTH     = 0x019a,
	MyCSS_PROPERTY_MARGIN_BLOCK_END_INHERIT     = 0x0092,
	MyCSS_PROPERTY_MARGIN_BLOCK_END_INITIAL     = 0x0093,
	MyCSS_PROPERTY_MARGIN_BLOCK_END__PERCENTAGE = 0x019d
}
typedef mycss_property_margin_block_end_t;

enum mycss_property_margin_block_start {
	MyCSS_PROPERTY_MARGIN_BLOCK_START_AUTO        = 0x0018,
	MyCSS_PROPERTY_MARGIN_BLOCK_START_UNSET       = 0x016f,
	MyCSS_PROPERTY_MARGIN_BLOCK_START__LENGTH     = 0x019a,
	MyCSS_PROPERTY_MARGIN_BLOCK_START_INHERIT     = 0x0092,
	MyCSS_PROPERTY_MARGIN_BLOCK_START_INITIAL     = 0x0093,
	MyCSS_PROPERTY_MARGIN_BLOCK_START__PERCENTAGE = 0x019d
}
typedef mycss_property_margin_block_start_t;

enum mycss_property_margin_bottom {
	MyCSS_PROPERTY_MARGIN_BOTTOM_AUTO        = 0x0018,
	MyCSS_PROPERTY_MARGIN_BOTTOM_UNSET       = 0x016f,
	MyCSS_PROPERTY_MARGIN_BOTTOM__LENGTH     = 0x019a,
	MyCSS_PROPERTY_MARGIN_BOTTOM_INHERIT     = 0x0092,
	MyCSS_PROPERTY_MARGIN_BOTTOM_INITIAL     = 0x0093,
	MyCSS_PROPERTY_MARGIN_BOTTOM__PERCENTAGE = 0x019d
}
typedef mycss_property_margin_bottom_t;

enum mycss_property_margin_inline_end {
	MyCSS_PROPERTY_MARGIN_INLINE_END_AUTO        = 0x0018,
	MyCSS_PROPERTY_MARGIN_INLINE_END_UNSET       = 0x016f,
	MyCSS_PROPERTY_MARGIN_INLINE_END__LENGTH     = 0x019a,
	MyCSS_PROPERTY_MARGIN_INLINE_END_INHERIT     = 0x0092,
	MyCSS_PROPERTY_MARGIN_INLINE_END_INITIAL     = 0x0093,
	MyCSS_PROPERTY_MARGIN_INLINE_END__PERCENTAGE = 0x019d
}
typedef mycss_property_margin_inline_end_t;

enum mycss_property_margin_inline_start {
	MyCSS_PROPERTY_MARGIN_INLINE_START_AUTO        = 0x0018,
	MyCSS_PROPERTY_MARGIN_INLINE_START_UNSET       = 0x016f,
	MyCSS_PROPERTY_MARGIN_INLINE_START__LENGTH     = 0x019a,
	MyCSS_PROPERTY_MARGIN_INLINE_START_INHERIT     = 0x0092,
	MyCSS_PROPERTY_MARGIN_INLINE_START_INITIAL     = 0x0093,
	MyCSS_PROPERTY_MARGIN_INLINE_START__PERCENTAGE = 0x019d
}
typedef mycss_property_margin_inline_start_t;

enum mycss_property_margin_left {
	MyCSS_PROPERTY_MARGIN_LEFT_AUTO        = 0x0018,
	MyCSS_PROPERTY_MARGIN_LEFT_UNSET       = 0x016f,
	MyCSS_PROPERTY_MARGIN_LEFT__LENGTH     = 0x019a,
	MyCSS_PROPERTY_MARGIN_LEFT_INHERIT     = 0x0092,
	MyCSS_PROPERTY_MARGIN_LEFT_INITIAL     = 0x0093,
	MyCSS_PROPERTY_MARGIN_LEFT__PERCENTAGE = 0x019d
}
typedef mycss_property_margin_left_t;

enum mycss_property_margin_right {
	MyCSS_PROPERTY_MARGIN_RIGHT_UNSET       = 0x016f,
	MyCSS_PROPERTY_MARGIN_RIGHT__LENGTH     = 0x019a,
	MyCSS_PROPERTY_MARGIN_RIGHT_INHERIT     = 0x0092,
	MyCSS_PROPERTY_MARGIN_RIGHT_INITIAL     = 0x0093,
	MyCSS_PROPERTY_MARGIN_RIGHT__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_MARGIN_RIGHT_AUTO        = 0x0018
}
typedef mycss_property_margin_right_t;

enum mycss_property_margin_top {
	MyCSS_PROPERTY_MARGIN_TOP__LENGTH     = 0x019a,
	MyCSS_PROPERTY_MARGIN_TOP_INHERIT     = 0x0092,
	MyCSS_PROPERTY_MARGIN_TOP_INITIAL     = 0x0093,
	MyCSS_PROPERTY_MARGIN_TOP__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_MARGIN_TOP_AUTO        = 0x0018,
	MyCSS_PROPERTY_MARGIN_TOP_UNSET       = 0x016f
}
typedef mycss_property_margin_top_t;

enum mycss_property_marker_end {
	MyCSS_PROPERTY_MARKER_END_NONE = 0x00d3
}
typedef mycss_property_marker_end_t;

enum mycss_property_marker_mid {
	MyCSS_PROPERTY_MARKER_MID_NONE = 0x00d3
}
typedef mycss_property_marker_mid_t;

enum mycss_property_marker_side {
	MyCSS_PROPERTY_MARKER_SIDE_LIST_CONTAINER = 0x00b6,
	MyCSS_PROPERTY_MARKER_SIDE_LIST_ITEM      = 0x00b7
}
typedef mycss_property_marker_side_t;

enum mycss_property_marker_start {
	MyCSS_PROPERTY_MARKER_START_NONE = 0x00d3
}
typedef mycss_property_marker_start_t;

enum mycss_property_max_height {
	MyCSS_PROPERTY_MAX_HEIGHT_INHERIT     = 0x0092,
	MyCSS_PROPERTY_MAX_HEIGHT_INITIAL     = 0x0093,
	MyCSS_PROPERTY_MAX_HEIGHT__LENGTH     = 0x019a,
	MyCSS_PROPERTY_MAX_HEIGHT_UNSET       = 0x016f,
	MyCSS_PROPERTY_MAX_HEIGHT__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_MAX_HEIGHT_NONE        = 0x00d3
}
typedef mycss_property_max_height_t;

enum mycss_property_max_lines {
	MyCSS_PROPERTY_MAX_LINES_NONE = 0x00d3
}
typedef mycss_property_max_lines_t;

enum mycss_property_max_width {
	MyCSS_PROPERTY_MAX_WIDTH_NONE        = 0x00d3,
	MyCSS_PROPERTY_MAX_WIDTH__LENGTH     = 0x019a,
	MyCSS_PROPERTY_MAX_WIDTH_UNSET       = 0x016f,
	MyCSS_PROPERTY_MAX_WIDTH__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_MAX_WIDTH_INHERIT     = 0x0092,
	MyCSS_PROPERTY_MAX_WIDTH_INITIAL     = 0x0093
}
typedef mycss_property_max_width_t;

enum mycss_property_min_height {
	MyCSS_PROPERTY_MIN_HEIGHT_UNSET       = 0x016f,
	MyCSS_PROPERTY_MIN_HEIGHT__LENGTH     = 0x019a,
	MyCSS_PROPERTY_MIN_HEIGHT_INHERIT     = 0x0092,
	MyCSS_PROPERTY_MIN_HEIGHT_INITIAL     = 0x0093,
	MyCSS_PROPERTY_MIN_HEIGHT__PERCENTAGE = 0x019d
}
typedef mycss_property_min_height_t;

enum mycss_property_min_width {
	MyCSS_PROPERTY_MIN_WIDTH_INITIAL     = 0x0093,
	MyCSS_PROPERTY_MIN_WIDTH__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_MIN_WIDTH_UNSET       = 0x016f,
	MyCSS_PROPERTY_MIN_WIDTH__LENGTH     = 0x019a,
	MyCSS_PROPERTY_MIN_WIDTH_INHERIT     = 0x0092
}
typedef mycss_property_min_width_t;

enum mycss_property_nav_down {
	MyCSS_PROPERTY_NAV_DOWN_AUTO    = 0x0018,
	MyCSS_PROPERTY_NAV_DOWN_ROOT    = 0x0117,
	MyCSS_PROPERTY_NAV_DOWN_CURRENT = 0x004f
}
typedef mycss_property_nav_down_t;

enum mycss_property_nav_left {
	MyCSS_PROPERTY_NAV_LEFT_AUTO    = 0x0018,
	MyCSS_PROPERTY_NAV_LEFT_ROOT    = 0x0117,
	MyCSS_PROPERTY_NAV_LEFT_CURRENT = 0x004f
}
typedef mycss_property_nav_left_t;

enum mycss_property_nav_right {
	MyCSS_PROPERTY_NAV_RIGHT_ROOT    = 0x0117,
	MyCSS_PROPERTY_NAV_RIGHT_AUTO    = 0x0018,
	MyCSS_PROPERTY_NAV_RIGHT_CURRENT = 0x004f
}
typedef mycss_property_nav_right_t;

enum mycss_property_nav_up {
	MyCSS_PROPERTY_NAV_UP_AUTO    = 0x0018,
	MyCSS_PROPERTY_NAV_UP_ROOT    = 0x0117,
	MyCSS_PROPERTY_NAV_UP_CURRENT = 0x004f
}
typedef mycss_property_nav_up_t;

enum mycss_property_offset_after {
	MyCSS_PROPERTY_OFFSET_AFTER_AUTO = 0x0018
}
typedef mycss_property_offset_after_t;

enum mycss_property_offset_before {
	MyCSS_PROPERTY_OFFSET_BEFORE_AUTO = 0x0018
}
typedef mycss_property_offset_before_t;

enum mycss_property_offset_end {
	MyCSS_PROPERTY_OFFSET_END_AUTO = 0x0018
}
typedef mycss_property_offset_end_t;

enum mycss_property_offset_start {
	MyCSS_PROPERTY_OFFSET_START_AUTO = 0x0018
}
typedef mycss_property_offset_start_t;

enum mycss_property_outline_color {
	MyCSS_PROPERTY_OUTLINE_COLOR_INVERT = 0x009f
}
typedef mycss_property_outline_color_t;

enum mycss_property_outline_style {
	MyCSS_PROPERTY_OUTLINE_STYLE_NONE = 0x00d3,
	MyCSS_PROPERTY_OUTLINE_STYLE_AUTO = 0x0018
}
typedef mycss_property_outline_style_t;

enum mycss_property_outline_width {
	MyCSS_PROPERTY_OUTLINE_WIDTH_MEDIUM = 0x00c6
}
typedef mycss_property_outline_width_t;

enum mycss_property_overflow {
	MyCSS_PROPERTY_OVERFLOW_HIDDEN     = 0x0088,
	MyCSS_PROPERTY_OVERFLOW_VISIBLE    = 0x0178,
	MyCSS_PROPERTY_OVERFLOW_AUTO       = 0x0018,
	MyCSS_PROPERTY_OVERFLOW_SCROLL     = 0x0126,
	MyCSS_PROPERTY_OVERFLOW_UNSET      = 0x016f,
	MyCSS_PROPERTY_OVERFLOW_INHERIT    = 0x0092,
	MyCSS_PROPERTY_OVERFLOW_NO_DISPLAY = 0x00dc,
	MyCSS_PROPERTY_OVERFLOW_NO_CONTENT = 0x00d9,
	MyCSS_PROPERTY_OVERFLOW_INITIAL    = 0x0093
}
typedef mycss_property_overflow_t;

enum mycss_property_overflow_wrap {
	MyCSS_PROPERTY_OVERFLOW_WRAP_INITIAL      = 0x0093,
	MyCSS_PROPERTY_OVERFLOW_WRAP_UNSET        = 0x016f,
	MyCSS_PROPERTY_OVERFLOW_WRAP_BREAK_WORD   = 0x0032,
	MyCSS_PROPERTY_OVERFLOW_WRAP_INHERIT      = 0x0092,
	MyCSS_PROPERTY_OVERFLOW_WRAP_BREAK_SPACES = 0x0031,
	MyCSS_PROPERTY_OVERFLOW_WRAP_NORMAL       = 0x00d5
}
typedef mycss_property_overflow_wrap_t;

enum mycss_property_overflow_x {
	MyCSS_PROPERTY_OVERFLOW_X_NO_DISPLAY = 0x00dc,
	MyCSS_PROPERTY_OVERFLOW_X_INHERIT    = 0x0092,
	MyCSS_PROPERTY_OVERFLOW_X_UNSET      = 0x016f,
	MyCSS_PROPERTY_OVERFLOW_X_NO_CONTENT = 0x00d9,
	MyCSS_PROPERTY_OVERFLOW_X_INITIAL    = 0x0093,
	MyCSS_PROPERTY_OVERFLOW_X_AUTO       = 0x0018,
	MyCSS_PROPERTY_OVERFLOW_X_HIDDEN     = 0x0088,
	MyCSS_PROPERTY_OVERFLOW_X_VISIBLE    = 0x0178,
	MyCSS_PROPERTY_OVERFLOW_X_SCROLL     = 0x0126
}
typedef mycss_property_overflow_x_t;

enum mycss_property_overflow_y {
	MyCSS_PROPERTY_OVERFLOW_Y_AUTO       = 0x0018,
	MyCSS_PROPERTY_OVERFLOW_Y_HIDDEN     = 0x0088,
	MyCSS_PROPERTY_OVERFLOW_Y_VISIBLE    = 0x0178,
	MyCSS_PROPERTY_OVERFLOW_Y_SCROLL     = 0x0126,
	MyCSS_PROPERTY_OVERFLOW_Y_UNSET      = 0x016f,
	MyCSS_PROPERTY_OVERFLOW_Y_INHERIT    = 0x0092,
	MyCSS_PROPERTY_OVERFLOW_Y_NO_DISPLAY = 0x00dc,
	MyCSS_PROPERTY_OVERFLOW_Y_NO_CONTENT = 0x00d9,
	MyCSS_PROPERTY_OVERFLOW_Y_INITIAL    = 0x0093
}
typedef mycss_property_overflow_y_t;

enum mycss_property_padding {
	MyCSS_PROPERTY_PADDING_UNSET       = 0x016f,
	MyCSS_PROPERTY_PADDING__LENGTH     = 0x019a,
	MyCSS_PROPERTY_PADDING_INHERIT     = 0x0092,
	MyCSS_PROPERTY_PADDING_INITIAL     = 0x0093,
	MyCSS_PROPERTY_PADDING__PERCENTAGE = 0x019d
}
typedef mycss_property_padding_t;

enum mycss_property_padding_block_end {
	MyCSS_PROPERTY_PADDING_BLOCK_END_UNSET       = 0x016f,
	MyCSS_PROPERTY_PADDING_BLOCK_END__LENGTH     = 0x019a,
	MyCSS_PROPERTY_PADDING_BLOCK_END_INHERIT     = 0x0092,
	MyCSS_PROPERTY_PADDING_BLOCK_END_INITIAL     = 0x0093,
	MyCSS_PROPERTY_PADDING_BLOCK_END__PERCENTAGE = 0x019d
}
typedef mycss_property_padding_block_end_t;

enum mycss_property_padding_block_start {
	MyCSS_PROPERTY_PADDING_BLOCK_START_UNSET       = 0x016f,
	MyCSS_PROPERTY_PADDING_BLOCK_START__LENGTH     = 0x019a,
	MyCSS_PROPERTY_PADDING_BLOCK_START_INHERIT     = 0x0092,
	MyCSS_PROPERTY_PADDING_BLOCK_START_INITIAL     = 0x0093,
	MyCSS_PROPERTY_PADDING_BLOCK_START__PERCENTAGE = 0x019d
}
typedef mycss_property_padding_block_start_t;

enum mycss_property_padding_bottom {
	MyCSS_PROPERTY_PADDING_BOTTOM_UNSET       = 0x016f,
	MyCSS_PROPERTY_PADDING_BOTTOM__LENGTH     = 0x019a,
	MyCSS_PROPERTY_PADDING_BOTTOM_INHERIT     = 0x0092,
	MyCSS_PROPERTY_PADDING_BOTTOM_INITIAL     = 0x0093,
	MyCSS_PROPERTY_PADDING_BOTTOM__PERCENTAGE = 0x019d
}
typedef mycss_property_padding_bottom_t;

enum mycss_property_padding_inline_end {
	MyCSS_PROPERTY_PADDING_INLINE_END_UNSET       = 0x016f,
	MyCSS_PROPERTY_PADDING_INLINE_END__LENGTH     = 0x019a,
	MyCSS_PROPERTY_PADDING_INLINE_END_INHERIT     = 0x0092,
	MyCSS_PROPERTY_PADDING_INLINE_END_INITIAL     = 0x0093,
	MyCSS_PROPERTY_PADDING_INLINE_END__PERCENTAGE = 0x019d
}
typedef mycss_property_padding_inline_end_t;

enum mycss_property_padding_inline_start {
	MyCSS_PROPERTY_PADDING_INLINE_START_UNSET       = 0x016f,
	MyCSS_PROPERTY_PADDING_INLINE_START__LENGTH     = 0x019a,
	MyCSS_PROPERTY_PADDING_INLINE_START_INHERIT     = 0x0092,
	MyCSS_PROPERTY_PADDING_INLINE_START_INITIAL     = 0x0093,
	MyCSS_PROPERTY_PADDING_INLINE_START__PERCENTAGE = 0x019d
}
typedef mycss_property_padding_inline_start_t;

enum mycss_property_padding_left {
	MyCSS_PROPERTY_PADDING_LEFT_UNSET       = 0x016f,
	MyCSS_PROPERTY_PADDING_LEFT__LENGTH     = 0x019a,
	MyCSS_PROPERTY_PADDING_LEFT_INHERIT     = 0x0092,
	MyCSS_PROPERTY_PADDING_LEFT_INITIAL     = 0x0093,
	MyCSS_PROPERTY_PADDING_LEFT__PERCENTAGE = 0x019d
}
typedef mycss_property_padding_left_t;

enum mycss_property_padding_right {
	MyCSS_PROPERTY_PADDING_RIGHT_INITIAL     = 0x0093,
	MyCSS_PROPERTY_PADDING_RIGHT__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_PADDING_RIGHT_UNSET       = 0x016f,
	MyCSS_PROPERTY_PADDING_RIGHT__LENGTH     = 0x019a,
	MyCSS_PROPERTY_PADDING_RIGHT_INHERIT     = 0x0092
}
typedef mycss_property_padding_right_t;

enum mycss_property_padding_top {
	MyCSS_PROPERTY_PADDING_TOP_UNSET       = 0x016f,
	MyCSS_PROPERTY_PADDING_TOP__LENGTH     = 0x019a,
	MyCSS_PROPERTY_PADDING_TOP_INHERIT     = 0x0092,
	MyCSS_PROPERTY_PADDING_TOP_INITIAL     = 0x0093,
	MyCSS_PROPERTY_PADDING_TOP__PERCENTAGE = 0x019d
}
typedef mycss_property_padding_top_t;

enum mycss_property_pause_after {
	MyCSS_PROPERTY_PAUSE_AFTER_WEAK     = 0x017b,
	MyCSS_PROPERTY_PAUSE_AFTER_STRONG   = 0x014e,
	MyCSS_PROPERTY_PAUSE_AFTER_MEDIUM   = 0x00c6,
	MyCSS_PROPERTY_PAUSE_AFTER_X_STRONG = 0x018b,
	MyCSS_PROPERTY_PAUSE_AFTER_X_WEAK   = 0x018c,
	MyCSS_PROPERTY_PAUSE_AFTER_NONE     = 0x00d3
}
typedef mycss_property_pause_after_t;

enum mycss_property_pause_before {
	MyCSS_PROPERTY_PAUSE_BEFORE_NONE     = 0x00d3,
	MyCSS_PROPERTY_PAUSE_BEFORE_WEAK     = 0x017b,
	MyCSS_PROPERTY_PAUSE_BEFORE_X_WEAK   = 0x018c,
	MyCSS_PROPERTY_PAUSE_BEFORE_MEDIUM   = 0x00c6,
	MyCSS_PROPERTY_PAUSE_BEFORE_STRONG   = 0x014e,
	MyCSS_PROPERTY_PAUSE_BEFORE_X_STRONG = 0x018b
}
typedef mycss_property_pause_before_t;

enum mycss_property_perspective {
	MyCSS_PROPERTY_PERSPECTIVE_NONE = 0x00d3
}
typedef mycss_property_perspective_t;

enum mycss_property_perspective_origin {
	MyCSS_PROPERTY_PERSPECTIVE_ORIGIN_RIGHT  = 0x0115,
	MyCSS_PROPERTY_PERSPECTIVE_ORIGIN_CENTER = 0x0037,
	MyCSS_PROPERTY_PERSPECTIVE_ORIGIN_TOP    = 0x0164,
	MyCSS_PROPERTY_PERSPECTIVE_ORIGIN_BOTTOM = 0x002d,
	MyCSS_PROPERTY_PERSPECTIVE_ORIGIN_LEFT   = 0x00ae
}
typedef mycss_property_perspective_origin_t;

enum mycss_property_position {
	MyCSS_PROPERTY_POSITION_INITIAL  = 0x0093,
	MyCSS_PROPERTY_POSITION_UNSET    = 0x016f,
	MyCSS_PROPERTY_POSITION_INHERIT  = 0x0092,
	MyCSS_PROPERTY_POSITION_RELATIVE = 0x010f,
	MyCSS_PROPERTY_POSITION_ABSOLUTE = 0x000e,
	MyCSS_PROPERTY_POSITION_STICKY   = 0x014b,
	MyCSS_PROPERTY_POSITION_FIXED    = 0x0076,
	MyCSS_PROPERTY_POSITION_STATIC   = 0x0147
}
typedef mycss_property_position_t;

enum mycss_property_presentation_level {
	MyCSS_PROPERTY_PRESENTATION_LEVEL_INCREMENT = 0x0090,
	MyCSS_PROPERTY_PRESENTATION_LEVEL_SAME      = 0x0124
}
typedef mycss_property_presentation_level_t;

enum mycss_property_quotes {
	MyCSS_PROPERTY_QUOTES_NONE = 0x00d3
}
typedef mycss_property_quotes_t;

enum mycss_property_region_fragment {
	MyCSS_PROPERTY_REGION_FRAGMENT_AUTO  = 0x0018,
	MyCSS_PROPERTY_REGION_FRAGMENT_BREAK = 0x002f
}
typedef mycss_property_region_fragment_t;

enum mycss_property_resize {
	MyCSS_PROPERTY_RESIZE_BOTH       = 0x002c,
	MyCSS_PROPERTY_RESIZE_NONE       = 0x00d3,
	MyCSS_PROPERTY_RESIZE_VERTICAL   = 0x0173,
	MyCSS_PROPERTY_RESIZE_HORIZONTAL = 0x008d
}
typedef mycss_property_resize_t;

enum mycss_property_rest_after {
	MyCSS_PROPERTY_REST_AFTER_X_WEAK   = 0x018c,
	MyCSS_PROPERTY_REST_AFTER_WEAK     = 0x017b,
	MyCSS_PROPERTY_REST_AFTER_MEDIUM   = 0x00c6,
	MyCSS_PROPERTY_REST_AFTER_NONE     = 0x00d3,
	MyCSS_PROPERTY_REST_AFTER_STRONG   = 0x014e,
	MyCSS_PROPERTY_REST_AFTER_X_STRONG = 0x018b
}
typedef mycss_property_rest_after_t;

enum mycss_property_rest_before {
	MyCSS_PROPERTY_REST_BEFORE_NONE     = 0x00d3,
	MyCSS_PROPERTY_REST_BEFORE_MEDIUM   = 0x00c6,
	MyCSS_PROPERTY_REST_BEFORE_STRONG   = 0x014e,
	MyCSS_PROPERTY_REST_BEFORE_WEAK     = 0x017b,
	MyCSS_PROPERTY_REST_BEFORE_X_WEAK   = 0x018c,
	MyCSS_PROPERTY_REST_BEFORE_X_STRONG = 0x018b
}
typedef mycss_property_rest_before_t;

enum mycss_property_right {
	MyCSS_PROPERTY_RIGHT__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_RIGHT_INHERIT     = 0x0092,
	MyCSS_PROPERTY_RIGHT__LENGTH     = 0x019a,
	MyCSS_PROPERTY_RIGHT_UNSET       = 0x016f,
	MyCSS_PROPERTY_RIGHT_INITIAL     = 0x0093,
	MyCSS_PROPERTY_RIGHT_AUTO        = 0x0018
}
typedef mycss_property_right_t;

enum mycss_property_ruby_align {
	MyCSS_PROPERTY_RUBY_ALIGN_CENTER        = 0x0037,
	MyCSS_PROPERTY_RUBY_ALIGN_START         = 0x0146,
	MyCSS_PROPERTY_RUBY_ALIGN_SPACE_AROUND  = 0x0140,
	MyCSS_PROPERTY_RUBY_ALIGN_SPACE_BETWEEN = 0x0141
}
typedef mycss_property_ruby_align_t;

enum mycss_property_ruby_merge {
	MyCSS_PROPERTY_RUBY_MERGE_AUTO     = 0x0018,
	MyCSS_PROPERTY_RUBY_MERGE_SEPARATE = 0x012a,
	MyCSS_PROPERTY_RUBY_MERGE_COLLAPSE = 0x003d
}
typedef mycss_property_ruby_merge_t;

enum mycss_property_ruby_position {
	MyCSS_PROPERTY_RUBY_POSITION_INTER_CHARACTER = 0x009d,
	MyCSS_PROPERTY_RUBY_POSITION_UNDER           = 0x016a,
	MyCSS_PROPERTY_RUBY_POSITION_OVER            = 0x00f1
}
typedef mycss_property_ruby_position_t;

enum mycss_property_scroll_snap_align {
	MyCSS_PROPERTY_SCROLL_SNAP_ALIGN_END    = 0x0066,
	MyCSS_PROPERTY_SCROLL_SNAP_ALIGN_NONE   = 0x00d3,
	MyCSS_PROPERTY_SCROLL_SNAP_ALIGN_START  = 0x0146,
	MyCSS_PROPERTY_SCROLL_SNAP_ALIGN_CENTER = 0x0037
}
typedef mycss_property_scroll_snap_align_t;

enum mycss_property_scroll_snap_stop {
	MyCSS_PROPERTY_SCROLL_SNAP_STOP_NORMAL = 0x00d5,
	MyCSS_PROPERTY_SCROLL_SNAP_STOP_ALWAYS = 0x0017
}
typedef mycss_property_scroll_snap_stop_t;

enum mycss_property_scroll_snap_type {
	MyCSS_PROPERTY_SCROLL_SNAP_TYPE_BLOCK     = 0x0026,
	MyCSS_PROPERTY_SCROLL_SNAP_TYPE_X         = 0x0180,
	MyCSS_PROPERTY_SCROLL_SNAP_TYPE_INLINE    = 0x0095,
	MyCSS_PROPERTY_SCROLL_SNAP_TYPE_BOTH      = 0x002c,
	MyCSS_PROPERTY_SCROLL_SNAP_TYPE_MANDATORY = 0x00bf,
	MyCSS_PROPERTY_SCROLL_SNAP_TYPE_PROXIMITY = 0x010b,
	MyCSS_PROPERTY_SCROLL_SNAP_TYPE_NONE      = 0x00d3,
	MyCSS_PROPERTY_SCROLL_SNAP_TYPE_Y         = 0x018d
}
typedef mycss_property_scroll_snap_type_t;

enum mycss_property_shape_outside {
	MyCSS_PROPERTY_SHAPE_OUTSIDE_NONE = 0x00d3
}
typedef mycss_property_shape_outside_t;

enum mycss_property_shape_rendering {
	MyCSS_PROPERTY_SHAPE_RENDERING_AUTO               = 0x0018,
	MyCSS_PROPERTY_SHAPE_RENDERING_INHERIT            = 0x0092,
	MyCSS_PROPERTY_SHAPE_RENDERING_CRISPEDGES         = 0x004d,
	MyCSS_PROPERTY_SHAPE_RENDERING_OPTIMIZESPEED      = 0x00ed,
	MyCSS_PROPERTY_SHAPE_RENDERING_GEOMETRICPRECISION = 0x0081
}
typedef mycss_property_shape_rendering_t;

enum mycss_property_speak {
	MyCSS_PROPERTY_SPEAK_AUTO   = 0x0018,
	MyCSS_PROPERTY_SPEAK_NONE   = 0x00d3,
	MyCSS_PROPERTY_SPEAK_NORMAL = 0x00d5
}
typedef mycss_property_speak_t;

enum mycss_property_speak_as {
	MyCSS_PROPERTY_SPEAK_AS_LITERAL_PUNCTUATION = 0x00b8,
	MyCSS_PROPERTY_SPEAK_AS_NO_PUNCTUATION      = 0x00df,
	MyCSS_PROPERTY_SPEAK_AS_NORMAL              = 0x00d5,
	MyCSS_PROPERTY_SPEAK_AS_DIGITS              = 0x0056,
	MyCSS_PROPERTY_SPEAK_AS_SPELL_OUT           = 0x0142
}
typedef mycss_property_speak_as_t;

enum mycss_property_string_set {
	MyCSS_PROPERTY_STRING_SET_NONE = 0x00d3
}
typedef mycss_property_string_set_t;

enum mycss_property_stroke {
	MyCSS_PROPERTY_STROKE_NONE = 0x00d3
}
typedef mycss_property_stroke_t;

enum mycss_property_stroke_dasharray {
	MyCSS_PROPERTY_STROKE_DASHARRAY_NONE = 0x00d3
}
typedef mycss_property_stroke_dasharray_t;

enum mycss_property_stroke_linecap {
	MyCSS_PROPERTY_STROKE_LINECAP_ROUND   = 0x0118,
	MyCSS_PROPERTY_STROKE_LINECAP_BUTT    = 0x0033,
	MyCSS_PROPERTY_STROKE_LINECAP_INHERIT = 0x0092,
	MyCSS_PROPERTY_STROKE_LINECAP_SQUARE  = 0x0143
}
typedef mycss_property_stroke_linecap_t;

enum mycss_property_stroke_linejoin {
	MyCSS_PROPERTY_STROKE_LINEJOIN_ROUND   = 0x0118,
	MyCSS_PROPERTY_STROKE_LINEJOIN_MITER   = 0x00cc,
	MyCSS_PROPERTY_STROKE_LINEJOIN_BEVEL   = 0x0023,
	MyCSS_PROPERTY_STROKE_LINEJOIN_INHERIT = 0x0092
}
typedef mycss_property_stroke_linejoin_t;

enum mycss_property_tab_size {
	MyCSS_PROPERTY_TAB_SIZE__NUMBER = 0x019c,
	MyCSS_PROPERTY_TAB_SIZE_INHERIT = 0x0092,
	MyCSS_PROPERTY_TAB_SIZE__LENGTH = 0x019a,
	MyCSS_PROPERTY_TAB_SIZE_INITIAL = 0x0093,
	MyCSS_PROPERTY_TAB_SIZE_UNSET   = 0x016f
}
typedef mycss_property_tab_size_t;

enum mycss_property_table_layout {
	MyCSS_PROPERTY_TABLE_LAYOUT_AUTO  = 0x0018,
	MyCSS_PROPERTY_TABLE_LAYOUT_FIXED = 0x0076
}
typedef mycss_property_table_layout_t;

enum mycss_property_text_align {
	MyCSS_PROPERTY_TEXT_ALIGN_RIGHT        = 0x0115,
	MyCSS_PROPERTY_TEXT_ALIGN_UNSET        = 0x016f,
	MyCSS_PROPERTY_TEXT_ALIGN_JUSTIFY      = 0x00a7,
	MyCSS_PROPERTY_TEXT_ALIGN_CENTER       = 0x0037,
	MyCSS_PROPERTY_TEXT_ALIGN_LEFT         = 0x00ae,
	MyCSS_PROPERTY_TEXT_ALIGN_START        = 0x0146,
	MyCSS_PROPERTY_TEXT_ALIGN_END          = 0x0066,
	MyCSS_PROPERTY_TEXT_ALIGN_JUSTIFY_ALL  = 0x00a8,
	MyCSS_PROPERTY_TEXT_ALIGN_MATCH_PARENT = 0x00c3,
	MyCSS_PROPERTY_TEXT_ALIGN_INHERIT      = 0x0092,
	MyCSS_PROPERTY_TEXT_ALIGN_INITIAL      = 0x0093
}
typedef mycss_property_text_align_t;

enum mycss_property_text_align_all {
	MyCSS_PROPERTY_TEXT_ALIGN_ALL_END          = 0x0066,
	MyCSS_PROPERTY_TEXT_ALIGN_ALL_START        = 0x0146,
	MyCSS_PROPERTY_TEXT_ALIGN_ALL_LEFT         = 0x00ae,
	MyCSS_PROPERTY_TEXT_ALIGN_ALL_CENTER       = 0x0037,
	MyCSS_PROPERTY_TEXT_ALIGN_ALL_RIGHT        = 0x0115,
	MyCSS_PROPERTY_TEXT_ALIGN_ALL_UNSET        = 0x016f,
	MyCSS_PROPERTY_TEXT_ALIGN_ALL_JUSTIFY      = 0x00a7,
	MyCSS_PROPERTY_TEXT_ALIGN_ALL_INHERIT      = 0x0092,
	MyCSS_PROPERTY_TEXT_ALIGN_ALL_MATCH_PARENT = 0x00c3,
	MyCSS_PROPERTY_TEXT_ALIGN_ALL_INITIAL      = 0x0093
}
typedef mycss_property_text_align_all_t;

enum mycss_property_text_align_last {
	MyCSS_PROPERTY_TEXT_ALIGN_LAST_RIGHT   = 0x0115,
	MyCSS_PROPERTY_TEXT_ALIGN_LAST_UNSET   = 0x016f,
	MyCSS_PROPERTY_TEXT_ALIGN_LAST_CENTER  = 0x0037,
	MyCSS_PROPERTY_TEXT_ALIGN_LAST_START   = 0x0146,
	MyCSS_PROPERTY_TEXT_ALIGN_LAST_INHERIT = 0x0092,
	MyCSS_PROPERTY_TEXT_ALIGN_LAST_JUSTIFY = 0x00a7,
	MyCSS_PROPERTY_TEXT_ALIGN_LAST_INITIAL = 0x0093,
	MyCSS_PROPERTY_TEXT_ALIGN_LAST_END     = 0x0066,
	MyCSS_PROPERTY_TEXT_ALIGN_LAST_LEFT    = 0x00ae,
	MyCSS_PROPERTY_TEXT_ALIGN_LAST_AUTO    = 0x0018
}
typedef mycss_property_text_align_last_t;

enum mycss_property_text_combine_upright {
	MyCSS_PROPERTY_TEXT_COMBINE_UPRIGHT_DIGITS = 0x0056,
	MyCSS_PROPERTY_TEXT_COMBINE_UPRIGHT_ALL    = 0x0010,
	MyCSS_PROPERTY_TEXT_COMBINE_UPRIGHT_NONE   = 0x00d3
}
typedef mycss_property_text_combine_upright_t;

enum mycss_property_text_decoration_color {
	MyCSS_PROPERTY_TEXT_DECORATION_COLOR_INITIAL      = 0x0093,
	MyCSS_PROPERTY_TEXT_DECORATION_COLOR_CURRENTCOLOR = 0x0050,
	MyCSS_PROPERTY_TEXT_DECORATION_COLOR_UNSET        = 0x016f,
	MyCSS_PROPERTY_TEXT_DECORATION_COLOR_INHERIT      = 0x0092
}
typedef mycss_property_text_decoration_color_t;

enum mycss_property_text_decoration_line {
	MyCSS_PROPERTY_TEXT_DECORATION_LINE_INITIAL      = 0x0093,
	MyCSS_PROPERTY_TEXT_DECORATION_LINE_INHERIT      = 0x0092,
	MyCSS_PROPERTY_TEXT_DECORATION_LINE_UNDERLINE    = 0x016b,
	MyCSS_PROPERTY_TEXT_DECORATION_LINE_UNSET        = 0x016f,
	MyCSS_PROPERTY_TEXT_DECORATION_LINE_OVERLINE     = 0x00f3,
	MyCSS_PROPERTY_TEXT_DECORATION_LINE_LINE_THROUGH = 0x00b4,
	MyCSS_PROPERTY_TEXT_DECORATION_LINE_BLINK        = 0x0025,
	MyCSS_PROPERTY_TEXT_DECORATION_LINE_NONE         = 0x00d3
}
typedef mycss_property_text_decoration_line_t;

enum mycss_property_text_decoration_skip {
	MyCSS_PROPERTY_TEXT_DECORATION_SKIP_INK            = 0x0094,
	MyCSS_PROPERTY_TEXT_DECORATION_SKIP_UNSET          = 0x016f,
	MyCSS_PROPERTY_TEXT_DECORATION_SKIP_INHERIT        = 0x0092,
	MyCSS_PROPERTY_TEXT_DECORATION_SKIP_INITIAL        = 0x0093,
	MyCSS_PROPERTY_TEXT_DECORATION_SKIP_BOX_DECORATION = 0x002e,
	MyCSS_PROPERTY_TEXT_DECORATION_SKIP_SPACES         = 0x013f,
	MyCSS_PROPERTY_TEXT_DECORATION_SKIP_OBJECTS        = 0x00e5,
	MyCSS_PROPERTY_TEXT_DECORATION_SKIP_EDGES          = 0x0063,
	MyCSS_PROPERTY_TEXT_DECORATION_SKIP_NONE           = 0x00d3
}
typedef mycss_property_text_decoration_skip_t;

enum mycss_property_text_decoration_style {
	MyCSS_PROPERTY_TEXT_DECORATION_STYLE_WAVY    = 0x017a,
	MyCSS_PROPERTY_TEXT_DECORATION_STYLE_SOLID   = 0x013d,
	MyCSS_PROPERTY_TEXT_DECORATION_STYLE_DOUBLE  = 0x005b,
	MyCSS_PROPERTY_TEXT_DECORATION_STYLE_DOTTED  = 0x005a,
	MyCSS_PROPERTY_TEXT_DECORATION_STYLE_DASHED  = 0x0052,
	MyCSS_PROPERTY_TEXT_DECORATION_STYLE_UNSET   = 0x016f,
	MyCSS_PROPERTY_TEXT_DECORATION_STYLE_INHERIT = 0x0092,
	MyCSS_PROPERTY_TEXT_DECORATION_STYLE_INITIAL = 0x0093
}
typedef mycss_property_text_decoration_style_t;

enum mycss_property_text_emphasis_color {
	MyCSS_PROPERTY_TEXT_EMPHASIS_COLOR_CURRENTCOLOR = 0x0050
}
typedef mycss_property_text_emphasis_color_t;

enum mycss_property_text_emphasis_position {
	MyCSS_PROPERTY_TEXT_EMPHASIS_POSITION_RIGHT = 0x0115,
	MyCSS_PROPERTY_TEXT_EMPHASIS_POSITION_OVER  = 0x00f1,
	MyCSS_PROPERTY_TEXT_EMPHASIS_POSITION_LEFT  = 0x00ae,
	MyCSS_PROPERTY_TEXT_EMPHASIS_POSITION_UNDER = 0x016a
}
typedef mycss_property_text_emphasis_position_t;

enum mycss_property_text_emphasis_style {
	MyCSS_PROPERTY_TEXT_EMPHASIS_STYLE_DOT           = 0x0059,
	MyCSS_PROPERTY_TEXT_EMPHASIS_STYLE_NONE          = 0x00d3,
	MyCSS_PROPERTY_TEXT_EMPHASIS_STYLE_OPEN          = 0x00ea,
	MyCSS_PROPERTY_TEXT_EMPHASIS_STYLE_FILLED        = 0x0071,
	MyCSS_PROPERTY_TEXT_EMPHASIS_STYLE_DOUBLE_CIRCLE = 0x005c,
	MyCSS_PROPERTY_TEXT_EMPHASIS_STYLE_SESAMEINITIAL = 0x012c,
	MyCSS_PROPERTY_TEXT_EMPHASIS_STYLE_TRIANGLE      = 0x0167,
	MyCSS_PROPERTY_TEXT_EMPHASIS_STYLE_CIRCLE        = 0x0038
}
typedef mycss_property_text_emphasis_style_t;

enum mycss_property_text_indent {
	MyCSS_PROPERTY_TEXT_INDENT_EACH_LINE = 0x005d,
	MyCSS_PROPERTY_TEXT_INDENT_HANGING   = 0x0086
}
typedef mycss_property_text_indent_t;

enum mycss_property_text_justify {
	MyCSS_PROPERTY_TEXT_JUSTIFY_AUTO            = 0x0018,
	MyCSS_PROPERTY_TEXT_JUSTIFY_INTER_WORD      = 0x009e,
	MyCSS_PROPERTY_TEXT_JUSTIFY_NONE            = 0x00d3,
	MyCSS_PROPERTY_TEXT_JUSTIFY_INITIAL         = 0x0093,
	MyCSS_PROPERTY_TEXT_JUSTIFY_UNSET           = 0x016f,
	MyCSS_PROPERTY_TEXT_JUSTIFY_INHERIT         = 0x0092,
	MyCSS_PROPERTY_TEXT_JUSTIFY_INTER_CHARACTER = 0x009d
}
typedef mycss_property_text_justify_t;

enum mycss_property_text_orientation {
	MyCSS_PROPERTY_TEXT_ORIENTATION_MIXED    = 0x00cd,
	MyCSS_PROPERTY_TEXT_ORIENTATION_UNSET    = 0x016f,
	MyCSS_PROPERTY_TEXT_ORIENTATION_UPRIGHT  = 0x0171,
	MyCSS_PROPERTY_TEXT_ORIENTATION_SIDEWAYS = 0x012f,
	MyCSS_PROPERTY_TEXT_ORIENTATION_INHERIT  = 0x0092,
	MyCSS_PROPERTY_TEXT_ORIENTATION_INITIAL  = 0x0093
}
typedef mycss_property_text_orientation_t;

enum mycss_property_text_overflow {
	MyCSS_PROPERTY_TEXT_OVERFLOW_CLIP     = 0x003a,
	MyCSS_PROPERTY_TEXT_OVERFLOW_ELLIPSIS = 0x0064
}
typedef mycss_property_text_overflow_t;

enum mycss_property_text_rendering {
	MyCSS_PROPERTY_TEXT_RENDERING_AUTO               = 0x0018,
	MyCSS_PROPERTY_TEXT_RENDERING_INHERIT            = 0x0092,
	MyCSS_PROPERTY_TEXT_RENDERING_OPTIMIZESPEED      = 0x00ed,
	MyCSS_PROPERTY_TEXT_RENDERING_OPTIMIZELEGIBILITY = 0x00eb,
	MyCSS_PROPERTY_TEXT_RENDERING_GEOMETRICPRECISION = 0x0081
}
typedef mycss_property_text_rendering_t;

enum mycss_property_text_shadow {
	MyCSS_PROPERTY_TEXT_SHADOW_NONE = 0x00d3
}
typedef mycss_property_text_shadow_t;

enum mycss_property_text_size_adjust {
	MyCSS_PROPERTY_TEXT_SIZE_ADJUST_NONE = 0x00d3,
	MyCSS_PROPERTY_TEXT_SIZE_ADJUST_AUTO = 0x0018
}
typedef mycss_property_text_size_adjust_t;

enum mycss_property_text_transform {
	MyCSS_PROPERTY_TEXT_TRANSFORM_LOWERCASE  = 0x00bd,
	MyCSS_PROPERTY_TEXT_TRANSFORM_NONE       = 0x00d3,
	MyCSS_PROPERTY_TEXT_TRANSFORM_UNSET      = 0x016f,
	MyCSS_PROPERTY_TEXT_TRANSFORM_INHERIT    = 0x0092,
	MyCSS_PROPERTY_TEXT_TRANSFORM_UPPERCASE  = 0x0170,
	MyCSS_PROPERTY_TEXT_TRANSFORM_CAPITALIZE = 0x0034,
	MyCSS_PROPERTY_TEXT_TRANSFORM_FULL_WIDTH = 0x0080,
	MyCSS_PROPERTY_TEXT_TRANSFORM_INITIAL    = 0x0093
}
typedef mycss_property_text_transform_t;

enum mycss_property_text_underline_position {
	MyCSS_PROPERTY_TEXT_UNDERLINE_POSITION_LEFT  = 0x00ae,
	MyCSS_PROPERTY_TEXT_UNDERLINE_POSITION_UNDER = 0x016a,
	MyCSS_PROPERTY_TEXT_UNDERLINE_POSITION_RIGHT = 0x0115,
	MyCSS_PROPERTY_TEXT_UNDERLINE_POSITION_AUTO  = 0x0018
}
typedef mycss_property_text_underline_position_t;

enum mycss_property_top {
	MyCSS_PROPERTY_TOP_AUTO        = 0x0018,
	MyCSS_PROPERTY_TOP__LENGTH     = 0x019a,
	MyCSS_PROPERTY_TOP_UNSET       = 0x016f,
	MyCSS_PROPERTY_TOP__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_TOP_INHERIT     = 0x0092,
	MyCSS_PROPERTY_TOP_INITIAL     = 0x0093
}
typedef mycss_property_top_t;

enum mycss_property_touch_action {
	MyCSS_PROPERTY_TOUCH_ACTION_PAN_LEFT     = 0x00fa,
	MyCSS_PROPERTY_TOUCH_ACTION_PAN_UP       = 0x00fc,
	MyCSS_PROPERTY_TOUCH_ACTION_NONE         = 0x00d3,
	MyCSS_PROPERTY_TOUCH_ACTION_PAN_RIGHT    = 0x00fb,
	MyCSS_PROPERTY_TOUCH_ACTION_AUTO         = 0x0018,
	MyCSS_PROPERTY_TOUCH_ACTION_PAN_X        = 0x00fd,
	MyCSS_PROPERTY_TOUCH_ACTION_PAN_Y        = 0x00fe,
	MyCSS_PROPERTY_TOUCH_ACTION_PAN_DOWN     = 0x00f9,
	MyCSS_PROPERTY_TOUCH_ACTION_MANIPULATION = 0x00c0
}
typedef mycss_property_touch_action_t;

enum mycss_property_transform {
	MyCSS_PROPERTY_TRANSFORM_NONE = 0x00d3
}
typedef mycss_property_transform_t;

enum mycss_property_transform_box {
	MyCSS_PROPERTY_TRANSFORM_BOX_VIEW_BOX   = 0x0177,
	MyCSS_PROPERTY_TRANSFORM_BOX_FILL_BOX   = 0x0072,
	MyCSS_PROPERTY_TRANSFORM_BOX_BORDER_BOX = 0x002a
}
typedef mycss_property_transform_box_t;

enum mycss_property_transform_origin {
	MyCSS_PROPERTY_TRANSFORM_ORIGIN_TOP    = 0x0164,
	MyCSS_PROPERTY_TRANSFORM_ORIGIN_RIGHT  = 0x0115,
	MyCSS_PROPERTY_TRANSFORM_ORIGIN_CENTER = 0x0037,
	MyCSS_PROPERTY_TRANSFORM_ORIGIN_BOTTOM = 0x002d,
	MyCSS_PROPERTY_TRANSFORM_ORIGIN_LEFT   = 0x00ae
}
typedef mycss_property_transform_origin_t;

enum mycss_property_transform_style {
	MyCSS_PROPERTY_TRANSFORM_STYLE_FLAT        = 0x0077,
	MyCSS_PROPERTY_TRANSFORM_STYLE_PRESERVE_3D = 0x0105,
	MyCSS_PROPERTY_TRANSFORM_STYLE_AUTO        = 0x0018
}
typedef mycss_property_transform_style_t;

enum mycss_property_transition_property {
	MyCSS_PROPERTY_TRANSITION_PROPERTY_NONE = 0x00d3,
	MyCSS_PROPERTY_TRANSITION_PROPERTY_ALL  = 0x0010
}
typedef mycss_property_transition_property_t;

enum mycss_property_transition_timing_function {
	MyCSS_PROPERTY_TRANSITION_TIMING_FUNCTION_LINEAR      = 0x00b2,
	MyCSS_PROPERTY_TRANSITION_TIMING_FUNCTION_EASE        = 0x005e,
	MyCSS_PROPERTY_TRANSITION_TIMING_FUNCTION_EASE_IN     = 0x005f,
	MyCSS_PROPERTY_TRANSITION_TIMING_FUNCTION_EASE_OUT    = 0x0061,
	MyCSS_PROPERTY_TRANSITION_TIMING_FUNCTION_STEP_END    = 0x0149,
	MyCSS_PROPERTY_TRANSITION_TIMING_FUNCTION_STEP_START  = 0x014a,
	MyCSS_PROPERTY_TRANSITION_TIMING_FUNCTION_EASE_IN_OUT = 0x0060
}
typedef mycss_property_transition_timing_function_t;

enum mycss_property_unicode_bidi {
	MyCSS_PROPERTY_UNICODE_BIDI_EMBED            = 0x0065,
	MyCSS_PROPERTY_UNICODE_BIDI_NORMAL           = 0x00d5,
	MyCSS_PROPERTY_UNICODE_BIDI_INHERIT          = 0x0092,
	MyCSS_PROPERTY_UNICODE_BIDI_PLAINTEXT        = 0x0101,
	MyCSS_PROPERTY_UNICODE_BIDI_UNSET            = 0x016f,
	MyCSS_PROPERTY_UNICODE_BIDI_ISOLATE          = 0x00a0,
	MyCSS_PROPERTY_UNICODE_BIDI_INITIAL          = 0x0093,
	MyCSS_PROPERTY_UNICODE_BIDI_BIDI_OVERRIDE    = 0x0024,
	MyCSS_PROPERTY_UNICODE_BIDI_ISOLATE_OVERRIDE = 0x00a1
}
typedef mycss_property_unicode_bidi_t;

enum mycss_property_user_select {
	MyCSS_PROPERTY_USER_SELECT_CONTAIN = 0x0044,
	MyCSS_PROPERTY_USER_SELECT_ALL     = 0x0010,
	MyCSS_PROPERTY_USER_SELECT_AUTO    = 0x0018,
	MyCSS_PROPERTY_USER_SELECT_TEXT    = 0x015e,
	MyCSS_PROPERTY_USER_SELECT_NONE    = 0x00d3
}
typedef mycss_property_user_select_t;

enum mycss_property_vertical_align {
	MyCSS_PROPERTY_VERTICAL_ALIGN_SUB         = 0x0150,
	MyCSS_PROPERTY_VERTICAL_ALIGN_TOP         = 0x0164,
	MyCSS_PROPERTY_VERTICAL_ALIGN__LENGTH     = 0x019a,
	MyCSS_PROPERTY_VERTICAL_ALIGN_BASELINE    = 0x0022,
	MyCSS_PROPERTY_VERTICAL_ALIGN__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_VERTICAL_ALIGN_SUPER       = 0x0151,
	MyCSS_PROPERTY_VERTICAL_ALIGN_UNSET       = 0x016f,
	MyCSS_PROPERTY_VERTICAL_ALIGN_MIDDLE      = 0x00c9,
	MyCSS_PROPERTY_VERTICAL_ALIGN_TEXT_TOP    = 0x0160,
	MyCSS_PROPERTY_VERTICAL_ALIGN_BOTTOM      = 0x002d,
	MyCSS_PROPERTY_VERTICAL_ALIGN_INHERIT     = 0x0092,
	MyCSS_PROPERTY_VERTICAL_ALIGN_INITIAL     = 0x0093,
	MyCSS_PROPERTY_VERTICAL_ALIGN_TEXT_BOTTOM = 0x015f
}
typedef mycss_property_vertical_align_t;

enum mycss_property_visibility {
	MyCSS_PROPERTY_VISIBILITY_UNSET    = 0x016f,
	MyCSS_PROPERTY_VISIBILITY_HIDDEN   = 0x0088,
	MyCSS_PROPERTY_VISIBILITY_VISIBLE  = 0x0178,
	MyCSS_PROPERTY_VISIBILITY_INHERIT  = 0x0092,
	MyCSS_PROPERTY_VISIBILITY_COLLAPSE = 0x003d,
	MyCSS_PROPERTY_VISIBILITY_INITIAL  = 0x0093
}
typedef mycss_property_visibility_t;

enum mycss_property_voice_balance {
	MyCSS_PROPERTY_VOICE_BALANCE_LEFT       = 0x00ae,
	MyCSS_PROPERTY_VOICE_BALANCE_RIGHT      = 0x0115,
	MyCSS_PROPERTY_VOICE_BALANCE_CENTER     = 0x0037,
	MyCSS_PROPERTY_VOICE_BALANCE_LEFTWARDS  = 0x00af,
	MyCSS_PROPERTY_VOICE_BALANCE_RIGHTWARDS = 0x0116
}
typedef mycss_property_voice_balance_t;

enum mycss_property_voice_duration {
	MyCSS_PROPERTY_VOICE_DURATION_AUTO = 0x0018
}
typedef mycss_property_voice_duration_t;

enum mycss_property_voice_family {
	MyCSS_PROPERTY_VOICE_FAMILY_PRESERVE = 0x0104
}
typedef mycss_property_voice_family_t;

enum mycss_property_voice_pitch {
	MyCSS_PROPERTY_VOICE_PITCH_LOW      = 0x00bc,
	MyCSS_PROPERTY_VOICE_PITCH_X_LOW    = 0x0187,
	MyCSS_PROPERTY_VOICE_PITCH_ABSOLUTE = 0x000e,
	MyCSS_PROPERTY_VOICE_PITCH_HIGH     = 0x008a,
	MyCSS_PROPERTY_VOICE_PITCH_MEDIUM   = 0x00c6,
	MyCSS_PROPERTY_VOICE_PITCH_X_HIGH   = 0x0184
}
typedef mycss_property_voice_pitch_t;

enum mycss_property_voice_range {
	MyCSS_PROPERTY_VOICE_RANGE_X_LOW    = 0x0187,
	MyCSS_PROPERTY_VOICE_RANGE_LOW      = 0x00bc,
	MyCSS_PROPERTY_VOICE_RANGE_ABSOLUTE = 0x000e,
	MyCSS_PROPERTY_VOICE_RANGE_HIGH     = 0x008a,
	MyCSS_PROPERTY_VOICE_RANGE_MEDIUM   = 0x00c6,
	MyCSS_PROPERTY_VOICE_RANGE_X_HIGH   = 0x0184
}
typedef mycss_property_voice_range_t;

enum mycss_property_voice_rate {
	MyCSS_PROPERTY_VOICE_RATE_SLOW   = 0x0137,
	MyCSS_PROPERTY_VOICE_RATE_X_FAST = 0x0183,
	MyCSS_PROPERTY_VOICE_RATE_NORMAL = 0x00d5,
	MyCSS_PROPERTY_VOICE_RATE_X_SLOW = 0x0188,
	MyCSS_PROPERTY_VOICE_RATE_FAST   = 0x006f,
	MyCSS_PROPERTY_VOICE_RATE_MEDIUM = 0x00c6
}
typedef mycss_property_voice_rate_t;

enum mycss_property_voice_stress {
	MyCSS_PROPERTY_VOICE_STRESS_STRONG   = 0x014e,
	MyCSS_PROPERTY_VOICE_STRESS_NORMAL   = 0x00d5,
	MyCSS_PROPERTY_VOICE_STRESS_NONE     = 0x00d3,
	MyCSS_PROPERTY_VOICE_STRESS_MODERATE = 0x00ce,
	MyCSS_PROPERTY_VOICE_STRESS_REDUCED  = 0x010d
}
typedef mycss_property_voice_stress_t;

enum mycss_property_voice_volume {
	MyCSS_PROPERTY_VOICE_VOLUME_SOFT   = 0x013c,
	MyCSS_PROPERTY_VOICE_VOLUME_X_SOFT = 0x018a,
	MyCSS_PROPERTY_VOICE_VOLUME_SILENT = 0x0132,
	MyCSS_PROPERTY_VOICE_VOLUME_LOUD   = 0x00bb,
	MyCSS_PROPERTY_VOICE_VOLUME_MEDIUM = 0x00c6,
	MyCSS_PROPERTY_VOICE_VOLUME_X_LOUD = 0x0186
}
typedef mycss_property_voice_volume_t;

enum mycss_property_white_space {
	MyCSS_PROPERTY_WHITE_SPACE_PRE      = 0x0103,
	MyCSS_PROPERTY_WHITE_SPACE_NORMAL   = 0x00d5,
	MyCSS_PROPERTY_WHITE_SPACE_UNSET    = 0x016f,
	MyCSS_PROPERTY_WHITE_SPACE_NOWRAP   = 0x00d7,
	MyCSS_PROPERTY_WHITE_SPACE_INHERIT  = 0x0092,
	MyCSS_PROPERTY_WHITE_SPACE_PRE_WRAP = 0x0107,
	MyCSS_PROPERTY_WHITE_SPACE_PRE_LINE = 0x0106,
	MyCSS_PROPERTY_WHITE_SPACE_INITIAL  = 0x0093
}
typedef mycss_property_white_space_t;

enum mycss_property_width {
	MyCSS_PROPERTY_WIDTH_MAX_CONTENT = 0x00c5,
	MyCSS_PROPERTY_WIDTH_AUTO        = 0x0018,
	MyCSS_PROPERTY_WIDTH__LENGTH     = 0x019a,
	MyCSS_PROPERTY_WIDTH_AVAILABLE   = 0x0019,
	MyCSS_PROPERTY_WIDTH__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_WIDTH_UNSET       = 0x016f,
	MyCSS_PROPERTY_WIDTH_MIN_CONTENT = 0x00cb,
	MyCSS_PROPERTY_WIDTH_FIT_CONTENT = 0x0075,
	MyCSS_PROPERTY_WIDTH_INHERIT     = 0x0092,
	MyCSS_PROPERTY_WIDTH_INITIAL     = 0x0093
}
typedef mycss_property_width_t;

enum mycss_property_will_change {
	MyCSS_PROPERTY_WILL_CHANGE_SCROLL_POSITION = 0x0127,
	MyCSS_PROPERTY_WILL_CHANGE_AUTO            = 0x0018,
	MyCSS_PROPERTY_WILL_CHANGE_CONTENTS        = 0x0046
}
typedef mycss_property_will_change_t;

enum mycss_property_word_break {
	MyCSS_PROPERTY_WORD_BREAK_BREAK_ALL = 0x0030,
	MyCSS_PROPERTY_WORD_BREAK_NORMAL    = 0x00d5,
	MyCSS_PROPERTY_WORD_BREAK_UNSET     = 0x016f,
	MyCSS_PROPERTY_WORD_BREAK_INHERIT   = 0x0092,
	MyCSS_PROPERTY_WORD_BREAK_KEEP_ALL  = 0x00a9,
	MyCSS_PROPERTY_WORD_BREAK_INITIAL   = 0x0093
}
typedef mycss_property_word_break_t;

enum mycss_property_word_spacing {
	MyCSS_PROPERTY_WORD_SPACING_INHERIT     = 0x0092,
	MyCSS_PROPERTY_WORD_SPACING_NORMAL      = 0x00d5,
	MyCSS_PROPERTY_WORD_SPACING__PERCENTAGE = 0x019d,
	MyCSS_PROPERTY_WORD_SPACING__LENGTH     = 0x019a,
	MyCSS_PROPERTY_WORD_SPACING_UNSET       = 0x016f,
	MyCSS_PROPERTY_WORD_SPACING_INITIAL     = 0x0093
}
typedef mycss_property_word_spacing_t;

enum mycss_property_word_wrap {
	MyCSS_PROPERTY_WORD_WRAP_NORMAL       = 0x00d5,
	MyCSS_PROPERTY_WORD_WRAP_UNSET        = 0x016f,
	MyCSS_PROPERTY_WORD_WRAP_INITIAL      = 0x0093,
	MyCSS_PROPERTY_WORD_WRAP_BREAK_SPACES = 0x0031,
	MyCSS_PROPERTY_WORD_WRAP_INHERIT      = 0x0092,
	MyCSS_PROPERTY_WORD_WRAP_BREAK_WORD   = 0x0032
}
typedef mycss_property_word_wrap_t;

enum mycss_property_wrap_flow {
	MyCSS_PROPERTY_WRAP_FLOW_MAXIMUM = 0x00c4,
	MyCSS_PROPERTY_WRAP_FLOW_MINIMUM = 0x00ca,
	MyCSS_PROPERTY_WRAP_FLOW_END     = 0x0066,
	MyCSS_PROPERTY_WRAP_FLOW_AUTO    = 0x0018,
	MyCSS_PROPERTY_WRAP_FLOW_BOTH    = 0x002c,
	MyCSS_PROPERTY_WRAP_FLOW_START   = 0x0146,
	MyCSS_PROPERTY_WRAP_FLOW_CLEAR   = 0x0039
}
typedef mycss_property_wrap_flow_t;

enum mycss_property_wrap_through {
	MyCSS_PROPERTY_WRAP_THROUGH_WRAP = 0x017d,
	MyCSS_PROPERTY_WRAP_THROUGH_NONE = 0x00d3
}
typedef mycss_property_wrap_through_t;

enum mycss_property_writing_mode {
	MyCSS_PROPERTY_WRITING_MODE_INITIAL       = 0x0093,
	MyCSS_PROPERTY_WRITING_MODE_VERTICAL_RL   = 0x0175,
	MyCSS_PROPERTY_WRITING_MODE_HORIZONTAL_TB = 0x008e,
	MyCSS_PROPERTY_WRITING_MODE_VERTICAL_LR   = 0x0174,
	MyCSS_PROPERTY_WRITING_MODE_SIDEWAYS_RL   = 0x0131,
	MyCSS_PROPERTY_WRITING_MODE_SIDEWAYS_LR   = 0x0130,
	MyCSS_PROPERTY_WRITING_MODE_INHERIT       = 0x0092,
	MyCSS_PROPERTY_WRITING_MODE_UNSET         = 0x016f
}
typedef mycss_property_writing_mode_t;

enum mycss_property_z_index {
	MyCSS_PROPERTY_Z_INDEX_AUTO    = 0x0018,
	MyCSS_PROPERTY_Z_INDEX__NUMBER = 0x019c,
	MyCSS_PROPERTY_Z_INDEX_UNSET   = 0x016f,
	MyCSS_PROPERTY_Z_INDEX_INHERIT = 0x0092,
	MyCSS_PROPERTY_Z_INDEX_INITIAL = 0x0093
}
typedef mycss_property_z_index_t;



#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* MyHTML_MyCSS_PROPERTY_CONST_H */


