from setuptools import setup, find_packages

with open("README.md", "r", encoding = "UTF-8") as file:
    long_desc = file.read()

setup(
    name = "rsharp",
    version = "0.0.12",
    entry_points={
        "console_scripts": [
            "rsharp = rsharp.main:main",
        ],
    },
    description = "An interpreted statically typed multi paradigm general purpose programming language designed for cross platform applications.",
    long_description = long_desc,
    long_description_content_type = "text/markdown",
    url = "https://github.com/Aermoss/RSharp",
    author = "Yusuf Rencber",
    author_email = "yusufrencber546@gmail.com",
    license = "MIT",
    keywords = "",
    packages = find_packages(),
    include_package_data = True,
    install_requires = ["raylib", "numba", "pyinstaller", "pysdl2", "pysdl2-dll"]
)