# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ....core.datetime_utils import serialize_datetime
from ...ids.types.device_id import DeviceId
from .platform import Platform


class Device(pydantic.BaseModel):
    id: typing.Optional[str]
    platform: typing.Optional[Platform]
    onesignal_player_id: typing.Optional[str]
    xiaomi_token: typing.Optional[str]
    oppo_token: typing.Optional[str]
    vivo_token: typing.Optional[str]
    huawei_token: typing.Optional[str] = pydantic.Field(alias="huaweiToken")
    fcm_token: typing.Optional[str] = pydantic.Field(description=("firebase device token\n"))
    raven_id: typing.Optional[str] = pydantic.Field(description=("user id affiliated with device\n"))
    device_sid: typing.Optional[DeviceId]
    notifications_disabled: typing.Optional[bool]
    created_at: typing.Optional[int]
    updated_at: typing.Optional[int]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
