# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ..core.datetime_utils import serialize_datetime
from .email_override import EmailOverride
from .in_app_override import InAppOverride
from .provider_override import ProviderOverride
from .push_override import PushOverride
from .slack_override import SlackOverride
from .sms_override import SmsOverride
from .telegram_override import TelegramOverride
from .voice_override import VoiceOverride
from .webhook_override import WebhookOverride
from .whatsapp_override import WhatsappOverride


class EventOverride(pydantic.BaseModel):
    email: typing.Optional[EmailOverride]
    sms: typing.Optional[SmsOverride]
    whatsapp: typing.Optional[WhatsappOverride]
    push: typing.Optional[PushOverride]
    webhook: typing.Optional[WebhookOverride]
    voice: typing.Optional[VoiceOverride]
    slack: typing.Optional[SlackOverride]
    in_app: typing.Optional[InAppOverride]
    telegram: typing.Optional[TelegramOverride]
    providers: typing.Dict[str, ProviderOverride]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        json_encoders = {dt.datetime: serialize_datetime}
