# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ....core.datetime_utils import serialize_datetime
from ...ids.types.user_id import UserId
from .slack_profile import SlackProfile
from .telegram_profile import TelegramProfile


class RavenUser(pydantic.BaseModel):
    user_id: UserId = pydantic.Field(
        description=(
            "Your user identifier. \n"
            "If user_id already exists, user properties will be updated else a new user will be created\n"
        )
    )
    user_sid: typing.Optional[str]
    onesignal_external_id: typing.Optional[str]
    mobile: typing.Optional[str]
    email: typing.Optional[str]
    whatsapp_mobile: typing.Optional[str] = pydantic.Field(
        description=("Include this only when user's whatsapp mobile is different than primary mobile\n")
    )
    slack: typing.Optional[SlackProfile]
    telegram: typing.Optional[TelegramProfile]
    fcm_tokens: typing.Optional[typing.List[str]]
    onesignal_player_ids: typing.Optional[typing.List[str]]
    ios_tokens: typing.Optional[typing.List[str]]
    created_at: typing.Optional[int]
    updated_at: typing.Optional[int]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        json_encoders = {dt.datetime: serialize_datetime}
