### Cross platform Python port of [Peek](https://github.com/phw/peek)

<br/>

# Peek - Screen Capture & Recording With Annotations

### Cross platform screen recorder with an easy to use interface and annotation features.

<br/>
<br/>

![Peek recording itself](https://raw.githubusercontent.com/firatkiral/pypeek/main/data/art/peek-recording-itself.gif)

<br/>
<br/>

### Requirements:

- Python 3.10 or later

- Windows, macOS, Linux on Xorg ([How to switch to Xorg](https://itsfoss.com/switch-xorg-wayland/))

<br/>

### Install:

```console
$ pip install pypeek
```

### Usage:

```console
$ pypeek
```

### Create a desktop shortcut:

```console
$ pypeek shortcut
```

### Import as a module:

```python
import pypeek

pypeek.show()
```

### Run as a module:

```console
$ python -m pypeek
```

### Update:

```console
$ pip install --upgrade pypeek
```

### Uninstall:

```console
$ pip uninstall pypeek
```

<br/>
<br/>

## License
Peek Copyright © 2023

Peek is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Peek is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Peek. If not, see <https://www.gnu.org/licenses/>.