# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ApplicationServerConfigurationArgs',
    'ApplicationServerFullResourceNamesArgs',
    'CentralServerConfigurationArgs',
    'CentralServerFullResourceNamesArgs',
    'CreateAndMountFileShareConfigurationArgs',
    'DB2ProviderInstancePropertiesArgs',
    'DatabaseConfigurationArgs',
    'DatabaseServerFullResourceNamesArgs',
    'DeployerVmPackagesArgs',
    'DeploymentConfigurationArgs',
    'DeploymentWithOSConfigurationArgs',
    'DiscoveryConfigurationArgs',
    'DiskConfigurationArgs',
    'DiskSkuArgs',
    'DiskVolumeConfigurationArgs',
    'ExternalInstallationSoftwareConfigurationArgs',
    'HanaDbProviderInstancePropertiesArgs',
    'HighAvailabilityConfigurationArgs',
    'HighAvailabilitySoftwareConfigurationArgs',
    'ImageReferenceArgs',
    'LinuxConfigurationArgs',
    'LoadBalancerResourceNamesArgs',
    'ManagedRGConfigurationArgs',
    'MountFileShareConfigurationArgs',
    'MsSqlServerProviderInstancePropertiesArgs',
    'NetworkConfigurationArgs',
    'NetworkInterfaceResourceNamesArgs',
    'OSProfileArgs',
    'OsSapConfigurationArgs',
    'PrometheusHaClusterProviderInstancePropertiesArgs',
    'PrometheusOSProviderInstancePropertiesArgs',
    'SAPInstallWithoutOSConfigSoftwareConfigurationArgs',
    'SapLandscapeMonitorMetricThresholdsArgs',
    'SapLandscapeMonitorPropertiesGroupingArgs',
    'SapLandscapeMonitorSidMappingArgs',
    'SapNetWeaverProviderInstancePropertiesArgs',
    'ServiceInitiatedSoftwareConfigurationArgs',
    'SharedStorageResourceNamesArgs',
    'SingleServerConfigurationArgs',
    'SingleServerFullResourceNamesArgs',
    'SkipFileShareConfigurationArgs',
    'SshConfigurationArgs',
    'SshKeyPairArgs',
    'SshPublicKeyArgs',
    'StorageConfigurationArgs',
    'ThreeTierConfigurationArgs',
    'ThreeTierFullResourceNamesArgs',
    'UserAssignedServiceIdentityArgs',
    'VirtualMachineConfigurationArgs',
    'VirtualMachineResourceNamesArgs',
    'WindowsConfigurationArgs',
]

@pulumi.input_type
class ApplicationServerConfigurationArgs:
    def __init__(__self__, *,
                 instance_count: pulumi.Input[float],
                 subnet_id: pulumi.Input[str],
                 virtual_machine_configuration: pulumi.Input['VirtualMachineConfigurationArgs']):
        """
        Gets or sets the application server configuration.
        :param pulumi.Input[float] instance_count: The number of app server instances.
        :param pulumi.Input[str] subnet_id: The subnet id.
        :param pulumi.Input['VirtualMachineConfigurationArgs'] virtual_machine_configuration: Gets or sets the virtual machine configuration.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Input[float]:
        """
        The number of app server instances.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: pulumi.Input[float]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> pulumi.Input['VirtualMachineConfigurationArgs']:
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")

    @virtual_machine_configuration.setter
    def virtual_machine_configuration(self, value: pulumi.Input['VirtualMachineConfigurationArgs']):
        pulumi.set(self, "virtual_machine_configuration", value)


@pulumi.input_type
class ApplicationServerFullResourceNamesArgs:
    def __init__(__self__, *,
                 availability_set_name: Optional[pulumi.Input[str]] = None,
                 virtual_machines: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineResourceNamesArgs']]]] = None):
        """
        The full resource names object for application layer resources. The number of entries in this list should be equal to the number VMs to be created for application layer.
        :param pulumi.Input[str] availability_set_name: The full name for availability set. In case name is not provided, it will be defaulted to {SID}-App-AvSet.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineResourceNamesArgs']]] virtual_machines: The list of virtual machine naming details.
        """
        if availability_set_name is not None:
            pulumi.set(__self__, "availability_set_name", availability_set_name)
        if virtual_machines is not None:
            pulumi.set(__self__, "virtual_machines", virtual_machines)

    @property
    @pulumi.getter(name="availabilitySetName")
    def availability_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name for availability set. In case name is not provided, it will be defaulted to {SID}-App-AvSet.
        """
        return pulumi.get(self, "availability_set_name")

    @availability_set_name.setter
    def availability_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_set_name", value)

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineResourceNamesArgs']]]]:
        """
        The list of virtual machine naming details.
        """
        return pulumi.get(self, "virtual_machines")

    @virtual_machines.setter
    def virtual_machines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineResourceNamesArgs']]]]):
        pulumi.set(self, "virtual_machines", value)


@pulumi.input_type
class CentralServerConfigurationArgs:
    def __init__(__self__, *,
                 instance_count: pulumi.Input[float],
                 subnet_id: pulumi.Input[str],
                 virtual_machine_configuration: pulumi.Input['VirtualMachineConfigurationArgs']):
        """
        Gets or sets the central server configuration.
        :param pulumi.Input[float] instance_count: The number of central server VMs.
        :param pulumi.Input[str] subnet_id: The subnet id.
        :param pulumi.Input['VirtualMachineConfigurationArgs'] virtual_machine_configuration: Gets or sets the virtual machine configuration.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Input[float]:
        """
        The number of central server VMs.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: pulumi.Input[float]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> pulumi.Input['VirtualMachineConfigurationArgs']:
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")

    @virtual_machine_configuration.setter
    def virtual_machine_configuration(self, value: pulumi.Input['VirtualMachineConfigurationArgs']):
        pulumi.set(self, "virtual_machine_configuration", value)


@pulumi.input_type
class CentralServerFullResourceNamesArgs:
    def __init__(__self__, *,
                 availability_set_name: Optional[pulumi.Input[str]] = None,
                 load_balancer: Optional[pulumi.Input['LoadBalancerResourceNamesArgs']] = None,
                 virtual_machines: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineResourceNamesArgs']]]] = None):
        """
        The full resource names object for central server layer resources.
        :param pulumi.Input[str] availability_set_name: The full name for availability set. In case name is not provided, it will be defaulted to {SID}-ASCS-AvSet.
        :param pulumi.Input['LoadBalancerResourceNamesArgs'] load_balancer: The resource names object for load balancer and related resources.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineResourceNamesArgs']]] virtual_machines: The list of names for all ASCS virtual machines to be deployed. The number of entries in this list should be equal to the number VMs to be created for ASCS layer. At maximum, there can be two virtual machines at this layer: ASCS and ERS.
        """
        if availability_set_name is not None:
            pulumi.set(__self__, "availability_set_name", availability_set_name)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if virtual_machines is not None:
            pulumi.set(__self__, "virtual_machines", virtual_machines)

    @property
    @pulumi.getter(name="availabilitySetName")
    def availability_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name for availability set. In case name is not provided, it will be defaulted to {SID}-ASCS-AvSet.
        """
        return pulumi.get(self, "availability_set_name")

    @availability_set_name.setter
    def availability_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_set_name", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['LoadBalancerResourceNamesArgs']]:
        """
        The resource names object for load balancer and related resources.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['LoadBalancerResourceNamesArgs']]):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineResourceNamesArgs']]]]:
        """
        The list of names for all ASCS virtual machines to be deployed. The number of entries in this list should be equal to the number VMs to be created for ASCS layer. At maximum, there can be two virtual machines at this layer: ASCS and ERS.
        """
        return pulumi.get(self, "virtual_machines")

    @virtual_machines.setter
    def virtual_machines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineResourceNamesArgs']]]]):
        pulumi.set(self, "virtual_machines", value)


@pulumi.input_type
class CreateAndMountFileShareConfigurationArgs:
    def __init__(__self__, *,
                 configuration_type: pulumi.Input[str],
                 resource_group: Optional[pulumi.Input[str]] = None,
                 storage_account_name: Optional[pulumi.Input[str]] = None):
        """
        Gets or sets the file share configuration where the transport directory fileshare is created and mounted as a part of the create infra flow. Please pre-create the resource group you intend to place the transport directory in. The storage account and fileshare will be auto-created by the ACSS and doesn’t need to pre-created.
        :param pulumi.Input[str] configuration_type: The type of file share config.
               Expected value is 'CreateAndMount'.
        :param pulumi.Input[str] resource_group: The name of transport file share resource group. This should be pre created by the customer. The app rg is used in case of missing input.
        :param pulumi.Input[str] storage_account_name: The name of file share storage account name . A custom name is used in case of missing input.
        """
        pulumi.set(__self__, "configuration_type", 'CreateAndMount')
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if storage_account_name is not None:
            pulumi.set(__self__, "storage_account_name", storage_account_name)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> pulumi.Input[str]:
        """
        The type of file share config.
        Expected value is 'CreateAndMount'.
        """
        return pulumi.get(self, "configuration_type")

    @configuration_type.setter
    def configuration_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_type", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of transport file share resource group. This should be pre created by the customer. The app rg is used in case of missing input.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of file share storage account name . A custom name is used in case of missing input.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_name", value)


@pulumi.input_type
class DB2ProviderInstancePropertiesArgs:
    def __init__(__self__, *,
                 provider_type: pulumi.Input[str],
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_password: Optional[pulumi.Input[str]] = None,
                 db_password_uri: Optional[pulumi.Input[str]] = None,
                 db_port: Optional[pulumi.Input[str]] = None,
                 db_username: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 sap_sid: Optional[pulumi.Input[str]] = None,
                 ssl_certificate_uri: Optional[pulumi.Input[str]] = None,
                 ssl_preference: Optional[pulumi.Input[Union[str, 'SslPreference']]] = None):
        """
        Gets or sets the DB2 provider properties.
        :param pulumi.Input[str] provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'Db2'.
        :param pulumi.Input[str] db_name: Gets or sets the db2 database name.
        :param pulumi.Input[str] db_password: Gets or sets the db2 database password.
        :param pulumi.Input[str] db_password_uri: Gets or sets the key vault URI to secret with the database password.
        :param pulumi.Input[str] db_port: Gets or sets the db2 database sql port.
        :param pulumi.Input[str] db_username: Gets or sets the db2 database user name.
        :param pulumi.Input[str] hostname: Gets or sets the target virtual machine name.
        :param pulumi.Input[str] sap_sid: Gets or sets the SAP System Identifier
        :param pulumi.Input[str] ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the DB2 Database.
        :param pulumi.Input[Union[str, 'SslPreference']] ssl_preference: Gets or sets certificate preference if secure communication is enabled.
        """
        pulumi.set(__self__, "provider_type", 'Db2')
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_password is not None:
            pulumi.set(__self__, "db_password", db_password)
        if db_password_uri is not None:
            pulumi.set(__self__, "db_password_uri", db_password_uri)
        if db_port is not None:
            pulumi.set(__self__, "db_port", db_port)
        if db_username is not None:
            pulumi.set(__self__, "db_username", db_username)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)
        if ssl_certificate_uri is not None:
            pulumi.set(__self__, "ssl_certificate_uri", ssl_certificate_uri)
        if ssl_preference is not None:
            pulumi.set(__self__, "ssl_preference", ssl_preference)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Input[str]:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'Db2'.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_type", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the db2 database name.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="dbPassword")
    def db_password(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the db2 database password.
        """
        return pulumi.get(self, "db_password")

    @db_password.setter
    def db_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_password", value)

    @property
    @pulumi.getter(name="dbPasswordUri")
    def db_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the key vault URI to secret with the database password.
        """
        return pulumi.get(self, "db_password_uri")

    @db_password_uri.setter
    def db_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_password_uri", value)

    @property
    @pulumi.getter(name="dbPort")
    def db_port(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the db2 database sql port.
        """
        return pulumi.get(self, "db_port")

    @db_port.setter
    def db_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_port", value)

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the db2 database user name.
        """
        return pulumi.get(self, "db_username")

    @db_username.setter
    def db_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_username", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the target virtual machine name.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAP System Identifier
        """
        return pulumi.get(self, "sap_sid")

    @sap_sid.setter
    def sap_sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_sid", value)

    @property
    @pulumi.getter(name="sslCertificateUri")
    def ssl_certificate_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the blob URI to SSL certificate for the DB2 Database.
        """
        return pulumi.get(self, "ssl_certificate_uri")

    @ssl_certificate_uri.setter
    def ssl_certificate_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_certificate_uri", value)

    @property
    @pulumi.getter(name="sslPreference")
    def ssl_preference(self) -> Optional[pulumi.Input[Union[str, 'SslPreference']]]:
        """
        Gets or sets certificate preference if secure communication is enabled.
        """
        return pulumi.get(self, "ssl_preference")

    @ssl_preference.setter
    def ssl_preference(self, value: Optional[pulumi.Input[Union[str, 'SslPreference']]]):
        pulumi.set(self, "ssl_preference", value)


@pulumi.input_type
class DatabaseConfigurationArgs:
    def __init__(__self__, *,
                 instance_count: pulumi.Input[float],
                 subnet_id: pulumi.Input[str],
                 virtual_machine_configuration: pulumi.Input['VirtualMachineConfigurationArgs'],
                 database_type: Optional[pulumi.Input[Union[str, 'SAPDatabaseType']]] = None,
                 disk_configuration: Optional[pulumi.Input['DiskConfigurationArgs']] = None):
        """
        Gets or sets the database configuration.
        :param pulumi.Input[float] instance_count: The number of database VMs.
        :param pulumi.Input[str] subnet_id: The subnet id.
        :param pulumi.Input['VirtualMachineConfigurationArgs'] virtual_machine_configuration: Gets or sets the virtual machine configuration.
        :param pulumi.Input[Union[str, 'SAPDatabaseType']] database_type: The database type.
        :param pulumi.Input['DiskConfigurationArgs'] disk_configuration: Gets or sets the disk configuration.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if disk_configuration is not None:
            pulumi.set(__self__, "disk_configuration", disk_configuration)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Input[float]:
        """
        The number of database VMs.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: pulumi.Input[float]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> pulumi.Input['VirtualMachineConfigurationArgs']:
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")

    @virtual_machine_configuration.setter
    def virtual_machine_configuration(self, value: pulumi.Input['VirtualMachineConfigurationArgs']):
        pulumi.set(self, "virtual_machine_configuration", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[Union[str, 'SAPDatabaseType']]]:
        """
        The database type.
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[Union[str, 'SAPDatabaseType']]]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter(name="diskConfiguration")
    def disk_configuration(self) -> Optional[pulumi.Input['DiskConfigurationArgs']]:
        """
        Gets or sets the disk configuration.
        """
        return pulumi.get(self, "disk_configuration")

    @disk_configuration.setter
    def disk_configuration(self, value: Optional[pulumi.Input['DiskConfigurationArgs']]):
        pulumi.set(self, "disk_configuration", value)


@pulumi.input_type
class DatabaseServerFullResourceNamesArgs:
    def __init__(__self__, *,
                 availability_set_name: Optional[pulumi.Input[str]] = None,
                 load_balancer: Optional[pulumi.Input['LoadBalancerResourceNamesArgs']] = None,
                 virtual_machines: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineResourceNamesArgs']]]] = None):
        """
        The full resource names object for database layer resources. The number of entries in this list should be equal to the number VMs to be created for database layer.
        :param pulumi.Input[str] availability_set_name: The full name for availability set. In case name is not provided, it will be defaulted to {SID}-DB-AvSet.
        :param pulumi.Input['LoadBalancerResourceNamesArgs'] load_balancer: The resource names object for load balancer and related resources.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualMachineResourceNamesArgs']]] virtual_machines: The list of virtual machine naming details.
        """
        if availability_set_name is not None:
            pulumi.set(__self__, "availability_set_name", availability_set_name)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if virtual_machines is not None:
            pulumi.set(__self__, "virtual_machines", virtual_machines)

    @property
    @pulumi.getter(name="availabilitySetName")
    def availability_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name for availability set. In case name is not provided, it will be defaulted to {SID}-DB-AvSet.
        """
        return pulumi.get(self, "availability_set_name")

    @availability_set_name.setter
    def availability_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_set_name", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['LoadBalancerResourceNamesArgs']]:
        """
        The resource names object for load balancer and related resources.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['LoadBalancerResourceNamesArgs']]):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineResourceNamesArgs']]]]:
        """
        The list of virtual machine naming details.
        """
        return pulumi.get(self, "virtual_machines")

    @virtual_machines.setter
    def virtual_machines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualMachineResourceNamesArgs']]]]):
        pulumi.set(self, "virtual_machines", value)


@pulumi.input_type
class DeployerVmPackagesArgs:
    def __init__(__self__, *,
                 storage_account_id: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Defines the url and storage account ID where deployer VM packages are uploaded
        :param pulumi.Input[str] storage_account_id: The deployer VM packages storage account id
        :param pulumi.Input[str] url: The URL to the deployer VM packages file.
        """
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The deployer VM packages storage account id
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_id", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL to the deployer VM packages file.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class DeploymentConfigurationArgs:
    def __init__(__self__, *,
                 configuration_type: pulumi.Input[str],
                 app_location: Optional[pulumi.Input[str]] = None,
                 infrastructure_configuration: Optional[pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']]] = None,
                 software_configuration: Optional[pulumi.Input[Union['ExternalInstallationSoftwareConfigurationArgs', 'SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']]] = None):
        """
        Deployment Configuration.
        :param pulumi.Input[str] configuration_type: The configuration Type.
               Expected value is 'Deployment'.
        :param pulumi.Input[str] app_location: The geo-location where the SAP system is to be created.
        :param pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']] infrastructure_configuration: The infrastructure configuration.
        :param pulumi.Input[Union['ExternalInstallationSoftwareConfigurationArgs', 'SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']] software_configuration: The software configuration.
        """
        pulumi.set(__self__, "configuration_type", 'Deployment')
        if app_location is not None:
            pulumi.set(__self__, "app_location", app_location)
        if infrastructure_configuration is not None:
            pulumi.set(__self__, "infrastructure_configuration", infrastructure_configuration)
        if software_configuration is not None:
            pulumi.set(__self__, "software_configuration", software_configuration)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> pulumi.Input[str]:
        """
        The configuration Type.
        Expected value is 'Deployment'.
        """
        return pulumi.get(self, "configuration_type")

    @configuration_type.setter
    def configuration_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_type", value)

    @property
    @pulumi.getter(name="appLocation")
    def app_location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the SAP system is to be created.
        """
        return pulumi.get(self, "app_location")

    @app_location.setter
    def app_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_location", value)

    @property
    @pulumi.getter(name="infrastructureConfiguration")
    def infrastructure_configuration(self) -> Optional[pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']]]:
        """
        The infrastructure configuration.
        """
        return pulumi.get(self, "infrastructure_configuration")

    @infrastructure_configuration.setter
    def infrastructure_configuration(self, value: Optional[pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']]]):
        pulumi.set(self, "infrastructure_configuration", value)

    @property
    @pulumi.getter(name="softwareConfiguration")
    def software_configuration(self) -> Optional[pulumi.Input[Union['ExternalInstallationSoftwareConfigurationArgs', 'SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']]]:
        """
        The software configuration.
        """
        return pulumi.get(self, "software_configuration")

    @software_configuration.setter
    def software_configuration(self, value: Optional[pulumi.Input[Union['ExternalInstallationSoftwareConfigurationArgs', 'SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']]]):
        pulumi.set(self, "software_configuration", value)


@pulumi.input_type
class DeploymentWithOSConfigurationArgs:
    def __init__(__self__, *,
                 configuration_type: pulumi.Input[str],
                 app_location: Optional[pulumi.Input[str]] = None,
                 infrastructure_configuration: Optional[pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']]] = None,
                 os_sap_configuration: Optional[pulumi.Input['OsSapConfigurationArgs']] = None,
                 software_configuration: Optional[pulumi.Input[Union['ExternalInstallationSoftwareConfigurationArgs', 'SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']]] = None):
        """
        Deployment along with OS Configuration.
        :param pulumi.Input[str] configuration_type: The configuration Type.
               Expected value is 'DeploymentWithOSConfig'.
        :param pulumi.Input[str] app_location: The geo-location where the SAP system is to be created.
        :param pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']] infrastructure_configuration: The infrastructure configuration.
        :param pulumi.Input['OsSapConfigurationArgs'] os_sap_configuration: The OS and SAP configuration.
        :param pulumi.Input[Union['ExternalInstallationSoftwareConfigurationArgs', 'SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']] software_configuration: The software configuration.
        """
        pulumi.set(__self__, "configuration_type", 'DeploymentWithOSConfig')
        if app_location is not None:
            pulumi.set(__self__, "app_location", app_location)
        if infrastructure_configuration is not None:
            pulumi.set(__self__, "infrastructure_configuration", infrastructure_configuration)
        if os_sap_configuration is not None:
            pulumi.set(__self__, "os_sap_configuration", os_sap_configuration)
        if software_configuration is not None:
            pulumi.set(__self__, "software_configuration", software_configuration)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> pulumi.Input[str]:
        """
        The configuration Type.
        Expected value is 'DeploymentWithOSConfig'.
        """
        return pulumi.get(self, "configuration_type")

    @configuration_type.setter
    def configuration_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_type", value)

    @property
    @pulumi.getter(name="appLocation")
    def app_location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the SAP system is to be created.
        """
        return pulumi.get(self, "app_location")

    @app_location.setter
    def app_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_location", value)

    @property
    @pulumi.getter(name="infrastructureConfiguration")
    def infrastructure_configuration(self) -> Optional[pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']]]:
        """
        The infrastructure configuration.
        """
        return pulumi.get(self, "infrastructure_configuration")

    @infrastructure_configuration.setter
    def infrastructure_configuration(self, value: Optional[pulumi.Input[Union['SingleServerConfigurationArgs', 'ThreeTierConfigurationArgs']]]):
        pulumi.set(self, "infrastructure_configuration", value)

    @property
    @pulumi.getter(name="osSapConfiguration")
    def os_sap_configuration(self) -> Optional[pulumi.Input['OsSapConfigurationArgs']]:
        """
        The OS and SAP configuration.
        """
        return pulumi.get(self, "os_sap_configuration")

    @os_sap_configuration.setter
    def os_sap_configuration(self, value: Optional[pulumi.Input['OsSapConfigurationArgs']]):
        pulumi.set(self, "os_sap_configuration", value)

    @property
    @pulumi.getter(name="softwareConfiguration")
    def software_configuration(self) -> Optional[pulumi.Input[Union['ExternalInstallationSoftwareConfigurationArgs', 'SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']]]:
        """
        The software configuration.
        """
        return pulumi.get(self, "software_configuration")

    @software_configuration.setter
    def software_configuration(self, value: Optional[pulumi.Input[Union['ExternalInstallationSoftwareConfigurationArgs', 'SAPInstallWithoutOSConfigSoftwareConfigurationArgs', 'ServiceInitiatedSoftwareConfigurationArgs']]]):
        pulumi.set(self, "software_configuration", value)


@pulumi.input_type
class DiscoveryConfigurationArgs:
    def __init__(__self__, *,
                 configuration_type: pulumi.Input[str],
                 central_server_vm_id: Optional[pulumi.Input[str]] = None,
                 managed_rg_storage_account_name: Optional[pulumi.Input[str]] = None):
        """
        Discovery Details.
        :param pulumi.Input[str] configuration_type: The configuration Type.
               Expected value is 'Discovery'.
        :param pulumi.Input[str] central_server_vm_id: The virtual machine ID of the Central Server.
        :param pulumi.Input[str] managed_rg_storage_account_name: The custom storage account name for the storage account created by the service in the managed resource group created as part of VIS deployment.<br><br>Refer to the storage account naming rules [here](https://learn.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftstorage).<br><br>If not provided, the service will create the storage account with a random name.
        """
        pulumi.set(__self__, "configuration_type", 'Discovery')
        if central_server_vm_id is not None:
            pulumi.set(__self__, "central_server_vm_id", central_server_vm_id)
        if managed_rg_storage_account_name is not None:
            pulumi.set(__self__, "managed_rg_storage_account_name", managed_rg_storage_account_name)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> pulumi.Input[str]:
        """
        The configuration Type.
        Expected value is 'Discovery'.
        """
        return pulumi.get(self, "configuration_type")

    @configuration_type.setter
    def configuration_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_type", value)

    @property
    @pulumi.getter(name="centralServerVmId")
    def central_server_vm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual machine ID of the Central Server.
        """
        return pulumi.get(self, "central_server_vm_id")

    @central_server_vm_id.setter
    def central_server_vm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "central_server_vm_id", value)

    @property
    @pulumi.getter(name="managedRgStorageAccountName")
    def managed_rg_storage_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        The custom storage account name for the storage account created by the service in the managed resource group created as part of VIS deployment.<br><br>Refer to the storage account naming rules [here](https://learn.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftstorage).<br><br>If not provided, the service will create the storage account with a random name.
        """
        return pulumi.get(self, "managed_rg_storage_account_name")

    @managed_rg_storage_account_name.setter
    def managed_rg_storage_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_rg_storage_account_name", value)


@pulumi.input_type
class DiskConfigurationArgs:
    def __init__(__self__, *,
                 disk_volume_configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input['DiskVolumeConfigurationArgs']]]] = None):
        """
        The Disk Configuration Details.
        :param pulumi.Input[Mapping[str, pulumi.Input['DiskVolumeConfigurationArgs']]] disk_volume_configurations: The disk configuration for the db volume. For HANA, Required volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume : ['backup'].
        """
        if disk_volume_configurations is not None:
            pulumi.set(__self__, "disk_volume_configurations", disk_volume_configurations)

    @property
    @pulumi.getter(name="diskVolumeConfigurations")
    def disk_volume_configurations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['DiskVolumeConfigurationArgs']]]]:
        """
        The disk configuration for the db volume. For HANA, Required volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume : ['backup'].
        """
        return pulumi.get(self, "disk_volume_configurations")

    @disk_volume_configurations.setter
    def disk_volume_configurations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['DiskVolumeConfigurationArgs']]]]):
        pulumi.set(self, "disk_volume_configurations", value)


@pulumi.input_type
class DiskSkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'DiskSkuName']]] = None):
        """
        The type of disk sku. For example, Standard_LRS, Standard_ZRS, Premium_LRS, Premium_ZRS.
        :param pulumi.Input[Union[str, 'DiskSkuName']] name: Defines the disk sku name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'DiskSkuName']]]:
        """
        Defines the disk sku name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'DiskSkuName']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class DiskVolumeConfigurationArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[float]] = None,
                 size_gb: Optional[pulumi.Input[float]] = None,
                 sku: Optional[pulumi.Input['DiskSkuArgs']] = None):
        """
        The disk configuration required for the selected volume.
        :param pulumi.Input[float] count: The total number of disks required for the concerned volume.
        :param pulumi.Input[float] size_gb: The disk size in GB.
        :param pulumi.Input['DiskSkuArgs'] sku: The disk SKU details.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[float]]:
        """
        The total number of disks required for the concerned volume.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="sizeGB")
    def size_gb(self) -> Optional[pulumi.Input[float]]:
        """
        The disk size in GB.
        """
        return pulumi.get(self, "size_gb")

    @size_gb.setter
    def size_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "size_gb", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['DiskSkuArgs']]:
        """
        The disk SKU details.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['DiskSkuArgs']]):
        pulumi.set(self, "sku", value)


@pulumi.input_type
class ExternalInstallationSoftwareConfigurationArgs:
    def __init__(__self__, *,
                 software_installation_type: pulumi.Input[str],
                 central_server_vm_id: Optional[pulumi.Input[str]] = None):
        """
        The SAP Software configuration Input when the software is installed externally outside the service.
        :param pulumi.Input[str] software_installation_type: The SAP software installation Type.
               Expected value is 'External'.
        :param pulumi.Input[str] central_server_vm_id: The resource ID of the virtual machine containing the central server instance.
        """
        pulumi.set(__self__, "software_installation_type", 'External')
        if central_server_vm_id is not None:
            pulumi.set(__self__, "central_server_vm_id", central_server_vm_id)

    @property
    @pulumi.getter(name="softwareInstallationType")
    def software_installation_type(self) -> pulumi.Input[str]:
        """
        The SAP software installation Type.
        Expected value is 'External'.
        """
        return pulumi.get(self, "software_installation_type")

    @software_installation_type.setter
    def software_installation_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "software_installation_type", value)

    @property
    @pulumi.getter(name="centralServerVmId")
    def central_server_vm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the virtual machine containing the central server instance.
        """
        return pulumi.get(self, "central_server_vm_id")

    @central_server_vm_id.setter
    def central_server_vm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "central_server_vm_id", value)


@pulumi.input_type
class HanaDbProviderInstancePropertiesArgs:
    def __init__(__self__, *,
                 provider_type: pulumi.Input[str],
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_password: Optional[pulumi.Input[str]] = None,
                 db_password_uri: Optional[pulumi.Input[str]] = None,
                 db_username: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 instance_number: Optional[pulumi.Input[str]] = None,
                 sap_sid: Optional[pulumi.Input[str]] = None,
                 sql_port: Optional[pulumi.Input[str]] = None,
                 ssl_certificate_uri: Optional[pulumi.Input[str]] = None,
                 ssl_host_name_in_certificate: Optional[pulumi.Input[str]] = None,
                 ssl_preference: Optional[pulumi.Input[Union[str, 'SslPreference']]] = None):
        """
        Gets or sets the provider properties.
        :param pulumi.Input[str] provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'SapHana'.
        :param pulumi.Input[str] db_name: Gets or sets the hana database name.
        :param pulumi.Input[str] db_password: Gets or sets the database password.
        :param pulumi.Input[str] db_password_uri: Gets or sets the key vault URI to secret with the database password.
        :param pulumi.Input[str] db_username: Gets or sets the database user name.
        :param pulumi.Input[str] hostname: Gets or sets the target virtual machine size.
        :param pulumi.Input[str] instance_number: Gets or sets the database instance number.
        :param pulumi.Input[str] sap_sid: Gets or sets the SAP System Identifier.
        :param pulumi.Input[str] sql_port: Gets or sets the database sql port.
        :param pulumi.Input[str] ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the DB.
        :param pulumi.Input[str] ssl_host_name_in_certificate: Gets or sets the hostname(s) in the SSL certificate.
        :param pulumi.Input[Union[str, 'SslPreference']] ssl_preference: Gets or sets certificate preference if secure communication is enabled.
        """
        pulumi.set(__self__, "provider_type", 'SapHana')
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_password is not None:
            pulumi.set(__self__, "db_password", db_password)
        if db_password_uri is not None:
            pulumi.set(__self__, "db_password_uri", db_password_uri)
        if db_username is not None:
            pulumi.set(__self__, "db_username", db_username)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if instance_number is not None:
            pulumi.set(__self__, "instance_number", instance_number)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)
        if sql_port is not None:
            pulumi.set(__self__, "sql_port", sql_port)
        if ssl_certificate_uri is not None:
            pulumi.set(__self__, "ssl_certificate_uri", ssl_certificate_uri)
        if ssl_host_name_in_certificate is not None:
            pulumi.set(__self__, "ssl_host_name_in_certificate", ssl_host_name_in_certificate)
        if ssl_preference is not None:
            pulumi.set(__self__, "ssl_preference", ssl_preference)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Input[str]:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'SapHana'.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_type", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the hana database name.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="dbPassword")
    def db_password(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the database password.
        """
        return pulumi.get(self, "db_password")

    @db_password.setter
    def db_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_password", value)

    @property
    @pulumi.getter(name="dbPasswordUri")
    def db_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the key vault URI to secret with the database password.
        """
        return pulumi.get(self, "db_password_uri")

    @db_password_uri.setter
    def db_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_password_uri", value)

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the database user name.
        """
        return pulumi.get(self, "db_username")

    @db_username.setter
    def db_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_username", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the target virtual machine size.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the database instance number.
        """
        return pulumi.get(self, "instance_number")

    @instance_number.setter
    def instance_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_number", value)

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAP System Identifier.
        """
        return pulumi.get(self, "sap_sid")

    @sap_sid.setter
    def sap_sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_sid", value)

    @property
    @pulumi.getter(name="sqlPort")
    def sql_port(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the database sql port.
        """
        return pulumi.get(self, "sql_port")

    @sql_port.setter
    def sql_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_port", value)

    @property
    @pulumi.getter(name="sslCertificateUri")
    def ssl_certificate_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the blob URI to SSL certificate for the DB.
        """
        return pulumi.get(self, "ssl_certificate_uri")

    @ssl_certificate_uri.setter
    def ssl_certificate_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_certificate_uri", value)

    @property
    @pulumi.getter(name="sslHostNameInCertificate")
    def ssl_host_name_in_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the hostname(s) in the SSL certificate.
        """
        return pulumi.get(self, "ssl_host_name_in_certificate")

    @ssl_host_name_in_certificate.setter
    def ssl_host_name_in_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_host_name_in_certificate", value)

    @property
    @pulumi.getter(name="sslPreference")
    def ssl_preference(self) -> Optional[pulumi.Input[Union[str, 'SslPreference']]]:
        """
        Gets or sets certificate preference if secure communication is enabled.
        """
        return pulumi.get(self, "ssl_preference")

    @ssl_preference.setter
    def ssl_preference(self, value: Optional[pulumi.Input[Union[str, 'SslPreference']]]):
        pulumi.set(self, "ssl_preference", value)


@pulumi.input_type
class HighAvailabilityConfigurationArgs:
    def __init__(__self__, *,
                 high_availability_type: pulumi.Input[Union[str, 'SAPHighAvailabilityType']]):
        """
        Gets or sets the high availability configuration.
        :param pulumi.Input[Union[str, 'SAPHighAvailabilityType']] high_availability_type: The high availability type.
        """
        pulumi.set(__self__, "high_availability_type", high_availability_type)

    @property
    @pulumi.getter(name="highAvailabilityType")
    def high_availability_type(self) -> pulumi.Input[Union[str, 'SAPHighAvailabilityType']]:
        """
        The high availability type.
        """
        return pulumi.get(self, "high_availability_type")

    @high_availability_type.setter
    def high_availability_type(self, value: pulumi.Input[Union[str, 'SAPHighAvailabilityType']]):
        pulumi.set(self, "high_availability_type", value)


@pulumi.input_type
class HighAvailabilitySoftwareConfigurationArgs:
    def __init__(__self__, *,
                 fencing_client_id: pulumi.Input[str],
                 fencing_client_password: pulumi.Input[str]):
        """
        Gets or sets the HA software configuration.
        :param pulumi.Input[str] fencing_client_id: The fencing client id.
        :param pulumi.Input[str] fencing_client_password: The fencing client id secret/password. The secret should never expire. This will be used pacemaker to start/stop the cluster VMs.
        """
        pulumi.set(__self__, "fencing_client_id", fencing_client_id)
        pulumi.set(__self__, "fencing_client_password", fencing_client_password)

    @property
    @pulumi.getter(name="fencingClientId")
    def fencing_client_id(self) -> pulumi.Input[str]:
        """
        The fencing client id.
        """
        return pulumi.get(self, "fencing_client_id")

    @fencing_client_id.setter
    def fencing_client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "fencing_client_id", value)

    @property
    @pulumi.getter(name="fencingClientPassword")
    def fencing_client_password(self) -> pulumi.Input[str]:
        """
        The fencing client id secret/password. The secret should never expire. This will be used pacemaker to start/stop the cluster VMs.
        """
        return pulumi.get(self, "fencing_client_password")

    @fencing_client_password.setter
    def fencing_client_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "fencing_client_password", value)


@pulumi.input_type
class ImageReferenceArgs:
    def __init__(__self__, *,
                 offer: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.
        :param pulumi.Input[str] offer: Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        :param pulumi.Input[str] publisher: The image publisher.
        :param pulumi.Input[str] sku: The image SKU.
        :param pulumi.Input[str] version: Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        The image publisher.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[str]]:
        """
        The image SKU.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class LinuxConfigurationArgs:
    def __init__(__self__, *,
                 os_type: pulumi.Input[str],
                 disable_password_authentication: Optional[pulumi.Input[bool]] = None,
                 ssh: Optional[pulumi.Input['SshConfigurationArgs']] = None,
                 ssh_key_pair: Optional[pulumi.Input['SshKeyPairArgs']] = None):
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
        :param pulumi.Input[str] os_type: The OS Type
               Expected value is 'Linux'.
        :param pulumi.Input[bool] disable_password_authentication: Specifies whether password authentication should be disabled.
        :param pulumi.Input['SshConfigurationArgs'] ssh: Specifies the ssh key configuration for a Linux OS. (This property is deprecated, please use 'sshKeyPair' instead)
        :param pulumi.Input['SshKeyPairArgs'] ssh_key_pair: The SSH Key-pair used to authenticate with the VM's.
        """
        pulumi.set(__self__, "os_type", 'Linux')
        if disable_password_authentication is not None:
            pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)
        if ssh_key_pair is not None:
            pulumi.set(__self__, "ssh_key_pair", ssh_key_pair)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input[str]:
        """
        The OS Type
        Expected value is 'Linux'.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether password authentication should be disabled.
        """
        return pulumi.get(self, "disable_password_authentication")

    @disable_password_authentication.setter
    def disable_password_authentication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_password_authentication", value)

    @property
    @pulumi.getter
    def ssh(self) -> Optional[pulumi.Input['SshConfigurationArgs']]:
        """
        Specifies the ssh key configuration for a Linux OS. (This property is deprecated, please use 'sshKeyPair' instead)
        """
        return pulumi.get(self, "ssh")

    @ssh.setter
    def ssh(self, value: Optional[pulumi.Input['SshConfigurationArgs']]):
        pulumi.set(self, "ssh", value)

    @property
    @pulumi.getter(name="sshKeyPair")
    def ssh_key_pair(self) -> Optional[pulumi.Input['SshKeyPairArgs']]:
        """
        The SSH Key-pair used to authenticate with the VM's.
        """
        return pulumi.get(self, "ssh_key_pair")

    @ssh_key_pair.setter
    def ssh_key_pair(self, value: Optional[pulumi.Input['SshKeyPairArgs']]):
        pulumi.set(self, "ssh_key_pair", value)


@pulumi.input_type
class LoadBalancerResourceNamesArgs:
    def __init__(__self__, *,
                 backend_pool_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 frontend_ip_configuration_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 health_probe_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None):
        """
        The resource names object for load balancer and related resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backend_pool_names: The list of backend pool names. Currently, ACSS deploys only one backend pool and hence, size of this list should be 1
        :param pulumi.Input[Sequence[pulumi.Input[str]]] frontend_ip_configuration_names: The list of frontend IP configuration names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] health_probe_names: The list of health probe names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
        :param pulumi.Input[str] load_balancer_name: The full resource name for load balancer. If this value is not provided, load balancer will be name as {ASCS/DB}-loadBalancer.
        """
        if backend_pool_names is not None:
            pulumi.set(__self__, "backend_pool_names", backend_pool_names)
        if frontend_ip_configuration_names is not None:
            pulumi.set(__self__, "frontend_ip_configuration_names", frontend_ip_configuration_names)
        if health_probe_names is not None:
            pulumi.set(__self__, "health_probe_names", health_probe_names)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)

    @property
    @pulumi.getter(name="backendPoolNames")
    def backend_pool_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of backend pool names. Currently, ACSS deploys only one backend pool and hence, size of this list should be 1
        """
        return pulumi.get(self, "backend_pool_names")

    @backend_pool_names.setter
    def backend_pool_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "backend_pool_names", value)

    @property
    @pulumi.getter(name="frontendIpConfigurationNames")
    def frontend_ip_configuration_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of frontend IP configuration names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
        """
        return pulumi.get(self, "frontend_ip_configuration_names")

    @frontend_ip_configuration_names.setter
    def frontend_ip_configuration_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "frontend_ip_configuration_names", value)

    @property
    @pulumi.getter(name="healthProbeNames")
    def health_probe_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of health probe names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
        """
        return pulumi.get(self, "health_probe_names")

    @health_probe_names.setter
    def health_probe_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "health_probe_names", value)

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full resource name for load balancer. If this value is not provided, load balancer will be name as {ASCS/DB}-loadBalancer.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_name", value)


@pulumi.input_type
class ManagedRGConfigurationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Managed resource group configuration
        :param pulumi.Input[str] name: Managed resource group name
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Managed resource group name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class MountFileShareConfigurationArgs:
    def __init__(__self__, *,
                 configuration_type: pulumi.Input[str],
                 id: pulumi.Input[str],
                 private_endpoint_id: pulumi.Input[str]):
        """
        Gets or sets the file share configuration where the transport directory fileshare already exists, and user wishes to mount the fileshare as a part of the create infra flow.
        :param pulumi.Input[str] configuration_type: The type of file share config.
               Expected value is 'Mount'.
        :param pulumi.Input[str] id: The fileshare resource ID
        :param pulumi.Input[str] private_endpoint_id: The private endpoint resource ID
        """
        pulumi.set(__self__, "configuration_type", 'Mount')
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> pulumi.Input[str]:
        """
        The type of file share config.
        Expected value is 'Mount'.
        """
        return pulumi.get(self, "configuration_type")

    @configuration_type.setter
    def configuration_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_type", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The fileshare resource ID
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> pulumi.Input[str]:
        """
        The private endpoint resource ID
        """
        return pulumi.get(self, "private_endpoint_id")

    @private_endpoint_id.setter
    def private_endpoint_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_endpoint_id", value)


@pulumi.input_type
class MsSqlServerProviderInstancePropertiesArgs:
    def __init__(__self__, *,
                 provider_type: pulumi.Input[str],
                 db_password: Optional[pulumi.Input[str]] = None,
                 db_password_uri: Optional[pulumi.Input[str]] = None,
                 db_port: Optional[pulumi.Input[str]] = None,
                 db_username: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 sap_sid: Optional[pulumi.Input[str]] = None,
                 ssl_certificate_uri: Optional[pulumi.Input[str]] = None,
                 ssl_preference: Optional[pulumi.Input[Union[str, 'SslPreference']]] = None):
        """
        Gets or sets the SQL server provider properties.
        :param pulumi.Input[str] provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'MsSqlServer'.
        :param pulumi.Input[str] db_password: Gets or sets the database password.
        :param pulumi.Input[str] db_password_uri: Gets or sets the key vault URI to secret with the database password.
        :param pulumi.Input[str] db_port: Gets or sets the database sql port.
        :param pulumi.Input[str] db_username: Gets or sets the database user name.
        :param pulumi.Input[str] hostname: Gets or sets the SQL server host name.
        :param pulumi.Input[str] sap_sid: Gets or sets the SAP System Identifier
        :param pulumi.Input[str] ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the SQL Database.
        :param pulumi.Input[Union[str, 'SslPreference']] ssl_preference: Gets or sets certificate preference if secure communication is enabled.
        """
        pulumi.set(__self__, "provider_type", 'MsSqlServer')
        if db_password is not None:
            pulumi.set(__self__, "db_password", db_password)
        if db_password_uri is not None:
            pulumi.set(__self__, "db_password_uri", db_password_uri)
        if db_port is not None:
            pulumi.set(__self__, "db_port", db_port)
        if db_username is not None:
            pulumi.set(__self__, "db_username", db_username)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)
        if ssl_certificate_uri is not None:
            pulumi.set(__self__, "ssl_certificate_uri", ssl_certificate_uri)
        if ssl_preference is not None:
            pulumi.set(__self__, "ssl_preference", ssl_preference)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Input[str]:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'MsSqlServer'.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_type", value)

    @property
    @pulumi.getter(name="dbPassword")
    def db_password(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the database password.
        """
        return pulumi.get(self, "db_password")

    @db_password.setter
    def db_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_password", value)

    @property
    @pulumi.getter(name="dbPasswordUri")
    def db_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the key vault URI to secret with the database password.
        """
        return pulumi.get(self, "db_password_uri")

    @db_password_uri.setter
    def db_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_password_uri", value)

    @property
    @pulumi.getter(name="dbPort")
    def db_port(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the database sql port.
        """
        return pulumi.get(self, "db_port")

    @db_port.setter
    def db_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_port", value)

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the database user name.
        """
        return pulumi.get(self, "db_username")

    @db_username.setter
    def db_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_username", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SQL server host name.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAP System Identifier
        """
        return pulumi.get(self, "sap_sid")

    @sap_sid.setter
    def sap_sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_sid", value)

    @property
    @pulumi.getter(name="sslCertificateUri")
    def ssl_certificate_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the blob URI to SSL certificate for the SQL Database.
        """
        return pulumi.get(self, "ssl_certificate_uri")

    @ssl_certificate_uri.setter
    def ssl_certificate_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_certificate_uri", value)

    @property
    @pulumi.getter(name="sslPreference")
    def ssl_preference(self) -> Optional[pulumi.Input[Union[str, 'SslPreference']]]:
        """
        Gets or sets certificate preference if secure communication is enabled.
        """
        return pulumi.get(self, "ssl_preference")

    @ssl_preference.setter
    def ssl_preference(self, value: Optional[pulumi.Input[Union[str, 'SslPreference']]]):
        pulumi.set(self, "ssl_preference", value)


@pulumi.input_type
class NetworkConfigurationArgs:
    def __init__(__self__, *,
                 is_secondary_ip_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Defines the network configuration type for SAP system infrastructure that is being deployed 
        :param pulumi.Input[bool] is_secondary_ip_enabled: Specifies whether a secondary IP address should be added to the network interface on all VMs of the SAP system being deployed
        """
        if is_secondary_ip_enabled is None:
            is_secondary_ip_enabled = False
        if is_secondary_ip_enabled is not None:
            pulumi.set(__self__, "is_secondary_ip_enabled", is_secondary_ip_enabled)

    @property
    @pulumi.getter(name="isSecondaryIpEnabled")
    def is_secondary_ip_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether a secondary IP address should be added to the network interface on all VMs of the SAP system being deployed
        """
        return pulumi.get(self, "is_secondary_ip_enabled")

    @is_secondary_ip_enabled.setter
    def is_secondary_ip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_secondary_ip_enabled", value)


@pulumi.input_type
class NetworkInterfaceResourceNamesArgs:
    def __init__(__self__, *,
                 network_interface_name: Optional[pulumi.Input[str]] = None):
        """
        The resource names object for network interface and related resources.
        :param pulumi.Input[str] network_interface_name: The full name for network interface. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}-Nic. In case of HA-AvZone systems, default name will be {SID}-{App/ASCS/DB}-Zone{A/B}-Nic with an incrementor at the end in case of more than 1 instance per layer. For distributed and HA-AvSet systems, default name will be {SID}-{App/ASCS/DB}-Nic with an incrementor at the end in case of more than 1 instance per layer.
        """
        if network_interface_name is not None:
            pulumi.set(__self__, "network_interface_name", network_interface_name)

    @property
    @pulumi.getter(name="networkInterfaceName")
    def network_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name for network interface. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}-Nic. In case of HA-AvZone systems, default name will be {SID}-{App/ASCS/DB}-Zone{A/B}-Nic with an incrementor at the end in case of more than 1 instance per layer. For distributed and HA-AvSet systems, default name will be {SID}-{App/ASCS/DB}-Nic with an incrementor at the end in case of more than 1 instance per layer.
        """
        return pulumi.get(self, "network_interface_name")

    @network_interface_name.setter
    def network_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_interface_name", value)


@pulumi.input_type
class OSProfileArgs:
    def __init__(__self__, *,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 os_configuration: Optional[pulumi.Input[Union['LinuxConfigurationArgs', 'WindowsConfigurationArgs']]] = None):
        """
        Specifies the operating system settings for the virtual machine. Some of the settings cannot be changed once VM is provisioned.
        :param pulumi.Input[str] admin_password: Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
        :param pulumi.Input[str] admin_username: Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters.
        :param pulumi.Input[Union['LinuxConfigurationArgs', 'WindowsConfigurationArgs']] os_configuration: Specifies Windows operating system settings on the virtual machine.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if os_configuration is not None:
            pulumi.set(__self__, "os_configuration", os_configuration)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="osConfiguration")
    def os_configuration(self) -> Optional[pulumi.Input[Union['LinuxConfigurationArgs', 'WindowsConfigurationArgs']]]:
        """
        Specifies Windows operating system settings on the virtual machine.
        """
        return pulumi.get(self, "os_configuration")

    @os_configuration.setter
    def os_configuration(self, value: Optional[pulumi.Input[Union['LinuxConfigurationArgs', 'WindowsConfigurationArgs']]]):
        pulumi.set(self, "os_configuration", value)


@pulumi.input_type
class OsSapConfigurationArgs:
    def __init__(__self__, *,
                 deployer_vm_packages: Optional[pulumi.Input['DeployerVmPackagesArgs']] = None,
                 sap_fqdn: Optional[pulumi.Input[str]] = None):
        """
        Defines the OS and SAP Configurations for Deployment
        :param pulumi.Input['DeployerVmPackagesArgs'] deployer_vm_packages: The url and storage account ID where deployer VM packages are uploaded
        :param pulumi.Input[str] sap_fqdn: The FQDN to set for the SAP system
        """
        if deployer_vm_packages is not None:
            pulumi.set(__self__, "deployer_vm_packages", deployer_vm_packages)
        if sap_fqdn is not None:
            pulumi.set(__self__, "sap_fqdn", sap_fqdn)

    @property
    @pulumi.getter(name="deployerVmPackages")
    def deployer_vm_packages(self) -> Optional[pulumi.Input['DeployerVmPackagesArgs']]:
        """
        The url and storage account ID where deployer VM packages are uploaded
        """
        return pulumi.get(self, "deployer_vm_packages")

    @deployer_vm_packages.setter
    def deployer_vm_packages(self, value: Optional[pulumi.Input['DeployerVmPackagesArgs']]):
        pulumi.set(self, "deployer_vm_packages", value)

    @property
    @pulumi.getter(name="sapFqdn")
    def sap_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The FQDN to set for the SAP system
        """
        return pulumi.get(self, "sap_fqdn")

    @sap_fqdn.setter
    def sap_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_fqdn", value)


@pulumi.input_type
class PrometheusHaClusterProviderInstancePropertiesArgs:
    def __init__(__self__, *,
                 provider_type: pulumi.Input[str],
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 prometheus_url: Optional[pulumi.Input[str]] = None,
                 sid: Optional[pulumi.Input[str]] = None,
                 ssl_certificate_uri: Optional[pulumi.Input[str]] = None,
                 ssl_preference: Optional[pulumi.Input[Union[str, 'SslPreference']]] = None):
        """
        Gets or sets the PrometheusHaCluster provider properties.
        :param pulumi.Input[str] provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'PrometheusHaCluster'.
        :param pulumi.Input[str] cluster_name: Gets or sets the clusterName.
        :param pulumi.Input[str] hostname: Gets or sets the target machine name.
        :param pulumi.Input[str] prometheus_url: URL of the Node Exporter endpoint.
        :param pulumi.Input[str] sid: Gets or sets the cluster sid.
        :param pulumi.Input[str] ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the HA cluster exporter.
        :param pulumi.Input[Union[str, 'SslPreference']] ssl_preference: Gets or sets certificate preference if secure communication is enabled.
        """
        pulumi.set(__self__, "provider_type", 'PrometheusHaCluster')
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if prometheus_url is not None:
            pulumi.set(__self__, "prometheus_url", prometheus_url)
        if sid is not None:
            pulumi.set(__self__, "sid", sid)
        if ssl_certificate_uri is not None:
            pulumi.set(__self__, "ssl_certificate_uri", ssl_certificate_uri)
        if ssl_preference is not None:
            pulumi.set(__self__, "ssl_preference", ssl_preference)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Input[str]:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'PrometheusHaCluster'.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_type", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the clusterName.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the target machine name.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="prometheusUrl")
    def prometheus_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the Node Exporter endpoint.
        """
        return pulumi.get(self, "prometheus_url")

    @prometheus_url.setter
    def prometheus_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prometheus_url", value)

    @property
    @pulumi.getter
    def sid(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the cluster sid.
        """
        return pulumi.get(self, "sid")

    @sid.setter
    def sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sid", value)

    @property
    @pulumi.getter(name="sslCertificateUri")
    def ssl_certificate_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the blob URI to SSL certificate for the HA cluster exporter.
        """
        return pulumi.get(self, "ssl_certificate_uri")

    @ssl_certificate_uri.setter
    def ssl_certificate_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_certificate_uri", value)

    @property
    @pulumi.getter(name="sslPreference")
    def ssl_preference(self) -> Optional[pulumi.Input[Union[str, 'SslPreference']]]:
        """
        Gets or sets certificate preference if secure communication is enabled.
        """
        return pulumi.get(self, "ssl_preference")

    @ssl_preference.setter
    def ssl_preference(self, value: Optional[pulumi.Input[Union[str, 'SslPreference']]]):
        pulumi.set(self, "ssl_preference", value)


@pulumi.input_type
class PrometheusOSProviderInstancePropertiesArgs:
    def __init__(__self__, *,
                 provider_type: pulumi.Input[str],
                 prometheus_url: Optional[pulumi.Input[str]] = None,
                 sap_sid: Optional[pulumi.Input[str]] = None,
                 ssl_certificate_uri: Optional[pulumi.Input[str]] = None,
                 ssl_preference: Optional[pulumi.Input[Union[str, 'SslPreference']]] = None):
        """
        Gets or sets the PrometheusOS provider properties.
        :param pulumi.Input[str] provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'PrometheusOS'.
        :param pulumi.Input[str] prometheus_url: URL of the Node Exporter endpoint
        :param pulumi.Input[str] sap_sid: Gets or sets the SAP System Identifier
        :param pulumi.Input[str] ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the prometheus node exporter.
        :param pulumi.Input[Union[str, 'SslPreference']] ssl_preference: Gets or sets certificate preference if secure communication is enabled.
        """
        pulumi.set(__self__, "provider_type", 'PrometheusOS')
        if prometheus_url is not None:
            pulumi.set(__self__, "prometheus_url", prometheus_url)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)
        if ssl_certificate_uri is not None:
            pulumi.set(__self__, "ssl_certificate_uri", ssl_certificate_uri)
        if ssl_preference is not None:
            pulumi.set(__self__, "ssl_preference", ssl_preference)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Input[str]:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'PrometheusOS'.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_type", value)

    @property
    @pulumi.getter(name="prometheusUrl")
    def prometheus_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the Node Exporter endpoint
        """
        return pulumi.get(self, "prometheus_url")

    @prometheus_url.setter
    def prometheus_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prometheus_url", value)

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAP System Identifier
        """
        return pulumi.get(self, "sap_sid")

    @sap_sid.setter
    def sap_sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_sid", value)

    @property
    @pulumi.getter(name="sslCertificateUri")
    def ssl_certificate_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the blob URI to SSL certificate for the prometheus node exporter.
        """
        return pulumi.get(self, "ssl_certificate_uri")

    @ssl_certificate_uri.setter
    def ssl_certificate_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_certificate_uri", value)

    @property
    @pulumi.getter(name="sslPreference")
    def ssl_preference(self) -> Optional[pulumi.Input[Union[str, 'SslPreference']]]:
        """
        Gets or sets certificate preference if secure communication is enabled.
        """
        return pulumi.get(self, "ssl_preference")

    @ssl_preference.setter
    def ssl_preference(self, value: Optional[pulumi.Input[Union[str, 'SslPreference']]]):
        pulumi.set(self, "ssl_preference", value)


@pulumi.input_type
class SAPInstallWithoutOSConfigSoftwareConfigurationArgs:
    def __init__(__self__, *,
                 bom_url: pulumi.Input[str],
                 sap_bits_storage_account_id: pulumi.Input[str],
                 software_installation_type: pulumi.Input[str],
                 software_version: pulumi.Input[str],
                 high_availability_software_configuration: Optional[pulumi.Input['HighAvailabilitySoftwareConfigurationArgs']] = None):
        """
        The SAP Software configuration Input when the software is to be installed by service without OS Configurations
        :param pulumi.Input[str] bom_url: The URL to the SAP Build of Materials(BOM) file.
        :param pulumi.Input[str] sap_bits_storage_account_id: The SAP bits storage account id.
        :param pulumi.Input[str] software_installation_type: The SAP software installation Type.
               Expected value is 'SAPInstallWithoutOSConfig'.
        :param pulumi.Input[str] software_version: The software version to install.
        :param pulumi.Input['HighAvailabilitySoftwareConfigurationArgs'] high_availability_software_configuration: Gets or sets the HA software configuration.
        """
        pulumi.set(__self__, "bom_url", bom_url)
        pulumi.set(__self__, "sap_bits_storage_account_id", sap_bits_storage_account_id)
        pulumi.set(__self__, "software_installation_type", 'SAPInstallWithoutOSConfig')
        pulumi.set(__self__, "software_version", software_version)
        if high_availability_software_configuration is not None:
            pulumi.set(__self__, "high_availability_software_configuration", high_availability_software_configuration)

    @property
    @pulumi.getter(name="bomUrl")
    def bom_url(self) -> pulumi.Input[str]:
        """
        The URL to the SAP Build of Materials(BOM) file.
        """
        return pulumi.get(self, "bom_url")

    @bom_url.setter
    def bom_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "bom_url", value)

    @property
    @pulumi.getter(name="sapBitsStorageAccountId")
    def sap_bits_storage_account_id(self) -> pulumi.Input[str]:
        """
        The SAP bits storage account id.
        """
        return pulumi.get(self, "sap_bits_storage_account_id")

    @sap_bits_storage_account_id.setter
    def sap_bits_storage_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sap_bits_storage_account_id", value)

    @property
    @pulumi.getter(name="softwareInstallationType")
    def software_installation_type(self) -> pulumi.Input[str]:
        """
        The SAP software installation Type.
        Expected value is 'SAPInstallWithoutOSConfig'.
        """
        return pulumi.get(self, "software_installation_type")

    @software_installation_type.setter
    def software_installation_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "software_installation_type", value)

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> pulumi.Input[str]:
        """
        The software version to install.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "software_version", value)

    @property
    @pulumi.getter(name="highAvailabilitySoftwareConfiguration")
    def high_availability_software_configuration(self) -> Optional[pulumi.Input['HighAvailabilitySoftwareConfigurationArgs']]:
        """
        Gets or sets the HA software configuration.
        """
        return pulumi.get(self, "high_availability_software_configuration")

    @high_availability_software_configuration.setter
    def high_availability_software_configuration(self, value: Optional[pulumi.Input['HighAvailabilitySoftwareConfigurationArgs']]):
        pulumi.set(self, "high_availability_software_configuration", value)


@pulumi.input_type
class SapLandscapeMonitorMetricThresholdsArgs:
    def __init__(__self__, *,
                 green: Optional[pulumi.Input[float]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 red: Optional[pulumi.Input[float]] = None,
                 yellow: Optional[pulumi.Input[float]] = None):
        """
        Gets or sets the Threshold Values for Top Metrics Health.
        :param pulumi.Input[float] green: Gets or sets the threshold value for Green.
        :param pulumi.Input[str] name: Gets or sets the name of the threshold.
        :param pulumi.Input[float] red: Gets or sets the threshold value for Red.
        :param pulumi.Input[float] yellow: Gets or sets the threshold value for Yellow.
        """
        if green is not None:
            pulumi.set(__self__, "green", green)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if red is not None:
            pulumi.set(__self__, "red", red)
        if yellow is not None:
            pulumi.set(__self__, "yellow", yellow)

    @property
    @pulumi.getter
    def green(self) -> Optional[pulumi.Input[float]]:
        """
        Gets or sets the threshold value for Green.
        """
        return pulumi.get(self, "green")

    @green.setter
    def green(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "green", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the threshold.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def red(self) -> Optional[pulumi.Input[float]]:
        """
        Gets or sets the threshold value for Red.
        """
        return pulumi.get(self, "red")

    @red.setter
    def red(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "red", value)

    @property
    @pulumi.getter
    def yellow(self) -> Optional[pulumi.Input[float]]:
        """
        Gets or sets the threshold value for Yellow.
        """
        return pulumi.get(self, "yellow")

    @yellow.setter
    def yellow(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "yellow", value)


@pulumi.input_type
class SapLandscapeMonitorPropertiesGroupingArgs:
    def __init__(__self__, *,
                 landscape: Optional[pulumi.Input[Sequence[pulumi.Input['SapLandscapeMonitorSidMappingArgs']]]] = None,
                 sap_application: Optional[pulumi.Input[Sequence[pulumi.Input['SapLandscapeMonitorSidMappingArgs']]]] = None):
        """
        Gets or sets the SID groupings by landscape and Environment.
        :param pulumi.Input[Sequence[pulumi.Input['SapLandscapeMonitorSidMappingArgs']]] landscape: Gets or sets the list of landscape to SID mappings.
        :param pulumi.Input[Sequence[pulumi.Input['SapLandscapeMonitorSidMappingArgs']]] sap_application: Gets or sets the list of Sap Applications to SID mappings.
        """
        if landscape is not None:
            pulumi.set(__self__, "landscape", landscape)
        if sap_application is not None:
            pulumi.set(__self__, "sap_application", sap_application)

    @property
    @pulumi.getter
    def landscape(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SapLandscapeMonitorSidMappingArgs']]]]:
        """
        Gets or sets the list of landscape to SID mappings.
        """
        return pulumi.get(self, "landscape")

    @landscape.setter
    def landscape(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SapLandscapeMonitorSidMappingArgs']]]]):
        pulumi.set(self, "landscape", value)

    @property
    @pulumi.getter(name="sapApplication")
    def sap_application(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SapLandscapeMonitorSidMappingArgs']]]]:
        """
        Gets or sets the list of Sap Applications to SID mappings.
        """
        return pulumi.get(self, "sap_application")

    @sap_application.setter
    def sap_application(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SapLandscapeMonitorSidMappingArgs']]]]):
        pulumi.set(self, "sap_application", value)


@pulumi.input_type
class SapLandscapeMonitorSidMappingArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 top_sid: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Gets or sets the mapping for SID to Environment/Applications.
        :param pulumi.Input[str] name: Gets or sets the name of the grouping.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] top_sid: Gets or sets the list of SID's.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if top_sid is not None:
            pulumi.set(__self__, "top_sid", top_sid)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the grouping.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="topSid")
    def top_sid(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the list of SID's.
        """
        return pulumi.get(self, "top_sid")

    @top_sid.setter
    def top_sid(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "top_sid", value)


@pulumi.input_type
class SapNetWeaverProviderInstancePropertiesArgs:
    def __init__(__self__, *,
                 provider_type: pulumi.Input[str],
                 sap_client_id: Optional[pulumi.Input[str]] = None,
                 sap_host_file_entries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sap_hostname: Optional[pulumi.Input[str]] = None,
                 sap_instance_nr: Optional[pulumi.Input[str]] = None,
                 sap_password: Optional[pulumi.Input[str]] = None,
                 sap_password_uri: Optional[pulumi.Input[str]] = None,
                 sap_port_number: Optional[pulumi.Input[str]] = None,
                 sap_sid: Optional[pulumi.Input[str]] = None,
                 sap_username: Optional[pulumi.Input[str]] = None,
                 ssl_certificate_uri: Optional[pulumi.Input[str]] = None,
                 ssl_preference: Optional[pulumi.Input[Union[str, 'SslPreference']]] = None):
        """
        Gets or sets the provider properties.
        :param pulumi.Input[str] provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'SapNetWeaver'.
        :param pulumi.Input[str] sap_client_id: Gets or sets the SAP Client ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sap_host_file_entries: Gets or sets the list of HostFile Entries
        :param pulumi.Input[str] sap_hostname: Gets or sets the target virtual machine IP Address/FQDN.
        :param pulumi.Input[str] sap_instance_nr: Gets or sets the instance number of SAP NetWeaver.
        :param pulumi.Input[str] sap_password: Sets the SAP password.
        :param pulumi.Input[str] sap_password_uri: Gets or sets the key vault URI to secret with the SAP password.
        :param pulumi.Input[str] sap_port_number: Gets or sets the SAP HTTP port number.
        :param pulumi.Input[str] sap_sid: Gets or sets the SAP System Identifier
        :param pulumi.Input[str] sap_username: Gets or sets the SAP user name.
        :param pulumi.Input[str] ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the SAP system.
        :param pulumi.Input[Union[str, 'SslPreference']] ssl_preference: Gets or sets certificate preference if secure communication is enabled.
        """
        pulumi.set(__self__, "provider_type", 'SapNetWeaver')
        if sap_client_id is not None:
            pulumi.set(__self__, "sap_client_id", sap_client_id)
        if sap_host_file_entries is not None:
            pulumi.set(__self__, "sap_host_file_entries", sap_host_file_entries)
        if sap_hostname is not None:
            pulumi.set(__self__, "sap_hostname", sap_hostname)
        if sap_instance_nr is not None:
            pulumi.set(__self__, "sap_instance_nr", sap_instance_nr)
        if sap_password is not None:
            pulumi.set(__self__, "sap_password", sap_password)
        if sap_password_uri is not None:
            pulumi.set(__self__, "sap_password_uri", sap_password_uri)
        if sap_port_number is not None:
            pulumi.set(__self__, "sap_port_number", sap_port_number)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)
        if sap_username is not None:
            pulumi.set(__self__, "sap_username", sap_username)
        if ssl_certificate_uri is not None:
            pulumi.set(__self__, "ssl_certificate_uri", ssl_certificate_uri)
        if ssl_preference is not None:
            pulumi.set(__self__, "ssl_preference", ssl_preference)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Input[str]:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'SapNetWeaver'.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_type", value)

    @property
    @pulumi.getter(name="sapClientId")
    def sap_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAP Client ID.
        """
        return pulumi.get(self, "sap_client_id")

    @sap_client_id.setter
    def sap_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_client_id", value)

    @property
    @pulumi.getter(name="sapHostFileEntries")
    def sap_host_file_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the list of HostFile Entries
        """
        return pulumi.get(self, "sap_host_file_entries")

    @sap_host_file_entries.setter
    def sap_host_file_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sap_host_file_entries", value)

    @property
    @pulumi.getter(name="sapHostname")
    def sap_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the target virtual machine IP Address/FQDN.
        """
        return pulumi.get(self, "sap_hostname")

    @sap_hostname.setter
    def sap_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_hostname", value)

    @property
    @pulumi.getter(name="sapInstanceNr")
    def sap_instance_nr(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the instance number of SAP NetWeaver.
        """
        return pulumi.get(self, "sap_instance_nr")

    @sap_instance_nr.setter
    def sap_instance_nr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_instance_nr", value)

    @property
    @pulumi.getter(name="sapPassword")
    def sap_password(self) -> Optional[pulumi.Input[str]]:
        """
        Sets the SAP password.
        """
        return pulumi.get(self, "sap_password")

    @sap_password.setter
    def sap_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_password", value)

    @property
    @pulumi.getter(name="sapPasswordUri")
    def sap_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the key vault URI to secret with the SAP password.
        """
        return pulumi.get(self, "sap_password_uri")

    @sap_password_uri.setter
    def sap_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_password_uri", value)

    @property
    @pulumi.getter(name="sapPortNumber")
    def sap_port_number(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAP HTTP port number.
        """
        return pulumi.get(self, "sap_port_number")

    @sap_port_number.setter
    def sap_port_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_port_number", value)

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAP System Identifier
        """
        return pulumi.get(self, "sap_sid")

    @sap_sid.setter
    def sap_sid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_sid", value)

    @property
    @pulumi.getter(name="sapUsername")
    def sap_username(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the SAP user name.
        """
        return pulumi.get(self, "sap_username")

    @sap_username.setter
    def sap_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sap_username", value)

    @property
    @pulumi.getter(name="sslCertificateUri")
    def ssl_certificate_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the blob URI to SSL certificate for the SAP system.
        """
        return pulumi.get(self, "ssl_certificate_uri")

    @ssl_certificate_uri.setter
    def ssl_certificate_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_certificate_uri", value)

    @property
    @pulumi.getter(name="sslPreference")
    def ssl_preference(self) -> Optional[pulumi.Input[Union[str, 'SslPreference']]]:
        """
        Gets or sets certificate preference if secure communication is enabled.
        """
        return pulumi.get(self, "ssl_preference")

    @ssl_preference.setter
    def ssl_preference(self, value: Optional[pulumi.Input[Union[str, 'SslPreference']]]):
        pulumi.set(self, "ssl_preference", value)


@pulumi.input_type
class ServiceInitiatedSoftwareConfigurationArgs:
    def __init__(__self__, *,
                 bom_url: pulumi.Input[str],
                 sap_bits_storage_account_id: pulumi.Input[str],
                 sap_fqdn: pulumi.Input[str],
                 software_installation_type: pulumi.Input[str],
                 software_version: pulumi.Input[str],
                 ssh_private_key: pulumi.Input[str],
                 high_availability_software_configuration: Optional[pulumi.Input['HighAvailabilitySoftwareConfigurationArgs']] = None):
        """
        The SAP Software configuration Input when the software is to be installed by service.
        :param pulumi.Input[str] bom_url: The URL to the SAP Build of Materials(BOM) file.
        :param pulumi.Input[str] sap_bits_storage_account_id: The SAP bits storage account id.
        :param pulumi.Input[str] sap_fqdn: The FQDN to set for the SAP system during install.
        :param pulumi.Input[str] software_installation_type: The SAP software installation Type.
               Expected value is 'ServiceInitiated'.
        :param pulumi.Input[str] software_version: The software version to install.
        :param pulumi.Input[str] ssh_private_key: The SSH private key.
        :param pulumi.Input['HighAvailabilitySoftwareConfigurationArgs'] high_availability_software_configuration: Gets or sets the HA software configuration.
        """
        pulumi.set(__self__, "bom_url", bom_url)
        pulumi.set(__self__, "sap_bits_storage_account_id", sap_bits_storage_account_id)
        pulumi.set(__self__, "sap_fqdn", sap_fqdn)
        pulumi.set(__self__, "software_installation_type", 'ServiceInitiated')
        pulumi.set(__self__, "software_version", software_version)
        pulumi.set(__self__, "ssh_private_key", ssh_private_key)
        if high_availability_software_configuration is not None:
            pulumi.set(__self__, "high_availability_software_configuration", high_availability_software_configuration)

    @property
    @pulumi.getter(name="bomUrl")
    def bom_url(self) -> pulumi.Input[str]:
        """
        The URL to the SAP Build of Materials(BOM) file.
        """
        return pulumi.get(self, "bom_url")

    @bom_url.setter
    def bom_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "bom_url", value)

    @property
    @pulumi.getter(name="sapBitsStorageAccountId")
    def sap_bits_storage_account_id(self) -> pulumi.Input[str]:
        """
        The SAP bits storage account id.
        """
        return pulumi.get(self, "sap_bits_storage_account_id")

    @sap_bits_storage_account_id.setter
    def sap_bits_storage_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sap_bits_storage_account_id", value)

    @property
    @pulumi.getter(name="sapFqdn")
    def sap_fqdn(self) -> pulumi.Input[str]:
        """
        The FQDN to set for the SAP system during install.
        """
        return pulumi.get(self, "sap_fqdn")

    @sap_fqdn.setter
    def sap_fqdn(self, value: pulumi.Input[str]):
        pulumi.set(self, "sap_fqdn", value)

    @property
    @pulumi.getter(name="softwareInstallationType")
    def software_installation_type(self) -> pulumi.Input[str]:
        """
        The SAP software installation Type.
        Expected value is 'ServiceInitiated'.
        """
        return pulumi.get(self, "software_installation_type")

    @software_installation_type.setter
    def software_installation_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "software_installation_type", value)

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> pulumi.Input[str]:
        """
        The software version to install.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "software_version", value)

    @property
    @pulumi.getter(name="sshPrivateKey")
    def ssh_private_key(self) -> pulumi.Input[str]:
        """
        The SSH private key.
        """
        return pulumi.get(self, "ssh_private_key")

    @ssh_private_key.setter
    def ssh_private_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "ssh_private_key", value)

    @property
    @pulumi.getter(name="highAvailabilitySoftwareConfiguration")
    def high_availability_software_configuration(self) -> Optional[pulumi.Input['HighAvailabilitySoftwareConfigurationArgs']]:
        """
        Gets or sets the HA software configuration.
        """
        return pulumi.get(self, "high_availability_software_configuration")

    @high_availability_software_configuration.setter
    def high_availability_software_configuration(self, value: Optional[pulumi.Input['HighAvailabilitySoftwareConfigurationArgs']]):
        pulumi.set(self, "high_availability_software_configuration", value)


@pulumi.input_type
class SharedStorageResourceNamesArgs:
    def __init__(__self__, *,
                 shared_storage_account_name: Optional[pulumi.Input[str]] = None,
                 shared_storage_account_private_end_point_name: Optional[pulumi.Input[str]] = None):
        """
        The resource names object for shared storage.
        :param pulumi.Input[str] shared_storage_account_name: The full name of the shared storage account. If it is not provided, it will be defaulted to {SID}nfs{guid of 15 chars}.
        :param pulumi.Input[str] shared_storage_account_private_end_point_name: The full name of private end point for the shared storage account. If it is not provided, it will be defaulted to {storageAccountName}_pe
        """
        if shared_storage_account_name is not None:
            pulumi.set(__self__, "shared_storage_account_name", shared_storage_account_name)
        if shared_storage_account_private_end_point_name is not None:
            pulumi.set(__self__, "shared_storage_account_private_end_point_name", shared_storage_account_private_end_point_name)

    @property
    @pulumi.getter(name="sharedStorageAccountName")
    def shared_storage_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the shared storage account. If it is not provided, it will be defaulted to {SID}nfs{guid of 15 chars}.
        """
        return pulumi.get(self, "shared_storage_account_name")

    @shared_storage_account_name.setter
    def shared_storage_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_storage_account_name", value)

    @property
    @pulumi.getter(name="sharedStorageAccountPrivateEndPointName")
    def shared_storage_account_private_end_point_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of private end point for the shared storage account. If it is not provided, it will be defaulted to {storageAccountName}_pe
        """
        return pulumi.get(self, "shared_storage_account_private_end_point_name")

    @shared_storage_account_private_end_point_name.setter
    def shared_storage_account_private_end_point_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_storage_account_private_end_point_name", value)


@pulumi.input_type
class SingleServerConfigurationArgs:
    def __init__(__self__, *,
                 app_resource_group: pulumi.Input[str],
                 deployment_type: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 virtual_machine_configuration: pulumi.Input['VirtualMachineConfigurationArgs'],
                 custom_resource_names: Optional[pulumi.Input['SingleServerFullResourceNamesArgs']] = None,
                 database_type: Optional[pulumi.Input[Union[str, 'SAPDatabaseType']]] = None,
                 db_disk_configuration: Optional[pulumi.Input['DiskConfigurationArgs']] = None,
                 network_configuration: Optional[pulumi.Input['NetworkConfigurationArgs']] = None):
        """
        Gets or sets the single server configuration. For prerequisites for creating the infrastructure, please see [here](https://go.microsoft.com/fwlink/?linkid=2212611&clcid=0x409)
        :param pulumi.Input[str] app_resource_group: The application resource group where SAP system resources will be deployed.
        :param pulumi.Input[str] deployment_type: The type of SAP deployment, single server or Three tier.
               Expected value is 'SingleServer'.
        :param pulumi.Input[str] subnet_id: The subnet id.
        :param pulumi.Input['VirtualMachineConfigurationArgs'] virtual_machine_configuration: Gets or sets the virtual machine configuration.
        :param pulumi.Input['SingleServerFullResourceNamesArgs'] custom_resource_names: The set of custom names to be used for underlying azure resources that are part of the SAP system.
        :param pulumi.Input[Union[str, 'SAPDatabaseType']] database_type: The database type.
        :param pulumi.Input['DiskConfigurationArgs'] db_disk_configuration: Gets or sets the disk configuration.
        :param pulumi.Input['NetworkConfigurationArgs'] network_configuration: Network configuration for the server
        """
        pulumi.set(__self__, "app_resource_group", app_resource_group)
        pulumi.set(__self__, "deployment_type", 'SingleServer')
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)
        if custom_resource_names is not None:
            pulumi.set(__self__, "custom_resource_names", custom_resource_names)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if db_disk_configuration is not None:
            pulumi.set(__self__, "db_disk_configuration", db_disk_configuration)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)

    @property
    @pulumi.getter(name="appResourceGroup")
    def app_resource_group(self) -> pulumi.Input[str]:
        """
        The application resource group where SAP system resources will be deployed.
        """
        return pulumi.get(self, "app_resource_group")

    @app_resource_group.setter
    def app_resource_group(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_resource_group", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Input[str]:
        """
        The type of SAP deployment, single server or Three tier.
        Expected value is 'SingleServer'.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> pulumi.Input['VirtualMachineConfigurationArgs']:
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")

    @virtual_machine_configuration.setter
    def virtual_machine_configuration(self, value: pulumi.Input['VirtualMachineConfigurationArgs']):
        pulumi.set(self, "virtual_machine_configuration", value)

    @property
    @pulumi.getter(name="customResourceNames")
    def custom_resource_names(self) -> Optional[pulumi.Input['SingleServerFullResourceNamesArgs']]:
        """
        The set of custom names to be used for underlying azure resources that are part of the SAP system.
        """
        return pulumi.get(self, "custom_resource_names")

    @custom_resource_names.setter
    def custom_resource_names(self, value: Optional[pulumi.Input['SingleServerFullResourceNamesArgs']]):
        pulumi.set(self, "custom_resource_names", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[Union[str, 'SAPDatabaseType']]]:
        """
        The database type.
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[Union[str, 'SAPDatabaseType']]]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter(name="dbDiskConfiguration")
    def db_disk_configuration(self) -> Optional[pulumi.Input['DiskConfigurationArgs']]:
        """
        Gets or sets the disk configuration.
        """
        return pulumi.get(self, "db_disk_configuration")

    @db_disk_configuration.setter
    def db_disk_configuration(self, value: Optional[pulumi.Input['DiskConfigurationArgs']]):
        pulumi.set(self, "db_disk_configuration", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['NetworkConfigurationArgs']]:
        """
        Network configuration for the server
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['NetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)


@pulumi.input_type
class SingleServerFullResourceNamesArgs:
    def __init__(__self__, *,
                 naming_pattern_type: pulumi.Input[str],
                 virtual_machine: Optional[pulumi.Input['VirtualMachineResourceNamesArgs']] = None):
        """
        The resource name object where the specified values will be full resource names of the corresponding resources in a single server SAP system.
        :param pulumi.Input[str] naming_pattern_type: The pattern type to be used for resource naming.
               Expected value is 'FullResourceName'.
        :param pulumi.Input['VirtualMachineResourceNamesArgs'] virtual_machine: The resource names object for virtual machine and related resources.
        """
        pulumi.set(__self__, "naming_pattern_type", 'FullResourceName')
        if virtual_machine is not None:
            pulumi.set(__self__, "virtual_machine", virtual_machine)

    @property
    @pulumi.getter(name="namingPatternType")
    def naming_pattern_type(self) -> pulumi.Input[str]:
        """
        The pattern type to be used for resource naming.
        Expected value is 'FullResourceName'.
        """
        return pulumi.get(self, "naming_pattern_type")

    @naming_pattern_type.setter
    def naming_pattern_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "naming_pattern_type", value)

    @property
    @pulumi.getter(name="virtualMachine")
    def virtual_machine(self) -> Optional[pulumi.Input['VirtualMachineResourceNamesArgs']]:
        """
        The resource names object for virtual machine and related resources.
        """
        return pulumi.get(self, "virtual_machine")

    @virtual_machine.setter
    def virtual_machine(self, value: Optional[pulumi.Input['VirtualMachineResourceNamesArgs']]):
        pulumi.set(self, "virtual_machine", value)


@pulumi.input_type
class SkipFileShareConfigurationArgs:
    def __init__(__self__, *,
                 configuration_type: pulumi.Input[str]):
        """
        Gets or sets the file share configuration for scenarios where transport directory fileshare is not created or required.
        :param pulumi.Input[str] configuration_type: The type of file share config.
               Expected value is 'Skip'.
        """
        pulumi.set(__self__, "configuration_type", 'Skip')

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> pulumi.Input[str]:
        """
        The type of file share config.
        Expected value is 'Skip'.
        """
        return pulumi.get(self, "configuration_type")

    @configuration_type.setter
    def configuration_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_type", value)


@pulumi.input_type
class SshConfigurationArgs:
    def __init__(__self__, *,
                 public_keys: Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]] = None):
        """
        SSH configuration for Linux based VMs running on Azure
        :param pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]] public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]]:
        """
        The list of SSH public keys used to authenticate with linux based VMs.
        """
        return pulumi.get(self, "public_keys")

    @public_keys.setter
    def public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]]):
        pulumi.set(self, "public_keys", value)


@pulumi.input_type
class SshKeyPairArgs:
    def __init__(__self__, *,
                 private_key: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None):
        """
        The SSH Key-pair used to authenticate with the VM. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        :param pulumi.Input[str] private_key: SSH private key.
        :param pulumi.Input[str] public_key: SSH public key
        """
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        SSH private key.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        SSH public key
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)


@pulumi.input_type
class SshPublicKeyArgs:
    def __init__(__self__, *,
                 key_data: Optional[pulumi.Input[str]] = None):
        """
        Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
        :param pulumi.Input[str] key_data: SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[pulumi.Input[str]]:
        """
        SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        """
        return pulumi.get(self, "key_data")

    @key_data.setter
    def key_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_data", value)


@pulumi.input_type
class StorageConfigurationArgs:
    def __init__(__self__, *,
                 transport_file_share_configuration: Optional[pulumi.Input[Union['CreateAndMountFileShareConfigurationArgs', 'MountFileShareConfigurationArgs', 'SkipFileShareConfigurationArgs']]] = None):
        """
        Gets or sets the storage configuration.
        :param pulumi.Input[Union['CreateAndMountFileShareConfigurationArgs', 'MountFileShareConfigurationArgs', 'SkipFileShareConfigurationArgs']] transport_file_share_configuration: The properties of the transport directory attached to the VIS. The default for transportFileShareConfiguration is the createAndMount flow if storage configuration is missing.
        """
        if transport_file_share_configuration is not None:
            pulumi.set(__self__, "transport_file_share_configuration", transport_file_share_configuration)

    @property
    @pulumi.getter(name="transportFileShareConfiguration")
    def transport_file_share_configuration(self) -> Optional[pulumi.Input[Union['CreateAndMountFileShareConfigurationArgs', 'MountFileShareConfigurationArgs', 'SkipFileShareConfigurationArgs']]]:
        """
        The properties of the transport directory attached to the VIS. The default for transportFileShareConfiguration is the createAndMount flow if storage configuration is missing.
        """
        return pulumi.get(self, "transport_file_share_configuration")

    @transport_file_share_configuration.setter
    def transport_file_share_configuration(self, value: Optional[pulumi.Input[Union['CreateAndMountFileShareConfigurationArgs', 'MountFileShareConfigurationArgs', 'SkipFileShareConfigurationArgs']]]):
        pulumi.set(self, "transport_file_share_configuration", value)


@pulumi.input_type
class ThreeTierConfigurationArgs:
    def __init__(__self__, *,
                 app_resource_group: pulumi.Input[str],
                 application_server: pulumi.Input['ApplicationServerConfigurationArgs'],
                 central_server: pulumi.Input['CentralServerConfigurationArgs'],
                 database_server: pulumi.Input['DatabaseConfigurationArgs'],
                 deployment_type: pulumi.Input[str],
                 custom_resource_names: Optional[pulumi.Input['ThreeTierFullResourceNamesArgs']] = None,
                 high_availability_config: Optional[pulumi.Input['HighAvailabilityConfigurationArgs']] = None,
                 network_configuration: Optional[pulumi.Input['NetworkConfigurationArgs']] = None,
                 storage_configuration: Optional[pulumi.Input['StorageConfigurationArgs']] = None):
        """
        Gets or sets the three tier SAP configuration. For prerequisites for creating the infrastructure, please see [here](https://go.microsoft.com/fwlink/?linkid=2212611&clcid=0x409)
        :param pulumi.Input[str] app_resource_group: The application resource group where SAP system resources will be deployed.
        :param pulumi.Input['ApplicationServerConfigurationArgs'] application_server: The application server configuration.
        :param pulumi.Input['CentralServerConfigurationArgs'] central_server: The central server configuration.
        :param pulumi.Input['DatabaseConfigurationArgs'] database_server: The database configuration.
        :param pulumi.Input[str] deployment_type: The type of SAP deployment, single server or Three tier.
               Expected value is 'ThreeTier'.
        :param pulumi.Input['ThreeTierFullResourceNamesArgs'] custom_resource_names: The set of custom names to be used for underlying azure resources that are part of the SAP system.
        :param pulumi.Input['HighAvailabilityConfigurationArgs'] high_availability_config: The high availability configuration.
        :param pulumi.Input['NetworkConfigurationArgs'] network_configuration: Network configuration common to all servers
        :param pulumi.Input['StorageConfigurationArgs'] storage_configuration: The storage configuration.
        """
        pulumi.set(__self__, "app_resource_group", app_resource_group)
        pulumi.set(__self__, "application_server", application_server)
        pulumi.set(__self__, "central_server", central_server)
        pulumi.set(__self__, "database_server", database_server)
        pulumi.set(__self__, "deployment_type", 'ThreeTier')
        if custom_resource_names is not None:
            pulumi.set(__self__, "custom_resource_names", custom_resource_names)
        if high_availability_config is not None:
            pulumi.set(__self__, "high_availability_config", high_availability_config)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if storage_configuration is not None:
            pulumi.set(__self__, "storage_configuration", storage_configuration)

    @property
    @pulumi.getter(name="appResourceGroup")
    def app_resource_group(self) -> pulumi.Input[str]:
        """
        The application resource group where SAP system resources will be deployed.
        """
        return pulumi.get(self, "app_resource_group")

    @app_resource_group.setter
    def app_resource_group(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_resource_group", value)

    @property
    @pulumi.getter(name="applicationServer")
    def application_server(self) -> pulumi.Input['ApplicationServerConfigurationArgs']:
        """
        The application server configuration.
        """
        return pulumi.get(self, "application_server")

    @application_server.setter
    def application_server(self, value: pulumi.Input['ApplicationServerConfigurationArgs']):
        pulumi.set(self, "application_server", value)

    @property
    @pulumi.getter(name="centralServer")
    def central_server(self) -> pulumi.Input['CentralServerConfigurationArgs']:
        """
        The central server configuration.
        """
        return pulumi.get(self, "central_server")

    @central_server.setter
    def central_server(self, value: pulumi.Input['CentralServerConfigurationArgs']):
        pulumi.set(self, "central_server", value)

    @property
    @pulumi.getter(name="databaseServer")
    def database_server(self) -> pulumi.Input['DatabaseConfigurationArgs']:
        """
        The database configuration.
        """
        return pulumi.get(self, "database_server")

    @database_server.setter
    def database_server(self, value: pulumi.Input['DatabaseConfigurationArgs']):
        pulumi.set(self, "database_server", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Input[str]:
        """
        The type of SAP deployment, single server or Three tier.
        Expected value is 'ThreeTier'.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="customResourceNames")
    def custom_resource_names(self) -> Optional[pulumi.Input['ThreeTierFullResourceNamesArgs']]:
        """
        The set of custom names to be used for underlying azure resources that are part of the SAP system.
        """
        return pulumi.get(self, "custom_resource_names")

    @custom_resource_names.setter
    def custom_resource_names(self, value: Optional[pulumi.Input['ThreeTierFullResourceNamesArgs']]):
        pulumi.set(self, "custom_resource_names", value)

    @property
    @pulumi.getter(name="highAvailabilityConfig")
    def high_availability_config(self) -> Optional[pulumi.Input['HighAvailabilityConfigurationArgs']]:
        """
        The high availability configuration.
        """
        return pulumi.get(self, "high_availability_config")

    @high_availability_config.setter
    def high_availability_config(self, value: Optional[pulumi.Input['HighAvailabilityConfigurationArgs']]):
        pulumi.set(self, "high_availability_config", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['NetworkConfigurationArgs']]:
        """
        Network configuration common to all servers
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['NetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="storageConfiguration")
    def storage_configuration(self) -> Optional[pulumi.Input['StorageConfigurationArgs']]:
        """
        The storage configuration.
        """
        return pulumi.get(self, "storage_configuration")

    @storage_configuration.setter
    def storage_configuration(self, value: Optional[pulumi.Input['StorageConfigurationArgs']]):
        pulumi.set(self, "storage_configuration", value)


@pulumi.input_type
class ThreeTierFullResourceNamesArgs:
    def __init__(__self__, *,
                 naming_pattern_type: pulumi.Input[str],
                 application_server: Optional[pulumi.Input['ApplicationServerFullResourceNamesArgs']] = None,
                 central_server: Optional[pulumi.Input['CentralServerFullResourceNamesArgs']] = None,
                 database_server: Optional[pulumi.Input['DatabaseServerFullResourceNamesArgs']] = None,
                 shared_storage: Optional[pulumi.Input['SharedStorageResourceNamesArgs']] = None):
        """
        The resource name object where the specified values will be full resource names of the corresponding resources in a three tier SAP system.
        :param pulumi.Input[str] naming_pattern_type: The pattern type to be used for resource naming.
               Expected value is 'FullResourceName'.
        :param pulumi.Input['ApplicationServerFullResourceNamesArgs'] application_server: The full resource names object for application layer resources. The number of entries in this list should be equal to the number VMs to be created for application layer.
        :param pulumi.Input['CentralServerFullResourceNamesArgs'] central_server: The full resource names object for central server layer resources.
        :param pulumi.Input['DatabaseServerFullResourceNamesArgs'] database_server: The full resource names object for database layer resources. The number of entries in this list should be equal to the number VMs to be created for database layer.
        :param pulumi.Input['SharedStorageResourceNamesArgs'] shared_storage: The resource names object for shared storage.
        """
        pulumi.set(__self__, "naming_pattern_type", 'FullResourceName')
        if application_server is not None:
            pulumi.set(__self__, "application_server", application_server)
        if central_server is not None:
            pulumi.set(__self__, "central_server", central_server)
        if database_server is not None:
            pulumi.set(__self__, "database_server", database_server)
        if shared_storage is not None:
            pulumi.set(__self__, "shared_storage", shared_storage)

    @property
    @pulumi.getter(name="namingPatternType")
    def naming_pattern_type(self) -> pulumi.Input[str]:
        """
        The pattern type to be used for resource naming.
        Expected value is 'FullResourceName'.
        """
        return pulumi.get(self, "naming_pattern_type")

    @naming_pattern_type.setter
    def naming_pattern_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "naming_pattern_type", value)

    @property
    @pulumi.getter(name="applicationServer")
    def application_server(self) -> Optional[pulumi.Input['ApplicationServerFullResourceNamesArgs']]:
        """
        The full resource names object for application layer resources. The number of entries in this list should be equal to the number VMs to be created for application layer.
        """
        return pulumi.get(self, "application_server")

    @application_server.setter
    def application_server(self, value: Optional[pulumi.Input['ApplicationServerFullResourceNamesArgs']]):
        pulumi.set(self, "application_server", value)

    @property
    @pulumi.getter(name="centralServer")
    def central_server(self) -> Optional[pulumi.Input['CentralServerFullResourceNamesArgs']]:
        """
        The full resource names object for central server layer resources.
        """
        return pulumi.get(self, "central_server")

    @central_server.setter
    def central_server(self, value: Optional[pulumi.Input['CentralServerFullResourceNamesArgs']]):
        pulumi.set(self, "central_server", value)

    @property
    @pulumi.getter(name="databaseServer")
    def database_server(self) -> Optional[pulumi.Input['DatabaseServerFullResourceNamesArgs']]:
        """
        The full resource names object for database layer resources. The number of entries in this list should be equal to the number VMs to be created for database layer.
        """
        return pulumi.get(self, "database_server")

    @database_server.setter
    def database_server(self, value: Optional[pulumi.Input['DatabaseServerFullResourceNamesArgs']]):
        pulumi.set(self, "database_server", value)

    @property
    @pulumi.getter(name="sharedStorage")
    def shared_storage(self) -> Optional[pulumi.Input['SharedStorageResourceNamesArgs']]:
        """
        The resource names object for shared storage.
        """
        return pulumi.get(self, "shared_storage")

    @shared_storage.setter
    def shared_storage(self, value: Optional[pulumi.Input['SharedStorageResourceNamesArgs']]):
        pulumi.set(self, "shared_storage", value)


@pulumi.input_type
class UserAssignedServiceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'ManagedServiceIdentityType']],
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        A pre-created user assigned identity with appropriate roles assigned. To learn more on identity and roles required, visit the ACSS how-to-guide.
        :param pulumi.Input[Union[str, 'ManagedServiceIdentityType']] type: Type of manage identity
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: User assigned identities dictionary
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ManagedServiceIdentityType']]:
        """
        Type of manage identity
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ManagedServiceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        User assigned identities dictionary
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class VirtualMachineConfigurationArgs:
    def __init__(__self__, *,
                 image_reference: pulumi.Input['ImageReferenceArgs'],
                 os_profile: pulumi.Input['OSProfileArgs'],
                 vm_size: pulumi.Input[str]):
        """
        Defines the virtual machine configuration.
        :param pulumi.Input['ImageReferenceArgs'] image_reference: The image reference.
        :param pulumi.Input['OSProfileArgs'] os_profile: The OS profile.
        :param pulumi.Input[str] vm_size: The virtual machine size.
        """
        pulumi.set(__self__, "image_reference", image_reference)
        pulumi.set(__self__, "os_profile", os_profile)
        pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> pulumi.Input['ImageReferenceArgs']:
        """
        The image reference.
        """
        return pulumi.get(self, "image_reference")

    @image_reference.setter
    def image_reference(self, value: pulumi.Input['ImageReferenceArgs']):
        pulumi.set(self, "image_reference", value)

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> pulumi.Input['OSProfileArgs']:
        """
        The OS profile.
        """
        return pulumi.get(self, "os_profile")

    @os_profile.setter
    def os_profile(self, value: pulumi.Input['OSProfileArgs']):
        pulumi.set(self, "os_profile", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> pulumi.Input[str]:
        """
        The virtual machine size.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "vm_size", value)


@pulumi.input_type
class VirtualMachineResourceNamesArgs:
    def __init__(__self__, *,
                 data_disk_names: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceResourceNamesArgs']]]] = None,
                 os_disk_name: Optional[pulumi.Input[str]] = None,
                 vm_name: Optional[pulumi.Input[str]] = None):
        """
        The resource names object for virtual machine and related resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]] data_disk_names: The full resource names for virtual machine data disks. This is a dictionary containing list of names of data disks per volume. Currently supported volumes for database layer are ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os', 'backup']. For application and cs layers, only 'default' volume is supported
        :param pulumi.Input[str] host_name: The full name for virtual-machine's host (computer name). Currently, ACSS only supports host names which are less than or equal to 13 characters long. If this value is not provided, vmName will be used as host name.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceResourceNamesArgs']]] network_interfaces: The list of network interface name objects for the selected virtual machine. Currently, only one network interface is supported per virtual machine.
        :param pulumi.Input[str] os_disk_name: The full name for OS disk attached to the VM. If this value is not provided, it will be named by ARM as per its default naming standards (prefixed with vm name). There is only one OS disk attached per Virtual Machine.
        :param pulumi.Input[str] vm_name: The full name for virtual machine. The length of this field can be upto 64 characters. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}vm. In case of HA-AvZone systems, default name will be {SID}{app/ascs/db}z{a/b}vm with an incrementor at the end in case of more than 1 vm per layer. For distributed and HA-AvSet systems, default name will be {SID}{app/ascs/db}vm with an incrementor at the end in case of more than 1 vm per layer.
        """
        if data_disk_names is not None:
            pulumi.set(__self__, "data_disk_names", data_disk_names)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if os_disk_name is not None:
            pulumi.set(__self__, "os_disk_name", os_disk_name)
        if vm_name is not None:
            pulumi.set(__self__, "vm_name", vm_name)

    @property
    @pulumi.getter(name="dataDiskNames")
    def data_disk_names(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]]:
        """
        The full resource names for virtual machine data disks. This is a dictionary containing list of names of data disks per volume. Currently supported volumes for database layer are ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os', 'backup']. For application and cs layers, only 'default' volume is supported
        """
        return pulumi.get(self, "data_disk_names")

    @data_disk_names.setter
    def data_disk_names(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]]):
        pulumi.set(self, "data_disk_names", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name for virtual-machine's host (computer name). Currently, ACSS only supports host names which are less than or equal to 13 characters long. If this value is not provided, vmName will be used as host name.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceResourceNamesArgs']]]]:
        """
        The list of network interface name objects for the selected virtual machine. Currently, only one network interface is supported per virtual machine.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceResourceNamesArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="osDiskName")
    def os_disk_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name for OS disk attached to the VM. If this value is not provided, it will be named by ARM as per its default naming standards (prefixed with vm name). There is only one OS disk attached per Virtual Machine.
        """
        return pulumi.get(self, "os_disk_name")

    @os_disk_name.setter
    def os_disk_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_disk_name", value)

    @property
    @pulumi.getter(name="vmName")
    def vm_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name for virtual machine. The length of this field can be upto 64 characters. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}vm. In case of HA-AvZone systems, default name will be {SID}{app/ascs/db}z{a/b}vm with an incrementor at the end in case of more than 1 vm per layer. For distributed and HA-AvSet systems, default name will be {SID}{app/ascs/db}vm with an incrementor at the end in case of more than 1 vm per layer.
        """
        return pulumi.get(self, "vm_name")

    @vm_name.setter
    def vm_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_name", value)


@pulumi.input_type
class WindowsConfigurationArgs:
    def __init__(__self__, *,
                 os_type: pulumi.Input[str]):
        """
        Specifies Windows operating system settings on the virtual machine.
        :param pulumi.Input[str] os_type: The OS Type
               Expected value is 'Windows'.
        """
        pulumi.set(__self__, "os_type", 'Windows')

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input[str]:
        """
        The OS Type
        Expected value is 'Windows'.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "os_type", value)


