# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetLivePipelineResult',
    'AwaitableGetLivePipelineResult',
    'get_live_pipeline',
    'get_live_pipeline_output',
]

@pulumi.output_type
class GetLivePipelineResult:
    """
    Live pipeline represents a unique instance of a live topology, used for real-time ingestion, archiving and publishing of content for a unique RTSP camera.
    """
    def __init__(__self__, bitrate_kbps=None, description=None, id=None, name=None, parameters=None, state=None, system_data=None, topology_name=None, type=None):
        if bitrate_kbps and not isinstance(bitrate_kbps, int):
            raise TypeError("Expected argument 'bitrate_kbps' to be a int")
        pulumi.set(__self__, "bitrate_kbps", bitrate_kbps)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parameters and not isinstance(parameters, list):
            raise TypeError("Expected argument 'parameters' to be a list")
        pulumi.set(__self__, "parameters", parameters)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if topology_name and not isinstance(topology_name, str):
            raise TypeError("Expected argument 'topology_name' to be a str")
        pulumi.set(__self__, "topology_name", topology_name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="bitrateKbps")
    def bitrate_kbps(self) -> int:
        """
        Maximum bitrate capacity in Kbps reserved for the live pipeline. The allowed range is from 500 to 3000 Kbps in increments of 100 Kbps. If the RTSP camera exceeds this capacity, then the service will disconnect temporarily from the camera. It will retry to re-establish connection (with exponential backoff), checking to see if the camera bitrate is now below the reserved capacity. Doing so will ensure that one 'noisy neighbor' does not affect other live pipelines in your account.
        """
        return pulumi.get(self, "bitrate_kbps")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        An optional description for the pipeline.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.ParameterDefinitionResponse']]:
        """
        List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of the pipeline (read-only).
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter(name="topologyName")
    def topology_name(self) -> str:
        """
        The reference to an existing pipeline topology defined for real-time content processing. When activated, this live pipeline will process content according to the pipeline topology definition.
        """
        return pulumi.get(self, "topology_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetLivePipelineResult(GetLivePipelineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLivePipelineResult(
            bitrate_kbps=self.bitrate_kbps,
            description=self.description,
            id=self.id,
            name=self.name,
            parameters=self.parameters,
            state=self.state,
            system_data=self.system_data,
            topology_name=self.topology_name,
            type=self.type)


def get_live_pipeline(account_name: Optional[str] = None,
                      live_pipeline_name: Optional[str] = None,
                      resource_group_name: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLivePipelineResult:
    """
    Retrieves a specific live pipeline by name. If a live pipeline with that name has been previously created, the call will return the JSON representation of that instance.


    :param str account_name: The Azure Video Analyzer account name.
    :param str live_pipeline_name: Live pipeline unique identifier.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['livePipelineName'] = live_pipeline_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:videoanalyzer/v20211101preview:getLivePipeline', __args__, opts=opts, typ=GetLivePipelineResult).value

    return AwaitableGetLivePipelineResult(
        bitrate_kbps=__ret__.bitrate_kbps,
        description=__ret__.description,
        id=__ret__.id,
        name=__ret__.name,
        parameters=__ret__.parameters,
        state=__ret__.state,
        system_data=__ret__.system_data,
        topology_name=__ret__.topology_name,
        type=__ret__.type)


@_utilities.lift_output_func(get_live_pipeline)
def get_live_pipeline_output(account_name: Optional[pulumi.Input[str]] = None,
                             live_pipeline_name: Optional[pulumi.Input[str]] = None,
                             resource_group_name: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLivePipelineResult]:
    """
    Retrieves a specific live pipeline by name. If a live pipeline with that name has been previously created, the call will return the JSON representation of that instance.


    :param str account_name: The Azure Video Analyzer account name.
    :param str live_pipeline_name: Live pipeline unique identifier.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
